/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.items.instances.ItemPart;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketVehiclePart;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.PartGun;

public class PacketVehiclePartGun
extends APacketVehiclePart {
    private final boolean controlPulse;
    private final boolean triggerState;
    private final String bulletPackID;
    private final String bulletSystemName;

    public PacketVehiclePartGun(PartGun gun, boolean triggerState) {
        super(gun.vehicle, gun.placementOffset);
        this.controlPulse = true;
        this.triggerState = triggerState;
        this.bulletPackID = null;
        this.bulletSystemName = null;
    }

    public PacketVehiclePartGun(PartGun gun, ItemPart bullet) {
        super(gun.vehicle, gun.placementOffset);
        this.controlPulse = false;
        this.triggerState = false;
        this.bulletPackID = ((JSONPart)bullet.definition).packID;
        this.bulletSystemName = ((JSONPart)bullet.definition).systemName;
    }

    public PacketVehiclePartGun(ByteBuf buf) {
        super(buf);
        this.controlPulse = buf.readBoolean();
        if (this.controlPulse) {
            this.triggerState = buf.readBoolean();
            this.bulletPackID = null;
            this.bulletSystemName = null;
        } else {
            this.triggerState = false;
            this.bulletPackID = PacketVehiclePartGun.readStringFromBuffer(buf);
            this.bulletSystemName = PacketVehiclePartGun.readStringFromBuffer(buf);
        }
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeBoolean(this.controlPulse);
        if (this.controlPulse) {
            buf.writeBoolean(this.triggerState);
        } else {
            PacketVehiclePartGun.writeStringToBuffer(this.bulletPackID, buf);
            PacketVehiclePartGun.writeStringToBuffer(this.bulletSystemName, buf);
        }
    }

    @Override
    public boolean handle(IWrapperWorld world, IWrapperPlayer player, EntityVehicleF_Physics vehicle, Point3d offset) {
        PartGun gun = (PartGun)vehicle.getPartAtLocation(offset);
        if (this.controlPulse) {
            gun.firing = this.triggerState;
        } else {
            gun.tryToReload((ItemPart)PackParserSystem.getItem(this.bulletPackID, this.bulletSystemName));
        }
        return true;
    }
}

