/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packloading;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.systems.PackParserSystem;

public final class PackResourceLoader {
    public static String getPackResource(AJSONItem<?> definition, ResourceType type, String name) {
        switch (PackStructure.values()[PackParserSystem.getPackConfiguration((String)definition.packID).fileStructure]) {
            case DEFAULT: {
                return "/assets/" + definition.packID + "/" + type.prefixFolder + definition.prefixFolders + name + type.normalSuffix;
            }
            case LAYERED: {
                return "/assets/" + definition.packID + "/" + type.prefixFolder + definition.prefixFolders + name + type.normalSuffix;
            }
            case MODULAR: {
                return "/assets/" + definition.packID + "/" + definition.prefixFolders + name + type.modularSuffix;
            }
        }
        return null;
    }

    public static enum ItemClassification {
        VEHICLE,
        PART,
        INSTRUMENT,
        POLE,
        DECOR,
        ITEM,
        BOOKLET;


        public static List<String> getAllTypesAsStrings() {
            ArrayList<String> assetTypes = new ArrayList<String>();
            for (ItemClassification classification : ItemClassification.values()) {
                assetTypes.add(classification.name().toLowerCase());
            }
            return assetTypes;
        }
    }

    public static enum ResourceType {
        OBJ("objmodels/", ".obj", ".obj"),
        PNG("textures/", ".png", ".png"),
        ITEM_PNG("textures/items/", ".png", "_item.png"),
        ITEM_JSON("models/item/", ".json", "_item.json");

        private final String prefixFolder;
        private final String normalSuffix;
        private final String modularSuffix;

        private ResourceType(String prefixFolder, String normalSuffix, String modularSuffix) {
            this.prefixFolder = prefixFolder;
            this.normalSuffix = normalSuffix;
            this.modularSuffix = modularSuffix;
        }
    }

    public static enum PackStructure {
        DEFAULT,
        LAYERED,
        MODULAR;

    }
}

