/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.components;

import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;

public abstract class AParticle {
    public final IWrapperWorld world;
    public final Point3d position;
    public final Point3d motion;
    public final BoundingBox box;
    public final float red;
    public final float green;
    public final float blue;
    public final float alpha;
    public final float scale;
    public final int maxAge;
    public boolean touchingBlocks;
    public int age;

    public AParticle(IWrapperWorld world, Point3d position, Point3d motion) {
        this(world, position, motion, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public AParticle(IWrapperWorld world, Point3d position, Point3d motion, float red, float green, float blue, float alpha, float scale) {
        this.world = world;
        this.position = position;
        this.motion = motion;
        this.box = new BoundingBox(position, (double)this.getSize() / 2.0, (double)this.getSize() / 2.0, (double)this.getSize() / 2.0);
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        this.scale = scale;
        this.maxAge = this.generateMaxAge();
    }

    public void update() {
        if (this.collidesWithBlocks()) {
            this.touchingBlocks = this.box.updateMovingCollisions(this.world, this.motion);
            if (this.touchingBlocks) {
                this.motion.add(-this.box.currentCollisionDepth.x * Math.signum(this.motion.x), -this.box.currentCollisionDepth.y * Math.signum(this.motion.y), -this.box.currentCollisionDepth.z * Math.signum(this.motion.z));
            }
        }
        this.position.add(this.motion);
        ++this.age;
    }

    public boolean collidesWithBlocks() {
        return true;
    }

    public abstract float getScale(float var1);

    public float getSize() {
        return 0.2f;
    }

    protected abstract int generateMaxAge();

    public abstract int getTextureIndex();

    public boolean isBright() {
        return false;
    }

    public void render(float partialTicks) {
    }
}

