/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.components;

import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.sound.SoundInstance;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;

public class DurationDelayClock {
    public final JSONVehicle.VehicleAnimationDefinition definition;
    private Long timeCommandedForwards = 0L;
    private Long timeCommandedReverse = 0L;
    private boolean playedForwardsStartSound = false;
    private boolean playedForwardsEndSound = false;
    private boolean playedReverseStartSound = false;
    private boolean playedReverseEndSound = false;

    public DurationDelayClock(JSONVehicle.VehicleAnimationDefinition definition) {
        this.definition = definition;
    }

    public double getFactoredState(EntityVehicleF_Physics vehicle, double variable) {
        if (this.definition.duration == 0 && this.definition.forwardsDelay == 0 && this.definition.reverseDelay == 0) {
            return variable;
        }
        boolean commandForwards = variable == 1.0;
        long currentTime = System.currentTimeMillis();
        long cycleTime = this.definition.duration * 50 + this.definition.forwardsDelay * 50 + this.definition.reverseDelay * 50;
        if (this.timeCommandedForwards == 0L && this.timeCommandedReverse == 0L) {
            if (commandForwards) {
                this.timeCommandedForwards = currentTime - cycleTime;
            } else {
                this.timeCommandedReverse = currentTime - cycleTime;
            }
            this.playedForwardsStartSound = true;
            this.playedForwardsEndSound = true;
            this.playedReverseStartSound = true;
            this.playedReverseEndSound = true;
        } else if (this.timeCommandedForwards != 0L) {
            if (!commandForwards) {
                this.timeCommandedReverse = currentTime;
                long timeForwards = currentTime - this.timeCommandedForwards;
                if (timeForwards < cycleTime) {
                    this.timeCommandedReverse = this.timeCommandedReverse + (timeForwards - cycleTime);
                }
                if (timeForwards >= (long)(this.definition.duration * 50 + this.definition.forwardsDelay * 50)) {
                    this.playedReverseStartSound = false;
                }
                this.playedReverseEndSound = false;
                this.timeCommandedForwards = 0L;
            }
        } else if (commandForwards) {
            this.timeCommandedForwards = currentTime;
            long timeReverse = currentTime - this.timeCommandedReverse;
            if (timeReverse < cycleTime) {
                this.timeCommandedForwards = this.timeCommandedForwards + (timeReverse - cycleTime);
            } else {
                this.playedForwardsStartSound = false;
            }
            this.playedForwardsEndSound = false;
            this.timeCommandedReverse = 0L;
        }
        double movementFactor = 0.0;
        if (commandForwards) {
            long timedelayed = currentTime - this.timeCommandedForwards;
            if (timedelayed >= (long)(this.definition.forwardsDelay * 50)) {
                long timeMoved = currentTime - (this.timeCommandedForwards + (long)(this.definition.forwardsDelay * 50));
                if (timeMoved < (long)(this.definition.duration * 50)) {
                    movementFactor = (double)timeMoved / (double)(this.definition.duration * 50);
                } else {
                    movementFactor = 1.0;
                    if (!this.playedForwardsEndSound && vehicle.world.isClient()) {
                        MasterLoader.audioInterface.playQuickSound(new SoundInstance(vehicle, this.definition.forwardsEndSound));
                        this.playedForwardsEndSound = true;
                    }
                }
                if (!this.playedForwardsStartSound && vehicle.world.isClient()) {
                    MasterLoader.audioInterface.playQuickSound(new SoundInstance(vehicle, this.definition.forwardsStartSound));
                    this.playedForwardsStartSound = true;
                }
            }
        } else {
            long timedelayed = currentTime - this.timeCommandedReverse;
            if (timedelayed >= (long)(this.definition.reverseDelay * 50)) {
                long timeMoved = currentTime - (this.timeCommandedReverse + (long)(this.definition.reverseDelay * 50));
                if (timeMoved < (long)(this.definition.duration * 50)) {
                    movementFactor = (double)timeMoved / (double)(this.definition.duration * 50);
                } else {
                    movementFactor = 1.0;
                    if (!this.playedReverseEndSound && vehicle.world.isClient()) {
                        MasterLoader.audioInterface.playQuickSound(new SoundInstance(vehicle, this.definition.reverseEndSound));
                        this.playedReverseEndSound = true;
                    }
                }
                if (!this.playedReverseStartSound && vehicle.world.isClient()) {
                    MasterLoader.audioInterface.playQuickSound(new SoundInstance(vehicle, this.definition.reverseStartSound));
                    this.playedReverseStartSound = true;
                }
            }
            movementFactor = 1.0 - movementFactor;
        }
        return movementFactor;
    }
}

