/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.components;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.opengl.GL11;

public final class OBJParser {
    public static Map<String, Float[][]> parseOBJModel(String modelLocation) {
        BufferedReader reader;
        HashMap<String, Float[][]> partMap = new HashMap<String, Float[][]>();
        try {
            reader = new BufferedReader(new InputStreamReader(OBJParser.class.getResourceAsStream(modelLocation)));
        }
        catch (Exception e) {
            throw new NullPointerException("ERROR: Attempted to parse the OBJ model at: " + modelLocation + " but could not find it.  Check the path and try again.");
        }
        String partName = null;
        ArrayList<Float[]> vertexList = new ArrayList<Float[]>();
        ArrayList<Float[]> normalList = new ArrayList<Float[]>();
        ArrayList<Float[]> textureList = new ArrayList<Float[]>();
        ArrayList<String> faceList = new ArrayList<String>();
        try {
            int lineNumber = 0;
            while (reader.ready()) {
                Float[] coords;
                String line = reader.readLine();
                ++lineNumber;
                if (line.isEmpty()) continue;
                if (line.startsWith("o")) {
                    if (partName != null) {
                        partMap.put(partName, OBJParser.compileVertexArray(vertexList, normalList, textureList, faceList, partName.toLowerCase().contains("window")));
                        vertexList.clear();
                        normalList.clear();
                        textureList.clear();
                        faceList.clear();
                    }
                    try {
                        partName = line.trim().substring(2, line.length());
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("ERROR: Object found with no name at line: " + lineNumber + " of: " + modelLocation + ".  Make sure your model exporter isn't making things into groups rather than objects.");
                    }
                }
                if (partName == null) continue;
                if (line.startsWith("v ")) {
                    try {
                        coords = new Float[3];
                        line = line.trim().substring(2, line.trim().length()).trim();
                        coords[0] = Float.valueOf(line.substring(0, line.indexOf(32)));
                        coords[1] = Float.valueOf(line.substring(line.indexOf(32) + 1, line.lastIndexOf(32)));
                        coords[2] = Float.valueOf(line.substring(line.lastIndexOf(32) + 1, line.length()));
                        vertexList.add(coords);
                        continue;
                    }
                    catch (Exception e) {
                        throw new NumberFormatException("ERROR: Could not parse vertex info at line: " + lineNumber + " of: " + modelLocation + " due to bad formatting.  Vertex lines must consist of only three numbers (X, Y, Z).");
                    }
                }
                if (line.startsWith("vt ")) {
                    try {
                        coords = new Float[2];
                        line = line.trim().substring(3, line.trim().length()).trim();
                        int space = line.indexOf(32);
                        int vertexEnd = line.lastIndexOf(32) == space ? line.length() : line.lastIndexOf(32);
                        coords[0] = Float.valueOf(line.substring(0, space));
                        coords[1] = Float.valueOf(1.0f - Float.valueOf(line.substring(space + 1, vertexEnd)).floatValue());
                        textureList.add(coords);
                        continue;
                    }
                    catch (Exception e) {
                        throw new NumberFormatException("ERROR: Could not parse vertex texture info at line: " + lineNumber + " of: " + modelLocation + " due to bad formatting.  Vertex texture lines must consist of only two numbers (U, V).");
                    }
                }
                if (line.startsWith("vn ")) {
                    try {
                        coords = new Float[3];
                        line = line.trim().substring(2, line.trim().length()).trim();
                        coords[0] = Float.valueOf(line.substring(0, line.indexOf(32)));
                        coords[1] = Float.valueOf(line.substring(line.indexOf(32) + 1, line.lastIndexOf(32)));
                        coords[2] = Float.valueOf(line.substring(line.lastIndexOf(32) + 1, line.length()));
                        normalList.add(coords);
                        continue;
                    }
                    catch (Exception e) {
                        throw new NumberFormatException("ERROR: Could not parse normals info at line: " + lineNumber + " of: " + modelLocation + " due to bad formatting.  Normals lines must consist of only three numbers (Xn, Yn, Zn).");
                    }
                }
                if (!line.startsWith("f ")) continue;
                faceList.add(line.trim().substring(2, line.trim().length()));
            }
            try {
                partMap.put(partName, OBJParser.compileVertexArray(vertexList, normalList, textureList, faceList, partName.toLowerCase().contains("window")));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("ERROR: Could not compile points of: " + modelLocation + ".  This is likely due to missing UV mapping on some or all faces.");
            }
            reader.close();
            return partMap;
        }
        catch (IOException e) {
            throw new IllegalStateException("ERROR: Could not finish parsing: " + modelLocation + " due to IOException error.  Did the file change state during parsing?");
        }
    }

    private static Float[][] compileVertexArray(List<Float[]> vertexList, List<Float[]> normalList, List<Float[]> textureList, List<String> faceList, boolean isWindow) {
        ArrayList vertexDataSets = new ArrayList();
        for (String faceString : faceList) {
            ArrayList<Object> faceVertexData = new ArrayList<Object>();
            while (!faceString.isEmpty()) {
                String faceDef;
                int defEnd = faceString.indexOf(32);
                if (defEnd != -1) {
                    faceDef = faceString.substring(0, defEnd);
                    faceString = faceString.substring(defEnd + 1);
                } else {
                    faceDef = faceString;
                    faceString = "";
                }
                int firstSlash = faceDef.indexOf(47);
                int secondSlash = faceDef.lastIndexOf(47);
                int vertexNumber = Integer.valueOf(faceDef.substring(0, firstSlash)) - 1;
                int textureNumber = Integer.valueOf(faceDef.substring(firstSlash + 1, secondSlash)) - 1;
                int normalNumber = Integer.valueOf(faceDef.substring(secondSlash + 1)) - 1;
                if (faceVertexData.size() >= 3) {
                    faceVertexData.add(faceVertexData.get(0));
                    faceVertexData.add(faceVertexData.get(faceVertexData.size() - 2));
                }
                faceVertexData.add(new Integer[]{vertexNumber, textureNumber, normalNumber});
            }
            vertexDataSets.addAll(faceVertexData);
        }
        int vertexOffset = Integer.MAX_VALUE;
        int textureOffset = Integer.MAX_VALUE;
        int normalOffset = Integer.MAX_VALUE;
        for (Object vertexData : vertexDataSets) {
            vertexOffset = Math.min(vertexOffset, vertexData[0]);
            textureOffset = Math.min(textureOffset, (Integer)vertexData[1]);
            normalOffset = Math.min(normalOffset, (Integer)vertexData[2]);
        }
        ArrayList<Float[]> vertexArray = new ArrayList<Float[]>();
        for (Integer[] vertexData : vertexDataSets) {
            vertexArray.add(vertexList.get(vertexData[0] - vertexOffset));
        }
        ArrayList<Float[]> textureArray = new ArrayList<Float[]>();
        if (isWindow) {
            for (int i = 0; i < vertexDataSets.size(); i += 3) {
                textureArray.add(new Float[]{Float.valueOf(0.0f), Float.valueOf(1.0f)});
                textureArray.add(new Float[]{Float.valueOf(1.0f), Float.valueOf(1.0f)});
                textureArray.add(new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f)});
                if (vertexArray.size() > 3) {
                    textureArray.add(new Float[]{Float.valueOf(0.0f), Float.valueOf(1.0f)});
                    textureArray.add(new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f)});
                    textureArray.add(new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f)});
                    continue;
                }
                break;
            }
        } else {
            for (Integer[] face : vertexDataSets) {
                textureArray.add(textureList.get(face[1] - textureOffset));
            }
        }
        ArrayList<Float[]> normalArray = new ArrayList<Float[]>();
        for (Integer[] face : vertexDataSets) {
            normalArray.add(normalList.get(face[2] - normalOffset));
        }
        ArrayList<Float[]> compiledArray = new ArrayList<Float[]>();
        for (int i = 0; i < vertexArray.size(); ++i) {
            compiledArray.add(new Float[]{((Float[])vertexArray.get(i))[0], ((Float[])vertexArray.get(i))[1], ((Float[])vertexArray.get(i))[2], ((Float[])textureArray.get(i))[0], ((Float[])textureArray.get(i))[1], ((Float[])normalArray.get(i))[0], ((Float[])normalArray.get(i))[1], ((Float[])normalArray.get(i))[2]});
        }
        return (Float[][])compiledArray.toArray((T[])new Float[compiledArray.size()][8]);
    }

    public static int generateDisplayList(Map<String, Float[][]> parsedModel) {
        int displayListIndex = GL11.glGenLists((int)1);
        GL11.glNewList((int)displayListIndex, (int)4864);
        GL11.glBegin((int)4);
        for (Map.Entry<String, Float[][]> entry : parsedModel.entrySet()) {
            for (Float[] vertex : entry.getValue()) {
                GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
                GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
                GL11.glVertex3f((float)vertex[0].floatValue(), (float)vertex[1].floatValue(), (float)vertex[2].floatValue());
            }
        }
        GL11.glEnd();
        GL11.glEndList();
        return displayListIndex;
    }
}

