/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.components;

import minecrafttransportsimulator.mcinterface.IWrapperWorld;

public class RenderTickData {
    private final IWrapperWorld world;
    private long[] lastTickPass = new long[]{0L, 0L, 0L};
    private float[] lastPartialTicks = new float[]{0.0f, 0.0f, 0.0f};
    private boolean doneRenderingShaders;
    private static boolean shadersPresent;

    public RenderTickData(IWrapperWorld world) {
        this.world = world;
    }

    public boolean shouldRender(int renderPass, float partialTicks) {
        if (!shadersPresent && renderPass != 2 && this.lastTickPass[renderPass] > this.lastTickPass[2] && this.lastTickPass[2] > 0L) {
            shadersPresent = true;
        }
        if (!shadersPresent || this.doneRenderingShaders) {
            this.lastTickPass[renderPass] = this.world.getTime();
            this.lastPartialTicks[renderPass] = partialTicks;
        } else if (shadersPresent && !this.doneRenderingShaders && renderPass == 1) {
            this.doneRenderingShaders = true;
        }
        if (renderPass == 2) {
            if (shadersPresent) {
                this.doneRenderingShaders = false;
            }
            return this.lastTickPass[0] != this.lastTickPass[2];
        }
        return true;
    }
}

