/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.rendering.components.ATransformRenderable;
import minecrafttransportsimulator.rendering.components.TransformLight;
import minecrafttransportsimulator.rendering.components.TransformRotatable;
import minecrafttransportsimulator.rendering.components.TransformTranslatable;
import minecrafttransportsimulator.rendering.components.TransformTreadRoller;
import minecrafttransportsimulator.rendering.components.TransformVisibile;
import minecrafttransportsimulator.rendering.components.TransformWindow;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import org.lwjgl.opengl.GL11;

public final class RenderableModelObject {
    private final String modelName;
    public final String objectName;
    private final Float[][] vertices;
    public final String applyAfter;
    public final List<ATransformRenderable> transforms = new ArrayList<ATransformRenderable>();
    private static final Map<String, Map<String, Integer>> displayLists = new HashMap<String, Map<String, Integer>>();

    public RenderableModelObject(String modelName, String objectName, JSONVehicle.VehicleAnimatedObject definition, Float[][] vertices, EntityVehicleF_Physics vehicle, APart optionalPart) {
        this.modelName = modelName;
        this.objectName = objectName;
        this.vertices = vertices;
        if (definition != null) {
            this.applyAfter = definition.applyAfter;
            for (JSONVehicle.VehicleAnimationDefinition animation : definition.animations) {
                switch (animation.animationType) {
                    case "translation": {
                        this.transforms.add(new TransformTranslatable(animation));
                        break;
                    }
                    case "rotation": {
                        if (objectName.toLowerCase().contains("roller")) {
                            this.transforms.add(TransformTreadRoller.create(objectName, animation, vehicle, vertices));
                            break;
                        }
                        this.transforms.add(new TransformRotatable(animation));
                        break;
                    }
                    case "visibility": {
                        this.transforms.add(new TransformVisibile(animation));
                    }
                }
            }
        } else {
            this.applyAfter = null;
            if (objectName.toLowerCase().contains("roller")) {
                this.transforms.add(TransformTreadRoller.create(objectName, null, vehicle, vertices));
            }
        }
        if (objectName.contains("&")) {
            this.transforms.add(new TransformLight(modelName, objectName, vertices));
        }
        if (objectName.toLowerCase().contains("window")) {
            this.transforms.add(new TransformWindow(vertices));
        }
    }

    public void render(EntityVehicleF_Physics vehicle, APart optionalPart, float partialTicks, List<RenderableModelObject> allObjects) {
        GL11.glPushMatrix();
        double priorOffset = 0.0;
        for (ATransformRenderable aTransformRenderable : this.transforms) {
            if (!aTransformRenderable.shouldRender(vehicle, optionalPart, partialTicks)) {
                GL11.glPopMatrix();
                return;
            }
            if (aTransformRenderable.definition != null && aTransformRenderable.definition.addPriorOffset) {
                priorOffset = aTransformRenderable.applyTransform(vehicle, optionalPart, partialTicks, priorOffset);
                continue;
            }
            priorOffset = aTransformRenderable.applyTransform(vehicle, optionalPart, partialTicks, 0.0);
        }
        if (MasterLoader.renderInterface.getRenderPass() != 1) {
            if (!displayLists.containsKey(this.modelName) || !displayLists.get(this.modelName).containsKey(this.objectName)) {
                int displayListIndex = GL11.glGenLists((int)1);
                GL11.glNewList((int)displayListIndex, (int)4864);
                GL11.glBegin((int)4);
                for (Float[] vertex : this.vertices) {
                    GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
                    GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
                    GL11.glVertex3f((float)vertex[0].floatValue(), (float)vertex[1].floatValue(), (float)vertex[2].floatValue());
                }
                GL11.glEnd();
                GL11.glEndList();
                if (!displayLists.containsKey(this.modelName)) {
                    displayLists.put(this.modelName, new HashMap());
                }
                displayLists.get(this.modelName).put(this.objectName, displayListIndex);
            }
            GL11.glCallList((int)displayLists.get(this.modelName).get(this.objectName));
        }
        for (ATransformRenderable aTransformRenderable : this.transforms) {
            aTransformRenderable.doPostRenderLogic(vehicle, optionalPart, partialTicks);
        }
        if (optionalPart != null) {
            if (MasterLoader.renderInterface.renderTextMarkings(optionalPart.definition.rendering != null ? optionalPart.definition.rendering.textObjects : null, optionalPart.textLines, this.objectName, optionalPart.vehicle.areInteriorLightsOn())) {
                MasterLoader.renderInterface.recallTexture();
            }
        } else if (MasterLoader.renderInterface.renderTextMarkings(vehicle.definition.rendering != null ? vehicle.definition.rendering.textObjects : null, vehicle.textLines, this.objectName, vehicle.areInteriorLightsOn())) {
            MasterLoader.renderInterface.recallTexture();
        }
        for (RenderableModelObject renderableModelObject : allObjects) {
            if (!this.objectName.equals(renderableModelObject.applyAfter)) continue;
            renderableModelObject.render(vehicle, optionalPart, partialTicks, allObjects);
        }
        GL11.glPopMatrix();
    }

    public void resetDisplayList() {
        if (displayLists.containsKey(this.modelName)) {
            GL11.glDeleteLists((int)displayLists.get(this.modelName).remove(this.objectName), (int)1);
        }
    }
}

