/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.components;

import java.awt.Color;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.rendering.components.ATransformRenderable;
import minecrafttransportsimulator.rendering.components.LightType;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import org.lwjgl.opengl.GL11;

public class TransformLight
extends ATransformRenderable {
    public final LightType type;
    public final boolean isLightupTexture;
    private final Color color;
    private final int flashBits;
    private final boolean renderFlare;
    private final boolean renderColor;
    private final boolean renderCover;
    private final boolean renderBeam;
    private final Float[][] vertices;
    private final Point3d[] centerPoints;
    private final Float[] size;

    public TransformLight(String modelName, String objectName, Float[][] masterVertices) {
        super(null);
        this.type = TransformLight.getTypeFromName(objectName);
        try {
            this.color = Color.decode("0x" + objectName.substring(objectName.indexOf(95) + 1, objectName.indexOf(95) + 7));
            this.flashBits = Integer.decode("0x" + objectName.substring(objectName.indexOf(95, objectName.indexOf(95) + 7) + 1, objectName.lastIndexOf(95)));
            String lightProperties = objectName.substring(objectName.lastIndexOf(95) + 1);
            this.renderFlare = Integer.valueOf(lightProperties.substring(0, 1)) > 0;
            this.renderColor = Integer.valueOf(lightProperties.substring(1, 2)) > 0;
            boolean bl = this.renderCover = Integer.valueOf(lightProperties.substring(2, 3)) > 0;
            this.renderBeam = lightProperties.length() == 4 ? Integer.valueOf(lightProperties.substring(3)) > 0 : this.type.hasBeam;
        }
        catch (Exception e) {
            throw new NumberFormatException("ERROR: Attempted to parse light information from " + modelName + ":" + objectName + " but faulted.  This is likely due to a naming convention error.");
        }
        if (this.renderFlare || this.renderCover || this.renderBeam) {
            this.vertices = new Float[masterVertices.length][];
            this.centerPoints = new Point3d[masterVertices.length / 6];
            this.size = new Float[masterVertices.length / 6];
            for (int i = 0; i < this.centerPoints.length; ++i) {
                double minX = 999.0;
                double maxX = -999.0;
                double minY = 999.0;
                double maxY = -999.0;
                double minZ = 999.0;
                double maxZ = -999.0;
                for (int j = 0; j < 6; j = (int)((byte)(j + 1))) {
                    Float[] masterVertex = masterVertices[i * 6 + j];
                    minX = Math.min((double)masterVertex[0].floatValue(), minX);
                    maxX = Math.max((double)masterVertex[0].floatValue(), maxX);
                    minY = Math.min((double)masterVertex[1].floatValue(), minY);
                    maxY = Math.max((double)masterVertex[1].floatValue(), maxY);
                    minZ = Math.min((double)masterVertex[2].floatValue(), minZ);
                    maxZ = Math.max((double)masterVertex[2].floatValue(), maxZ);
                    Float[] newVertex = new Float[masterVertex.length];
                    newVertex[0] = masterVertex[0];
                    newVertex[1] = masterVertex[1];
                    newVertex[2] = masterVertex[2];
                    switch (j) {
                        case 0: {
                            newVertex[3] = Float.valueOf(0.0f);
                            newVertex[4] = Float.valueOf(0.0f);
                            break;
                        }
                        case 1: {
                            newVertex[3] = Float.valueOf(0.0f);
                            newVertex[4] = Float.valueOf(1.0f);
                            break;
                        }
                        case 2: {
                            newVertex[3] = Float.valueOf(1.0f);
                            newVertex[4] = Float.valueOf(1.0f);
                            break;
                        }
                        case 3: {
                            newVertex[3] = Float.valueOf(0.0f);
                            newVertex[4] = Float.valueOf(0.0f);
                            break;
                        }
                        case 4: {
                            newVertex[3] = Float.valueOf(1.0f);
                            newVertex[4] = Float.valueOf(1.0f);
                            break;
                        }
                        case 5: {
                            newVertex[3] = Float.valueOf(1.0f);
                            newVertex[4] = Float.valueOf(0.0f);
                        }
                    }
                    newVertex[5] = masterVertex[5];
                    newVertex[6] = masterVertex[6];
                    newVertex[7] = masterVertex[7];
                    this.vertices[i * 6 + j] = newVertex;
                }
                this.centerPoints[i] = new Point3d(minX + (maxX - minX) / 2.0, minY + (maxY - minY) / 2.0, minZ + (maxZ - minZ) / 2.0);
                this.size[i] = Float.valueOf((float)Math.max(Math.max(maxX - minX, maxZ - minZ), maxY - minY) * 32.0f);
            }
        } else {
            this.vertices = masterVertices;
            this.centerPoints = null;
            this.size = null;
        }
        this.isLightupTexture = !this.renderColor && !this.renderFlare && !this.renderCover && !this.renderBeam;
    }

    @Override
    public double applyTransform(EntityVehicleF_Physics vehicle, APart optionalPart, float partialTicks, double offset) {
        this.setLightupTextureState(vehicle.lightsOn.contains((Object)this.type), (float)Math.min(vehicle.electricPower > 2.0 ? (vehicle.electricPower - 2.0) / 6.0 : 0.0, 1.0));
        return 0.0;
    }

    @Override
    public void doPostRenderLogic(EntityVehicleF_Physics vehicle, APart optionalPart, float partialTicks) {
        boolean lightActuallyOn = vehicle.lightsOn.contains((Object)this.type) && this.isFlashingLightOn();
        float sunLight = vehicle.world.getLightBrightness(new Point3i(vehicle.position), false);
        float electricFactor = (float)Math.min(vehicle.electricPower > 2.0 ? (vehicle.electricPower - 2.0) / 6.0 : 0.0, 1.0);
        float lightBrightness = Math.min((1.0f - sunLight) * electricFactor, 1.0f);
        this.render(lightActuallyOn, (float)vehicle.electricPower, electricFactor, lightBrightness, (Boolean)ConfigSystem.configObject.client.vehicleBeams.value);
    }

    public void renderOnBlock(IWrapperWorld world, Point3i location, boolean lightActive) {
        this.render(lightActive && this.isFlashingLightOn(), 12.0f, 1.0f, 1.0f - world.getLightBrightness(location, false), (Boolean)ConfigSystem.configObject.client.blockBeams.value);
    }

    public void render(boolean lightOn, float electricPower, float electricFactor, float lightBrightness, boolean beamEnabled) {
        boolean doBlendRenders;
        if (MasterLoader.renderInterface.getRenderPass() != 1) {
            if (this.renderColor && lightOn && electricFactor > 0.0f) {
                this.renderColor(electricFactor);
            }
            if (this.renderCover) {
                this.renderCover(lightOn && electricFactor > 0.0f);
            }
        }
        boolean bl = lightBrightness > 0.0f && ((Boolean)ConfigSystem.configObject.client.lightsPass0.value != false ? MasterLoader.renderInterface.getRenderPass() != 1 : MasterLoader.renderInterface.getRenderPass() != 0) ? true : (doBlendRenders = false);
        if (this.renderFlare && lightOn && doBlendRenders) {
            this.renderFlare(lightBrightness);
        }
        if (beamEnabled && this.renderBeam && lightOn && doBlendRenders) {
            this.renderBeam(Math.min(electricPower > 4.0f ? 1.0f : 0.0f, lightBrightness));
        }
        MasterLoader.renderInterface.setColorState(1.0f, 1.0f, 1.0f, 1.0f);
        MasterLoader.renderInterface.setBlendState(false, false);
        MasterLoader.renderInterface.setLightingState(true);
        MasterLoader.renderInterface.recallTexture();
    }

    protected boolean isFlashingLightOn() {
        return (this.flashBits >> (int)(20L * System.currentTimeMillis() / 1000L % 20L) & 1) > 0;
    }

    public void setLightupTextureState(boolean lightOn, float electricFactor) {
        if (MasterLoader.renderInterface.getRenderPass() != 1 && this.isLightupTexture) {
            MasterLoader.renderInterface.setLightingState(!lightOn || !this.isFlashingLightOn() || !(electricFactor > 0.0f));
        }
    }

    private void renderColor(float alphaValue) {
        MasterLoader.renderInterface.bindTexture("mts:textures/rendering/light.png");
        MasterLoader.renderInterface.setLightingState(false);
        MasterLoader.renderInterface.setColorState((float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f, alphaValue);
        GL11.glBegin((int)4);
        for (Float[] vertex : this.vertices) {
            GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
            GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
            GL11.glVertex3f((float)(vertex[0].floatValue() + vertex[5].floatValue() * 1.0E-4f), (float)(vertex[1].floatValue() + vertex[6].floatValue() * 1.0E-4f), (float)(vertex[2].floatValue() + vertex[7].floatValue() * 1.0E-4f));
        }
        GL11.glEnd();
    }

    private void renderCover(boolean disableLighting) {
        MasterLoader.renderInterface.bindTexture("minecraft:textures/blocks/glass.png");
        MasterLoader.renderInterface.setLightingState(!disableLighting);
        MasterLoader.renderInterface.setColorState(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glBegin((int)4);
        for (Float[] vertex : this.vertices) {
            GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
            GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
            GL11.glVertex3f((float)(vertex[0].floatValue() + vertex[5].floatValue() * 3.0E-4f), (float)(vertex[1].floatValue() + vertex[6].floatValue() * 3.0E-4f), (float)(vertex[2].floatValue() + vertex[7].floatValue() * 3.0E-4f));
        }
        GL11.glEnd();
    }

    private void renderFlare(float alphaValue) {
        MasterLoader.renderInterface.bindTexture("mts:textures/rendering/lensflare.png");
        MasterLoader.renderInterface.setLightingState(false);
        MasterLoader.renderInterface.setBlendState(true, (Boolean)ConfigSystem.configObject.client.flareBlending.value);
        MasterLoader.renderInterface.setColorState((float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f, alphaValue);
        GL11.glBegin((int)4);
        for (int i = 0; i < this.centerPoints.length; ++i) {
            for (int j = 0; j < 6; j = (int)((byte)(j + 1))) {
                Float[] vertex = this.vertices[i * 6 + j];
                GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
                GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
                GL11.glVertex3d((double)((double)(vertex[0].floatValue() + vertex[5].floatValue() * 2.0E-4f) + ((double)vertex[0].floatValue() - this.centerPoints[i].x) * (double)(2.0f + this.size[i].floatValue() * 0.25f)), (double)((double)(vertex[1].floatValue() + vertex[6].floatValue() * 2.0E-4f) + ((double)vertex[1].floatValue() - this.centerPoints[i].y) * (double)(2.0f + this.size[i].floatValue() * 0.25f)), (double)((double)(vertex[2].floatValue() + vertex[7].floatValue() * 2.0E-4f) + ((double)vertex[2].floatValue() - this.centerPoints[i].z) * (double)(2.0f + this.size[i].floatValue() * 0.25f)));
            }
        }
        GL11.glEnd();
    }

    private void renderBeam(float alphaValue) {
        MasterLoader.renderInterface.bindTexture("mts:textures/rendering/lightbeam.png");
        MasterLoader.renderInterface.setLightingState(false);
        MasterLoader.renderInterface.setBlendState(true, (Boolean)ConfigSystem.configObject.client.beamBlending.value);
        MasterLoader.renderInterface.setColorState((float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f, alphaValue);
        for (int i = 0; i < this.centerPoints.length; ++i) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(this.centerPoints[i].x - (double)(this.vertices[i * 6][5].floatValue() * 0.15f)), (double)(this.centerPoints[i].y - (double)(this.vertices[i * 6][6].floatValue() * 0.15f)), (double)(this.centerPoints[i].z - (double)(this.vertices[i * 6][7].floatValue() * 0.15f)));
            GL11.glRotatef((float)((float)Math.toDegrees(Math.atan2(this.vertices[i * 6][6].floatValue(), this.vertices[i * 6][5].floatValue()))), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)((float)Math.toDegrees(Math.acos(this.vertices[i * 6][7].floatValue()))), (float)0.0f, (float)1.0f, (float)0.0f);
            TransformLight.drawLightCone(this.size[i].floatValue());
            GL11.glPopMatrix();
        }
    }

    private static void drawLightCone(double radius) {
        GL11.glBegin((int)6);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        float theta = (float)Math.PI * 2;
        while ((double)theta >= -0.1) {
            GL11.glTexCoord2f((float)theta, (float)1.0f);
            GL11.glVertex3d((double)(radius * Math.cos(theta)), (double)(radius * Math.sin(theta)), (double)(radius * 3.0));
            theta = (float)((double)theta - 0.15707963267948966);
        }
        theta = 0.0f;
        while ((double)theta < 6.383185307179586) {
            GL11.glTexCoord2f((float)theta, (float)1.0f);
            GL11.glVertex3d((double)(radius * Math.cos(theta)), (double)(radius * Math.sin(theta)), (double)(radius * 3.0));
            theta = (float)((double)theta + 0.15707963267948966);
        }
        GL11.glEnd();
    }

    private static LightType getTypeFromName(String lightName) {
        for (LightType light : LightType.values()) {
            if (!lightName.toUpperCase().contains(light.name())) continue;
            return light;
        }
        throw new IllegalArgumentException("ERROR: Attempted to parse light:" + lightName + ", but no lights exist with this name.  Is this light name spelled correctly?");
    }
}

