/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.components;

import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.rendering.components.ATransformRenderable;
import minecrafttransportsimulator.systems.VehicleAnimationSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import org.lwjgl.opengl.GL11;

public class TransformRotatable
extends ATransformRenderable {
    private final Point3d rotationAxis;
    private double rotationMagnitude;

    public TransformRotatable(JSONVehicle.VehicleAnimationDefinition definition) {
        super(definition);
        this.rotationAxis = definition.axis.copy();
        this.rotationMagnitude = this.rotationAxis.length();
        this.rotationAxis.normalize();
    }

    @Override
    public double applyTransform(EntityVehicleF_Physics vehicle, APart optionalPart, float partialTicks, double offset) {
        if (this.updateRotationAxis(vehicle, this.rotationAxis)) {
            this.rotationMagnitude = this.rotationAxis.length();
            this.rotationAxis.normalize();
        }
        double rotation = this.getClock(vehicle).getFactoredState(vehicle, VehicleAnimationSystem.getVariableValue(this.definition.variable, partialTicks, vehicle, optionalPart));
        if ((rotation = VehicleAnimationSystem.clampAndScale(rotation, this.rotationMagnitude, this.definition.offset + offset, this.definition.clampMin, this.definition.clampMax, this.definition.absolute)) != 0.0) {
            GL11.glTranslated((double)this.definition.centerPoint.x, (double)this.definition.centerPoint.y, (double)this.definition.centerPoint.z);
            GL11.glRotated((double)rotation, (double)this.rotationAxis.x, (double)this.rotationAxis.y, (double)this.rotationAxis.z);
            GL11.glTranslated((double)(-this.definition.centerPoint.x), (double)(-this.definition.centerPoint.y), (double)(-this.definition.centerPoint.z));
        }
        return rotation;
    }

    protected boolean updateRotationAxis(EntityVehicleF_Physics vehicle, Point3d rotationAxis) {
        return false;
    }
}

