/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.components;

import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.rendering.components.ATransformRenderable;
import minecrafttransportsimulator.systems.VehicleAnimationSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import org.lwjgl.opengl.GL11;

public class TransformTranslatable
extends ATransformRenderable {
    private final Point3d translationAxis;
    private final double translationMagnitude;

    public TransformTranslatable(JSONVehicle.VehicleAnimationDefinition definition) {
        super(definition);
        this.translationAxis = definition.axis.copy();
        this.translationMagnitude = this.translationAxis.length();
        this.translationAxis.normalize();
    }

    @Override
    public double applyTransform(EntityVehicleF_Physics vehicle, APart optionalPart, float partialTicks, double offset) {
        double translation = this.getClock(vehicle).getFactoredState(vehicle, VehicleAnimationSystem.getVariableValue(this.definition.variable, partialTicks, vehicle, null));
        if ((translation = VehicleAnimationSystem.clampAndScale(translation, this.translationMagnitude, this.definition.offset + offset, this.definition.clampMin, this.definition.clampMax, this.definition.absolute)) != 0.0) {
            GL11.glTranslated((double)(translation * this.translationAxis.x), (double)(translation * this.translationAxis.y), (double)(translation * this.translationAxis.z));
        }
        return translation;
    }
}

