/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.instances;

import java.util.HashMap;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.items.instances.ItemPart;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.IWrapperBlock;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketBulletHit;
import minecrafttransportsimulator.rendering.components.AParticle;
import minecrafttransportsimulator.rendering.components.OBJParser;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.vehicles.parts.PartGun;
import org.lwjgl.opengl.GL11;

public final class ParticleBullet
extends AParticle {
    private final ItemPart bullet;
    private final PartGun gun;
    private final int bulletNumber;
    private final double initalVelocity;
    private final IWrapperEntity gunController;
    private final Point3d blockMotionStep = new Point3d(0.0, 0.0, 0.0);
    private final Map<ItemPart, Integer> bulletDisplayLists = new HashMap<ItemPart, Integer>();
    private double armorPenetrated;

    public ParticleBullet(Point3d position, Point3d motion, ItemPart bullet, PartGun gun, IWrapperEntity gunController) {
        super(gun.vehicle.world, position, motion);
        this.bullet = bullet;
        this.gun = gun;
        this.bulletNumber = gun.bulletsFired;
        this.initalVelocity = motion.length();
        this.gunController = gunController;
    }

    @Override
    public void update() {
        double velocity = this.motion.length();
        Damage damage = new Damage("bullet", velocity * (double)((JSONPart)this.bullet.definition).bullet.diameter / 5.0 * (Double)ConfigSystem.configObject.damage.bulletDamageFactor.value, this.box, null);
        Map<IWrapperEntity, BoundingBox> attackedEntities = this.world.attackEntities(damage, this.gun.vehicle, this.motion);
        if (!attackedEntities.isEmpty()) {
            for (IWrapperEntity entity : attackedEntities.keySet()) {
                if (attackedEntities.get(entity) != null) {
                    BoundingBox hitBox = attackedEntities.get(entity);
                    if (hitBox.armorThickness != 0.0 && hitBox.armorThickness < (double)((JSONPart)this.bullet.definition).bullet.armorPenetration * velocity / this.initalVelocity - this.armorPenetrated) {
                        this.armorPenetrated += hitBox.armorThickness;
                        continue;
                    }
                    MasterLoader.networkInterface.sendToServer(new PacketBulletHit(hitBox, velocity, this.bullet, this.gun, this.bulletNumber, entity, this.gunController));
                    this.age = this.maxAge;
                    continue;
                }
                this.box.globalCenter.setTo(entity.getPosition());
                MasterLoader.networkInterface.sendToServer(new PacketBulletHit(this.box, velocity, this.bullet, this.gun, this.bulletNumber, entity, this.gunController));
                this.age = this.maxAge;
            }
            if (this.age == this.maxAge) {
                return;
            }
        }
        double maxSteps = this.motion.length();
        int i = -1;
        while ((double)i < maxSteps + 2.0) {
            this.blockMotionStep.setTo(this.motion).multiply((double)i / maxSteps);
            if (this.box.updateCollidingBlocks(this.world, this.blockMotionStep)) {
                for (IWrapperBlock block : this.box.collidingBlocks) {
                    Point3d position = new Point3d(block.getPosition());
                    MasterLoader.networkInterface.sendToServer(new PacketBulletHit(new BoundingBox(position, this.box.widthRadius, this.box.heightRadius, this.box.depthRadius), velocity, this.bullet, this.gun, this.bulletNumber, null, this.gunController));
                }
                this.age = this.maxAge;
                return;
            }
            ++i;
        }
        this.motion.multiply(0.98);
        this.motion.y -= 0.0245;
        super.update();
    }

    @Override
    public boolean collidesWithBlocks() {
        return false;
    }

    @Override
    public float getScale(float partialTicks) {
        return 1.0f;
    }

    @Override
    public float getSize() {
        return this.bullet != null ? ((JSONPart)this.bullet.definition).bullet.diameter / 1000.0f : super.getSize();
    }

    @Override
    protected int generateMaxAge() {
        return 200;
    }

    @Override
    public int getTextureIndex() {
        return -1;
    }

    @Override
    public boolean isBright() {
        return ((JSONPart)this.bullet.definition).bullet.type.equals("tracer");
    }

    @Override
    public void render(float partialTicks) {
        if (!this.bulletDisplayLists.containsKey(this.bullet)) {
            Map<String, Float[][]> parsedModel = OBJParser.parseOBJModel(((JSONPart)this.bullet.definition).getModelLocation());
            int displayListIndex = GL11.glGenLists((int)1);
            GL11.glNewList((int)displayListIndex, (int)4864);
            GL11.glBegin((int)4);
            for (Map.Entry<String, Float[][]> entry : parsedModel.entrySet()) {
                for (Float[] vertex : entry.getValue()) {
                    GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
                    GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
                    GL11.glVertex3f((float)(-vertex[0].floatValue()), (float)vertex[1].floatValue(), (float)vertex[2].floatValue());
                }
            }
            GL11.glEnd();
            GL11.glEndList();
            this.bulletDisplayLists.put(this.bullet, displayListIndex);
        }
        MasterLoader.renderInterface.bindTexture(((JSONPart)this.bullet.definition).getTextureLocation(this.bullet.subName));
        double yaw = Math.toDegrees(Math.atan2(this.motion.x, this.motion.z));
        double pitch = -Math.toDegrees(Math.asin(this.motion.y / Math.sqrt(this.motion.x * this.motion.x + this.motion.y * this.motion.y + this.motion.z * this.motion.z)));
        GL11.glRotated((double)yaw, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)pitch, (double)1.0, (double)0.0, (double)0.0);
        GL11.glCallList((int)this.bulletDisplayLists.get(this.bullet));
    }
}

