/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.instances;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.FluidTank;
import minecrafttransportsimulator.baseclasses.IFluidTankProvider;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.rendering.components.OBJParser;
import minecrafttransportsimulator.rendering.instances.ARenderTileEntityBase;
import org.lwjgl.opengl.GL11;

public class RenderDecor
extends ARenderTileEntityBase<ATileEntityBase<JSONDecor>> {
    private static final Map<JSONDecor, Integer> displayListMap = new HashMap<JSONDecor, Integer>();

    @Override
    public void render(ATileEntityBase<JSONDecor> tile, float partialTicks) {
        if (!displayListMap.containsKey(tile.definition)) {
            Map<String, Float[][]> parsedModel = OBJParser.parseOBJModel(((JSONDecor)tile.definition).getModelLocation());
            int displayListIndex = GL11.glGenLists((int)1);
            GL11.glNewList((int)displayListIndex, (int)4864);
            GL11.glBegin((int)4);
            for (Map.Entry<String, Float[][]> entry : parsedModel.entrySet()) {
                for (Float[] vertex : entry.getValue()) {
                    GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
                    GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
                    GL11.glVertex3f((float)vertex[0].floatValue(), (float)vertex[1].floatValue(), (float)vertex[2].floatValue());
                }
            }
            GL11.glEnd();
            GL11.glEndList();
            displayListMap.put((JSONDecor)tile.definition, displayListIndex);
        }
        if (MasterLoader.renderInterface.getRenderPass() != 1) {
            MasterLoader.renderInterface.bindTexture(((JSONDecor)tile.definition).getTextureLocation());
            GL11.glCallList((int)displayListMap.get(tile.definition));
            if (((JSONDecor.DecorGeneral)((JSONDecor)tile.definition).general).textObjects != null && tile instanceof IFluidTankProvider) {
                FluidTank tank = ((IFluidTankProvider)((Object)tile)).getTank();
                String fluidName = tank.getFluidLevel() > 0.0 ? MasterLoader.coreInterface.getFluidName(tank.getFluid()).toUpperCase() : "";
                String fluidLevel = MasterLoader.coreInterface.translate("tile.fuelpump.level") + String.format("%04.1f", tank.getFluidLevel() / 1000.0) + "b";
                String fluidDispensed = MasterLoader.coreInterface.translate("tile.fuelpump.dispensed") + String.format("%04.1f", tank.getAmountDispensed() / 1000.0) + "b";
                ArrayList<String> textLines = new ArrayList<String>();
                block7: for (int i = 0; i < ((JSONDecor.DecorGeneral)((JSONDecor)tile.definition).general).textObjects.size(); i = (int)((byte)(i + 1))) {
                    switch (i % 3) {
                        case 0: {
                            textLines.add(fluidName);
                            continue block7;
                        }
                        case 1: {
                            textLines.add(fluidLevel);
                            continue block7;
                        }
                        case 2: {
                            textLines.add(fluidDispensed);
                        }
                    }
                }
                MasterLoader.renderInterface.setLightingState(false);
                MasterLoader.renderInterface.renderTextMarkings(((JSONDecor.DecorGeneral)((JSONDecor)tile.definition).general).textObjects, textLines, null, true);
            }
        }
    }
}

