/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.instances;

import java.awt.Color;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.items.instances.ItemInstrument;
import minecrafttransportsimulator.jsondefs.JSONInstrument;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.systems.VehicleAnimationSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import org.lwjgl.opengl.GL11;

public final class RenderInstrument {
    public static void drawInstrument(ItemInstrument instrument, byte partNumber, EntityVehicleF_Physics vehicle) {
        MasterLoader.renderInterface.setTexture("/assets/" + ((JSONInstrument)instrument.definition).packID + "/textures/instruments.png");
        boolean lightsOn = vehicle.areInteriorLightsOn();
        for (int i = 0; i < ((JSONInstrument)instrument.definition).components.size(); i = (int)((byte)(i + 1))) {
            JSONInstrument.Component section = ((JSONInstrument)instrument.definition).components.get(i);
            if (!section.lightOverlay && MasterLoader.renderInterface.getRenderPass() != 1 || section.lightOverlay && MasterLoader.renderInterface.getRenderPass() != 0) {
                boolean addTextSuffix;
                if (lightsOn) {
                    MasterLoader.renderInterface.setInternalLightingState(false);
                }
                boolean addRotationSuffix = section.rotationVariable != null && (section.rotationVariable.startsWith("engine_") || section.rotationVariable.startsWith("propeller_") || section.rotationVariable.startsWith("gun_"));
                boolean addTranslationSuffix = section.translationVariable != null && (section.translationVariable.startsWith("engine_") || section.translationVariable.startsWith("propeller_") || section.translationVariable.startsWith("gun_"));
                boolean bl = addTextSuffix = section.textObject != null && (section.textObject.fieldName.startsWith("engine_") || section.textObject.fieldName.startsWith("propeller_") || section.textObject.fieldName.startsWith("gun_"));
                if (partNumber == 0 && (addRotationSuffix || addTranslationSuffix || addTextSuffix)) {
                    partNumber = 1;
                }
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)i * 0.1f));
                if (section.textObject != null) {
                    double textNumeric = VehicleAnimationSystem.getVariableValue(addTextSuffix ? section.textObject.fieldName + "_" + partNumber : section.textObject.fieldName, section.textFactor, 0.0, 0.0, 0.0, false, 0.0f, vehicle, null);
                    String text = String.format("%0" + section.textObject.maxLength + "d", (int)textNumeric);
                    MasterLoader.guiInterface.drawScaledText(text, (int)section.textObject.pos.x, (int)section.textObject.pos.y, Color.decode(section.textObject.color), AGUIBase.TextPosition.values()[section.textObject.renderPosition], section.textObject.wrapWidth, section.textObject.scale, section.textObject.autoScale);
                    MasterLoader.renderInterface.setColorState(1.0f, 1.0f, 1.0f, 1.0f);
                    MasterLoader.renderInterface.recallTexture();
                } else {
                    float layerVEnd;
                    float layerUEnd;
                    float layerVStart;
                    float layerUStart;
                    double rotation;
                    GL11.glTranslatef((float)section.xCenter, (float)section.yCenter, (float)0.0f);
                    if (section.rotationVariable != null && section.rotateWindow) {
                        rotation = VehicleAnimationSystem.getVariableValue(addRotationSuffix ? section.rotationVariable + "_" + partNumber : section.rotationVariable, section.rotationFactor, section.rotationOffset, section.rotationClampMin, section.rotationClampMax, section.rotationAbsoluteValue, 0.0f, vehicle, null);
                        double sin = Math.sin(Math.toRadians(rotation));
                        double cos = Math.sin(Math.toRadians(rotation));
                        layerUStart = (float)((double)((float)(-section.textureWidth) / 2.0f) * cos - (double)((float)(-section.textureHeight) / 2.0f) * sin);
                        layerVStart = (float)((double)((float)(-section.textureWidth) / 2.0f) * sin + (double)((float)(-section.textureHeight) / 2.0f) * cos);
                        layerUEnd = (float)((double)((float)section.textureWidth / 2.0f) * cos - (double)((float)section.textureHeight / 2.0f) * sin);
                        layerVEnd = (float)((double)((float)section.textureWidth / 2.0f) * sin + (double)((float)section.textureHeight / 2.0f) * cos);
                    } else {
                        layerUStart = (float)section.textureXCenter - (float)section.textureWidth / 2.0f;
                        layerUEnd = layerUStart + (float)section.textureWidth;
                        layerVStart = (float)section.textureYCenter - (float)section.textureHeight / 2.0f;
                        layerVEnd = layerVStart + (float)section.textureHeight;
                    }
                    if (section.translationVariable != null) {
                        double translation = VehicleAnimationSystem.getVariableValue(addTranslationSuffix ? section.translationVariable + "_" + partNumber : section.translationVariable, section.translationFactor, 0.0, section.translationClampMin, section.translationClampMax, section.translationAbsoluteValue, 0.0f, vehicle, null);
                        if (section.extendWindow) {
                            if (section.translateHorizontal) {
                                layerUEnd = (float)((double)layerUEnd + translation);
                            } else {
                                layerVEnd = (float)((double)layerVEnd + translation);
                            }
                        } else if (section.translateHorizontal) {
                            layerUStart = (float)((double)layerUStart + translation);
                            layerUEnd = layerUStart + (float)section.textureWidth;
                        } else {
                            layerVStart = (float)((double)layerVStart + translation);
                            layerVEnd = layerVStart + (float)section.textureHeight;
                        }
                    }
                    if (section.rotationVariable != null && !section.rotateWindow) {
                        rotation = VehicleAnimationSystem.getVariableValue(addRotationSuffix ? section.rotationVariable + "_" + partNumber : section.rotationVariable, section.rotationFactor, section.rotationOffset, section.rotationClampMin, section.rotationClampMax, section.rotationAbsoluteValue, 0.0f, vehicle, null);
                        GL11.glRotated((double)rotation, (double)0.0, (double)0.0, (double)1.0);
                    }
                    if (!section.lightOverlay) {
                        GL11.glDisable((int)3042);
                        RenderInstrument.renderSquareUV(section.textureWidth, section.textureHeight, layerUStart / 1024.0f, layerUEnd / 1024.0f, layerVStart / 1024.0f, layerVEnd / 1024.0f);
                    } else if (lightsOn) {
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)770, (int)1);
                        RenderInstrument.renderSquareUV(section.textureWidth, section.textureHeight, layerUStart / 1024.0f, layerUEnd / 1024.0f, layerVStart / 1024.0f, layerVEnd / 1024.0f);
                    }
                }
                GL11.glPopMatrix();
            }
            if (lightsOn) {
                MasterLoader.renderInterface.setInternalLightingState(true);
            }
            GL11.glBlendFunc((int)770, (int)771);
            if (MasterLoader.renderInterface.getRenderPass() == 1) continue;
            GL11.glDisable((int)3042);
        }
    }

    private static void renderSquareUV(float width, float height, float u, float U, float v, float V) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)u, (float)v);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(-width / 2.0f), (float)(-height / 2.0f), (float)0.0f);
        GL11.glTexCoord2f((float)u, (float)V);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(-width / 2.0f), (float)(height / 2.0f), (float)0.0f);
        GL11.glTexCoord2f((float)U, (float)V);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(width / 2.0f), (float)(height / 2.0f), (float)0.0f);
        GL11.glTexCoord2f((float)U, (float)v);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(width / 2.0f), (float)(-height / 2.0f), (float)0.0f);
        GL11.glEnd();
    }
}

