/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.instances;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.instances.BlockPole;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityPole_Component;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_Core;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_Sign;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_StreetLight;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_TrafficSignal;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.rendering.components.LightType;
import minecrafttransportsimulator.rendering.components.OBJParser;
import minecrafttransportsimulator.rendering.components.TransformLight;
import minecrafttransportsimulator.rendering.instances.ARenderTileEntityBase;
import org.lwjgl.opengl.GL11;

public class RenderPole
extends ARenderTileEntityBase<TileEntityPole> {
    private static final Map<JSONPoleComponent, Map<ABlockBase.Axis, Integer>> connectorDisplayListMap = new HashMap<JSONPoleComponent, Map<ABlockBase.Axis, Integer>>();
    private static final Map<JSONPoleComponent, Map<ABlockBase.Axis, Integer>> solidConnectorDisplayListMap = new HashMap<JSONPoleComponent, Map<ABlockBase.Axis, Integer>>();
    private static final Map<JSONPoleComponent, Integer> componentDisplayListMap = new HashMap<JSONPoleComponent, Integer>();
    private static final Map<JSONPoleComponent, List<TransformLight>> componentLightMap = new HashMap<JSONPoleComponent, List<TransformLight>>();

    @Override
    public void render(TileEntityPole tile, float partialTicks) {
        TileEntityPole_Core coreComponent = (TileEntityPole_Core)tile.components.get((Object)ABlockBase.Axis.NONE);
        if (coreComponent != null) {
            if (!connectorDisplayListMap.containsKey(tile.definition)) {
                Map<String, Float[][]> parsedModel = OBJParser.parseOBJModel(((JSONPoleComponent)tile.definition).getModelLocation());
                HashMap<ABlockBase.Axis, Integer> connectorDisplayLists = new HashMap<ABlockBase.Axis, Integer>();
                HashMap<ABlockBase.Axis, Integer> solidConncectorDisplayLists = new HashMap<ABlockBase.Axis, Integer>();
                for (ABlockBase.Axis axis : ABlockBase.Axis.values()) {
                    if (parsedModel.containsKey(axis.name().toLowerCase())) {
                        connectorDisplayLists.put(axis, RenderPole.cacheAxisVertices(parsedModel.get(axis.name().toLowerCase())));
                    }
                    if (!parsedModel.containsKey(axis.name().toLowerCase() + "_solid")) continue;
                    solidConncectorDisplayLists.put(axis, RenderPole.cacheAxisVertices(parsedModel.get(axis.name().toLowerCase() + "_solid")));
                }
                connectorDisplayListMap.put((JSONPoleComponent)tile.definition, connectorDisplayLists);
                solidConnectorDisplayListMap.put((JSONPoleComponent)tile.definition, solidConncectorDisplayLists);
            }
            if (MasterLoader.renderInterface.getRenderPass() != 1) {
                MasterLoader.renderInterface.bindTexture(((JSONPoleComponent)tile.definition).getTextureLocation());
                for (ABlockBase.Axis axis : ABlockBase.Axis.values()) {
                    boolean slabBlock;
                    if (axis.equals((Object)ABlockBase.Axis.NONE)) {
                        GL11.glCallList((int)connectorDisplayListMap.get(tile.definition).get((Object)axis));
                        continue;
                    }
                    Point3i offset = axis.getOffsetPoint(tile.position);
                    boolean adjacentPole = tile.world.getBlock(offset) instanceof BlockPole;
                    boolean solidBlock = tile.world.isBlockSolid(offset);
                    boolean bl = slabBlock = axis.equals((Object)ABlockBase.Axis.DOWN) && tile.world.isBlockBottomSlab(offset) || axis.equals((Object)ABlockBase.Axis.UP) && tile.world.isBlockTopSlab(offset);
                    if ((adjacentPole || solidBlock) && connectorDisplayListMap.get(tile.definition).containsKey((Object)axis)) {
                        GL11.glCallList((int)connectorDisplayListMap.get(tile.definition).get((Object)axis));
                    }
                    if (solidBlock) {
                        if (!solidConnectorDisplayListMap.get(tile.definition).containsKey((Object)axis)) continue;
                        GL11.glCallList((int)solidConnectorDisplayListMap.get(tile.definition).get((Object)axis));
                        continue;
                    }
                    if (!slabBlock) continue;
                    ABlockBase.Axis oppositeAxis = axis.getOpposite();
                    if (!connectorDisplayListMap.get(tile.definition).containsKey((Object)axis)) continue;
                    GL11.glCallList((int)connectorDisplayListMap.get(tile.definition).get((Object)axis));
                    GL11.glTranslatef((float)0.0f, (float)axis.yOffset, (float)0.0f);
                    if (connectorDisplayListMap.get(tile.definition).containsKey((Object)oppositeAxis)) {
                        GL11.glCallList((int)connectorDisplayListMap.get(tile.definition).get((Object)oppositeAxis));
                    }
                    GL11.glCallList((int)connectorDisplayListMap.get(tile.definition).get((Object)ABlockBase.Axis.NONE));
                    GL11.glTranslatef((float)0.0f, (float)((float)(-axis.yOffset) / 2.0f), (float)0.0f);
                    if (solidConnectorDisplayListMap.get(tile.definition).containsKey((Object)axis)) {
                        GL11.glCallList((int)solidConnectorDisplayListMap.get(tile.definition).get((Object)axis));
                    }
                    GL11.glTranslatef((float)0.0f, (float)((float)(-axis.yOffset) / 2.0f), (float)0.0f);
                }
            }
        }
        for (ABlockBase.Axis axis : ABlockBase.Axis.values()) {
            if (axis.equals((Object)ABlockBase.Axis.NONE) || !tile.components.containsKey((Object)axis)) continue;
            ATileEntityPole_Component component = tile.components.get((Object)axis);
            if (!componentDisplayListMap.containsKey(component.definition)) {
                Map<String, Float[][]> parsedModel = OBJParser.parseOBJModel(component.definition.getModelLocation());
                ArrayList<TransformLight> lightParts = new ArrayList<TransformLight>();
                int displayListIndex = GL11.glGenLists((int)1);
                GL11.glNewList((int)displayListIndex, (int)4864);
                GL11.glBegin((int)4);
                for (Map.Entry<String, Float[][]> entry : parsedModel.entrySet()) {
                    if (entry.getKey().startsWith("&")) {
                        lightParts.add(new TransformLight(((JSONPoleComponent.PoleGeneral)component.definition.general).modelName, entry.getKey(), entry.getValue()));
                        if (((TransformLight)lightParts.get((int)(lightParts.size() - 1))).isLightupTexture) continue;
                    }
                    for (Float[] vertex : entry.getValue()) {
                        GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
                        GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
                        GL11.glVertex3f((float)vertex[0].floatValue(), (float)vertex[1].floatValue(), (float)vertex[2].floatValue());
                    }
                }
                GL11.glEnd();
                GL11.glEndList();
                componentDisplayListMap.put(component.definition, displayListIndex);
                componentLightMap.put(component.definition, lightParts);
            }
            GL11.glPushMatrix();
            GL11.glRotatef((float)axis.yRotation, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(((JSONPoleComponent.PoleGeneral)((JSONPoleComponent)tile.definition).general).radius + 0.001f));
            if (MasterLoader.renderInterface.getRenderPass() != 1) {
                MasterLoader.renderInterface.bindTexture(component.definition.getTextureLocation());
                GL11.glCallList((int)componentDisplayListMap.get(component.definition));
            }
            if (component instanceof TileEntityPole_TrafficSignal) {
                LightType litLight;
                switch (((TileEntityPole_TrafficSignal)component).state) {
                    case UNLINKED: {
                        litLight = LightType.UNLINKEDLIGHT;
                        break;
                    }
                    case RED: {
                        litLight = LightType.STOPLIGHT;
                        break;
                    }
                    case YELLOW: {
                        litLight = LightType.CAUTIONLIGHT;
                        break;
                    }
                    case GREEN: {
                        litLight = LightType.GOLIGHT;
                        break;
                    }
                    default: {
                        litLight = null;
                    }
                }
                for (TransformLight lightPart : componentLightMap.get(component.definition)) {
                    lightPart.renderOnBlock(tile.world, tile.position, lightPart.type.equals((Object)litLight));
                }
            } else if (component instanceof TileEntityPole_StreetLight) {
                for (TransformLight lightPart : componentLightMap.get(component.definition)) {
                    lightPart.renderOnBlock(tile.world, tile.position, ((TileEntityPole_StreetLight)component).state.equals((Object)TileEntityPole_StreetLight.LightState.ON));
                }
            } else if (component instanceof TileEntityPole_Sign) {
                for (TransformLight lightPart : componentLightMap.get(component.definition)) {
                    lightPart.renderOnBlock(tile.world, tile.position, true);
                }
                if (((JSONPoleComponent.PoleGeneral)component.definition.general).textObjects != null) {
                    MasterLoader.renderInterface.renderTextMarkings(((JSONPoleComponent.PoleGeneral)component.definition.general).textObjects, ((TileEntityPole_Sign)component).getTextLines(), null, false);
                }
            }
            GL11.glPopMatrix();
        }
    }

    @Override
    public boolean rotateToBlock() {
        return false;
    }

    @Override
    public boolean translateToSlabs() {
        return false;
    }

    private static int cacheAxisVertices(Float[][] vertices) {
        int displayListIndex = GL11.glGenLists((int)1);
        GL11.glNewList((int)displayListIndex, (int)4864);
        GL11.glBegin((int)4);
        for (Float[] vertex : vertices) {
            GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
            GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
            GL11.glVertex3f((float)vertex[0].floatValue(), (float)vertex[1].floatValue(), (float)vertex[2].floatValue());
        }
        GL11.glEnd();
        GL11.glEndList();
        return displayListIndex;
    }
}

