/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.instances;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.instances.ItemInstrument;
import minecrafttransportsimulator.items.instances.ItemPart;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.rendering.components.ATransformRenderable;
import minecrafttransportsimulator.rendering.components.IVehiclePartFXProvider;
import minecrafttransportsimulator.rendering.components.LightType;
import minecrafttransportsimulator.rendering.components.OBJParser;
import minecrafttransportsimulator.rendering.components.RenderableModelObject;
import minecrafttransportsimulator.rendering.components.TransformLight;
import minecrafttransportsimulator.rendering.components.TransformTreadRoller;
import minecrafttransportsimulator.rendering.instances.RenderInstrument;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartGroundDevice;
import org.lwjgl.opengl.GL11;

public final class RenderVehicle {
    private static final Map<String, Integer> vehicleDisplayLists = new HashMap<String, Integer>();
    private static final Map<String, List<RenderableModelObject>> vehicleObjectLists = new HashMap<String, List<RenderableModelObject>>();
    @Deprecated
    private static final Map<String, List<Float[]>> treadDeltas = new HashMap<String, List<Float[]>>();
    private static final Map<String, List<Double[]>> treadPoints = new HashMap<String, List<Double[]>>();
    private static final Map<String, Integer> partDisplayLists = new HashMap<String, Integer>();
    private static final Map<String, List<RenderableModelObject>> partObjectLists = new HashMap<String, List<RenderableModelObject>>();

    public static void clearVehicleCaches(JSONVehicle definition) {
        if (vehicleDisplayLists.containsKey(definition.systemName)) {
            GL11.glDeleteLists((int)vehicleDisplayLists.remove(definition.systemName), (int)1);
            for (RenderableModelObject modelObject : vehicleObjectLists.get(definition.systemName)) {
                modelObject.resetDisplayList();
            }
            vehicleObjectLists.remove(definition.systemName);
            treadDeltas.remove(definition.systemName);
            treadPoints.remove(definition.systemName);
        }
    }

    public static void clearPartCaches(JSONPart definition) {
        String modelName = definition.getModelLocation();
        if (partDisplayLists.containsKey(modelName)) {
            GL11.glDeleteLists((int)partDisplayLists.remove(modelName), (int)1);
        }
        if (partObjectLists.containsKey(modelName)) {
            for (RenderableModelObject modelObject : partObjectLists.get(modelName)) {
                modelObject.resetDisplayList();
            }
            partObjectLists.remove(definition.systemName);
        }
    }

    public static boolean doesVehicleHaveLight(EntityVehicleF_Physics vehicle, LightType light) {
        for (RenderableModelObject modelObject : vehicleObjectLists.get(vehicle.definition.systemName)) {
            for (ATransformRenderable transform : modelObject.transforms) {
                if (!(transform instanceof TransformLight) || !((TransformLight)transform).type.equals((Object)light)) continue;
                return true;
            }
        }
        for (APart part : vehicle.parts) {
            String partModelLocation = part.definition.getModelLocation();
            if (!partObjectLists.containsKey(partModelLocation)) continue;
            for (RenderableModelObject modelObject : partObjectLists.get(partModelLocation)) {
                for (ATransformRenderable transform : modelObject.transforms) {
                    if (!(transform instanceof TransformLight) || !((TransformLight)transform).type.equals((Object)light)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void render(EntityVehicleF_Physics vehicle, float partialTicks) {
        Point3d vehiclePosition = vehicle.position.copy().subtract(vehicle.prevPosition).multiply(partialTicks).add(vehicle.prevPosition);
        Point3d renderPosition = vehiclePosition.copy().subtract(MasterLoader.gameInterface.getRenderViewEntity().getRenderedPosition(partialTicks));
        Point3d renderRotation = vehicle.angles.copy().subtract(vehicle.prevAngles).multiply(1.0 - (double)partialTicks).multiply(-1.0).add(vehicle.angles);
        MasterLoader.renderInterface.setLightingToEntity(vehicle);
        GL11.glShadeModel((int)7425);
        GL11.glPushMatrix();
        GL11.glTranslated((double)renderPosition.x, (double)renderPosition.y, (double)renderPosition.z);
        GL11.glPushMatrix();
        GL11.glRotated((double)renderRotation.y, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)renderRotation.x, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)renderRotation.z, (double)0.0, (double)0.0, (double)1.0);
        RenderVehicle.renderMainModel(vehicle, partialTicks);
        for (APart part : vehicle.parts) {
            if (part.isFake() || part.vehicleDefinition.isSubPart) continue;
            GL11.glPushMatrix();
            if (part.definition.ground != null && part.definition.ground.isTread) {
                GL11.glTranslated((double)part.placementOffset.x, (double)0.0, (double)0.0);
                RenderVehicle.renderPart(part, partialTicks);
            } else {
                Point3d offset = part.getPositionOffset(partialTicks).add(part.placementOffset);
                GL11.glTranslated((double)offset.x, (double)offset.y, (double)offset.z);
                RenderVehicle.renderPart(part, partialTicks);
            }
            GL11.glPopMatrix();
        }
        GL11.glShadeModel((int)7424);
        RenderVehicle.renderInstruments(vehicle);
        GL11.glPopMatrix();
        if (MasterLoader.renderInterface.getRenderPass() == -1) {
            MasterLoader.renderInterface.renderEntityRiders(vehicle, partialTicks);
        }
        GL11.glTranslated((double)(-vehiclePosition.x), (double)(-vehiclePosition.y), (double)(-vehiclePosition.z));
        RenderVehicle.renderPartBoxes(vehicle);
        if (MasterLoader.renderInterface.shouldRenderBoundingBoxes()) {
            RenderVehicle.renderBoundingBoxes(vehicle);
        }
        GL11.glPopMatrix();
        MasterLoader.renderInterface.resetStates();
        if (MasterLoader.renderInterface.getRenderPass() != 1 && !MasterLoader.gameInterface.isGamePaused()) {
            for (APart part : vehicle.parts) {
                if (!(part instanceof IVehiclePartFXProvider)) continue;
                ((IVehiclePartFXProvider)((Object)part)).spawnParticles();
            }
        }
    }

    private static void renderMainModel(EntityVehicleF_Physics vehicle, float partialTicks) {
        if (!vehicleDisplayLists.containsKey(vehicle.definition.systemName)) {
            Map<String, Float[][]> parsedModel = OBJParser.parseOBJModel(vehicle.definition.getModelLocation());
            ArrayList<RenderableModelObject> modelObjects = new ArrayList<RenderableModelObject>();
            if (vehicle.definition.rendering.animatedObjects != null) {
                for (JSONVehicle.VehicleAnimatedObject definition : vehicle.definition.rendering.animatedObjects) {
                    if (!parsedModel.containsKey(definition.objectName)) continue;
                    modelObjects.add(new RenderableModelObject(vehicle.definition.systemName, definition.objectName, definition, parsedModel.get(definition.objectName), vehicle, null));
                    parsedModel.remove(definition.objectName);
                }
            }
            Iterator<Map.Entry<String, Float[][]>> iterator = parsedModel.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Float[][]> entry = iterator.next();
                RenderableModelObject modelObject = new RenderableModelObject(vehicle.definition.systemName, entry.getKey(), null, entry.getValue(), vehicle, null);
                if (modelObject.transforms.isEmpty()) continue;
                modelObjects.add(modelObject);
                iterator.remove();
            }
            vehicleDisplayLists.put(vehicle.definition.systemName, OBJParser.generateDisplayList(parsedModel));
            vehicleObjectLists.put(vehicle.definition.systemName, modelObjects);
        }
        MasterLoader.renderInterface.setTexture(vehicle.definition.getTextureLocation(vehicle.currentSubName));
        if (MasterLoader.renderInterface.getRenderPass() != 1) {
            GL11.glCallList((int)vehicleDisplayLists.get(vehicle.definition.systemName));
        }
        if (MasterLoader.renderInterface.renderTextMarkings(vehicle.definition.rendering != null ? vehicle.definition.rendering.textObjects : null, vehicle.textLines, null, vehicle.areInteriorLightsOn())) {
            MasterLoader.renderInterface.recallTexture();
        }
        List<RenderableModelObject> modelObjects = vehicleObjectLists.get(vehicle.definition.systemName);
        for (RenderableModelObject modelObject : modelObjects) {
            if (modelObject.applyAfter != null) continue;
            modelObject.render(vehicle, null, partialTicks, modelObjects);
            if (!MasterLoader.renderInterface.renderTextMarkings(vehicle.definition.rendering != null ? vehicle.definition.rendering.textObjects : null, vehicle.textLines, modelObject.objectName, vehicle.areInteriorLightsOn())) continue;
            MasterLoader.renderInterface.recallTexture();
        }
    }

    private static void renderPart(APart part, float partialTicks) {
        boolean mirrored;
        List<Object> modelObjects;
        String partModelLocation = part.definition.getModelLocation();
        if (!partDisplayLists.containsKey(partModelLocation)) {
            Map<String, Float[][]> parsedModel = OBJParser.parseOBJModel(partModelLocation);
            modelObjects = new ArrayList<RenderableModelObject>();
            if (part.definition.rendering != null && part.definition.rendering.animatedObjects != null) {
                for (JSONVehicle.VehicleAnimatedObject vehicleAnimatedObject : part.definition.rendering.animatedObjects) {
                    if (!parsedModel.containsKey(vehicleAnimatedObject.objectName)) continue;
                    modelObjects.add(new RenderableModelObject(partModelLocation, vehicleAnimatedObject.objectName, vehicleAnimatedObject, parsedModel.get(vehicleAnimatedObject.objectName), part.vehicle, part));
                    parsedModel.remove(vehicleAnimatedObject.objectName);
                }
            }
            Iterator<Map.Entry<String, Float[][]>> iterator = parsedModel.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Float[][]> entry = iterator.next();
                RenderableModelObject modelObject = new RenderableModelObject(partModelLocation, entry.getKey(), null, entry.getValue(), part.vehicle, part);
                if (modelObject.transforms.isEmpty()) continue;
                modelObjects.add(modelObject);
                iterator.remove();
            }
            partDisplayLists.put(partModelLocation, OBJParser.generateDisplayList(parsedModel));
            partObjectLists.put(partModelLocation, modelObjects);
        }
        if (!((JSONPart.JSONPartGeneral)part.definition.general).useVehicleTexture) {
            MasterLoader.renderInterface.setTexture(part.definition.getTextureLocation(part.currentSubName));
        } else {
            MasterLoader.renderInterface.setTexture(part.vehicle.definition.getTextureLocation(part.vehicle.currentSubName));
        }
        GL11.glPushMatrix();
        RenderVehicle.rotatePart(part, partialTicks);
        boolean bl = mirrored = (part.placementOffset.x < 0.0 && !part.vehicleDefinition.inverseMirroring || part.placementOffset.x > 0.0 && part.vehicleDefinition.inverseMirroring) && !part.disableMirroring;
        if (mirrored && !part.vehicleDefinition.isSubPart) {
            GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
            GL11.glCullFace((int)1028);
        }
        if (part.definition.ground != null && part.definition.ground.isTread && MasterLoader.renderInterface.getRenderPass() != 1) {
            if (part.vehicleDefinition.treadZPoints != null) {
                RenderVehicle.doManualTreadRender((PartGroundDevice)part, partialTicks, partDisplayLists.get(partModelLocation));
            } else {
                RenderVehicle.doAutomaticTreadRender((PartGroundDevice)part, partialTicks, partDisplayLists.get(partModelLocation));
            }
        } else {
            if (MasterLoader.renderInterface.getRenderPass() != 1) {
                GL11.glCallList((int)partDisplayLists.get(partModelLocation));
            }
            if (MasterLoader.renderInterface.renderTextMarkings(part.definition.rendering != null ? part.definition.rendering.textObjects : null, part.textLines, null, part.vehicle.areInteriorLightsOn())) {
                MasterLoader.renderInterface.recallTexture();
            }
            modelObjects = partObjectLists.get(partModelLocation);
            for (RenderableModelObject renderableModelObject : modelObjects) {
                if (renderableModelObject.applyAfter != null) continue;
                renderableModelObject.render(part.vehicle, part, partialTicks, modelObjects);
                if (!MasterLoader.renderInterface.renderTextMarkings(part.definition.rendering != null ? part.definition.rendering.textObjects : null, part.textLines, renderableModelObject.objectName, part.vehicle.areInteriorLightsOn())) continue;
                MasterLoader.renderInterface.recallTexture();
            }
            for (APart aPart : part.childParts) {
                if (aPart.isFake() || !aPart.vehicleDefinition.isSubPart) continue;
                Point3d relativeOffset = aPart.getPositionOffset(partialTicks).add(aPart.placementOffset).subtract(part.placementOffset);
                GL11.glPushMatrix();
                GL11.glTranslated((double)relativeOffset.x, (double)relativeOffset.y, (double)relativeOffset.z);
                RenderVehicle.renderPart(aPart, partialTicks);
                GL11.glPopMatrix();
            }
        }
        if (mirrored) {
            GL11.glCullFace((int)1029);
        }
        GL11.glPopMatrix();
    }

    private static void rotatePart(APart part, float partialTicks) {
        Point3d actionRotation;
        Point3d positionRotation;
        if (!part.placementRotation.isZero()) {
            if (part.parentPart != null && part.vehicleDefinition.isSubPart) {
                GL11.glRotated((double)(part.placementRotation.y - part.parentPart.placementRotation.y), (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)(part.placementRotation.x - part.parentPart.placementRotation.x), (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)(part.placementRotation.z - part.parentPart.placementRotation.z), (double)0.0, (double)0.0, (double)1.0);
            } else {
                GL11.glRotated((double)part.placementRotation.y, (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)part.placementRotation.x, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)part.placementRotation.z, (double)0.0, (double)0.0, (double)1.0);
            }
        }
        if (!(positionRotation = part.getPositionRotation(partialTicks)).isZero()) {
            GL11.glRotated((double)positionRotation.y, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)positionRotation.x, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)positionRotation.z, (double)0.0, (double)0.0, (double)1.0);
        }
        if (!(actionRotation = part.getActionRotation(partialTicks)).isZero()) {
            GL11.glRotated((double)actionRotation.y, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)actionRotation.x, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)actionRotation.z, (double)0.0, (double)0.0, (double)1.0);
        }
    }

    @Deprecated
    private static void doManualTreadRender(PartGroundDevice treadPart, float partialTicks, int displayListIndex) {
        List<Float[]> deltas = treadDeltas.get(treadPart.vehicle.definition.systemName);
        if (deltas == null) {
            float totalDistance = 0.0f;
            float lastY = treadPart.vehicleDefinition.treadYPoints[0];
            float lastZ = treadPart.vehicleDefinition.treadZPoints[0];
            for (int i = 1; i < treadPart.vehicleDefinition.treadYPoints.length; i = (int)((byte)(i + 1))) {
                totalDistance = (float)((double)totalDistance + Math.hypot(treadPart.vehicleDefinition.treadYPoints[i] - lastY, treadPart.vehicleDefinition.treadYPoints[i] - lastZ));
                lastY = treadPart.vehicleDefinition.treadYPoints[i];
                lastZ = treadPart.vehicleDefinition.treadZPoints[i];
            }
            deltas = new ArrayList<Float[]>();
            float spacing = treadPart.definition.ground.spacing;
            int pointIndex = 0;
            float currentY = treadPart.vehicleDefinition.treadYPoints[pointIndex];
            float currentZ = treadPart.vehicleDefinition.treadZPoints[pointIndex];
            float nextY = treadPart.vehicleDefinition.treadYPoints[pointIndex + 1];
            float nextZ = treadPart.vehicleDefinition.treadZPoints[pointIndex + 1];
            float deltaYBeforeSegment = 0.0f;
            float deltaZBeforeSegment = 0.0f;
            float deltaBeforeSegment = 0.0f;
            float segmentDeltaY = nextY - currentY;
            float segmentDeltaZ = nextZ - currentZ;
            float segmentDeltaTotal = (float)Math.hypot(segmentDeltaY, segmentDeltaZ);
            float angle = treadPart.vehicleDefinition.treadAngles[pointIndex];
            float currentAngle = 0.0f;
            while (totalDistance > 0.0f) {
                while (deltaBeforeSegment + segmentDeltaTotal < spacing) {
                    if ((pointIndex = (int)((byte)(pointIndex + 1))) + 1 == treadPart.vehicleDefinition.treadYPoints.length) {
                        float angleToAdd;
                        currentY = treadPart.vehicleDefinition.treadYPoints[pointIndex];
                        currentZ = treadPart.vehicleDefinition.treadZPoints[pointIndex];
                        nextY = treadPart.vehicleDefinition.treadYPoints[0];
                        nextZ = treadPart.vehicleDefinition.treadZPoints[0];
                        for (angleToAdd = treadPart.vehicleDefinition.treadAngles[0] - treadPart.vehicleDefinition.treadAngles[pointIndex]; angleToAdd < 0.0f; angleToAdd += 360.0f) {
                        }
                        angle += angleToAdd;
                    } else {
                        if (pointIndex + 1 > treadPart.vehicleDefinition.treadYPoints.length) break;
                        currentY = treadPart.vehicleDefinition.treadYPoints[pointIndex];
                        currentZ = treadPart.vehicleDefinition.treadZPoints[pointIndex];
                        nextY = treadPart.vehicleDefinition.treadYPoints[pointIndex + 1];
                        nextZ = treadPart.vehicleDefinition.treadZPoints[pointIndex + 1];
                        angle += treadPart.vehicleDefinition.treadAngles[pointIndex] - treadPart.vehicleDefinition.treadAngles[pointIndex - 1];
                    }
                    deltaBeforeSegment += segmentDeltaTotal;
                    deltaYBeforeSegment += segmentDeltaY;
                    deltaZBeforeSegment += segmentDeltaZ;
                    segmentDeltaY = nextY - currentY;
                    segmentDeltaZ = nextZ - currentZ;
                    segmentDeltaTotal = (float)Math.hypot(segmentDeltaY, segmentDeltaZ);
                }
                if (deltaBeforeSegment + segmentDeltaTotal >= spacing) {
                    float segmentPercentage = (spacing - deltaBeforeSegment) / segmentDeltaTotal;
                    float segmentY = deltaYBeforeSegment + segmentDeltaY * segmentPercentage;
                    float segmentZ = deltaZBeforeSegment + segmentDeltaZ * segmentPercentage;
                    float correctedZ = (float)(Math.cos(Math.toRadians(currentAngle += angle)) * (double)segmentZ - Math.sin(Math.toRadians(currentAngle)) * (double)segmentY);
                    float correctedY = (float)(Math.sin(Math.toRadians(currentAngle)) * (double)segmentZ + Math.cos(Math.toRadians(currentAngle)) * (double)segmentY);
                    deltas.add(new Float[]{Float.valueOf(correctedY), Float.valueOf(correctedZ), Float.valueOf(angle)});
                    totalDistance -= spacing;
                    segmentDeltaTotal -= spacing;
                    segmentDeltaY -= segmentDeltaY * segmentPercentage;
                    segmentDeltaZ -= segmentDeltaZ * segmentPercentage;
                    deltaBeforeSegment = 0.0f;
                    deltaYBeforeSegment = 0.0f;
                    deltaZBeforeSegment = 0.0f;
                    angle = 0.0f;
                    continue;
                }
                if (deltaBeforeSegment + segmentDeltaTotal > spacing / 2.0f) {
                    deltas.add(deltas.get(deltas.size() - 1));
                }
                totalDistance = 0.0f;
            }
            treadDeltas.put(treadPart.vehicle.definition.systemName, deltas);
        }
        float treadMovementPercentage = (float)((Math.abs(treadPart.angularPosition) + treadPart.angularVelocity * (double)partialTicks) * (double)treadPart.getHeight() / Math.PI % (double)treadPart.definition.ground.spacing / (double)treadPart.definition.ground.spacing);
        if (treadPart.angularPosition < 0.0) {
            treadMovementPercentage = 1.0f - treadMovementPercentage;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)(treadPart.placementOffset.y + (double)treadPart.vehicleDefinition.treadYPoints[0]), (double)(treadPart.placementOffset.z + (double)treadPart.vehicleDefinition.treadZPoints[0]));
        for (Float[] point : deltas) {
            if (point[2].floatValue() != 0.0f) {
                GL11.glRotatef((float)point[2].floatValue(), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)(point[0].floatValue() * treadMovementPercentage), (float)(point[1].floatValue() * treadMovementPercentage));
                GL11.glRotatef((float)(-point[2].floatValue() * (1.0f - treadMovementPercentage)), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glCallList((int)displayListIndex);
                GL11.glRotatef((float)(point[2].floatValue() * (1.0f - treadMovementPercentage)), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)(point[0].floatValue() * (1.0f - treadMovementPercentage)), (float)(point[1].floatValue() * (1.0f - treadMovementPercentage)));
                continue;
            }
            GL11.glTranslatef((float)0.0f, (float)(point[0].floatValue() * treadMovementPercentage), (float)(point[1].floatValue() * treadMovementPercentage));
            GL11.glCallList((int)displayListIndex);
            GL11.glTranslatef((float)0.0f, (float)(point[0].floatValue() * (1.0f - treadMovementPercentage)), (float)(point[1].floatValue() * (1.0f - treadMovementPercentage)));
        }
        GL11.glPopMatrix();
    }

    private static void doAutomaticTreadRender(PartGroundDevice treadPart, float partialTicks, int displayListIndex) {
        List<Double[]> points = treadPoints.get(treadPart.vehicle.definition.systemName);
        if (points == null) {
            int i;
            HashMap<Integer, TransformTreadRoller> parsedRollers = new HashMap<Integer, TransformTreadRoller>();
            for (RenderableModelObject modelObject : vehicleObjectLists.get(treadPart.vehicle.definition.systemName)) {
                for (ATransformRenderable transform : modelObject.transforms) {
                    if (!(transform instanceof TransformTreadRoller)) continue;
                    TransformTreadRoller treadTransform = (TransformTreadRoller)transform;
                    parsedRollers.put(treadTransform.rollerNumber, treadTransform);
                }
            }
            TransformTreadRoller[] rollers = new TransformTreadRoller[parsedRollers.size()];
            for (i = 0; i < parsedRollers.size(); ++i) {
                if (!parsedRollers.containsKey(i)) {
                    throw new IndexOutOfBoundsException("ERROR: Attempted to render roller_" + i + " on " + treadPart.vehicle.definition.packID + ":" + treadPart.vehicle.definition.systemName + ", but it was not found.  Did you not make it in the OBJ model?");
                }
                if (i < parsedRollers.size() - 1) {
                    ((TransformTreadRoller)parsedRollers.get(i)).calculateEndpoints((TransformTreadRoller)parsedRollers.get(i + 1));
                } else {
                    ((TransformTreadRoller)parsedRollers.get(i)).calculateEndpoints((TransformTreadRoller)parsedRollers.get(0));
                }
                rollers[i] = (TransformTreadRoller)parsedRollers.get(i);
            }
            rollers[0].endAngle = 180.0;
            for (i = 1; i < rollers.length; ++i) {
                TransformTreadRoller roller = rollers[i];
                roller.startAngle = rollers[i - 1].endAngle;
                while (roller.endAngle < roller.startAngle - 30.0) {
                    roller.endAngle += 360.0;
                }
                while (roller.endAngle > roller.startAngle + 360.0) {
                    roller.endAngle += 360.0;
                }
            }
            while (rollers[0].startAngle < 0.0) {
                rollers[0].startAngle += 360.0;
            }
            if (rollers[0].startAngle > 180.0) {
                rollers[0].startAngle -= 360.0;
            }
            rollers[0].startAngle += 360.0;
            rollers[rollers.length - 1].endAngle = rollers[0].startAngle;
            double totalPathLength = 0.0;
            for (int i2 = 0; i2 < rollers.length; ++i2) {
                TransformTreadRoller roller = rollers[i2];
                totalPathLength += Math.PI * 2 * roller.radius * Math.abs(roller.endAngle - (i2 == 0 ? roller.startAngle - 360.0 : roller.startAngle)) / 360.0;
                TransformTreadRoller nextRoller = i2 == rollers.length - 1 ? rollers[0] : rollers[i2 + 1];
                double straightPathLength = Math.hypot(nextRoller.startY - roller.endY, nextRoller.startZ - roller.endZ);
                if (treadPart.vehicleDefinition.treadDroopConstant > 0.0f && (roller.endAngle % 360.0 < 10.0 || roller.endAngle % 360.0 > 350.0) && (nextRoller.startAngle % 360.0 < 10.0 || nextRoller.startAngle % 360.0 > 350.0)) {
                    totalPathLength += 2.0 * (double)treadPart.vehicleDefinition.treadDroopConstant * Math.sinh(straightPathLength / 2.0 / (double)treadPart.vehicleDefinition.treadDroopConstant);
                    continue;
                }
                totalPathLength += straightPathLength;
            }
            double deltaDist = (double)treadPart.definition.ground.spacing + totalPathLength % (double)treadPart.definition.ground.spacing / (totalPathLength / (double)treadPart.definition.ground.spacing);
            double leftoverPathLength = 0.0;
            double yPoint = 0.0;
            double zPoint = 0.0;
            points = new ArrayList<Double[]>();
            for (int i3 = 0; i3 < rollers.length; ++i3) {
                TransformTreadRoller roller = rollers[i3];
                double rollerPathLength = Math.PI * 2 * roller.radius * Math.abs(roller.endAngle - (i3 == 0 ? roller.startAngle - 360.0 : roller.startAngle)) / 360.0;
                double currentAngle = roller.startAngle;
                if (i3 == 0) {
                    yPoint = roller.yPos + roller.radius * Math.cos(Math.toRadians(currentAngle));
                    zPoint = roller.zPos + roller.radius * Math.sin(Math.toRadians(currentAngle));
                    points.add(new Double[]{yPoint, zPoint, currentAngle + 180.0});
                }
                if (deltaDist - leftoverPathLength < rollerPathLength) {
                    if (leftoverPathLength > 0.0) {
                        Double[] lastPoint = points.get(points.size() - 1);
                        yPoint = roller.yPos + roller.radius * Math.cos(Math.toRadians(currentAngle));
                        zPoint = roller.zPos + roller.radius * Math.sin(Math.toRadians(currentAngle));
                        double pointDist = Math.hypot(yPoint - lastPoint[0], zPoint - lastPoint[1]);
                        double normalizedY = (yPoint - lastPoint[0]) / pointDist;
                        double normalizedZ = (zPoint - lastPoint[1]) / pointDist;
                        double rollerAngleSpan = 360.0 * ((deltaDist - leftoverPathLength) / roller.circumference);
                        points.add(new Double[]{lastPoint[0] + deltaDist * normalizedY, lastPoint[1] + deltaDist * normalizedZ, lastPoint[2] + rollerAngleSpan});
                        currentAngle += rollerAngleSpan;
                        rollerPathLength -= deltaDist - leftoverPathLength;
                        leftoverPathLength = 0.0;
                    }
                    while (rollerPathLength > deltaDist) {
                        rollerPathLength -= deltaDist;
                        yPoint = roller.yPos + roller.radius * Math.cos(Math.toRadians(currentAngle += 360.0 * (deltaDist / roller.circumference)));
                        zPoint = roller.zPos + roller.radius * Math.sin(Math.toRadians(currentAngle));
                        points.add(new Double[]{yPoint, zPoint, currentAngle + 180.0});
                    }
                    currentAngle = roller.endAngle;
                }
                TransformTreadRoller nextRoller = i3 == rollers.length - 1 ? rollers[0] : rollers[i3 + 1];
                double straightPathLength = Math.hypot(nextRoller.startY - roller.endY, nextRoller.startZ - roller.endZ);
                double extraPathLength = rollerPathLength + leftoverPathLength;
                double normalizedY = (nextRoller.startY - roller.endY) / straightPathLength;
                double normalizedZ = (nextRoller.startZ - roller.endZ) / straightPathLength;
                if (treadPart.vehicleDefinition.treadDroopConstant > 0.0f && (roller.endAngle % 360.0 < 10.0 || roller.endAngle % 360.0 > 350.0) && (nextRoller.startAngle % 360.0 < 10.0 || nextRoller.startAngle % 360.0 > 350.0)) {
                    double hyperbolicPathLength = 2.0 * (double)treadPart.vehicleDefinition.treadDroopConstant * Math.sinh(straightPathLength / 2.0 / (double)treadPart.vehicleDefinition.treadDroopConstant);
                    double hyperbolicFunctionStep = deltaDist * straightPathLength / hyperbolicPathLength;
                    double hyperbolicPathMaxY = (double)treadPart.vehicleDefinition.treadDroopConstant * Math.cosh(-straightPathLength / 2.0 / (double)treadPart.vehicleDefinition.treadDroopConstant);
                    double hyperbolicFunctionCurrent = 0.0;
                    while (straightPathLength + extraPathLength - hyperbolicFunctionCurrent > hyperbolicFunctionStep) {
                        if (extraPathLength > 0.0) {
                            hyperbolicFunctionCurrent += extraPathLength * hyperbolicFunctionStep;
                            extraPathLength = 0.0;
                        } else {
                            hyperbolicFunctionCurrent += hyperbolicFunctionStep;
                        }
                        yPoint = roller.endY + normalizedY * hyperbolicFunctionCurrent + (double)treadPart.vehicleDefinition.treadDroopConstant * Math.cosh((hyperbolicFunctionCurrent - straightPathLength / 2.0) / (double)treadPart.vehicleDefinition.treadDroopConstant) - hyperbolicPathMaxY;
                        zPoint = roller.endZ + normalizedZ * hyperbolicFunctionCurrent;
                        points.add(new Double[]{yPoint, zPoint, roller.endAngle + 180.0 - Math.toDegrees(Math.asin((hyperbolicFunctionCurrent - straightPathLength / 2.0) / (double)treadPart.vehicleDefinition.treadDroopConstant))});
                    }
                    leftoverPathLength = (straightPathLength - hyperbolicFunctionCurrent) / (straightPathLength / hyperbolicPathLength);
                    continue;
                }
                while (straightPathLength + extraPathLength > deltaDist) {
                    if (extraPathLength > 0.0) {
                        yPoint = roller.endY + normalizedY * (deltaDist - extraPathLength);
                        zPoint = roller.endZ + normalizedZ * (deltaDist - extraPathLength);
                        straightPathLength -= deltaDist - extraPathLength;
                        extraPathLength = 0.0;
                    } else {
                        yPoint += normalizedY * deltaDist;
                        zPoint += normalizedZ * deltaDist;
                        straightPathLength -= deltaDist;
                    }
                    points.add(new Double[]{yPoint, zPoint, roller.endAngle + 180.0});
                }
                leftoverPathLength = straightPathLength;
            }
            treadPoints.put(treadPart.vehicle.definition.systemName, points);
        }
        float treadLinearPosition = (float)((Math.abs(treadPart.angularPosition) + treadPart.angularVelocity * (double)partialTicks) * treadPart.vehicle.SPEED_FACTOR);
        float treadMovementPercentage = treadLinearPosition % treadPart.definition.ground.spacing / treadPart.definition.ground.spacing;
        if (treadPart.angularPosition < 0.0) {
            treadMovementPercentage = 1.0f - treadMovementPercentage;
        }
        GL11.glPushMatrix();
        for (int i = 0; i < points.size() - 1; ++i) {
            Double[] point = points.get(i);
            Double[] nextPoint = i == points.size() - 1 ? points.get(0) : points.get(i + 1);
            double yDelta = nextPoint[0] - point[0];
            double zDelta = nextPoint[1] - point[1];
            double angleDelta = nextPoint[2] - point[2];
            if (i == 0) {
                GL11.glTranslated((double)0.0, (double)point[0], (double)point[1]);
            }
            if (angleDelta > 180.0) {
                angleDelta -= 360.0;
            } else if (angleDelta < -180.0) {
                angleDelta += 360.0;
            }
            if (point[2] != 0.0 || angleDelta != 0.0) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)(yDelta * (double)treadMovementPercentage), (double)(zDelta * (double)treadMovementPercentage));
                GL11.glRotated((double)(point[2] + angleDelta * (double)treadMovementPercentage), (double)1.0, (double)0.0, (double)0.0);
                GL11.glCallList((int)displayListIndex);
                GL11.glPopMatrix();
                GL11.glTranslated((double)0.0, (double)yDelta, (double)zDelta);
                continue;
            }
            GL11.glTranslated((double)0.0, (double)(yDelta * (double)treadMovementPercentage), (double)(zDelta * (double)treadMovementPercentage));
            GL11.glCallList((int)displayListIndex);
            GL11.glTranslated((double)0.0, (double)(yDelta * (double)(1.0f - treadMovementPercentage)), (double)(zDelta * (double)(1.0f - treadMovementPercentage)));
        }
        GL11.glPopMatrix();
    }

    private static void renderInstruments(EntityVehicleF_Physics vehicle) {
        GL11.glEnable((int)2977);
        for (byte i = 0; i < vehicle.definition.motorized.instruments.size(); i = (byte)(i + 1)) {
            JSONVehicle.PackInstrument packInstrument = vehicle.definition.motorized.instruments.get(i);
            GL11.glPushMatrix();
            GL11.glTranslated((double)packInstrument.pos.x, (double)packInstrument.pos.y, (double)packInstrument.pos.z);
            GL11.glRotated((double)packInstrument.rot.x, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)packInstrument.rot.y, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)packInstrument.rot.z, (double)0.0, (double)0.0, (double)1.0);
            GL11.glScalef((float)(-packInstrument.scale / 16.0f), (float)(-packInstrument.scale / 16.0f), (float)(-packInstrument.scale / 16.0f));
            if (vehicle.instruments.containsKey(i)) {
                RenderInstrument.drawInstrument((ItemInstrument)vehicle.instruments.get(i), packInstrument.optionalPartNumber, vehicle);
            }
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)2977);
    }

    private static void renderPartBoxes(EntityVehicleF_Physics vehicle) {
        if (MasterLoader.renderInterface.getRenderPass() != 0) {
            IWrapperPlayer player;
            AItemBase heldItem;
            MasterLoader.renderInterface.setLightingState(false);
            MasterLoader.renderInterface.setBlendState(true, false);
            GL11.glDisable((int)3553);
            if (MasterLoader.renderInterface.getRenderPass() == -1) {
                MasterLoader.renderInterface.setBlendState(true, false);
            }
            if ((heldItem = (player = MasterLoader.gameInterface.getClientPlayer()).getHeldItem()) instanceof ItemPart) {
                ItemPart heldPart = (ItemPart)heldItem;
                for (Map.Entry packPartEntry : vehicle.activePartSlotBoxes.entrySet()) {
                    boolean isHoldingPart = false;
                    boolean isPartValid = false;
                    if (((JSONVehicle.VehiclePart)packPartEntry.getValue()).types.contains(((JSONPart.JSONPartGeneral)((JSONPart)heldPart.definition).general).type)) {
                        isHoldingPart = true;
                        if (heldPart.isPartValidForPackDef((JSONVehicle.VehiclePart)packPartEntry.getValue())) {
                            isPartValid = true;
                        }
                    }
                    if (!isHoldingPart) continue;
                    if (isPartValid) {
                        MasterLoader.renderInterface.setColorState(0.0f, 1.0f, 0.0f, 0.5f);
                    } else {
                        MasterLoader.renderInterface.setColorState(1.0f, 0.0f, 0.0f, 0.5f);
                    }
                    BoundingBox box = (BoundingBox)packPartEntry.getKey();
                    GL11.glBegin((int)7);
                    GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
                    GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
                    GL11.glEnd();
                }
            }
        }
    }

    private static void renderBoundingBoxes(EntityVehicleF_Physics vehicle) {
        MasterLoader.renderInterface.setLightingState(false);
        GL11.glDisable((int)3553);
        MasterLoader.renderInterface.setColorState(0.0f, 0.0f, 0.0f, 1.0f);
        GL11.glLineWidth((float)3.0f);
        GL11.glBegin((int)1);
        for (BoundingBox box : vehicle.interactionBoxes) {
            GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z - box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x - box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y - box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
            GL11.glVertex3d((double)(box.globalCenter.x + box.widthRadius), (double)(box.globalCenter.y + box.heightRadius), (double)(box.globalCenter.z + box.depthRadius));
        }
        GL11.glEnd();
        MasterLoader.renderInterface.setColorState(0.0f, 1.0f, 0.0f, 1.0f);
        GL11.glBegin((int)1);
        for (APart part : vehicle.parts) {
            Point3d partRotatedCenter = part.totalOffset.copy().rotateCoarse(vehicle.angles);
            GL11.glVertex3d((double)partRotatedCenter.x, (double)(partRotatedCenter.y - (double)part.getHeight()), (double)partRotatedCenter.z);
            GL11.glVertex3d((double)partRotatedCenter.x, (double)(partRotatedCenter.y + (double)part.getHeight()), (double)partRotatedCenter.z);
        }
        GL11.glEnd();
        GL11.glLineWidth((float)1.0f);
    }
}

