/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.sound;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import minecrafttransportsimulator.shadowed.javazoom.jl.decoder.Bitstream;
import minecrafttransportsimulator.shadowed.javazoom.jl.decoder.Decoder;
import minecrafttransportsimulator.shadowed.javazoom.jl.decoder.Equalizer;
import minecrafttransportsimulator.shadowed.javazoom.jl.decoder.Header;
import minecrafttransportsimulator.shadowed.javazoom.jl.decoder.SampleBuffer;
import minecrafttransportsimulator.sound.IStreamDecoder;

public class MP3Decoder
implements IStreamDecoder {
    private static final int MAX_READ_SIZE = 49152;
    private static final int MP3_BUFFER_SIZE = 131072;
    private final InputStream dataSourceStream;
    private final Bitstream bitstream;
    private final Decoder decoder;
    private final Equalizer equalizer;
    private final SampleBuffer decoderOutputBuffer;
    private final ByteBuffer decodedDataBuffer;
    private final boolean isStereo;
    private final int sampleRate;
    private Header currentFrameHeader;

    public MP3Decoder(InputStream dataSourceStream, Equalizer equalizer) {
        this.dataSourceStream = dataSourceStream;
        this.bitstream = new Bitstream(dataSourceStream);
        this.decoder = new Decoder();
        this.equalizer = equalizer;
        try {
            this.currentFrameHeader = this.bitstream.readFrame();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isStereo = this.currentFrameHeader.mode() != 3;
        this.sampleRate = this.currentFrameHeader.frequency();
        this.decoderOutputBuffer = new SampleBuffer(this.sampleRate, this.isStereo ? 2 : 1);
        this.decodedDataBuffer = ByteBuffer.allocateDirect(131072).order(ByteOrder.nativeOrder());
        this.decoder.setOutputBuffer(this.decoderOutputBuffer);
    }

    @Override
    public ByteBuffer readBlock() {
        if (this.currentFrameHeader == null) {
            return null;
        }
        int totalSamplesRead = 0;
        this.decoder.setEqualizer(this.equalizer);
        this.decodedDataBuffer.clear();
        ShortBuffer sampleBuffer = this.decodedDataBuffer.asShortBuffer();
        while (totalSamplesRead < 49152) {
            try {
                this.decoder.decodeFrame(this.currentFrameHeader, this.bitstream);
                this.bitstream.closeFrame();
                int samplesRead = this.decoderOutputBuffer.getBufferLength();
                sampleBuffer.put(this.decoderOutputBuffer.getBuffer(), 0, samplesRead);
                totalSamplesRead += samplesRead;
                this.currentFrameHeader = this.bitstream.readFrame();
                if (this.currentFrameHeader != null) continue;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.decodedDataBuffer.rewind();
        this.decodedDataBuffer.limit(totalSamplesRead * 2);
        return this.decodedDataBuffer;
    }

    @Override
    public void stop() {
        try {
            this.bitstream.close();
            this.dataSourceStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isStereo() {
        return this.isStereo;
    }

    @Override
    public int getSampleRate() {
        return this.sampleRate;
    }
}

