/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.sound;

import java.util.HashMap;
import java.util.Map;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketRadioStateChange;
import minecrafttransportsimulator.sound.ISoundProvider;
import minecrafttransportsimulator.sound.RadioManager;
import minecrafttransportsimulator.sound.RadioStation;
import minecrafttransportsimulator.sound.SoundInstance;

public class Radio {
    public static final Map<Integer, Radio> createdClientRadios = new HashMap<Integer, Radio>();
    public static final Map<Integer, Radio> createdServerRadios = new HashMap<Integer, Radio>();
    private static int idCounter = 1;
    public final int radioID;
    public int preset;
    public int volume;
    public String displayText;
    public RadioStation currentStation;
    private final ISoundProvider provider;
    private RadioManager.RadioSources currentSource;
    private SoundInstance currentSound;

    public Radio(ISoundProvider provider, IWrapperNBT data) {
        int n;
        this.provider = provider;
        if (provider.getProviderWorld().isClient()) {
            n = data.getInteger("radioID");
        } else {
            int n2 = idCounter;
            n = n2;
            idCounter = n2 + 1;
        }
        this.radioID = n;
        if (provider.getProviderWorld().isClient()) {
            if (data.getBoolean("savedRadio")) {
                this.changeSource(RadioManager.RadioSources.values()[data.getInteger("currentSource")], false);
                this.pressPreset(data.getInteger("preset"), false);
                this.changeVolume(data.getInteger("volume"), false);
            } else {
                this.changeSource(RadioManager.RadioSources.LOCAL, false);
                this.changeVolume(10, false);
            }
            createdClientRadios.put(this.radioID, this);
        } else {
            this.setProperties(RadioManager.RadioSources.values()[data.getInteger("currentSource")], data.getInteger("volume"), data.getInteger("preset"));
            createdServerRadios.put(this.radioID, this);
        }
    }

    public void start() {
        this.currentSound = new SoundInstance(this.provider, "Radio_" + this.radioID, false, this);
        this.currentSound.volume = (float)this.volume / 10.0f;
    }

    public void stop() {
        if (this.currentStation != null) {
            this.currentStation.removeRadio(this);
            this.currentStation = null;
            if (this.currentSound != null) {
                this.currentSound.stop();
            }
            this.displayText = "Radio turned off.";
        }
    }

    public void changeSource(RadioManager.RadioSources source, boolean sendPacket) {
        this.stop();
        this.currentSource = source;
        switch (source) {
            case LOCAL: {
                this.displayText = "Ready to play from files on your PC.\nPress a station number to start.\nFiles are in folders in the mts_music directory.";
                break;
            }
            case SERVER: {
                this.displayText = "Ready to play from files on the server.\nPress a station number to start.";
                break;
            }
            case INTERNET: {
                this.displayText = "Ready to play from internet streams.\nPress a station number to start.\nOr press SET to set a station URL.";
            }
        }
        if (this.provider.getProviderWorld().isClient() && sendPacket) {
            MasterLoader.networkInterface.sendToServer(new PacketRadioStateChange(this, this.currentSource, this.volume, this.preset));
        }
    }

    public RadioManager.RadioSources getSource() {
        return this.currentSource;
    }

    public void changeVolume(int volume, boolean sendPacket) {
        int n = this.volume = volume == 0 ? 10 : volume;
        if (this.currentSound != null) {
            this.currentSound.volume = (float)volume / 10.0f;
        }
        if (this.provider.getProviderWorld().isClient() && sendPacket) {
            MasterLoader.networkInterface.sendToServer(new PacketRadioStateChange(this, this.currentSource, volume, this.preset));
        }
    }

    public boolean isPlaying() {
        return this.currentSound != null && !this.currentSound.stopSound;
    }

    public SoundInstance getPlayingSound() {
        return this.currentSound;
    }

    public void pressPreset(int index, boolean sendPacket) {
        this.stop();
        this.preset = index;
        if (this.preset > 0) {
            if (this.currentSource.equals((Object)RadioManager.RadioSources.SERVER)) {
                this.displayText = "This method of playback is not supported .... yet!";
            } else {
                this.currentStation = RadioManager.getStation(this.currentSource, this.preset - 1);
                this.currentStation.addRadio(this);
            }
        }
        if (this.provider.getProviderWorld().isClient() && sendPacket) {
            MasterLoader.networkInterface.sendToServer(new PacketRadioStateChange(this, this.currentSource, this.volume, this.preset));
        }
    }

    public void setProperties(RadioManager.RadioSources source, int volume, int preset) {
        this.currentSource = source;
        this.volume = volume;
        this.preset = preset;
    }

    public void save(IWrapperNBT data) {
        data.setInteger("radioID", this.radioID);
        data.setInteger("currentSource", this.currentSource.ordinal());
        data.setBoolean("savedRadio", true);
        data.setInteger("preset", this.preset);
        data.setInteger("volume", this.volume);
    }
}

