/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.sound;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.sound.RadioStation;

public class RadioManager {
    private static File musicDir;
    private static File radioStationsFile;
    private static Map<RadioSources, Map<Integer, RadioStation>> sourceMap;

    public static RadioStation getStation(RadioSources source, int index) {
        Integer mapKey = index;
        if (!sourceMap.containsKey((Object)source)) {
            sourceMap.put(source, new HashMap());
        }
        if (!sourceMap.get((Object)source).containsKey(mapKey)) {
            sourceMap.get((Object)source).put(mapKey, new RadioStation(source, index));
        }
        return sourceMap.get((Object)source).get(mapKey);
    }

    public static List<File> parseLocalDirectory(int index) {
        ArrayList<File> musicDirectories = new ArrayList<File>();
        ArrayList<File> musicFiles = new ArrayList<File>();
        for (File file : musicDir.listFiles()) {
            if (!file.isDirectory()) continue;
            musicDirectories.add(file);
        }
        Collections.sort(musicDirectories);
        if (musicDirectories.size() > index) {
            for (File musicFile : ((File)musicDirectories.get(index)).listFiles()) {
                if (musicFile.isDirectory()) continue;
                musicFiles.add(musicFile);
            }
            Collections.sort(musicFiles);
        }
        return musicFiles;
    }

    public static String getLocalStationURL(int index) {
        try {
            ArrayList<String> stations = new ArrayList<String>();
            BufferedReader radioStationFileReader = new BufferedReader(new FileReader(radioStationsFile));
            while (radioStationFileReader.ready()) {
                stations.add(radioStationFileReader.readLine());
            }
            radioStationFileReader.close();
            if (stations.size() > index) {
                return (String)stations.get(index);
            }
            return "";
        }
        catch (IOException e) {
            System.err.println("ERROR: Unable to parse radio_stations.txt file.  Is it in use?");
            System.err.println(e.getMessage());
            return "";
        }
    }

    public static void setLocalStationURL(String stationURL, int index) {
        try {
            ArrayList<String> stations = new ArrayList<String>();
            BufferedReader radioStationFileReader = new BufferedReader(new FileReader(radioStationsFile));
            while (radioStationFileReader.ready()) {
                stations.add(radioStationFileReader.readLine());
            }
            radioStationFileReader.close();
            if (stations.size() == 0) {
                for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                    stations.add("");
                }
            }
            stations.set(index, stationURL);
            BufferedWriter radioStationFileWriter = new BufferedWriter(new FileWriter(radioStationsFile));
            for (String stationToWrite : stations) {
                radioStationFileWriter.write(stationToWrite + "\n");
            }
            radioStationFileWriter.close();
        }
        catch (IOException e) {
            System.err.println("ERROR: Unable to save radio_stations.txt file.  Is it in use?");
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    static {
        sourceMap = new HashMap<RadioSources, Map<Integer, RadioStation>>();
        musicDir = new File(MasterLoader.gameDirectory, "mts_music");
        musicDir.mkdir();
        radioStationsFile = new File(musicDir.getAbsolutePath() + File.separator + "radio_stations.txt");
        if (!radioStationsFile.exists()) {
            try {
                radioStationsFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static enum RadioSources {
        LOCAL,
        SERVER,
        INTERNET;

    }
}

