/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.sound;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.shadowed.javazoom.jl.decoder.Equalizer;
import minecrafttransportsimulator.sound.IStreamDecoder;
import minecrafttransportsimulator.sound.MP3Decoder;
import minecrafttransportsimulator.sound.Radio;
import minecrafttransportsimulator.sound.RadioManager;

public class RadioStation {
    public String displayText = "";
    public final Equalizer equalizer;
    private final RadioManager.RadioSources source;
    private final int index;
    private final List<File> musicFiles;
    private final Set<Radio> queuedRadios = new HashSet<Radio>();
    private final Set<Radio> playingRadios = new HashSet<Radio>();
    private volatile List<Integer> activeBuffers = new ArrayList<Integer>();
    private volatile IStreamDecoder decoder;
    private volatile DecoderThread decoderThread;

    public RadioStation(RadioManager.RadioSources source, int index) {
        this.source = source;
        this.index = index;
        this.equalizer = new Equalizer();
        if (source.equals((Object)RadioManager.RadioSources.LOCAL)) {
            this.musicFiles = RadioManager.parseLocalDirectory(index);
            if (this.musicFiles.isEmpty()) {
                this.displayText = "Fewer than " + (index + 1) + " folders in mts_music.\nGo add some!";
            }
        } else {
            this.musicFiles = new ArrayList<File>();
        }
        MasterLoader.audioInterface.addRadioStation(this);
    }

    private int generateBufferIndex() {
        ByteBuffer buffer = this.decoder.readBlock();
        if (buffer != null) {
            int bufferIndex = MasterLoader.audioInterface.createBuffer(buffer, this.decoder);
            this.activeBuffers.add(bufferIndex);
            this.displayText = this.displayText.substring(0, this.displayText.indexOf("Buffers:") + "Buffers:".length());
            for (int i = 0; i < this.activeBuffers.size(); i = (int)((byte)(i + 1))) {
                this.displayText = this.displayText + "X";
            }
            return bufferIndex;
        }
        return 0;
    }

    public void addRadio(Radio radio) {
        this.queuedRadios.add(radio);
    }

    public void removeRadio(Radio radio) {
        this.playingRadios.remove(radio);
        this.queuedRadios.remove(radio);
    }

    public void update() {
        if (!this.playingRadios.isEmpty() || !this.queuedRadios.isEmpty()) {
            if (this.decoderThread == null && this.decoder == null) {
                this.startPlayback();
            } else if (this.decoderThread == null) {
                int newIndex;
                int freeBufferIndex = 0;
                if (!this.playingRadios.isEmpty() && (freeBufferIndex = MasterLoader.audioInterface.getFreeStationBuffer(this.playingRadios)) != 0) {
                    this.activeBuffers.remove(this.activeBuffers.indexOf(freeBufferIndex));
                    MasterLoader.audioInterface.deleteBuffer(freeBufferIndex);
                }
                if ((freeBufferIndex != 0 || this.playingRadios.isEmpty()) && !this.queuedRadios.isEmpty()) {
                    for (Radio radio : this.queuedRadios) {
                        radio.start();
                        MasterLoader.audioInterface.addRadioSound(radio.getPlayingSound(), this.activeBuffers);
                        this.playingRadios.add(radio);
                    }
                    this.queuedRadios.clear();
                }
                if (this.activeBuffers.size() < 5 && (newIndex = this.generateBufferIndex()) != 0) {
                    for (Radio radio : this.playingRadios) {
                        MasterLoader.audioInterface.bindBuffer(radio.getPlayingSound(), newIndex);
                    }
                }
                if (this.activeBuffers.isEmpty()) {
                    this.startPlayback();
                }
            }
        } else if (!this.source.equals((Object)RadioManager.RadioSources.LOCAL) && this.decoder != null) {
            this.decoder.stop();
            this.decoder = null;
        }
    }

    private void startPlayback() {
        for (int buffer : this.activeBuffers) {
            MasterLoader.audioInterface.deleteBuffer(buffer);
        }
        this.activeBuffers.clear();
        this.queuedRadios.addAll(this.playingRadios);
        this.playingRadios.clear();
        if (this.source.equals((Object)RadioManager.RadioSources.LOCAL)) {
            if (this.musicFiles.isEmpty()) {
                this.musicFiles.addAll(RadioManager.parseLocalDirectory(this.index));
            }
            this.playFromLocalFiles();
        } else {
            this.playFromInternet();
        }
    }

    private void playFromLocalFiles() {
        Iterator<File> iterator = this.musicFiles.iterator();
        while (iterator.hasNext()) {
            try {
                File musicFile = iterator.next();
                if (!musicFile.getName().toLowerCase().endsWith(".mp3")) {
                    iterator.remove();
                    continue;
                }
                this.displayText = "Station: " + this.musicFiles.get(0).getParentFile().getName() + "\nNow Playing: " + this.musicFiles.get(0).getName();
                this.displayText = this.displayText + "\nBuffers:";
                this.decoder = null;
                this.decoderThread = new DecoderThread(this, this.musicFiles.get(0));
                this.decoderThread.start();
                iterator.remove();
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                iterator.remove();
            }
        }
    }

    private void playFromInternet() {
        String station = RadioManager.getLocalStationURL(this.index);
        if (station.isEmpty()) {
            this.displayText = "Press SET to teach a station.";
            this.playingRadios.clear();
            this.queuedRadios.clear();
            return;
        }
        try {
            URL url = new URL(station);
            URLConnection connection = url.openConnection();
            String contentType = connection.getHeaderField("Content-Type");
            if (contentType == null) {
                this.displayText = "ERROR: No Content-Type header found.  Contact the mod author for more information.";
                return;
            }
            switch (contentType) {
                case "audio/mpeg": {
                    break;
                }
                case "application/ogg": {
                    break;
                }
                case "audio/x-wav": {
                    this.displayText = "ERROR: WAV file format not supported...yet.  Contact the mod author.";
                    return;
                }
                case "audio/flac": {
                    this.displayText = "ERROR: Who the heck streams in FLAC?  Contact the mod author.";
                    return;
                }
                default: {
                    this.displayText = contentType.startsWith("audio") ? "ERROR: Unsupported audio format of " + contentType + ".  Contact the mod author." : "ERROR: Format " + contentType + " is NOT an audio format.  Is this really a music URL?";
                    return;
                }
            }
            this.displayText = "Name: " + (connection.getHeaderField("icy-name") != null ? connection.getHeaderField("icy-name") : "");
            this.displayText = this.displayText + "\nDesc: " + (connection.getHeaderField("icy-description") != null ? connection.getHeaderField("icy-description") : "");
            this.displayText = this.displayText + "\nGenre: " + (connection.getHeaderField("icy-genre") != null ? connection.getHeaderField("icy-genre") : "");
            this.displayText = this.displayText + "\nBuffers:";
            this.decoder = null;
            this.decoderThread = new DecoderThread(this, contentType, url);
            this.decoderThread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.displayText = "ERROR: Unable to open URL.  Have you tried playing it in another application first?";
        }
    }

    public static class DecoderThread
    extends Thread {
        private final RadioStation station;
        private final String contentType;
        private final URL contentURL;
        private final File contentFile;

        public DecoderThread(RadioStation station, String contentType, URL contentURL) {
            this.station = station;
            this.contentType = contentType;
            this.contentURL = contentURL;
            this.contentFile = null;
        }

        public DecoderThread(RadioStation station, File contentFile) {
            this.station = station;
            this.contentType = null;
            this.contentURL = null;
            this.contentFile = contentFile;
        }

        @Override
        public void run() {
            try {
                if (this.contentURL != null) {
                    switch (this.contentType) {
                        case "audio/mpeg": {
                            this.station.decoder = new MP3Decoder(this.contentURL.openStream(), this.station.equalizer);
                            break;
                        }
                        case "application/ogg": {
                            this.station.decoder = MasterLoader.oggDecoderInterface.createFrom(this.contentURL);
                        }
                    }
                } else {
                    this.station.decoder = new MP3Decoder(new FileInputStream(this.contentFile), this.station.equalizer);
                }
                for (int i = 0; i < 5; i = (int)((byte)(i + 1))) {
                    this.station.generateBufferIndex();
                }
                this.station.decoderThread = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

