/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.sound;

import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.sound.IRadioProvider;
import minecrafttransportsimulator.sound.ISoundProvider;
import minecrafttransportsimulator.sound.Radio;
import minecrafttransportsimulator.vehicles.main.AEntityBase;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;

public class SoundInstance {
    public final ISoundProvider provider;
    public final String soundName;
    public final boolean looping;
    public final Radio radio;
    public int sourceIndex;
    public float volume = 1.0f;
    public float pitch = 1.0f;
    public boolean stopSound = false;

    public SoundInstance(ISoundProvider provider, String soundName) {
        this(provider, soundName, false);
    }

    public SoundInstance(ISoundProvider provider, String soundName, boolean looping) {
        this(provider, soundName, looping, null);
    }

    public SoundInstance(ISoundProvider provider, String soundName, boolean looping, Radio radio) {
        this.provider = provider;
        this.soundName = soundName;
        this.looping = looping;
        if (!(radio == null || radio != null && provider instanceof IRadioProvider)) {
            throw new IllegalArgumentException("ERROR: A sound played from a radio was attempted to be added to an object that isn't an instance of " + IRadioProvider.class.getSimpleName());
        }
        this.radio = radio;
    }

    public void stop() {
        this.stopSound = true;
    }

    public boolean shouldBeDampened() {
        AEntityBase entityRiding = MasterLoader.gameInterface.getClientPlayer().getEntityRiding();
        return entityRiding instanceof EntityVehicleF_Physics && !((JSONVehicle.VehicleGeneral)((EntityVehicleF_Physics)entityRiding).definition.general).openTop && MasterLoader.gameInterface.inFirstPerson() && (this.radio == null || !entityRiding.equals(this.provider));
    }
}

