/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.systems;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.Map;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONConfig;
import minecrafttransportsimulator.jsondefs.JSONCraftingOverrides;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.systems.PackParserSystem;

public final class ConfigSystem {
    private static File configFile;
    public static JSONConfig configObject;

    public static void loadFromDisk(File configDirectory) {
        configFile = new File(configDirectory, "mtsconfig.json");
        if (configFile.exists()) {
            try {
                configObject = (JSONConfig)new Gson().fromJson((Reader)new FileReader(configFile), JSONConfig.class);
                for (Map.Entry<String, Map<String, Double>> fuelValues : JSONConfig.ConfigFuel.getDefaultFuels().entrySet()) {
                    if (ConfigSystem.configObject.fuel.fuels.containsKey(fuelValues.getKey())) continue;
                    ConfigSystem.configObject.fuel.fuels.put(fuelValues.getKey(), fuelValues.getValue());
                }
            }
            catch (Exception e) {
                MasterLoader.coreInterface.logError("ERROR: ConfigSystem failed to parse config file JSON.  Reverting to defauts.");
                MasterLoader.coreInterface.logError(e.getMessage());
            }
        }
        if (configObject == null) {
            configObject = new JSONConfig();
        }
        ConfigSystem.saveToDisk();
        File craftingFile = new File(configFile.getParentFile(), "mtscraftingoverrides.json");
        if (craftingFile.exists() && !((Boolean)ConfigSystem.configObject.general.dumpCraftingConfig.value).booleanValue()) {
            try {
                JSONCraftingOverrides craftingOverridesObject = (JSONCraftingOverrides)new Gson().fromJson((Reader)new FileReader(craftingFile), JSONCraftingOverrides.class);
                for (String craftingOverridePackID : craftingOverridesObject.overrides.keySet()) {
                    for (String craftingOverrideSystemName : craftingOverridesObject.overrides.get(craftingOverridePackID).keySet()) {
                        Object item = PackParserSystem.getItem(craftingOverridePackID, craftingOverrideSystemName);
                        if (item == null) continue;
                        ((AJSONItem.General)((AJSONItem)((AItemPack)item).definition).general).materials = craftingOverridesObject.overrides.get(craftingOverridePackID).get(craftingOverrideSystemName);
                    }
                }
            }
            catch (Exception e) {
                MasterLoader.coreInterface.logError("ERROR: ConfigSystem failed to parse crafting override file JSON.  Crafting overrides will not be applied.");
                MasterLoader.coreInterface.logError(e.getMessage());
            }
        } else {
            try {
                FileWriter writer = new FileWriter(craftingFile);
                new GsonBuilder().setPrettyPrinting().create().toJson((Object)new JSONCraftingOverrides(), JSONCraftingOverrides.class, (Appendable)writer);
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                System.err.println("ERROR: ConfigSystem failed to create fresh crafting overridesg file.  Report to the mod author!");
                e.printStackTrace();
            }
        }
        File oldConfigFile = new File(configDirectory, "mts.cfg");
        if (oldConfigFile.exists()) {
            oldConfigFile.delete();
        }
    }

    public static void saveToDisk() {
        try {
            FileWriter writer = new FileWriter(configFile);
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)configObject, JSONConfig.class, (Appendable)writer);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            System.err.println("ERROR: ConfigSystem failed to save modified config file.  Report to the mod author!");
            e.printStackTrace();
        }
    }
}

