/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.systems;

import minecrafttransportsimulator.guis.instances.GUIPanelAircraft;
import minecrafttransportsimulator.guis.instances.GUIPanelGround;
import minecrafttransportsimulator.guis.instances.GUIRadio;
import minecrafttransportsimulator.jsondefs.JSONConfig;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketVehicleControlAnalog;
import minecrafttransportsimulator.packets.instances.PacketVehicleControlDigital;
import minecrafttransportsimulator.packets.instances.PacketVehicleLightToggle;
import minecrafttransportsimulator.packets.instances.PacketVehiclePartGun;
import minecrafttransportsimulator.packets.instances.PacketVehiclePartSeat;
import minecrafttransportsimulator.rendering.components.LightType;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartEngine;
import minecrafttransportsimulator.vehicles.parts.PartGun;
import minecrafttransportsimulator.vehicles.parts.PartSeat;

public final class ControlSystem {
    private static final int NULL_COMPONENT = 999;
    private static boolean joysticksInhibited = false;
    private static IWrapperPlayer clientPlayer;

    public static void controlVehicle(EntityVehicleF_Physics vehicle, boolean isPlayerController) {
        clientPlayer = MasterLoader.gameInterface.getClientPlayer();
        if (((JSONVehicle.VehicleGeneral)vehicle.definition.general).isAircraft) {
            ControlSystem.controlAircraft(vehicle, isPlayerController);
        } else {
            ControlSystem.controlGroundVehicle(vehicle, isPlayerController);
        }
    }

    private static void controlCamera(ControlsKeyboard camLock, ControlsKeyboard zoomIn, ControlsKeyboard zoomOut, ControlsJoystick changeView) {
        if (camLock.isPressed()) {
            boolean bl = EntityVehicleF_Physics.lockCameraToMovement = !EntityVehicleF_Physics.lockCameraToMovement;
        }
        if (zoomIn.isPressed()) {
            MasterLoader.renderInterface.changeCameraZoom(true);
        }
        if (zoomOut.isPressed()) {
            MasterLoader.renderInterface.changeCameraZoom(false);
        }
        if (changeView.isPressed()) {
            MasterLoader.gameInterface.toggleFirstPerston();
        }
    }

    private static void rotateCamera(ControlsJoystick lookR, ControlsJoystick lookL, ControlsJoystick lookU, ControlsJoystick lookD, ControlsJoystick lookA) {
        float pollData;
        if (lookR.isPressed()) {
            clientPlayer.setYaw(clientPlayer.getYaw() - 3.0f);
        }
        if (lookL.isPressed()) {
            clientPlayer.setYaw(clientPlayer.getYaw() + 3.0f);
        }
        if (lookU.isPressed()) {
            clientPlayer.setPitch(clientPlayer.getPitch() - 3.0f);
        }
        if (lookD.isPressed()) {
            clientPlayer.setPitch(clientPlayer.getPitch() + 3.0f);
        }
        if ((pollData = lookA.getMultistateValue()) != 0.0f) {
            if (pollData >= 0.125f && pollData <= 0.375f) {
                clientPlayer.setPitch(clientPlayer.getPitch() + 3.0f);
            }
            if (pollData >= 0.375f && pollData <= 0.625f) {
                clientPlayer.setYaw(clientPlayer.getYaw() - 3.0f);
            }
            if (pollData >= 0.625f && pollData <= 0.875f) {
                clientPlayer.setPitch(clientPlayer.getPitch() - 3.0f);
            }
            if (pollData >= 0.875f || pollData <= 0.125f) {
                clientPlayer.setYaw(clientPlayer.getYaw() + 3.0f);
            }
        }
    }

    private static void controlBrake(EntityVehicleF_Physics vehicle, ControlsKeyboardDynamic dynamic, ControlsJoystick analogBrake, ControlsJoystick pBrake) {
        boolean isBrakePressed;
        boolean isParkingBrakePressed;
        boolean bl = MasterLoader.inputInterface.isJoystickPresent(analogBrake.config.joystickName) ? pBrake.isPressed() : (isParkingBrakePressed = dynamic.isPressed() || pBrake.isPressed());
        boolean bl2 = MasterLoader.inputInterface.isJoystickPresent(analogBrake.config.joystickName) ? analogBrake.getAxisState((short)0) > 25 : (isBrakePressed = dynamic.mainControl.isPressed());
        if (isParkingBrakePressed) {
            if (!vehicle.parkingBrakeOn) {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(vehicle, PacketVehicleControlDigital.Controls.P_BRAKE, true));
            }
        } else if (isBrakePressed) {
            if (!vehicle.brakeOn) {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(vehicle, PacketVehicleControlDigital.Controls.BRAKE, true));
            }
            if (vehicle.parkingBrakeOn) {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(vehicle, PacketVehicleControlDigital.Controls.P_BRAKE, false));
            }
        } else if (vehicle.brakeOn) {
            MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(vehicle, PacketVehicleControlDigital.Controls.BRAKE, false));
        }
    }

    private static void controlGun(EntityVehicleF_Physics vehicle, ControlsKeyboard gunTrigger, ControlsKeyboard gunSwitch) {
        boolean gunSwitchPressedThisScan = gunSwitch.isPressed();
        for (APart part : vehicle.parts) {
            if (part instanceof PartGun) {
                PartGun gun = (PartGun)part;
                if (!MasterLoader.gameInterface.getClientPlayer().equals(gun.getCurrentController())) continue;
                MasterLoader.networkInterface.sendToServer(new PacketVehiclePartGun(gun, gunTrigger.isPressed()));
                continue;
            }
            if (!(part instanceof PartSeat) || !gunSwitchPressedThisScan || !MasterLoader.gameInterface.getClientPlayer().equals(vehicle.locationRiderMap.get((Object)part.placementOffset))) continue;
            MasterLoader.networkInterface.sendToServer(new PacketVehiclePartSeat((PartSeat)part));
        }
    }

    private static void controlRadio(EntityVehicleF_Physics vehicle, ControlsKeyboard radio) {
        if (radio.isPressed()) {
            if (MasterLoader.guiInterface.isGUIActive(null)) {
                MasterLoader.guiInterface.openGUI(new GUIRadio(vehicle));
            } else if (MasterLoader.guiInterface.isGUIActive(GUIRadio.class)) {
                MasterLoader.guiInterface.closeGUI();
            }
        }
    }

    private static void controlJoystick(EntityVehicleF_Physics vehicle, ControlsKeyboard joystickInhibit) {
        if (joystickInhibit.isPressed()) {
            joysticksInhibited = !joysticksInhibited;
            MasterLoader.inputInterface.inhibitJoysticks(joysticksInhibited);
        }
    }

    private static void controlAircraft(EntityVehicleF_Physics aircraft, boolean isPlayerController) {
        ControlSystem.controlCamera(ControlsKeyboard.AIRCRAFT_CAMLOCK, ControlsKeyboard.AIRCRAFT_ZOOM_I, ControlsKeyboard.AIRCRAFT_ZOOM_O, ControlsJoystick.AIRCRAFT_CHANGEVIEW);
        ControlSystem.rotateCamera(ControlsJoystick.AIRCRAFT_LOOK_R, ControlsJoystick.AIRCRAFT_LOOK_L, ControlsJoystick.AIRCRAFT_LOOK_U, ControlsJoystick.AIRCRAFT_LOOK_D, ControlsJoystick.AIRCRAFT_LOOK_A);
        ControlSystem.controlGun(aircraft, ControlsKeyboard.AIRCRAFT_GUN_FIRE, ControlsKeyboard.AIRCRAFT_GUN_SWITCH);
        ControlSystem.controlRadio(aircraft, ControlsKeyboard.AIRCRAFT_RADIO);
        ControlSystem.controlJoystick(aircraft, ControlsKeyboard.AIRCRAFT_JS_INHIBIT);
        if (!isPlayerController) {
            return;
        }
        if (ControlsKeyboard.AIRCRAFT_PANEL.isPressed()) {
            if (MasterLoader.guiInterface.isGUIActive(null)) {
                MasterLoader.guiInterface.openGUI(new GUIPanelAircraft(aircraft));
            } else if (MasterLoader.guiInterface.isGUIActive(GUIPanelAircraft.class)) {
                MasterLoader.guiInterface.closeGUI();
            }
        }
        ControlSystem.controlBrake(aircraft, ControlsKeyboardDynamic.AIRCRAFT_PARK, ControlsJoystick.AIRCRAFT_BRAKE_ANALOG, ControlsJoystick.AIRCRAFT_PARK);
        if (ControlsJoystick.AIRCRAFT_REVERSE.isPressed()) {
            MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(aircraft, PacketVehicleControlDigital.Controls.REVERSE, !aircraft.reverseThrust));
        }
        if (MasterLoader.inputInterface.isJoystickPresent(ControlsJoystick.AIRCRAFT_THROTTLE.config.joystickName)) {
            MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(aircraft, PacketVehicleControlAnalog.Controls.THROTTLE, ControlsJoystick.AIRCRAFT_THROTTLE.getAxisState((short)0), 127));
        } else {
            if (ControlsKeyboard.AIRCRAFT_THROTTLE_U.isPressed()) {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(aircraft, PacketVehicleControlAnalog.Controls.THROTTLE, 1, 0));
            }
            if (ControlsKeyboard.AIRCRAFT_THROTTLE_D.isPressed()) {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(aircraft, PacketVehicleControlAnalog.Controls.THROTTLE, -1, 0));
            }
        }
        if (aircraft.definition.motorized.hasFlaps) {
            if (ControlsKeyboard.AIRCRAFT_FLAPS_U.isPressed()) {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(aircraft, PacketVehicleControlDigital.Controls.FLAPS, false));
            }
            if (ControlsKeyboard.AIRCRAFT_FLAPS_D.isPressed()) {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(aircraft, PacketVehicleControlDigital.Controls.FLAPS, true));
            }
        }
        if (MasterLoader.inputInterface.isJoystickPresent(ControlsJoystick.AIRCRAFT_YAW.config.joystickName)) {
            MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(aircraft, PacketVehicleControlAnalog.Controls.RUDDER, ControlsJoystick.AIRCRAFT_YAW.getAxisState((short)450), 127));
        } else {
            if (ControlsKeyboard.AIRCRAFT_YAW_R.isPressed()) {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(aircraft, PacketVehicleControlAnalog.Controls.RUDDER, (short)(((Integer)ConfigSystem.configObject.client.steeringIncrement.value).shortValue() * (aircraft.rudderAngle < 0 ? 2 : 1)), ((Integer)ConfigSystem.configObject.client.controlSurfaceCooldown.value).byteValue()));
            }
            if (ControlsKeyboard.AIRCRAFT_YAW_L.isPressed()) {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(aircraft, PacketVehicleControlAnalog.Controls.RUDDER, (short)(-((Integer)ConfigSystem.configObject.client.steeringIncrement.value).shortValue() * (aircraft.rudderAngle > 0 ? 2 : 1)), ((Integer)ConfigSystem.configObject.client.controlSurfaceCooldown.value).byteValue()));
            }
        }
        if (ControlsJoystick.AIRCRAFT_TRIM_YAW_R.isPressed()) {
            MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(aircraft, PacketVehicleControlDigital.Controls.TRIM_YAW, true));
        }
        if (ControlsJoystick.AIRCRAFT_TRIM_YAW_L.isPressed()) {
            MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(aircraft, PacketVehicleControlDigital.Controls.TRIM_YAW, false));
        }
        if (((Boolean)ConfigSystem.configObject.client.mouseYoke.value).booleanValue()) {
            if (EntityVehicleF_Physics.lockCameraToMovement && MasterLoader.guiInterface.isGUIActive(null)) {
                long mousePosition = MasterLoader.inputInterface.getTrackedMouseInfo();
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(aircraft, PacketVehicleControlAnalog.Controls.AILERON, (short)(mousePosition >> 32), 127));
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(aircraft, PacketVehicleControlAnalog.Controls.ELEVATOR, (short)(-mousePosition), 127));
            }
        } else {
            if (MasterLoader.inputInterface.isJoystickPresent(ControlsJoystick.AIRCRAFT_PITCH.config.joystickName)) {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(aircraft, PacketVehicleControlAnalog.Controls.ELEVATOR, ControlsJoystick.AIRCRAFT_PITCH.getAxisState((short)250), 127));
            } else {
                if (ControlsKeyboard.AIRCRAFT_PITCH_U.isPressed()) {
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(aircraft, PacketVehicleControlAnalog.Controls.ELEVATOR, (short)(((Integer)ConfigSystem.configObject.client.flightIncrement.value).shortValue() * (aircraft.elevatorAngle < 0 ? 2 : 1)), ((Integer)ConfigSystem.configObject.client.controlSurfaceCooldown.value).byteValue()));
                }
                if (ControlsKeyboard.AIRCRAFT_PITCH_D.isPressed()) {
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(aircraft, PacketVehicleControlAnalog.Controls.ELEVATOR, (short)(-((Integer)ConfigSystem.configObject.client.flightIncrement.value).shortValue() * (aircraft.elevatorAngle > 0 ? 2 : 1)), ((Integer)ConfigSystem.configObject.client.controlSurfaceCooldown.value).byteValue()));
                }
            }
            if (ControlsJoystick.AIRCRAFT_TRIM_PITCH_U.isPressed()) {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(aircraft, PacketVehicleControlDigital.Controls.TRIM_PITCH, true));
            }
            if (ControlsJoystick.AIRCRAFT_TRIM_PITCH_D.isPressed()) {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(aircraft, PacketVehicleControlDigital.Controls.TRIM_PITCH, false));
            }
            if (MasterLoader.inputInterface.isJoystickPresent(ControlsJoystick.AIRCRAFT_ROLL.config.joystickName)) {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(aircraft, PacketVehicleControlAnalog.Controls.AILERON, ControlsJoystick.AIRCRAFT_ROLL.getAxisState((short)250), 127));
            } else {
                if (ControlsKeyboard.AIRCRAFT_ROLL_R.isPressed()) {
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(aircraft, PacketVehicleControlAnalog.Controls.AILERON, (short)(((Integer)ConfigSystem.configObject.client.flightIncrement.value).shortValue() * (aircraft.aileronAngle < 0 ? 2 : 1)), ((Integer)ConfigSystem.configObject.client.controlSurfaceCooldown.value).byteValue()));
                }
                if (ControlsKeyboard.AIRCRAFT_ROLL_L.isPressed()) {
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(aircraft, PacketVehicleControlAnalog.Controls.AILERON, (short)(-((Integer)ConfigSystem.configObject.client.flightIncrement.value).shortValue() * (aircraft.aileronAngle > 0 ? 2 : 1)), ((Integer)ConfigSystem.configObject.client.controlSurfaceCooldown.value).byteValue()));
                }
            }
            if (ControlsJoystick.AIRCRAFT_TRIM_ROLL_R.isPressed()) {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(aircraft, PacketVehicleControlDigital.Controls.TRIM_ROLL, true));
            }
            if (ControlsJoystick.AIRCRAFT_TRIM_ROLL_L.isPressed()) {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(aircraft, PacketVehicleControlDigital.Controls.TRIM_ROLL, false));
            }
        }
    }

    private static void controlGroundVehicle(EntityVehicleF_Physics powered, boolean isPlayerController) {
        ControlSystem.controlCamera(ControlsKeyboard.CAR_CAMLOCK, ControlsKeyboard.CAR_ZOOM_I, ControlsKeyboard.CAR_ZOOM_O, ControlsJoystick.CAR_CHANGEVIEW);
        ControlSystem.rotateCamera(ControlsJoystick.CAR_LOOK_R, ControlsJoystick.CAR_LOOK_L, ControlsJoystick.CAR_LOOK_U, ControlsJoystick.CAR_LOOK_D, ControlsJoystick.CAR_LOOK_A);
        ControlSystem.controlGun(powered, ControlsKeyboard.CAR_GUN_FIRE, ControlsKeyboard.CAR_GUN_SWITCH);
        ControlSystem.controlRadio(powered, ControlsKeyboard.CAR_RADIO);
        ControlSystem.controlJoystick(powered, ControlsKeyboard.CAR_JS_INHIBIT);
        if (!isPlayerController) {
            return;
        }
        if (ControlsKeyboard.CAR_PANEL.isPressed()) {
            if (MasterLoader.guiInterface.isGUIActive(null)) {
                MasterLoader.guiInterface.openGUI(new GUIPanelGround(powered));
            } else if (MasterLoader.guiInterface.isGUIActive(GUIPanelGround.class)) {
                MasterLoader.guiInterface.closeGUI();
            }
        }
        if (((Boolean)ConfigSystem.configObject.client.simpleThrottle.value).booleanValue()) {
            if (!powered.engines.values().isEmpty()) {
                byte currentGear = 0;
                for (PartEngine engine : powered.engines.values()) {
                    currentGear = engine.currentGear;
                }
                boolean brakePressed = ControlsKeyboard.CAR_BRAKE.isPressed();
                boolean gasPressed = ControlsKeyboard.CAR_GAS.isPressed();
                if (brakePressed) {
                    if (currentGear >= 0) {
                        MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(powered, PacketVehicleControlDigital.Controls.BRAKE, brakePressed));
                        MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(powered, PacketVehicleControlAnalog.Controls.THROTTLE, 0, 127));
                        if (powered.velocity == 0.0 || currentGear == 0) {
                            MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(powered, PacketVehicleControlDigital.Controls.SHIFT_DN, false));
                        }
                    } else {
                        MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(powered, PacketVehicleControlDigital.Controls.BRAKE, gasPressed));
                        MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(powered, PacketVehicleControlAnalog.Controls.THROTTLE, (short)(brakePressed ? 100 : 0), 127));
                    }
                } else if (gasPressed) {
                    if (currentGear <= 0) {
                        MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(powered, PacketVehicleControlDigital.Controls.BRAKE, gasPressed));
                        MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(powered, PacketVehicleControlAnalog.Controls.THROTTLE, 0, 127));
                        if (powered.velocity == 0.0 || currentGear == 0) {
                            MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(powered, PacketVehicleControlDigital.Controls.SHIFT_UP, false));
                        }
                    } else {
                        MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(powered, PacketVehicleControlDigital.Controls.BRAKE, brakePressed));
                        MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(powered, PacketVehicleControlAnalog.Controls.THROTTLE, (short)(gasPressed ? 100 : 0), 127));
                    }
                } else if (Math.abs(powered.velocity) > 0.3) {
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(powered, PacketVehicleControlDigital.Controls.BRAKE, false));
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(powered, PacketVehicleControlAnalog.Controls.THROTTLE, 0, 127));
                } else {
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(powered, PacketVehicleControlDigital.Controls.BRAKE, true));
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(powered, PacketVehicleControlAnalog.Controls.THROTTLE, 0, 127));
                }
            }
        } else {
            ControlSystem.controlBrake(powered, ControlsKeyboardDynamic.CAR_PARK, ControlsJoystick.CAR_BRAKE_ANALOG, ControlsJoystick.CAR_PARK);
            if (MasterLoader.inputInterface.isJoystickPresent(ControlsJoystick.CAR_GAS.config.joystickName)) {
                short throttleLevel = ControlsJoystick.CAR_GAS.getAxisState((short)0);
                if (!powered.cruiseControl || powered.throttle < throttleLevel) {
                    MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(powered, PacketVehicleControlAnalog.Controls.THROTTLE, ControlsJoystick.CAR_GAS.getAxisState((short)0), 127));
                }
            } else if (ControlsKeyboardDynamic.CAR_SLOW.isPressed()) {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(powered, PacketVehicleControlAnalog.Controls.THROTTLE, 50, 127));
            } else if (ControlsKeyboard.CAR_GAS.isPressed()) {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(powered, PacketVehicleControlAnalog.Controls.THROTTLE, 100, 127));
            } else if (!powered.cruiseControl) {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(powered, PacketVehicleControlAnalog.Controls.THROTTLE, 0, 127));
            }
        }
        if (((Boolean)ConfigSystem.configObject.client.mouseYoke.value).booleanValue()) {
            if (EntityVehicleF_Physics.lockCameraToMovement && MasterLoader.guiInterface.isGUIActive(null)) {
                long mousePosition = MasterLoader.inputInterface.getTrackedMouseInfo();
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(powered, PacketVehicleControlAnalog.Controls.RUDDER, (short)(mousePosition >> 32), 127));
            }
        } else if (MasterLoader.inputInterface.isJoystickPresent(ControlsJoystick.CAR_TURN.config.joystickName)) {
            MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(powered, PacketVehicleControlAnalog.Controls.RUDDER, ControlsJoystick.CAR_TURN.getAxisState((short)450), 127));
        } else {
            boolean turningRight = ControlsKeyboard.CAR_TURN_R.isPressed();
            boolean turningLeft = ControlsKeyboard.CAR_TURN_L.isPressed();
            if (turningRight && !turningLeft) {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(powered, PacketVehicleControlAnalog.Controls.RUDDER, (short)(((Integer)ConfigSystem.configObject.client.steeringIncrement.value).shortValue() * (powered.rudderAngle < 0 ? 2 : 1)), ((Integer)ConfigSystem.configObject.client.controlSurfaceCooldown.value).byteValue()));
            } else if (turningLeft && !turningRight) {
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlAnalog(powered, PacketVehicleControlAnalog.Controls.RUDDER, (short)(-((Integer)ConfigSystem.configObject.client.steeringIncrement.value).shortValue() * (powered.rudderAngle > 0 ? 2 : 1)), ((Integer)ConfigSystem.configObject.client.controlSurfaceCooldown.value).byteValue()));
            }
        }
        if (ControlsKeyboard.CAR_SHIFT_U.isPressed()) {
            MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(powered, PacketVehicleControlDigital.Controls.SHIFT_UP, false));
        }
        if (ControlsKeyboard.CAR_SHIFT_D.isPressed()) {
            MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(powered, PacketVehicleControlDigital.Controls.SHIFT_DN, false));
        }
        if (ControlsKeyboard.CAR_HORN.isPressed() && !powered.hornOn) {
            MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(powered, PacketVehicleControlDigital.Controls.HORN, true));
        } else if (!ControlsKeyboard.CAR_HORN.isPressed() && powered.hornOn) {
            MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital(powered, PacketVehicleControlDigital.Controls.HORN, false));
        }
        if (ControlsKeyboard.CAR_LIGHTS.isPressed()) {
            MasterLoader.networkInterface.sendToServer(new PacketVehicleLightToggle(powered, LightType.RUNNINGLIGHT));
            MasterLoader.networkInterface.sendToServer(new PacketVehicleLightToggle(powered, LightType.HEADLIGHT));
        }
        if (ControlsKeyboard.CAR_TURNSIGNAL_L.isPressed()) {
            MasterLoader.networkInterface.sendToServer(new PacketVehicleLightToggle(powered, LightType.LEFTTURNLIGHT));
        }
        if (ControlsKeyboard.CAR_TURNSIGNAL_R.isPressed()) {
            MasterLoader.networkInterface.sendToServer(new PacketVehicleLightToggle(powered, LightType.RIGHTTURNLIGHT));
        }
    }

    static {
        for (ControlsJoystick controlsJoystick : ControlsJoystick.values()) {
            ConfigSystem.configObject.controls.joystick.put(controlsJoystick.systemName, controlsJoystick.config);
        }
        for (Enum enum_ : ControlsKeyboard.values()) {
            ConfigSystem.configObject.controls.keyboard.put(((ControlsKeyboard)enum_).systemName, ((ControlsKeyboard)enum_).config);
        }
        for (Enum enum_ : ControlsKeyboard.values()) {
            if (((ControlsKeyboard)enum_).config.keyCode != 0) continue;
            ((ControlsKeyboard)enum_).config.keyCode = MasterLoader.inputInterface.getKeyCodeForName(((ControlsKeyboard)enum_).defaultKeyName);
        }
        ConfigSystem.saveToDisk();
    }

    public static enum ControlsKeyboardDynamic {
        AIRCRAFT_PARK(ControlsKeyboard.AIRCRAFT_BRAKE, ControlsKeyboard.AIRCRAFT_MOD),
        CAR_PARK(ControlsKeyboard.CAR_BRAKE, ControlsKeyboard.CAR_MOD),
        CAR_SLOW(ControlsKeyboard.CAR_GAS, ControlsKeyboard.CAR_MOD);

        public final String translatedName = MasterLoader.coreInterface.translate("input." + this.name().toLowerCase().replaceFirst("_", "."));
        public final ControlsKeyboard mainControl;
        public final ControlsKeyboard modControl;

        private ControlsKeyboardDynamic(ControlsKeyboard mainControl, ControlsKeyboard modControl) {
            this.mainControl = mainControl;
            this.modControl = modControl;
        }

        public boolean isPressed() {
            return this.modControl.isPressed() ? this.mainControl.isPressed() : false;
        }
    }

    public static enum ControlsJoystick {
        AIRCRAFT_MOD(false, false),
        AIRCRAFT_CAMLOCK(false, true),
        AIRCRAFT_YAW(true, false),
        AIRCRAFT_PITCH(true, false),
        AIRCRAFT_ROLL(true, false),
        AIRCRAFT_THROTTLE(true, false),
        AIRCRAFT_FLAPS_U(false, true),
        AIRCRAFT_FLAPS_D(false, true),
        AIRCRAFT_BRAKE(false, false),
        AIRCRAFT_BRAKE_ANALOG(true, false),
        AIRCRAFT_PANEL(false, true),
        AIRCRAFT_PARK(false, true),
        AIRCRAFT_RADIO(false, true),
        AIRCRAFT_GUN_FIRE(false, false),
        AIRCRAFT_GUN_SWITCH(false, true),
        AIRCRAFT_ZOOM_I(false, true),
        AIRCRAFT_ZOOM_O(false, true),
        AIRCRAFT_CHANGEVIEW(false, true),
        AIRCRAFT_LOOK_L(false, false),
        AIRCRAFT_LOOK_R(false, false),
        AIRCRAFT_LOOK_U(false, false),
        AIRCRAFT_LOOK_D(false, false),
        AIRCRAFT_LOOK_A(false, false),
        AIRCRAFT_TRIM_YAW_R(false, false),
        AIRCRAFT_TRIM_YAW_L(false, false),
        AIRCRAFT_TRIM_PITCH_U(false, false),
        AIRCRAFT_TRIM_PITCH_D(false, false),
        AIRCRAFT_TRIM_ROLL_R(false, false),
        AIRCRAFT_TRIM_ROLL_L(false, false),
        AIRCRAFT_REVERSE(false, true),
        AIRCRAFT_JS_INHIBIT(false, true),
        CAR_MOD(false, false),
        CAR_CAMLOCK(false, true),
        CAR_TURN(true, false),
        CAR_GAS(true, false),
        CAR_BRAKE(false, false),
        CAR_BRAKE_ANALOG(true, false),
        CAR_PANEL(false, true),
        CAR_SHIFT_U(false, true),
        CAR_SHIFT_D(false, true),
        CAR_HORN(false, false),
        CAR_PARK(false, true),
        CAR_RADIO(false, true),
        CAR_GUN_FIRE(false, false),
        CAR_GUN_SWITCH(false, true),
        CAR_ZOOM_I(false, true),
        CAR_ZOOM_O(false, true),
        CAR_CHANGEVIEW(false, true),
        CAR_LOOK_L(false, false),
        CAR_LOOK_R(false, false),
        CAR_LOOK_U(false, false),
        CAR_LOOK_D(false, false),
        CAR_LOOK_A(false, false),
        CAR_LIGHTS(false, true),
        CAR_TURNSIGNAL_L(false, true),
        CAR_TURNSIGNAL_R(false, true),
        CAR_JS_INHIBIT(false, true);

        public final boolean isAxis;
        public final boolean isMomentary;
        public final String systemName;
        public final String translatedName;
        public final JSONConfig.ConfigJoystick config;
        private boolean wasPressedLastCall;

        private ControlsJoystick(boolean isAxis, boolean isMomentary) {
            this.isAxis = isAxis;
            this.isMomentary = isMomentary;
            this.systemName = this.name().toLowerCase().replaceFirst("_", ".");
            this.translatedName = MasterLoader.coreInterface.translate("input." + this.systemName);
            this.config = ConfigSystem.configObject.controls.joystick.containsKey(this.systemName) ? ConfigSystem.configObject.controls.joystick.get(this.systemName) : new JSONConfig.ConfigJoystick();
        }

        public boolean isPressed() {
            if (this.isMomentary) {
                if (this.wasPressedLastCall) {
                    this.wasPressedLastCall = MasterLoader.inputInterface.getJoystickInputValue(this.config.joystickName, this.config.buttonIndex) > 0.0f;
                    return false;
                }
                this.wasPressedLastCall = MasterLoader.inputInterface.getJoystickInputValue(this.config.joystickName, this.config.buttonIndex) > 0.0f;
                return this.wasPressedLastCall;
            }
            return MasterLoader.inputInterface.getJoystickInputValue(this.config.joystickName, this.config.buttonIndex) > 0.0f;
        }

        private float getMultistateValue() {
            return MasterLoader.inputInterface.getJoystickInputValue(this.config.joystickName, this.config.buttonIndex);
        }

        private short getAxisState(short pollBounds) {
            float pollValue = this.getMultistateValue();
            if ((double)Math.abs(pollValue) > (Double)ConfigSystem.configObject.client.joystickDeadZone.value || pollBounds == 0) {
                pollValue = (float)Math.max(this.config.axisMinTravel, (double)pollValue);
                pollValue = (float)Math.min(this.config.axisMaxTravel, (double)pollValue);
                if (pollBounds != 0) {
                    return (short)(this.config.invertedAxis ? (float)(-pollBounds) * pollValue : (float)pollBounds * pollValue);
                }
                pollValue = (float)(((double)pollValue - this.config.axisMinTravel) / (this.config.axisMaxTravel - this.config.axisMinTravel));
                if (this.config.invertedAxis) {
                    pollValue = 1.0f - pollValue;
                }
                return (short)(pollValue * 100.0f);
            }
            return 0;
        }

        public void setControl(String joystickName, int buttonIndex) {
            this.config.joystickName = joystickName;
            this.config.buttonIndex = buttonIndex;
            ConfigSystem.saveToDisk();
        }

        public void setAxisControl(String joystickName, int buttonIndex, double axisMinTravel, double axisMaxTravel, boolean invertedAxis) {
            this.config.axisMinTravel = axisMinTravel;
            this.config.axisMaxTravel = axisMaxTravel;
            this.config.invertedAxis = invertedAxis;
            this.setControl(joystickName, buttonIndex);
        }

        public void clearControl() {
            this.setControl(null, 999);
        }
    }

    public static enum ControlsKeyboard {
        AIRCRAFT_MOD(ControlsJoystick.AIRCRAFT_MOD, false, "RSHIFT"),
        AIRCRAFT_CAMLOCK(ControlsJoystick.AIRCRAFT_CAMLOCK, true, "RCONTROL"),
        AIRCRAFT_YAW_R(ControlsJoystick.AIRCRAFT_YAW, false, "L"),
        AIRCRAFT_YAW_L(ControlsJoystick.AIRCRAFT_YAW, false, "J"),
        AIRCRAFT_PITCH_U(ControlsJoystick.AIRCRAFT_PITCH, false, "S"),
        AIRCRAFT_PITCH_D(ControlsJoystick.AIRCRAFT_PITCH, false, "W"),
        AIRCRAFT_ROLL_R(ControlsJoystick.AIRCRAFT_ROLL, false, "D"),
        AIRCRAFT_ROLL_L(ControlsJoystick.AIRCRAFT_ROLL, false, "A"),
        AIRCRAFT_THROTTLE_U(ControlsJoystick.AIRCRAFT_THROTTLE, false, "I"),
        AIRCRAFT_THROTTLE_D(ControlsJoystick.AIRCRAFT_THROTTLE, false, "K"),
        AIRCRAFT_FLAPS_U(ControlsJoystick.AIRCRAFT_FLAPS_U, true, "Y"),
        AIRCRAFT_FLAPS_D(ControlsJoystick.AIRCRAFT_FLAPS_D, true, "H"),
        AIRCRAFT_BRAKE(ControlsJoystick.AIRCRAFT_BRAKE, false, "B"),
        AIRCRAFT_PANEL(ControlsJoystick.AIRCRAFT_PANEL, true, "U"),
        AIRCRAFT_RADIO(ControlsJoystick.AIRCRAFT_RADIO, true, "MINUS"),
        AIRCRAFT_GUN_FIRE(ControlsJoystick.AIRCRAFT_GUN_FIRE, false, "SPACE"),
        AIRCRAFT_GUN_SWITCH(ControlsJoystick.AIRCRAFT_GUN_SWITCH, true, "V"),
        AIRCRAFT_ZOOM_I(ControlsJoystick.AIRCRAFT_ZOOM_I, true, "PRIOR"),
        AIRCRAFT_ZOOM_O(ControlsJoystick.AIRCRAFT_ZOOM_O, true, "NEXT"),
        AIRCRAFT_JS_INHIBIT(ControlsJoystick.AIRCRAFT_JS_INHIBIT, true, "SCROLL"),
        CAR_MOD(ControlsJoystick.CAR_MOD, false, "RSHIFT"),
        CAR_CAMLOCK(ControlsJoystick.CAR_CAMLOCK, true, "RCONTROL"),
        CAR_TURN_R(ControlsJoystick.CAR_TURN, false, "D"),
        CAR_TURN_L(ControlsJoystick.CAR_TURN, false, "A"),
        CAR_GAS(ControlsJoystick.CAR_GAS, false, "W"),
        CAR_BRAKE(ControlsJoystick.CAR_BRAKE, false, "S"),
        CAR_PANEL(ControlsJoystick.CAR_PANEL, true, "U"),
        CAR_SHIFT_U(ControlsJoystick.CAR_SHIFT_U, true, "R"),
        CAR_SHIFT_D(ControlsJoystick.CAR_SHIFT_D, true, "F"),
        CAR_HORN(ControlsJoystick.CAR_HORN, false, "C"),
        CAR_RADIO(ControlsJoystick.CAR_RADIO, true, "MINUS"),
        CAR_GUN_FIRE(ControlsJoystick.CAR_GUN_FIRE, false, "SPACE"),
        CAR_GUN_SWITCH(ControlsJoystick.CAR_GUN_SWITCH, true, "V"),
        CAR_ZOOM_I(ControlsJoystick.CAR_ZOOM_I, true, "PRIOR"),
        CAR_ZOOM_O(ControlsJoystick.CAR_ZOOM_O, true, "NEXT"),
        CAR_LIGHTS(ControlsJoystick.CAR_LIGHTS, true, "NUMPAD5"),
        CAR_TURNSIGNAL_L(ControlsJoystick.CAR_TURNSIGNAL_L, true, "NUMPAD4"),
        CAR_TURNSIGNAL_R(ControlsJoystick.CAR_TURNSIGNAL_R, true, "NUMPAD6"),
        CAR_JS_INHIBIT(ControlsJoystick.CAR_JS_INHIBIT, true, "SCROLL");

        public final boolean isMomentary;
        public final String systemName;
        public final String translatedName;
        public final String defaultKeyName;
        public final JSONConfig.ConfigKeyboard config;
        private final ControlsJoystick linkedJoystick;
        private boolean wasPressedLastCall;

        private ControlsKeyboard(ControlsJoystick linkedJoystick, boolean isMomentary, String defaultKeyName) {
            this.linkedJoystick = linkedJoystick;
            this.isMomentary = isMomentary;
            this.systemName = this.name().toLowerCase().replaceFirst("_", ".");
            this.translatedName = MasterLoader.coreInterface.translate("input." + this.systemName);
            this.defaultKeyName = defaultKeyName;
            this.config = ConfigSystem.configObject.controls.keyboard.containsKey(this.systemName) ? ConfigSystem.configObject.controls.keyboard.get(this.systemName) : new JSONConfig.ConfigKeyboard();
        }

        public boolean isPressed() {
            if (this.linkedJoystick.isPressed()) {
                return true;
            }
            if (MasterLoader.inputInterface.isJoystickPresent(this.linkedJoystick.config.joystickName) && ((Boolean)ConfigSystem.configObject.client.kbOverride.value).booleanValue()) {
                return false;
            }
            if (this.isMomentary) {
                if (this.wasPressedLastCall) {
                    this.wasPressedLastCall = MasterLoader.inputInterface.isKeyPressed(this.config.keyCode);
                    return false;
                }
                this.wasPressedLastCall = MasterLoader.inputInterface.isKeyPressed(this.config.keyCode);
                return this.wasPressedLastCall;
            }
            return MasterLoader.inputInterface.isKeyPressed(this.config.keyCode);
        }
    }
}

