/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.systems;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import mcinterface1122.MasterInterface;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.instances.ItemBooklet;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.items.instances.ItemInstrument;
import minecrafttransportsimulator.items.instances.ItemItem;
import minecrafttransportsimulator.items.instances.ItemPart;
import minecrafttransportsimulator.items.instances.ItemPole;
import minecrafttransportsimulator.items.instances.ItemPoleComponent;
import minecrafttransportsimulator.items.instances.ItemVehicle;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.JSONBooklet;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.jsondefs.JSONInstrument;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPack;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packloading.PackResourceLoader;

public final class PackParserSystem {
    private static Map<String, File> packJarMap = new HashMap<String, File>();
    public static Map<String, JSONPack> packMap = new HashMap<String, JSONPack>();
    public static Map<String, List<String>> faultMap = new HashMap<String, List<String>>();
    private static TreeMap<String, LinkedHashMap<String, AItemPack<?>>> packItemMap = new TreeMap();
    public static final Gson packParser = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(Point3d.class, Point3d.adapter).create();

    public static void checkJarForPacks(File packJar) {
        try {
            ZipFile jarFile = new ZipFile(packJar);
            Enumeration<? extends ZipEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().endsWith("packdefinition.json")) continue;
                JSONPack packDef = (JSONPack)packParser.fromJson((Reader)new InputStreamReader(jarFile.getInputStream(entry), "UTF-8"), JSONPack.class);
                packJarMap.put(packDef.packID, packJar);
                packMap.put(packDef.packID, packDef);
            }
            jarFile.close();
        }
        catch (Exception e) {
            MasterLoader.coreInterface.logError("ERROR: A fault was encountered when trying to check file " + packJar.getName() + " for pack data.  This pack will not be loaded.");
            e.printStackTrace();
        }
    }

    public static void parseAllPacks() {
        ArrayList<String> packIDs = new ArrayList<String>(packMap.keySet());
        Iterator<String> iterator = packMap.keySet().iterator();
        while (iterator.hasNext()) {
            JSONPack packDef = packMap.get(iterator.next());
            if (packDef.packID.equals(MasterLoader.resourceDomain)) continue;
            ArrayList<String> validSubDirectories = new ArrayList<String>();
            if (packDef.activators != null) {
                block47: for (String subDirectory : packDef.activators.keySet()) {
                    for (String activator : packDef.activators.get(subDirectory)) {
                        if (!packIDs.contains(activator) && !MasterLoader.coreInterface.isModPresent(activator)) continue;
                        validSubDirectories.add(subDirectory);
                        continue block47;
                    }
                }
            } else {
                validSubDirectories.add("");
            }
            if (packDef.blockers != null) {
                block49: for (String subDirectory : packDef.blockers.keySet()) {
                    for (String blocker : packDef.blockers.get(subDirectory)) {
                        if (!packIDs.contains(blocker) && !MasterLoader.coreInterface.isModPresent(blocker)) continue;
                        validSubDirectories.remove(subDirectory);
                        continue block49;
                    }
                }
            }
            if (packDef.dependents != null) {
                for (String dependent : packDef.dependents) {
                    if (!packIDs.contains(dependent) && !MasterLoader.coreInterface.isModPresent(dependent)) continue;
                    faultMap.put(packDef.packID, packDef.dependents);
                    break;
                }
            }
            PackResourceLoader.PackStructure structure = PackResourceLoader.PackStructure.values()[packDef.fileStructure];
            for (String subDirectory : validSubDirectories) {
                String assetPathPrefix = "assets/" + packDef.packID + "/";
                if (!subDirectory.isEmpty()) {
                    assetPathPrefix = assetPathPrefix + subDirectory + "/";
                }
                try {
                    ZipFile jarFile = new ZipFile(packJarMap.get(packDef.packID));
                    Enumeration<? extends ZipEntry> entries = jarFile.entries();
                    block53: while (entries.hasMoreElements()) {
                        AItemPack item;
                        AJSONItem definition;
                        Class jsonClass;
                        String jsonType;
                        ZipEntry entry = entries.nextElement();
                        String entryFullPath = entry.getName();
                        if (!entryFullPath.startsWith(assetPathPrefix) || !entryFullPath.endsWith(".json")) continue;
                        String fileName = entryFullPath.substring(entryFullPath.lastIndexOf(47) + 1);
                        String assetPath = entryFullPath.substring(assetPathPrefix.length(), entryFullPath.substring(0, entryFullPath.length() - fileName.length()).lastIndexOf("/") + 1);
                        if (!structure.equals((Object)PackResourceLoader.PackStructure.MODULAR)) {
                            assetPath = assetPath.substring("jsondefs/".length());
                        }
                        if (fileName.equals("packdefinition.json") || !(structure.equals((Object)PackResourceLoader.PackStructure.MODULAR) ? !fileName.endsWith("_item.json") : entryFullPath.contains("jsondefs"))) continue;
                        switch (jsonType = assetPath.substring(0, assetPath.indexOf("/"))) {
                            case "vehicles": {
                                jsonClass = JSONVehicle.class;
                                break;
                            }
                            case "parts": {
                                jsonClass = JSONPart.class;
                                break;
                            }
                            case "instruments": {
                                jsonClass = JSONInstrument.class;
                                break;
                            }
                            case "poles": {
                                jsonClass = JSONPoleComponent.class;
                                break;
                            }
                            case "decors": {
                                jsonClass = JSONDecor.class;
                                break;
                            }
                            case "items": {
                                jsonClass = JSONItem.class;
                                break;
                            }
                            case "booklets": {
                                jsonClass = JSONBooklet.class;
                                break;
                            }
                            default: {
                                MasterLoader.coreInterface.logError("ERROR: Could not determine what type of JSON to create from: " + jsonType + " for asset: " + fileName);
                                continue block53;
                            }
                        }
                        try {
                            definition = (AJSONItem)packParser.fromJson((Reader)new InputStreamReader(jarFile.getInputStream(entry), "UTF-8"), jsonClass);
                            PackParserSystem.performLegacyCompats(definition);
                        }
                        catch (Exception e) {
                            MasterLoader.coreInterface.logError("ERROR: Could not parse: " + packDef.packID + ":" + fileName);
                            MasterLoader.coreInterface.logError(e.getMessage());
                            continue;
                        }
                        if (structure.equals((Object)PackResourceLoader.PackStructure.DEFAULT)) {
                            assetPath = assetPath.substring(0, assetPath.indexOf("/") + 1);
                        }
                        if (definition instanceof AJSONMultiModelProvider) {
                            for (AJSONMultiModelProvider.SubDefinition subDefinition : ((AJSONMultiModelProvider)definition).definitions) {
                                try {
                                    if (subDefinition.extraMaterials != null) {
                                        AItemSubTyped item2;
                                        switch (jsonType) {
                                            case "vehicles": {
                                                item2 = new ItemVehicle((JSONVehicle)definition, subDefinition.subName);
                                                break;
                                            }
                                            case "parts": {
                                                item2 = new ItemPart((JSONPart)definition, subDefinition.subName);
                                                break;
                                            }
                                            default: {
                                                throw new IllegalArgumentException("ERROR: No corresponding sub-definable item class was found for: " + jsonType + " for asset: " + fileName);
                                            }
                                        }
                                        PackParserSystem.setupItem(item2, packDef.packID, fileName.substring(0, fileName.length() - ".json".length()), subDefinition.subName, assetPath);
                                        continue;
                                    }
                                    throw new NullPointerException();
                                }
                                catch (Exception e) {
                                    throw new NullPointerException("Unable to parse definition #" + (((AJSONMultiModelProvider)definition).definitions.indexOf(subDefinition) + 1) + " due to a formatting error.");
                                }
                            }
                            continue;
                        }
                        switch (jsonType) {
                            case "instruments": {
                                item = new ItemInstrument((JSONInstrument)definition);
                                break;
                            }
                            case "poles": {
                                item = ((JSONPoleComponent.PoleGeneral)((JSONPoleComponent)definition).general).type.equals("core") ? new ItemPole((JSONPoleComponent)definition) : new ItemPoleComponent((JSONPoleComponent)definition);
                                break;
                            }
                            case "decors": {
                                item = new ItemDecor((JSONDecor)definition);
                                break;
                            }
                            case "items": {
                                item = new ItemItem((JSONItem)definition);
                                break;
                            }
                            case "booklets": {
                                item = new ItemBooklet((JSONBooklet)definition);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("ERROR: No corresponding sub-definable item class was found for: " + jsonType + " for asset: " + fileName);
                            }
                        }
                        PackParserSystem.setupItem(item, packDef.packID, fileName.substring(0, fileName.length() - ".json".length()), "", assetPath);
                    }
                    jarFile.close();
                }
                catch (Exception e) {
                    MasterLoader.coreInterface.logError("ERROR: Could not start parsing of pack: " + packDef.packID);
                    e.printStackTrace();
                }
            }
        }
    }

    public static String[] getValidPackContentNames() {
        return PackResourceLoader.ItemClassification.getAllTypesAsStrings().toArray(new String[PackResourceLoader.ItemClassification.values().length]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addVehicleDefinition(InputStreamReader jsonReader, String jsonFileName, String packID) {
        try {
            JSONVehicle definition = (JSONVehicle)packParser.fromJson((Reader)jsonReader, JSONVehicle.class);
            PackParserSystem.performLegacyCompats(definition);
            for (AJSONMultiModelProvider.SubDefinition subDefinition : definition.definitions) {
                try {
                    if (subDefinition.extraMaterials == null) throw new NullPointerException();
                    PackParserSystem.setupItem(new ItemVehicle(definition, subDefinition.subName), packID, jsonFileName, subDefinition.subName, "vehicles/");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new NullPointerException("Unable to parse definition #" + (definition.definitions.indexOf(subDefinition) + 1) + " due to a formatting error.");
                    return;
                }
            }
        }
        catch (Exception e) {
            MasterLoader.coreInterface.logError("AN ERROR WAS ENCOUNTERED WHEN TRY TO PARSE: " + packID + ":" + jsonFileName);
            MasterLoader.coreInterface.logError(e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addPartDefinition(InputStreamReader jsonReader, String jsonFileName, String packID) {
        try {
            JSONPart definition = (JSONPart)packParser.fromJson((Reader)jsonReader, JSONPart.class);
            PackParserSystem.performLegacyCompats(definition);
            for (AJSONMultiModelProvider.SubDefinition subDefinition : definition.definitions) {
                try {
                    if (subDefinition.extraMaterials == null) throw new NullPointerException();
                    PackParserSystem.setupItem(new ItemPart(definition, subDefinition.subName), packID, jsonFileName, subDefinition.subName, "parts/");
                }
                catch (Exception e) {
                    throw new NullPointerException("Unable to parse definition #" + (definition.definitions.indexOf(subDefinition) + 1) + " due to a formatting error.");
                    return;
                }
            }
        }
        catch (Exception e) {
            MasterLoader.coreInterface.logError("AN ERROR WAS ENCOUNTERED WHEN TRY TO PARSE: " + packID + ":" + jsonFileName);
            MasterLoader.coreInterface.logError(e.getMessage());
        }
    }

    public static void addInstrumentDefinition(InputStreamReader jsonReader, String jsonFileName, String packID) {
        try {
            PackParserSystem.setupItem(new ItemInstrument((JSONInstrument)packParser.fromJson((Reader)jsonReader, JSONInstrument.class)), packID, jsonFileName, "", "instruments/");
        }
        catch (Exception e) {
            MasterLoader.coreInterface.logError("AN ERROR WAS ENCOUNTERED WHEN TRY TO PARSE: " + packID + ":" + jsonFileName);
            MasterLoader.coreInterface.logError(e.getMessage());
        }
    }

    public static void addPoleDefinition(InputStreamReader jsonReader, String jsonFileName, String packID) {
        try {
            JSONPoleComponent definition = (JSONPoleComponent)packParser.fromJson((Reader)jsonReader, JSONPoleComponent.class);
            PackParserSystem.performLegacyCompats(definition);
            PackParserSystem.setupItem(((JSONPoleComponent.PoleGeneral)definition.general).type.equals("core") ? new ItemPole(definition) : new ItemPoleComponent(definition), packID, jsonFileName, "", "poles/");
        }
        catch (Exception e) {
            MasterLoader.coreInterface.logError("AN ERROR WAS ENCOUNTERED WHEN TRY TO PARSE: " + packID + ":" + jsonFileName);
            MasterLoader.coreInterface.logError(e.getMessage());
        }
    }

    public static void addDecorDefinition(InputStreamReader jsonReader, String jsonFileName, String packID) {
        try {
            JSONDecor definition = (JSONDecor)packParser.fromJson((Reader)jsonReader, JSONDecor.class);
            PackParserSystem.performLegacyCompats(definition);
            PackParserSystem.setupItem(new ItemDecor(definition), packID, jsonFileName, "", "decors/");
        }
        catch (Exception e) {
            MasterLoader.coreInterface.logError("AN ERROR WAS ENCOUNTERED WHEN TRY TO PARSE: " + packID + ":" + jsonFileName);
            MasterLoader.coreInterface.logError(e.getMessage());
        }
    }

    public static void addItemDefinition(InputStreamReader jsonReader, String jsonFileName, String packID) {
        try {
            PackParserSystem.setupItem(new ItemItem((JSONItem)packParser.fromJson((Reader)jsonReader, JSONItem.class)), packID, jsonFileName, "", "items/");
        }
        catch (Exception e) {
            MasterLoader.coreInterface.logError("AN ERROR WAS ENCOUNTERED WHEN TRY TO PARSE: " + packID + ":" + jsonFileName);
            MasterLoader.coreInterface.logError(e.getMessage());
        }
    }

    public static void addBookletDefinition(InputStreamReader jsonReader, String jsonFileName, String packID) {
        try {
            PackParserSystem.setupItem(new ItemBooklet((JSONBooklet)packParser.fromJson((Reader)jsonReader, JSONBooklet.class)), packID, jsonFileName, "", "booklets/");
        }
        catch (Exception e) {
            MasterLoader.coreInterface.logError("AN ERROR WAS ENCOUNTERED WHEN TRY TO PARSE: " + packID + ":" + jsonFileName);
            MasterLoader.coreInterface.logError(e.getMessage());
        }
    }

    public static <ItemInstance extends AItemPack<?>> void setupItem(AItemPack<?> item, String packID, String systemName, String subName, String prefixFolders) {
        ((AJSONItem)item.definition).packID = packID;
        ((AJSONItem)item.definition).prefixFolders = prefixFolders;
        ((AJSONItem)item.definition).systemName = systemName;
        MasterInterface.createItem(item);
        if (!packItemMap.containsKey(packID)) {
            packItemMap.put(packID, new LinkedHashMap());
        }
        packItemMap.get(packID).put(((AJSONItem)item.definition).systemName + subName, item);
    }

    private static <JSONDefinition extends AJSONItem<?>> void performLegacyCompats(JSONDefinition definition) {
        if (definition instanceof JSONPart) {
            JSONPart partDef = (JSONPart)definition;
            if (partDef.definitions == null) {
                partDef.definitions = new ArrayList();
                Iterator<JSONVehicle.VehiclePart> subDefinition = partDef.new AJSONMultiModelProvider.SubDefinition();
                ((AJSONMultiModelProvider.SubDefinition)((Object)subDefinition)).extraMaterials = new String[0];
                ((AJSONMultiModelProvider.SubDefinition)((Object)subDefinition)).name = ((AJSONItem.General)definition.general).name;
                ((AJSONMultiModelProvider.SubDefinition)((Object)subDefinition)).subName = "";
                partDef.definitions.add(subDefinition);
            }
            if (partDef.engine != null) {
                if (((JSONPart.JSONPartGeneral)partDef.general).type.equals("engine_jet") && partDef.engine.jetPowerFactor == 0.0f) {
                    partDef.engine.jetPowerFactor = 1.0f;
                    partDef.engine.bypassRatio = partDef.engine.gearRatios[0];
                    partDef.engine.gearRatios[0] = 1.0f;
                }
                if (partDef.engine.gearRatios.length == 1) {
                    partDef.engine.propellerRatio = 1.0f / partDef.engine.gearRatios[0];
                    partDef.engine.gearRatios = new float[]{-1.0f, 0.0f, 1.0f};
                }
                if (partDef.engine.shiftSpeed == 0) {
                    partDef.engine.shiftSpeed = (byte)20;
                }
                if (partDef.engine.revResistance == 0) {
                    partDef.engine.revResistance = (byte)10;
                }
            } else if (partDef.gun != null) {
                if (((JSONPart.JSONPartGeneral)partDef.general).type.equals("gun_turret")) {
                    partDef.gun.isTurret = true;
                }
            } else {
                switch (((JSONPart.JSONPartGeneral)partDef.general).type) {
                    case "wheel": {
                        ((JSONPart.JSONPartGeneral)partDef.general).type = "ground_" + ((JSONPart.JSONPartGeneral)partDef.general).type;
                        partDef.ground = partDef.new JSONPart.JSONPartGroundDevice();
                        partDef.ground.isWheel = true;
                        partDef.ground.width = partDef.wheel.diameter / 2.0f;
                        partDef.ground.height = partDef.wheel.diameter;
                        partDef.ground.lateralFriction = partDef.wheel.lateralFriction;
                        partDef.ground.motiveFriction = partDef.wheel.motiveFriction;
                        break;
                    }
                    case "skid": {
                        ((JSONPart.JSONPartGeneral)partDef.general).type = "ground_" + ((JSONPart.JSONPartGeneral)partDef.general).type;
                        partDef.ground = partDef.new JSONPart.JSONPartGroundDevice();
                        partDef.ground.width = partDef.skid.width;
                        partDef.ground.height = partDef.skid.width;
                        partDef.ground.lateralFriction = partDef.skid.lateralFriction;
                        break;
                    }
                    case "pontoon": {
                        ((JSONPart.JSONPartGeneral)partDef.general).type = "ground_" + ((JSONPart.JSONPartGeneral)partDef.general).type;
                        partDef.ground = partDef.new JSONPart.JSONPartGroundDevice();
                        partDef.ground.canFloat = true;
                        partDef.ground.width = partDef.pontoon.width;
                        partDef.ground.height = partDef.pontoon.width;
                        partDef.ground.lateralFriction = partDef.pontoon.lateralFriction;
                        partDef.ground.extraCollisionBoxOffset = partDef.pontoon.extraCollisionBoxOffset;
                        break;
                    }
                    case "tread": {
                        ((JSONPart.JSONPartGeneral)partDef.general).type = "ground_" + ((JSONPart.JSONPartGeneral)partDef.general).type;
                        partDef.ground = partDef.new JSONPart.JSONPartGroundDevice();
                        partDef.ground.isTread = true;
                        partDef.ground.width = partDef.tread.width;
                        partDef.ground.height = partDef.tread.width;
                        partDef.ground.lateralFriction = partDef.tread.lateralFriction;
                        partDef.ground.motiveFriction = partDef.tread.motiveFriction;
                        partDef.ground.extraCollisionBoxOffset = partDef.tread.extraCollisionBoxOffset;
                        partDef.ground.spacing = partDef.tread.spacing;
                        break;
                    }
                    case "crate": {
                        ((JSONPart.JSONPartGeneral)partDef.general).type = "interactable_crate";
                        partDef.interactable = partDef.new JSONPart.JSONPartInteractable();
                        partDef.interactable.interactionType = "crate";
                        partDef.interactable.inventoryUnits = 1;
                        partDef.interactable.feedsVehicles = true;
                        break;
                    }
                    case "barrel": {
                        ((JSONPart.JSONPartGeneral)partDef.general).type = "interactable_barrel";
                        partDef.interactable = partDef.new JSONPart.JSONPartInteractable();
                        partDef.interactable.interactionType = "barrel";
                        partDef.interactable.inventoryUnits = 1;
                        break;
                    }
                    case "crafting_table": {
                        ((JSONPart.JSONPartGeneral)partDef.general).type = "interactable_crafting_table";
                        partDef.interactable = partDef.new JSONPart.JSONPartInteractable();
                        partDef.interactable.interactionType = "crafting_table";
                        break;
                    }
                    case "furnace": {
                        ((JSONPart.JSONPartGeneral)partDef.general).type = "interactable_furnace";
                        partDef.interactable = partDef.new JSONPart.JSONPartInteractable();
                        partDef.interactable.interactionType = "furnace";
                        break;
                    }
                    case "brewing_stand": {
                        ((JSONPart.JSONPartGeneral)partDef.general).type = "interactable_brewing_stand";
                        partDef.interactable = partDef.new JSONPart.JSONPartInteractable();
                        partDef.interactable.interactionType = "brewing_stand";
                        break;
                    }
                    case "fertilizer": {
                        ((JSONPart.JSONPartGeneral)partDef.general).type = "effector_fertilizer";
                        partDef.effector = partDef.new JSONPart.JSONPartEffector();
                        partDef.effector.type = "fertilizer";
                        partDef.effector.blocksWide = 1;
                        break;
                    }
                    case "harvester": {
                        ((JSONPart.JSONPartGeneral)partDef.general).type = "effector_harvester";
                        partDef.effector = partDef.new JSONPart.JSONPartEffector();
                        partDef.effector.type = "harvester";
                        partDef.effector.blocksWide = 1;
                        break;
                    }
                    case "planter": {
                        ((JSONPart.JSONPartGeneral)partDef.general).type = "effector_planter";
                        partDef.effector = partDef.new JSONPart.JSONPartEffector();
                        partDef.effector.type = "planter";
                        partDef.effector.blocksWide = 1;
                        break;
                    }
                    case "plow": {
                        ((JSONPart.JSONPartGeneral)partDef.general).type = "effector_plow";
                        partDef.effector = partDef.new JSONPart.JSONPartEffector();
                        partDef.effector.type = "plow";
                        partDef.effector.blocksWide = 1;
                    }
                }
            }
            if (partDef.subParts != null) {
                for (JSONVehicle.VehiclePart subPartDef : partDef.subParts) {
                    if (subPartDef.additionalPart != null) {
                        subPartDef.additionalParts = new ArrayList<JSONVehicle.VehiclePart>();
                        subPartDef.additionalParts.add(subPartDef.additionalPart);
                    }
                    for (int i = 0; i < subPartDef.types.size(); i = (int)((byte)(i + 1))) {
                        String subPartName = subPartDef.types.get(i);
                        if (subPartName.equals("wheel") || subPartName.equals("skid") || subPartName.equals("pontoon") || subPartName.equals("tread")) {
                            if (subPartName.equals("tread")) {
                                subPartDef.turnsWithSteer = true;
                            }
                            subPartDef.types.set(i, "ground_" + subPartName);
                        } else if (subPartName.equals("crate") || subPartName.equals("barrel") || subPartName.equals("crafting_table") || subPartName.equals("furnace") || subPartName.equals("brewing_stand")) {
                            subPartDef.types.set(i, "interactable_" + subPartName);
                        } else if (subPartName.equals("fertilizer") || subPartName.equals("harvester") || subPartName.equals("planter") || subPartName.equals("plow")) {
                            subPartDef.types.set(i, "effector_" + subPartName);
                        }
                        if (subPartDef.additionalParts == null) continue;
                        for (JSONVehicle.VehiclePart additionalPart : subPartDef.additionalParts) {
                            for (int j = 0; j < additionalPart.types.size(); j = (int)((byte)(j + 1))) {
                                subPartName = additionalPart.types.get(j);
                                if (subPartName.equals("wheel") || subPartName.equals("skid") || subPartName.equals("pontoon") || subPartName.equals("tread")) {
                                    if (subPartName.equals("tread")) {
                                        additionalPart.turnsWithSteer = true;
                                    }
                                    additionalPart.types.set(j, "ground_" + subPartName);
                                    continue;
                                }
                                if (subPartName.equals("crate") || subPartName.equals("barrel") || subPartName.equals("crafting_table") || subPartName.equals("furnace") || subPartName.equals("brewing_stand")) {
                                    subPartDef.types.set(i, "interactable_" + subPartName);
                                    continue;
                                }
                                if (!subPartName.equals("fertilizer") && !subPartName.equals("harvester") && !subPartName.equals("planter") && !subPartName.equals("plow")) continue;
                                subPartDef.types.set(i, "effector_" + subPartName);
                            }
                        }
                    }
                }
            }
            if (partDef.rendering != null) {
                PackParserSystem.doAnimationLegacyCompats(partDef.rendering, new JSONVehicle());
            }
        } else if (definition instanceof JSONVehicle) {
            JSONVehicle vehicleDef = (JSONVehicle)definition;
            if (vehicleDef.car != null) {
                vehicleDef.motorized.isBigTruck = vehicleDef.car.isBigTruck;
                vehicleDef.motorized.isFrontWheelDrive = vehicleDef.car.isFrontWheelDrive;
                vehicleDef.motorized.isRearWheelDrive = vehicleDef.car.isRearWheelDrive;
                vehicleDef.motorized.hasCruiseControl = vehicleDef.car.hasCruiseControl;
                vehicleDef.motorized.axleRatio = vehicleDef.car.axleRatio;
                vehicleDef.motorized.dragCoefficient = vehicleDef.car.dragCoefficient;
                vehicleDef.car = null;
            }
            if (((JSONVehicle.VehicleGeneral)vehicleDef.general).type != null && (((JSONVehicle.VehicleGeneral)vehicleDef.general).type.equals("plane") || ((JSONVehicle.VehicleGeneral)vehicleDef.general).type.equals("blimp") || ((JSONVehicle.VehicleGeneral)vehicleDef.general).type.equals("helicopter"))) {
                ((JSONVehicle.VehicleGeneral)vehicleDef.general).isAircraft = true;
            }
            if (vehicleDef.plane != null) {
                ((JSONVehicle.VehicleGeneral)vehicleDef.general).isAircraft = true;
                vehicleDef.motorized.hasFlaps = vehicleDef.plane.hasFlaps;
                vehicleDef.motorized.hasAutopilot = vehicleDef.plane.hasAutopilot;
                vehicleDef.motorized.wingSpan = vehicleDef.plane.wingSpan;
                vehicleDef.motorized.wingArea = vehicleDef.plane.wingArea;
                vehicleDef.motorized.tailDistance = vehicleDef.plane.tailDistance;
                vehicleDef.motorized.aileronArea = vehicleDef.plane.aileronArea;
                vehicleDef.motorized.elevatorArea = vehicleDef.plane.elevatorArea;
                vehicleDef.motorized.rudderArea = vehicleDef.plane.rudderArea;
                vehicleDef.plane = null;
                if (vehicleDef.motorized.aileronArea == 0.0f) {
                    vehicleDef.motorized.aileronArea = vehicleDef.motorized.wingArea / 5.0f;
                }
            }
            if (vehicleDef.blimp != null) {
                ((JSONVehicle.VehicleGeneral)vehicleDef.general).isAircraft = true;
                ((JSONVehicle.VehicleGeneral)vehicleDef.general).isBlimp = true;
                vehicleDef.motorized.crossSectionalArea = vehicleDef.blimp.crossSectionalArea;
                vehicleDef.motorized.tailDistance = vehicleDef.blimp.tailDistance;
                vehicleDef.motorized.rudderArea = vehicleDef.blimp.rudderArea;
                vehicleDef.motorized.ballastVolume = vehicleDef.blimp.ballastVolume;
                vehicleDef.blimp = null;
            }
            for (JSONVehicle.VehiclePart part : vehicleDef.parts) {
                int i;
                if (part.additionalPart != null) {
                    part.additionalParts = new ArrayList<JSONVehicle.VehiclePart>();
                    part.additionalParts.add(part.additionalPart);
                    part.additionalPart = null;
                }
                if (part.linkedDoor != null) {
                    part.linkedDoors = new ArrayList<String>();
                    part.linkedDoors.add(part.linkedDoor);
                    part.linkedDoor = null;
                }
                if (part.exhaustPos != null) {
                    part.exhaustObjects = new ArrayList<JSONVehicle.VehiclePart.ExhaustObject>();
                    for (i = 0; i < part.exhaustPos.length; i += 3) {
                        JSONVehicle.VehiclePart.ExhaustObject exhaust = part.new JSONVehicle.VehiclePart.ExhaustObject();
                        exhaust.pos = new Point3d(part.exhaustPos[i], part.exhaustPos[i + 1], part.exhaustPos[i + 2]);
                        exhaust.velocity = new Point3d(part.exhaustVelocity[i], part.exhaustVelocity[i + 1], part.exhaustVelocity[i + 2]);
                        exhaust.scale = 1.0f;
                        part.exhaustObjects.add(exhaust);
                    }
                    part.exhaustPos = null;
                }
                if (part.rotationVariable != null) {
                    part.animations = new ArrayList<JSONVehicle.VehicleAnimationDefinition>();
                    JSONVehicle.VehicleAnimationDefinition animation = vehicleDef.new JSONVehicle.VehicleAnimationDefinition();
                    animation.animationType = "rotation";
                    animation.variable = part.rotationVariable;
                    animation.centerPoint = part.rotationPosition;
                    animation.axis = part.rotationAngles;
                    animation.clampMin = part.rotationClampMin;
                    animation.clampMax = part.rotationClampMax;
                    animation.absolute = part.rotationAbsolute;
                    part.animations.add(animation);
                }
                if (part.translationVariable != null) {
                    if (part.animations == null) {
                        part.animations = new ArrayList<JSONVehicle.VehicleAnimationDefinition>();
                    }
                    JSONVehicle.VehicleAnimationDefinition animation = vehicleDef.new JSONVehicle.VehicleAnimationDefinition();
                    animation.animationType = "translation";
                    animation.variable = part.translationVariable;
                    animation.axis = part.translationPosition;
                    animation.clampMin = part.translationClampMin;
                    animation.clampMax = part.translationClampMax;
                    animation.absolute = part.translationAbsolute;
                    part.animations.add(animation);
                }
                for (i = 0; i < part.types.size(); i = (int)((byte)(i + 1))) {
                    String partName = part.types.get(i);
                    if (partName.equals("wheel") || partName.equals("skid") || partName.equals("pontoon") || partName.equals("tread")) {
                        if (partName.equals("tread")) {
                            part.turnsWithSteer = true;
                        }
                        part.types.set(i, "ground_" + partName);
                    } else if (partName.equals("crate") || partName.equals("barrel") || partName.equals("crafting_table") || partName.equals("furnace") || partName.equals("brewing_stand")) {
                        part.types.set(i, "interactable_" + partName);
                    } else if (partName.equals("fertilizer") || partName.equals("harvester") || partName.equals("planter") || partName.equals("plow")) {
                        part.types.set(i, "effector_" + partName);
                    }
                    if (part.additionalParts == null) continue;
                    for (JSONVehicle.VehiclePart additionalPart : part.additionalParts) {
                        for (int j = 0; j < additionalPart.types.size(); j = (int)((byte)(j + 1))) {
                            partName = additionalPart.types.get(j);
                            if (partName.equals("wheel") || partName.equals("skid") || partName.equals("pontoon") || partName.equals("tread")) {
                                if (partName.equals("tread")) {
                                    additionalPart.turnsWithSteer = true;
                                }
                                additionalPart.types.set(j, "ground_" + partName);
                                continue;
                            }
                            if (partName.equals("crate") || partName.equals("barrel") || partName.equals("crafting_table") || partName.equals("furnace") || partName.equals("brewing_stand")) {
                                additionalPart.types.set(i, "interactable_" + partName);
                                continue;
                            }
                            if (!partName.equals("fertilizer") && !partName.equals("harvester") && !partName.equals("planter") && !partName.equals("plow")) continue;
                            additionalPart.types.set(i, "effector_" + partName);
                        }
                    }
                }
            }
            if (vehicleDef.rendering != null) {
                PackParserSystem.doAnimationLegacyCompats(vehicleDef.rendering, new JSONVehicle());
            }
        } else if (definition instanceof JSONPoleComponent) {
            JSONPoleComponent pole = (JSONPoleComponent)definition;
            if (((JSONPoleComponent.PoleGeneral)pole.general).textLines != null) {
                ((JSONPoleComponent.PoleGeneral)pole.general).textObjects = new ArrayList<JSONText>();
                for (JSONPoleComponent.TextLine line : ((JSONPoleComponent.PoleGeneral)pole.general).textLines) {
                    JSONText object = new JSONText();
                    object.color = line.color;
                    object.scale = line.scale;
                    object.maxLength = line.characters;
                    object.pos = new Point3d(line.xPos, line.yPos, (double)line.zPos + 0.01);
                    object.rot = new Point3d(0.0, 0.0, 0.0);
                    object.fieldName = "TextLine #" + (((JSONPoleComponent.PoleGeneral)pole.general).textObjects.size() + 1);
                    ((JSONPoleComponent.PoleGeneral)pole.general).textObjects.add(object);
                }
                ((JSONPoleComponent.PoleGeneral)pole.general).textLines = null;
            }
        } else if (definition instanceof JSONDecor) {
            JSONDecor decor = (JSONDecor)definition;
            if (((JSONDecor.DecorGeneral)decor.general).textLines != null) {
                ((JSONDecor.DecorGeneral)decor.general).textObjects = new ArrayList<JSONText>();
                int lineNumber = 0;
                for (JSONDecor.TextLine line : ((JSONDecor.DecorGeneral)decor.general).textLines) {
                    JSONText object = new JSONText();
                    object.lightsUp = true;
                    object.color = line.color;
                    object.scale = line.scale;
                    if (lineNumber++ < 3) {
                        object.pos = new Point3d(line.xPos, line.yPos, (double)line.zPos + 1.0E-4);
                        object.rot = new Point3d(0.0, 0.0, 0.0);
                    } else {
                        object.pos = new Point3d(line.xPos, line.yPos, (double)line.zPos - 1.0E-4);
                        object.rot = new Point3d(0.0, 180.0, 0.0);
                    }
                    object.fieldName = "TextLine #" + (((JSONDecor.DecorGeneral)decor.general).textObjects.size() + 1);
                    ((JSONDecor.DecorGeneral)decor.general).textObjects.add(object);
                }
                ((JSONDecor.DecorGeneral)decor.general).textLines = null;
            }
        }
    }

    private static void doAnimationLegacyCompats(JSONVehicle.VehicleRendering rendering, JSONVehicle jsonInstance) {
        Object animation;
        Object object;
        if (rendering.textMarkings != null) {
            rendering.textObjects = new ArrayList<JSONText>();
            for (JSONVehicle.VehicleDisplayText marking : rendering.textMarkings) {
                object = new JSONText();
                ((JSONText)object).lightsUp = rendering.textLighted;
                ((JSONText)object).color = marking.color;
                ((JSONText)object).scale = marking.scale;
                ((JSONText)object).maxLength = rendering.displayTextMaxLength;
                ((JSONText)object).pos = marking.pos;
                ((JSONText)object).rot = marking.rot;
                ((JSONText)object).fieldName = "Text";
                ((JSONText)object).defaultText = rendering.defaultDisplayText;
                rendering.textObjects.add((JSONText)object);
            }
            rendering.textMarkings = null;
        }
        if (rendering.rotatableModelObjects != null) {
            if (rendering.animatedObjects == null) {
                rendering.animatedObjects = new ArrayList<JSONVehicle.VehicleAnimatedObject>();
            }
            for (JSONVehicle.VehicleRotatableModelObject rotatable : rendering.rotatableModelObjects) {
                object = null;
                for (JSONVehicle.VehicleAnimatedObject testObject : rendering.animatedObjects) {
                    if (!testObject.objectName.equals(rotatable.partName)) continue;
                    object = testObject;
                    break;
                }
                if (object == null) {
                    object = jsonInstance.new JSONVehicle.VehicleAnimatedObject();
                    ((JSONVehicle.VehicleAnimatedObject)object).objectName = rotatable.partName;
                    ((JSONVehicle.VehicleAnimatedObject)object).animations = new ArrayList<JSONVehicle.VehicleAnimationDefinition>();
                    rendering.animatedObjects.add((JSONVehicle.VehicleAnimatedObject)object);
                }
                animation = jsonInstance.new JSONVehicle.VehicleAnimationDefinition();
                ((JSONVehicle.VehicleAnimationDefinition)animation).animationType = "rotation";
                ((JSONVehicle.VehicleAnimationDefinition)animation).variable = rotatable.rotationVariable;
                ((JSONVehicle.VehicleAnimationDefinition)animation).centerPoint = rotatable.rotationPoint;
                ((JSONVehicle.VehicleAnimationDefinition)animation).axis = rotatable.rotationAxis;
                ((JSONVehicle.VehicleAnimationDefinition)animation).clampMin = rotatable.rotationClampMin;
                ((JSONVehicle.VehicleAnimationDefinition)animation).clampMax = rotatable.rotationClampMax;
                ((JSONVehicle.VehicleAnimationDefinition)animation).absolute = rotatable.absoluteValue;
                if (rotatable.rotationVariable.equals("steering_wheel")) {
                    ((JSONVehicle.VehicleAnimationDefinition)animation).variable = "rudder";
                    ((JSONVehicle.VehicleAnimationDefinition)animation).axis.multiply(-1.0);
                }
                if (rotatable.rotationVariable.equals("door")) {
                    ((JSONVehicle.VehicleAnimationDefinition)animation).duration = 30;
                }
                ((JSONVehicle.VehicleAnimatedObject)object).animations.add((JSONVehicle.VehicleAnimationDefinition)animation);
            }
            rendering.rotatableModelObjects = null;
        }
        if (rendering.translatableModelObjects != null) {
            if (rendering.animatedObjects == null) {
                rendering.animatedObjects = new ArrayList<JSONVehicle.VehicleAnimatedObject>();
            }
            for (JSONVehicle.VehicleTranslatableModelObject translatable : rendering.translatableModelObjects) {
                object = null;
                for (JSONVehicle.VehicleAnimatedObject testObject : rendering.animatedObjects) {
                    if (!testObject.objectName.equals(translatable.partName)) continue;
                    object = testObject;
                    break;
                }
                if (object == null) {
                    object = jsonInstance.new JSONVehicle.VehicleAnimatedObject();
                    ((JSONVehicle.VehicleAnimatedObject)object).objectName = translatable.partName;
                    ((JSONVehicle.VehicleAnimatedObject)object).animations = new ArrayList<JSONVehicle.VehicleAnimationDefinition>();
                    rendering.animatedObjects.add((JSONVehicle.VehicleAnimatedObject)object);
                }
                animation = jsonInstance.new JSONVehicle.VehicleAnimationDefinition();
                ((JSONVehicle.VehicleAnimationDefinition)animation).animationType = "translation";
                ((JSONVehicle.VehicleAnimationDefinition)animation).variable = translatable.translationVariable;
                ((JSONVehicle.VehicleAnimationDefinition)animation).axis = translatable.translationAxis;
                ((JSONVehicle.VehicleAnimationDefinition)animation).clampMin = translatable.translationClampMin;
                ((JSONVehicle.VehicleAnimationDefinition)animation).clampMax = translatable.translationClampMax;
                ((JSONVehicle.VehicleAnimationDefinition)animation).absolute = translatable.absoluteValue;
                if (translatable.translationVariable.equals("steering_wheel")) {
                    ((JSONVehicle.VehicleAnimationDefinition)animation).variable = "rudder";
                    ((JSONVehicle.VehicleAnimationDefinition)animation).axis.multiply(-1.0);
                }
                if (translatable.translationVariable.equals("door")) {
                    ((JSONVehicle.VehicleAnimationDefinition)animation).duration = 30;
                }
                ((JSONVehicle.VehicleAnimatedObject)object).animations.add((JSONVehicle.VehicleAnimationDefinition)animation);
            }
            rendering.translatableModelObjects = null;
        }
    }

    public static <PackItem extends AItemPack<JSONDefinition>, JSONDefinition extends AJSONItem<?>> PackItem getItem(String packID, String systemName) {
        return PackParserSystem.getItem(packID, systemName, "");
    }

    public static <PackItem extends AItemPack<JSONDefinition>, JSONDefinition extends AJSONItem<?>> PackItem getItem(String packID, String systemName, String subName) {
        if (packItemMap.containsKey(packID)) {
            return (PackItem)packItemMap.get(packID).get(systemName + subName);
        }
        return null;
    }

    public static boolean arePacksPresent() {
        return packItemMap.size() > 1;
    }

    public static Set<String> getAllPackIDs() {
        return packItemMap.keySet();
    }

    public static JSONPack getPackConfiguration(String packID) {
        return packMap.get(packID);
    }

    public static List<AItemPack<?>> getAllItemsForPack(String packID) {
        return new ArrayList(packItemMap.get(packID).values());
    }

    public static List<AItemPack<?>> getAllPackItems() {
        ArrayList packItems = new ArrayList();
        for (String packID : packItemMap.keySet()) {
            packItems.addAll(PackParserSystem.getAllItemsForPack(packID));
        }
        return packItems;
    }
}

