/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.systems;

import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.rendering.components.LightType;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartEngine;
import minecrafttransportsimulator.vehicles.parts.PartGroundDevice;
import minecrafttransportsimulator.vehicles.parts.PartGun;
import minecrafttransportsimulator.vehicles.parts.PartInteractable;
import minecrafttransportsimulator.vehicles.parts.PartPropeller;

public final class VehicleAnimationSystem {
    public static double clampAndScale(double value, double scaling, double offset, double clampMin, double clampMax, boolean absolute) {
        value = scaling * (absolute ? Math.abs(value) : value) + offset;
        if (clampMin != 0.0 && value < clampMin) {
            value = clampMin;
        } else if (clampMax != 0.0 && value > clampMax) {
            value = clampMax;
        }
        return value;
    }

    public static double getVariableValue(String variable, double scaling, double offset, double clampMin, double clampMax, boolean absolute, float partialTicks, EntityVehicleF_Physics vehicle, APart optionalPart) {
        double value = VehicleAnimationSystem.getVariableValue(variable, partialTicks, vehicle, optionalPart);
        return VehicleAnimationSystem.clampAndScale(value, scaling, offset, clampMin, clampMax, absolute);
    }

    public static double getVariableValue(String variable, float partialTicks, EntityVehicleF_Physics vehicle, APart optionalPart) {
        if (variable.substring(variable.length() - 1).matches("[0-9]+")) {
            Class partClass;
            int partNumber = Integer.parseInt(variable.substring(variable.length() - 1)) - 1;
            String partType = variable.substring(0, variable.indexOf(95));
            switch (partType) {
                case "interactable": {
                    partClass = PartInteractable.class;
                    break;
                }
                case "engine": {
                    partClass = PartEngine.class;
                    break;
                }
                case "gun": {
                    partClass = PartGun.class;
                    break;
                }
                case "propeller": {
                    partClass = PartPropeller.class;
                    break;
                }
                case "ground": {
                    partClass = PartGroundDevice.class;
                    break;
                }
                default: {
                    if (((Boolean)ConfigSystem.configObject.client.devMode.value).booleanValue()) {
                        throw new IllegalArgumentException("ERROR: Was told to find part: " + variable.substring(0, variable.indexOf(95)) + " for rotation definition: " + (String)variable + " but could not as the part isn't a valid part name.  Is your spelling correct?");
                    }
                    return 0.0;
                }
            }
            block180: for (JSONVehicle.VehiclePart vehiclePart : vehicle.getAllPossiblePackParts().values()) {
                for (String defPartType : vehiclePart.types) {
                    if (!defPartType.startsWith(partType)) continue;
                    if (partNumber == 0) {
                        APart foundPart = vehicle.getPartAtLocation(vehiclePart.pos);
                        if (foundPart != null && partClass.isInstance(foundPart)) {
                            return VehicleAnimationSystem.getVariableValue(variable.substring(0, variable.length() - 2), partialTicks, vehicle, foundPart);
                        }
                        return 0.0;
                    }
                    --partNumber;
                    continue block180;
                }
            }
            return 0.0;
        }
        if (optionalPart != null) {
            if (optionalPart instanceof PartEngine) {
                PartEngine engine = (PartEngine)optionalPart;
                switch (variable) {
                    case "engine_rotation": {
                        return engine.getEngineRotation(partialTicks);
                    }
                    case "engine_driveshaft_rotation": {
                        return engine.getDriveshaftRotation(partialTicks);
                    }
                    case "engine_driveshaft_sin": {
                        return Math.sin(Math.toRadians(engine.getDriveshaftRotation(partialTicks)));
                    }
                    case "engine_driveshaft_cos": {
                        return Math.cos(Math.toRadians(engine.getDriveshaftRotation(partialTicks)));
                    }
                    case "engine_rpm": {
                        return engine.definition.engine.maxRPM < 15000 ? engine.rpm : engine.rpm / 10.0;
                    }
                    case "engine_rpm_safe": {
                        return engine.definition.engine.maxRPM < 15000 ? (double)PartEngine.getSafeRPMFromMax(engine.definition.engine.maxRPM) : (double)PartEngine.getSafeRPMFromMax(engine.definition.engine.maxRPM) / 10.0;
                    }
                    case "engine_rpm_max": {
                        return engine.definition.engine.maxRPM < 15000 ? (double)engine.definition.engine.maxRPM : (double)engine.definition.engine.maxRPM / 10.0;
                    }
                    case "engine_fuel_flow": {
                        return engine.fuelFlow * 20.0 * 60.0 / 1000.0;
                    }
                    case "engine_temp": {
                        return engine.temp;
                    }
                    case "engine_pressure": {
                        return engine.pressure;
                    }
                    case "engine_gear": {
                        return engine.currentGear;
                    }
                    case "engine_gearshift": {
                        return engine.getGearshiftRotation();
                    }
                    case "engine_gearshift_hvertical": {
                        return engine.getGearshiftPosition_Vertical();
                    }
                    case "engine_gearshift_hhorizontal": {
                        return engine.getGearshiftPosition_Horizontal();
                    }
                    case "engine_magneto": {
                        return engine.state.magnetoOn ? 1.0 : 0.0;
                    }
                    case "engine_starter": {
                        return engine.state.esOn ? 1.0 : 0.0;
                    }
                    case "engine_jumper_cable": {
                        return engine.linkedEngine != null ? 1.0 : 0.0;
                    }
                    case "engine_hours": {
                        return engine.hours;
                    }
                }
            } else if (optionalPart instanceof PartGun) {
                PartGun gun = (PartGun)optionalPart;
                switch (variable) {
                    case "gun_active": {
                        return gun.active ? 1.0 : 0.0;
                    }
                    case "gun_firing": {
                        return gun.firing ? 1.0 : 0.0;
                    }
                    case "gun_pitch": {
                        return gun.prevOrientation.x + (gun.currentOrientation.x - gun.prevOrientation.x) * (double)partialTicks;
                    }
                    case "gun_yaw": {
                        return gun.prevOrientation.y + (gun.currentOrientation.y - gun.prevOrientation.y) * (double)partialTicks;
                    }
                    case "gun_cooldown": {
                        return (double)gun.cooldownTimeRemaining / (double)gun.definition.gun.fireDelay;
                    }
                    case "gun_reload": {
                        return (double)gun.reloadTimeRemaining / (double)gun.definition.gun.reloadTime;
                    }
                    case "gun_ammo_count": {
                        return gun.bulletsLeft;
                    }
                    case "gun_ammo_percent": {
                        return gun.bulletsLeft / gun.definition.gun.capacity;
                    }
                }
            } else if (optionalPart instanceof PartInteractable) {
                PartInteractable interactable = (PartInteractable)optionalPart;
                switch (variable) {
                    case "interactable_count": {
                        return interactable.getInventoryCount();
                    }
                    case "interactable_percent": {
                        return interactable.getInventoryPercent();
                    }
                    case "interactable_capacity": {
                        return interactable.getInventoryCapacity();
                    }
                }
            } else if (optionalPart instanceof PartPropeller) {
                PartPropeller propeller = (PartPropeller)optionalPart;
                switch (variable) {
                    case "propeller_pitch_deg": {
                        return Math.toDegrees(Math.atan((double)propeller.currentPitch / ((double)propeller.definition.propeller.diameter * 0.75 * Math.PI)));
                    }
                    case "propeller_pitch_in": {
                        return propeller.currentPitch;
                    }
                    case "propeller_pitch_percent": {
                        return 1.0 * (double)(propeller.currentPitch - 45) / (double)(propeller.definition.propeller.pitch - 45);
                    }
                }
            } else if (optionalPart instanceof PartGroundDevice) {
                PartGroundDevice groundDevice = (PartGroundDevice)optionalPart;
                switch (variable) {
                    case "ground_rotation": {
                        return groundDevice.getActionRotation((float)partialTicks).x;
                    }
                    case "ground_onground": {
                        return groundDevice.isOnGround() ? 1.0 : 0.0;
                    }
                    case "ground_inliquid": {
                        return groundDevice.isInLiquid() ? 1.0 : 0.0;
                    }
                    case "ground_isflat": {
                        return groundDevice.getFlatState() ? 1.0 : 0.0;
                    }
                }
            }
            if (optionalPart.parentPart != null) {
                return VehicleAnimationSystem.getVariableValue((String)variable, partialTicks, vehicle, optionalPart.parentPart);
            }
        }
        switch (variable) {
            case "yaw": {
                return vehicle.angles.y;
            }
            case "pitch": {
                return vehicle.angles.x;
            }
            case "roll": {
                return vehicle.angles.z;
            }
            case "altitude": {
                return vehicle.position.y;
            }
            case "speed": {
                return vehicle.axialVelocity * vehicle.SPEED_FACTOR * 20.0;
            }
            case "throttle": {
                return (double)vehicle.throttle / 100.0;
            }
            case "fuel": {
                return vehicle.fuelTank.getFluidLevel() / (double)vehicle.fuelTank.getMaxLevel();
            }
            case "electric_power": {
                return vehicle.electricPower;
            }
            case "electric_usage": {
                return vehicle.electricFlow * 20.0;
            }
            case "brake": {
                return vehicle.brakeOn ? 1.0 : 0.0;
            }
            case "p_brake": {
                return vehicle.parkingBrakeOn ? 1.0 : 0.0;
            }
            case "reverser": {
                return vehicle.reverseThrust ? 1.0 : 0.0;
            }
            case "horn": {
                return vehicle.hornOn ? 1.0 : 0.0;
            }
            case "siren": {
                return vehicle.sirenOn ? 1.0 : 0.0;
            }
            case "hood": {
                return vehicle.engines.isEmpty() ? 1.0 : 0.0;
            }
            case "rain": {
                return vehicle.electricFlow < 0.0 ? (1.0 - Math.cos((double)((int)vehicle.world.getRainStrength(new Point3i(vehicle.position))) * Math.toRadians(360L * System.currentTimeMillis() / 1000L))) / 2.0 : 0.0;
            }
            case "door": {
                return vehicle.parkingBrakeOn && vehicle.velocity < 0.25 ? 1.0 : 0.0;
            }
            case "trailer": {
                return vehicle.towedVehicle != null ? 1.0 : 0.0;
            }
            case "hookup": {
                return vehicle.towedByVehicle != null ? 1.0 : 0.0;
            }
            case "fueling": {
                return vehicle.beingFueled ? 1.0 : 0.0;
            }
            case "aileron": {
                return (double)vehicle.aileronAngle / 10.0;
            }
            case "elevator": {
                return (double)vehicle.elevatorAngle / 10.0;
            }
            case "rudder": {
                return (double)vehicle.rudderAngle / 10.0;
            }
            case "flaps_setpoint": {
                return (double)vehicle.flapDesiredAngle / 10.0;
            }
            case "flaps_actual": {
                return (double)vehicle.flapCurrentAngle / 10.0;
            }
            case "trim_aileron": {
                return (double)vehicle.aileronTrim / 10.0;
            }
            case "trim_elevator": {
                return (double)vehicle.elevatorTrim / 10.0;
            }
            case "trim_rudder": {
                return (double)vehicle.rudderTrim / 10.0;
            }
            case "vertical_speed": {
                return vehicle.motion.y * vehicle.SPEED_FACTOR * 20.0;
            }
            case "lift_reserve": {
                return -vehicle.trackAngle;
            }
            case "turn_coordinator": {
                return ((vehicle.angles.z - vehicle.prevAngles.z) / 10.0 + vehicle.angles.y - vehicle.prevAngles.y) / 0.15 * 25.0;
            }
            case "turn_indicator": {
                return (vehicle.angles.y - vehicle.prevAngles.y) / (double)0.15f * 25.0;
            }
            case "slip": {
                return 75.0 * vehicle.sideVector.dotProduct(vehicle.normalizedVelocityVector);
            }
            case "gear_setpoint": {
                return vehicle.gearUpCommand ? 1.0 : 0.0;
            }
            case "gear_actual": {
                return (double)vehicle.gearMovementTime / (double)vehicle.definition.motorized.gearSequenceDuration;
            }
        }
        for (LightType light : LightType.values()) {
            if (!light.name().toLowerCase().equals(variable)) continue;
            return vehicle.lightsOn.contains((Object)light) ? 1.0 : 0.0;
        }
        for (String doorName : vehicle.doorsOpen) {
            if (!variable.equals(doorName)) continue;
            return 1.0;
        }
        if (vehicle.definition.rendering.customVariables != null) {
            return vehicle.customsOn.contains((byte)vehicle.definition.rendering.customVariables.indexOf(variable)) ? 1.0 : 0.0;
        }
        return 0.0;
    }
}

