/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.main;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketEntityRiderChange;

public abstract class AEntityBase {
    private static int idCounter = 1;
    public static List<AEntityBase> createdClientEntities = new ArrayList<AEntityBase>();
    public static List<AEntityBase> createdServerEntities = new ArrayList<AEntityBase>();
    public final int lookupID;
    public final String uniqueUUID;
    public final Point3d position;
    public final Point3d prevPosition;
    public final Point3d motion;
    public final Point3d prevMotion;
    public final Point3d angles;
    public final Point3d prevAngles;
    public final Point3d rotation;
    public final Point3d prevRotation;
    public final IWrapperWorld world;
    public boolean isValid = true;
    public long ticksExisted;
    public List<BoundingBox> collisionBoxes = new ArrayList<BoundingBox>();
    public List<BoundingBox> interactionBoxes = new ArrayList<BoundingBox>();
    public Set<Point3d> ridableLocations = new HashSet<Point3d>();
    public List<Point3d> savedRiderLocations = new ArrayList<Point3d>();
    public BiMap<Point3d, IWrapperEntity> locationRiderMap = HashBiMap.create();

    public AEntityBase(IWrapperWorld world, IWrapperNBT data) {
        int n;
        if (world.isClient()) {
            n = data.getInteger("lookupID");
        } else {
            int n2 = idCounter;
            n = n2;
            idCounter = n2 + 1;
        }
        this.lookupID = n;
        this.uniqueUUID = data.getString("uniqueUUID").isEmpty() ? UUID.randomUUID().toString() : data.getString("uniqueUUID");
        this.world = world;
        this.position = data.getPoint3d("position");
        this.prevPosition = this.position.copy();
        this.motion = data.getPoint3d("motion");
        this.prevMotion = this.motion.copy();
        this.angles = data.getPoint3d("angles");
        this.prevAngles = this.angles.copy();
        this.rotation = data.getPoint3d("rotation");
        this.prevRotation = this.rotation.copy();
        for (int riderIndex = 0; riderIndex < data.getInteger("totalSavedRiderLocations"); ++riderIndex) {
            this.savedRiderLocations.add(data.getPoint3d("savedRiderLocation" + riderIndex));
        }
        if (world.isClient()) {
            createdClientEntities.add(this);
        } else {
            createdServerEntities.add(this);
        }
    }

    public void update() {
        ++this.ticksExisted;
        this.prevPosition.setTo(this.position);
        this.prevMotion.setTo(this.motion);
        this.prevAngles.setTo(this.angles);
        this.prevRotation.setTo(this.rotation);
    }

    public void updateRider(IWrapperEntity rider, Iterator<IWrapperEntity> iterator) {
        if (rider.isValid()) {
            rider.setPosition((Point3d)this.locationRiderMap.inverse().get((Object)rider));
            rider.setVelocity(this.motion);
        } else {
            this.removeRider(rider, iterator);
        }
    }

    public boolean addRider(IWrapperEntity rider, Point3d riderLocation) {
        if (riderLocation == null) {
            if (this.savedRiderLocations.isEmpty()) {
                return false;
            }
            riderLocation = this.savedRiderLocations.get(0);
        }
        for (Point3d location : this.ridableLocations) {
            if (!riderLocation.equals(location)) continue;
            riderLocation = location;
            break;
        }
        this.savedRiderLocations.remove(riderLocation);
        if (this.locationRiderMap.containsKey((Object)riderLocation)) {
            return false;
        }
        if (!this.locationRiderMap.containsValue((Object)rider)) {
            rider.setYaw(this.angles.y);
        } else {
            this.locationRiderMap.inverse().remove((Object)rider);
        }
        this.locationRiderMap.put((Object)riderLocation, (Object)rider);
        if (!this.world.isClient()) {
            rider.setRiding(this);
            MasterLoader.networkInterface.sendToAllClients(new PacketEntityRiderChange(this, rider, riderLocation));
        }
        return true;
    }

    public void removeRider(IWrapperEntity rider, Iterator<IWrapperEntity> iterator) {
        if (this.locationRiderMap.containsValue((Object)rider)) {
            if (iterator != null) {
                iterator.remove();
            } else {
                this.locationRiderMap.inverse().remove((Object)rider);
            }
            if (!this.world.isClient()) {
                rider.setRiding(null);
                MasterLoader.networkInterface.sendToAllClients(new PacketEntityRiderChange(this, rider, null));
            }
        }
    }

    public void attack(Damage damage) {
    }

    public abstract boolean isLitUp();

    public abstract void render(float var1);

    public void save(IWrapperNBT data) {
        data.setInteger("lookupID", this.lookupID);
        data.setString("uniqueUUID", this.uniqueUUID);
        data.setPoint3d("position", this.position);
        data.setPoint3d("motion", this.motion);
        data.setPoint3d("angles", this.angles);
        data.setPoint3d("rotation", this.rotation);
        int riderIndex = 0;
        for (Point3d riderLocation : this.locationRiderMap.keySet()) {
            data.setPoint3d("savedRiderLocation" + riderIndex++, riderLocation);
        }
        data.setInteger("totalSavedRiderLocations", riderIndex);
    }
}

