/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.main;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.items.instances.ItemPart;
import minecrafttransportsimulator.items.instances.ItemVehicle;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketVehiclePartChange;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.AEntityBase;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartSeat;

abstract class EntityVehicleA_Base
extends AEntityBase {
    public final JSONVehicle definition;
    public String currentSubName;
    public final List<APart> parts = new ArrayList<APart>();
    public final List<APart> partsFromNBT = new ArrayList<APart>();
    private static final Map<JSONVehicle.VehiclePart, Map<JSONVehicle.VehiclePart, JSONVehicle.VehiclePart>> SUBPACK_MAPPINGS = new HashMap<JSONVehicle.VehiclePart, Map<JSONVehicle.VehiclePart, JSONVehicle.VehiclePart>>();
    public final double SPEED_FACTOR;

    public EntityVehicleA_Base(IWrapperWorld world, IWrapperNBT data) {
        super(world, data);
        this.SPEED_FACTOR = (Double)ConfigSystem.configObject.general.speedFactor.value;
        ItemVehicle item = (ItemVehicle)PackParserSystem.getItem(data.getString("packID"), data.getString("systemName"), data.getString("subName"));
        this.definition = (JSONVehicle)item.definition;
        this.currentSubName = item.subName;
        for (int i = 0; i < data.getInteger("totalParts"); ++i) {
            try {
                IWrapperNBT partData = data.getData("part_" + i);
                ItemPart partItem = (ItemPart)PackParserSystem.getItem(partData.getString("packID"), partData.getString("systemName"), partData.getString("subName"));
                Point3d partOffset = partData.getPoint3d("offset");
                this.addPartFromItem(partItem, partData, partOffset, true);
                continue;
            }
            catch (Exception e) {
                MasterLoader.coreInterface.logError("ERROR IN LOADING PART FROM NBT!");
                e.printStackTrace();
            }
        }
    }

    @Override
    public void update() {
        Iterator<APart> iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            APart part = iterator.next();
            part.update();
            if (part.isValid) continue;
            this.removePart(part, iterator);
        }
        super.update();
    }

    public boolean addPartFromItem(ItemPart partItem, IWrapperNBT partData, Point3d offset, boolean doingConstruction) {
        JSONVehicle.VehiclePart packPart = this.getPackDefForLocation(offset);
        APart partToAdd = null;
        APart parentPart = null;
        if (this.getPartAtLocation(offset) == null && packPart.types.contains(((JSONPart.JSONPartGeneral)((JSONPart)partItem.definition).general).type) && partItem.isPartValidForPackDef(packPart)) {
            for (JSONVehicle.VehiclePart vehiclePart : this.definition.parts) {
                if (vehiclePart.additionalParts != null) {
                    for (JSONVehicle.VehiclePart vehiclePart2 : vehiclePart.additionalParts) {
                        if (!offset.equals(vehiclePart2.pos)) continue;
                        parentPart = this.getPartAtLocation(vehiclePart.pos);
                        break;
                    }
                }
                if (parentPart == null) continue;
                break;
            }
            ArrayList<APart> partsToCheck = new ArrayList<APart>();
            partsToCheck.addAll(this.parts);
            partsToCheck.addAll(this.partsFromNBT);
            for (APart part : partsToCheck) {
                if (part.definition.subParts == null) continue;
                for (JSONVehicle.VehiclePart partSubPartPack : part.definition.subParts) {
                    JSONVehicle.VehiclePart correctedPack = this.getPackForSubPart(part.vehicleDefinition, partSubPartPack);
                    if (!offset.equals(correctedPack.pos)) continue;
                    parentPart = part;
                    break;
                }
                if (parentPart == null) continue;
                break;
            }
            partToAdd = partItem.createPart((EntityVehicleF_Physics)this, packPart, partData != null ? partData : MasterLoader.coreInterface.createNewTag(), parentPart);
        }
        if (partToAdd != null) {
            if (doingConstruction) {
                this.partsFromNBT.add(partToAdd);
                if (partToAdd instanceof PartSeat) {
                    this.ridableLocations.add(partToAdd.placementOffset);
                }
            } else {
                this.addPart(partToAdd);
                boolean newPart = partData.getString("packID").isEmpty();
                if (newPart) {
                    if (partToAdd.definition.rendering != null && partToAdd.definition.rendering.textObjects != null) {
                        byte by;
                        boolean bl = false;
                        while (by < partToAdd.definition.rendering.textObjects.size()) {
                            partToAdd.textLines.set(by, partToAdd.definition.rendering.textObjects.get((int)by).defaultText);
                            by = (byte)(by + true);
                        }
                    }
                    partData = partToAdd.getData();
                }
                MasterLoader.networkInterface.sendToAllClients(new PacketVehiclePartChange((EntityVehicleF_Physics)this, offset, partItem, partData, partToAdd.parentPart));
                if (newPart && partToAdd.definition.subParts != null) {
                    ArrayList<JSONVehicle.VehiclePart> arrayList = new ArrayList<JSONVehicle.VehiclePart>();
                    for (JSONVehicle.VehiclePart vehiclePart : partToAdd.definition.subParts) {
                        arrayList.add(this.getPackForSubPart(partToAdd.vehicleDefinition, vehiclePart));
                    }
                    EntityVehicleA_Base.addDefaultParts(arrayList, this, partToAdd, true);
                }
            }
            return true;
        }
        return false;
    }

    public void addPart(APart part) {
        this.parts.add(part);
        if (part instanceof PartSeat) {
            this.ridableLocations.add(part.placementOffset);
        }
    }

    public void removePart(APart part, Iterator<APart> iterator) {
        if (this.parts.contains(part)) {
            if (iterator != null) {
                iterator.remove();
            } else {
                this.parts.remove(part);
            }
            if (this.locationRiderMap.containsKey((Object)part.placementOffset)) {
                this.removeRider((IWrapperEntity)this.locationRiderMap.get((Object)part.placementOffset), null);
            }
            part.remove();
            if (!this.world.isClient()) {
                MasterLoader.networkInterface.sendToAllClients(new PacketVehiclePartChange((EntityVehicleF_Physics)this, part.placementOffset));
            }
        }
        if (part instanceof PartSeat) {
            this.ridableLocations.remove(part.placementOffset);
        }
    }

    public APart getPartAtLocation(Point3d offset) {
        for (APart part : this.parts) {
            if (!part.placementOffset.equals(offset)) continue;
            return part;
        }
        for (APart part : this.partsFromNBT) {
            if (!part.placementOffset.equals(offset)) continue;
            return part;
        }
        return null;
    }

    public LinkedHashMap<Point3d, JSONVehicle.VehiclePart> getAllPossiblePackParts() {
        LinkedHashMap<Point3d, JSONVehicle.VehiclePart> packParts = new LinkedHashMap<Point3d, JSONVehicle.VehiclePart>();
        block0: for (JSONVehicle.VehiclePart packPart : this.definition.parts) {
            packParts.put(packPart.pos, packPart);
            if (packPart.additionalParts == null) continue;
            for (APart part : this.parts) {
                if (!part.placementOffset.equals(packPart.pos)) continue;
                for (JSONVehicle.VehiclePart additionalPart : packPart.additionalParts) {
                    packParts.put(additionalPart.pos, additionalPart);
                }
                continue block0;
            }
        }
        for (APart part : this.parts) {
            if (part.definition.subParts == null) continue;
            JSONVehicle.VehiclePart parentPack = this.getPackDefForLocation(part.placementOffset);
            for (JSONVehicle.VehiclePart extraPackPart : part.definition.subParts) {
                JSONVehicle.VehiclePart correctedPack = this.getPackForSubPart(parentPack, extraPackPart);
                packParts.put(correctedPack.pos, correctedPack);
            }
        }
        return packParts;
    }

    public JSONVehicle.VehiclePart getPackDefForLocation(Point3d offset) {
        JSONVehicle.VehiclePart correctedPack;
        JSONVehicle.VehiclePart parentPack;
        for (JSONVehicle.VehiclePart packPart : this.definition.parts) {
            if (EntityVehicleA_Base.isPackAtPosition(packPart, offset)) {
                return packPart;
            }
            if (packPart.additionalParts == null) continue;
            for (JSONVehicle.VehiclePart additionalPart : packPart.additionalParts) {
                if (!EntityVehicleA_Base.isPackAtPosition(additionalPart, offset)) continue;
                return additionalPart;
            }
        }
        for (APart part : this.parts) {
            if (part.definition.subParts == null || part.definition.subParts.size() <= 0) continue;
            parentPack = this.getPackDefForLocation(part.placementOffset);
            for (JSONVehicle.VehiclePart extraPackPart : part.definition.subParts) {
                correctedPack = this.getPackForSubPart(parentPack, extraPackPart);
                if (!EntityVehicleA_Base.isPackAtPosition(correctedPack, offset)) continue;
                return correctedPack;
            }
        }
        for (APart part : this.partsFromNBT) {
            if (part.definition.subParts == null || part.definition.subParts.size() <= 0) continue;
            parentPack = this.getPackDefForLocation(part.placementOffset);
            for (JSONVehicle.VehiclePart extraPackPart : part.definition.subParts) {
                correctedPack = this.getPackForSubPart(parentPack, extraPackPart);
                if (!EntityVehicleA_Base.isPackAtPosition(correctedPack, offset)) continue;
                return correctedPack;
            }
        }
        return null;
    }

    public static boolean isPackAtPosition(JSONVehicle.VehiclePart packPart, Point3d offset) {
        return packPart.pos.equals(offset);
    }

    public JSONVehicle.VehiclePart getPackForSubPart(JSONVehicle.VehiclePart parentPack, JSONVehicle.VehiclePart subPack) {
        JSONVehicle.VehiclePart correctedPack;
        if (!SUBPACK_MAPPINGS.containsKey(parentPack)) {
            SUBPACK_MAPPINGS.put(parentPack, new HashMap());
        }
        if ((correctedPack = SUBPACK_MAPPINGS.get(parentPack).get(subPack)) == null) {
            correctedPack = this.definition.new JSONVehicle.VehiclePart();
            correctedPack.isSubPart = true;
            correctedPack.pos = new Point3d(parentPack.pos.x + (parentPack.pos.x < 0.0 ^ parentPack.inverseMirroring ? -subPack.pos.x : subPack.pos.x), parentPack.pos.y + subPack.pos.y, parentPack.pos.z + subPack.pos.z);
            correctedPack.rot = new Point3d(0.0, 0.0, 0.0);
            if (parentPack.rot != null) {
                correctedPack.rot = parentPack.rot.copy();
                if (subPack.rot != null) {
                    correctedPack.rot.add(subPack.rot);
                }
            } else if (subPack.rot != null) {
                correctedPack.rot = subPack.rot.copy();
            }
            correctedPack.turnsWithSteer = parentPack.turnsWithSteer;
            correctedPack.isController = subPack.isController;
            correctedPack.inverseMirroring = subPack.inverseMirroring;
            correctedPack.types = subPack.types;
            correctedPack.customTypes = subPack.customTypes;
            correctedPack.minValue = subPack.minValue;
            correctedPack.maxValue = subPack.maxValue;
            correctedPack.dismountPos = subPack.dismountPos;
            correctedPack.exhaustObjects = subPack.exhaustObjects;
            correctedPack.intakeOffset = subPack.intakeOffset;
            correctedPack.additionalParts = subPack.additionalParts;
            correctedPack.treadYPoints = subPack.treadYPoints;
            correctedPack.treadZPoints = subPack.treadZPoints;
            correctedPack.treadAngles = subPack.treadAngles;
            correctedPack.defaultPart = subPack.defaultPart;
            SUBPACK_MAPPINGS.get(parentPack).put(subPack, correctedPack);
        }
        return correctedPack;
    }

    public static void addDefaultParts(List<JSONVehicle.VehiclePart> partsToAdd, EntityVehicleA_Base vehicle, APart parentPart, boolean sendPacket) {
        for (JSONVehicle.VehiclePart packDef : partsToAdd) {
            if (packDef.defaultPart == null) continue;
            try {
                String partPackID = packDef.defaultPart.substring(0, packDef.defaultPart.indexOf(58));
                String partSystemName = packDef.defaultPart.substring(packDef.defaultPart.indexOf(58) + 1);
                try {
                    ItemPart partItem = (ItemPart)PackParserSystem.getItem(partPackID, partSystemName);
                    APart newPart = partItem.createPart((EntityVehicleF_Physics)vehicle, packDef, MasterLoader.coreInterface.createNewTag(), parentPart);
                    vehicle.addPart(newPart);
                    if (newPart.definition.rendering != null && newPart.definition.rendering.textObjects != null) {
                        for (int i = 0; i < newPart.definition.rendering.textObjects.size(); i = (int)((byte)(i + 1))) {
                            newPart.textLines.set(i, newPart.definition.rendering.textObjects.get((int)i).defaultText);
                        }
                    }
                    if (sendPacket) {
                        MasterLoader.networkInterface.sendToAllClients(new PacketVehiclePartChange((EntityVehicleF_Physics)vehicle, newPart.placementOffset, newPart.getItem(), newPart.getData(), parentPart));
                    }
                    if (packDef.additionalParts != null) {
                        EntityVehicleA_Base.addDefaultParts(packDef.additionalParts, vehicle, newPart, sendPacket);
                    }
                    if (newPart.definition.subParts == null) continue;
                    ArrayList<JSONVehicle.VehiclePart> subPartsToAdd = new ArrayList<JSONVehicle.VehiclePart>();
                    for (JSONVehicle.VehiclePart subPartPack : newPart.definition.subParts) {
                        subPartsToAdd.add(vehicle.getPackForSubPart(packDef, subPartPack));
                    }
                    EntityVehicleA_Base.addDefaultParts(subPartsToAdd, vehicle, newPart, sendPacket);
                }
                catch (NullPointerException e) {
                    throw new IllegalArgumentException("ERROR: Attempted to add defaultPart: " + partPackID + ":" + partSystemName + " to: " + vehicle.definition.packID + ":" + vehicle.definition.systemName + " but that part doesn't exist in the pack item registry.");
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("ERROR: Could not parse defaultPart definition: " + packDef.defaultPart + ".  Format should be \"packId:partName\"");
            }
        }
    }

    @Override
    public void save(IWrapperNBT data) {
        super.save(data);
        data.setString("packID", this.definition.packID);
        data.setString("systemName", this.definition.systemName);
        data.setString("subName", this.currentSubName);
        int totalParts = 0;
        for (APart part : this.parts) {
            if (!part.isValid || part.isFake()) continue;
            IWrapperNBT partData = part.getData();
            partData.setString("packID", part.definition.packID);
            partData.setString("systemName", part.definition.systemName);
            partData.setString("subName", part.currentSubName);
            partData.setPoint3d("offset", part.placementOffset);
            data.setData("part_" + totalParts, partData);
            ++totalParts;
        }
        data.setInteger("totalParts", totalParts);
    }
}

