/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.main;

import java.util.Iterator;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.ControlSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleA_Base;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartGun;
import minecrafttransportsimulator.vehicles.parts.PartInteractable;
import minecrafttransportsimulator.vehicles.parts.PartSeat;

abstract class EntityVehicleB_Rideable
extends EntityVehicleA_Base {
    public static boolean lockCameraToMovement = true;

    public EntityVehicleB_Rideable(IWrapperWorld world, IWrapperNBT data) {
        super(world, data);
    }

    @Override
    public void updateRider(IWrapperEntity rider, Iterator<IWrapperEntity> iterator) {
        Point3d riderPositionOffset = (Point3d)this.locationRiderMap.inverse().get((Object)rider);
        if (rider.isValid()) {
            PartSeat seat = (PartSeat)this.getPartAtLocation(riderPositionOffset);
            Point3d seatLocationOffset = new Point3d(0.0, rider.getEyeHeight() + rider.getSeatOffset(), 0.0).rotateFine(seat.totalRotation).add(seat.totalOffset).rotateFine(this.angles).add(this.position).add(0.0, -rider.getEyeHeight(), 0.0);
            rider.setPosition(seatLocationOffset);
            rider.setVelocity(this.motion);
            boolean controllingGun = false;
            for (APart part : this.parts) {
                if (!(part instanceof PartGun) || !rider.equals(((PartGun)part).getCurrentController())) continue;
                controllingGun = true;
            }
            if (controllingGun || !this.world.isClient() || MasterLoader.gameInterface.inFirstPerson() || lockCameraToMovement) {
                double playerYawDelta = (360.0 + (this.angles.y - (double)rider.getYaw()) % 360.0) % 360.0;
                if (playerYawDelta > 180.0) {
                    playerYawDelta -= 360.0;
                }
                rider.setYaw((double)rider.getYaw() + this.angles.y - this.prevAngles.y);
                rider.setPitch((double)rider.getPitch() + Math.cos(Math.toRadians(playerYawDelta)) * (this.angles.x - this.prevAngles.x) + Math.sin(Math.toRadians(playerYawDelta)) * (this.angles.z - this.prevAngles.z));
            }
            if (this.world.isClient() && !MasterLoader.gameInterface.isChatOpen() && rider.equals(MasterLoader.gameInterface.getClientPlayer())) {
                ControlSystem.controlVehicle((EntityVehicleF_Physics)this, seat.vehicleDefinition.isController);
                MasterLoader.inputInterface.setMouseEnabled(!seat.vehicleDefinition.isController || (Boolean)ConfigSystem.configObject.client.mouseYoke.value == false || !lockCameraToMovement);
            }
        } else {
            this.removeRider(rider, iterator);
        }
    }

    @Override
    public boolean addRider(IWrapperEntity rider, Point3d riderLocation) {
        boolean riderAlreadyInSeat = this.locationRiderMap.containsValue((Object)rider);
        boolean success = super.addRider(rider, riderLocation);
        if (success && !riderAlreadyInSeat) {
            PartSeat seat = (PartSeat)this.getPartAtLocation((Point3d)this.locationRiderMap.inverse().get((Object)rider));
            rider.setYaw(this.angles.y + seat.placementRotation.y);
        }
        return success;
    }

    @Override
    public void removeRider(IWrapperEntity rider, Iterator<IWrapperEntity> iterator) {
        Point3d riderLocation = (Point3d)this.locationRiderMap.inverse().get((Object)rider);
        super.removeRider(rider, iterator);
        if (!this.world.isClient()) {
            JSONVehicle.VehiclePart packPart = this.getPackDefForLocation(riderLocation);
            Point3d dismountPosition = packPart.dismountPos != null ? packPart.dismountPos.copy().rotateCoarse(this.angles).add(this.position) : riderLocation.copy().add(riderLocation.x > 0.0 ? 2.0 : -2.0, 0.0, 0.0).rotateCoarse(this.angles).add(this.position);
            rider.setPosition(dismountPosition);
        } else {
            MasterLoader.inputInterface.setMouseEnabled(true);
            MasterLoader.guiInterface.closeGUI();
        }
    }

    public IWrapperPlayer getController() {
        for (Point3d location : this.locationRiderMap.keySet()) {
            PartSeat seat = (PartSeat)this.getPartAtLocation(location);
            IWrapperEntity rider = (IWrapperEntity)this.locationRiderMap.get((Object)location);
            if (seat == null || !seat.vehicleDefinition.isController || !(rider instanceof IWrapperPlayer)) continue;
            return (IWrapperPlayer)rider;
        }
        return null;
    }

    protected float getCurrentMass() {
        int currentMass = ((JSONVehicle.VehicleGeneral)this.definition.general).emptyMass;
        for (APart part : this.parts) {
            if (!(part instanceof PartInteractable)) continue;
            currentMass = (int)((double)currentMass + ((PartInteractable)part).getInventoryWeight());
        }
        for (IWrapperEntity rider : this.locationRiderMap.values()) {
            if (rider instanceof IWrapperPlayer) {
                currentMass = (int)((float)currentMass + (100.0f + ((IWrapperPlayer)rider).getInventory().getInventoryWeight(ConfigSystem.configObject.general.itemWeights.weights)));
                continue;
            }
            currentMass += 100;
        }
        return currentMass;
    }
}

