/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.main;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.instances.ItemPart;
import minecrafttransportsimulator.items.instances.ItemWrench;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperBlock;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleB_Rideable;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartSeat;

abstract class EntityVehicleC_Colliding
extends EntityVehicleB_Rideable {
    private float hardnessHitThisTick = 0.0f;
    public double airDensity;
    public double currentMass;
    public double velocity;
    public double axialVelocity;
    public final Point3d headingVector = new Point3d(0.0, 0.0, 0.0);
    public final Point3d verticalVector = new Point3d(0.0, 0.0, 0.0);
    public final Point3d sideVector = new Point3d(0.0, 0.0, 0.0);
    public final Point3d normalizedVelocityVector = new Point3d(0.0, 0.0, 0.0);
    public final Set<String> doorsOpen = new HashSet<String>();
    private final float PART_SLOT_HITBOX_WIDTH = 0.75f;
    private final float PART_SLOT_HITBOX_HEIGHT = 2.25f;
    public final List<BoundingBox> vehicleCollisionBoxes = new ArrayList<BoundingBox>();
    public final Map<APart, List<BoundingBox>> partCollisionBoxes = new HashMap<APart, List<BoundingBox>>();
    public final List<BoundingBox> blockCollisionBoxes = new ArrayList<BoundingBox>();
    public final List<BoundingBox> partInteractionBoxes = new ArrayList<BoundingBox>();
    public final Map<BoundingBox, JSONVehicle.VehiclePart> partSlotBoxes = new HashMap<BoundingBox, JSONVehicle.VehiclePart>();
    public final Map<BoundingBox, JSONVehicle.VehiclePart> activePartSlotBoxes = new HashMap<BoundingBox, JSONVehicle.VehiclePart>();
    public final Map<BoundingBox, JSONVehicle.VehicleDoor> doorBoxes = new HashMap<BoundingBox, JSONVehicle.VehicleDoor>();

    public EntityVehicleC_Colliding(IWrapperWorld world, IWrapperNBT data) {
        super(world, data);
        this.recalculatePartSlots();
        for (int i = 0; i < this.definition.collision.size(); ++i) {
            JSONVehicle.VehicleCollisionBox boxDefinition = this.definition.collision.get(i);
            BoundingBox newBox = new BoundingBox(boxDefinition.pos, boxDefinition.pos.copy(), (double)boxDefinition.width / 2.0, (double)boxDefinition.height / 2.0, (double)boxDefinition.width / 2.0, boxDefinition.collidesWithLiquids, boxDefinition.isInterior, true, boxDefinition.armorThickness);
            this.vehicleCollisionBoxes.add(newBox);
            this.collisionBoxes.add(newBox);
            if (newBox.isInterior || ((Boolean)ConfigSystem.configObject.general.noclipVehicles.value).booleanValue()) continue;
            this.blockCollisionBoxes.add(newBox);
        }
        if (this.definition.doors != null) {
            this.doorsOpen.clear();
            for (JSONVehicle.VehicleDoor door : this.definition.doors) {
                BoundingBox box = new BoundingBox(door.closedPos, door.closedPos.copy(), (double)door.width / 2.0, (double)door.height / 2.0, (double)door.width / 2.0, false, true, false, 0.0);
                this.doorBoxes.put(box, door);
                this.collisionBoxes.add(box);
                if (!data.getBoolean("doorsOpen_" + door.name)) continue;
                this.doorsOpen.add(door.name);
            }
        }
    }

    @Override
    public void update() {
        super.update();
        this.headingVector.set(0.0, 0.0, 1.0).rotateFine(this.angles);
        this.verticalVector.set(0.0, 1.0, 0.0).rotateFine(this.angles);
        this.sideVector.setTo(this.verticalVector.crossProduct(this.headingVector));
        this.normalizedVelocityVector.setTo(this.motion).normalize();
        this.velocity = this.motion.length();
        this.axialVelocity = Math.abs(this.motion.dotProduct(this.headingVector));
        if (this.definition != null) {
            this.currentMass = this.getCurrentMass();
            this.airDensity = 1.225 * Math.pow(2.0, -this.position.y / (500.0 * (double)this.world.getMaxHeight() / 256.0));
        }
        for (int i = 0; i < this.definition.collision.size(); ++i) {
            this.vehicleCollisionBoxes.get(i).updateToEntity(this);
        }
        for (APart aPart : this.partCollisionBoxes.keySet()) {
            for (BoundingBox boundingBox : this.partCollisionBoxes.get(aPart)) {
                boundingBox.updateToEntity(this);
            }
        }
        for (Map.Entry entry : this.doorBoxes.entrySet()) {
            if (this.doorsOpen.contains(((JSONVehicle.VehicleDoor)entry.getValue()).name)) {
                ((BoundingBox)entry.getKey()).globalCenter.setTo(((JSONVehicle.VehicleDoor)entry.getValue()).openPos).rotateFine(this.angles).add(this.position);
                continue;
            }
            ((BoundingBox)entry.getKey()).globalCenter.setTo(((JSONVehicle.VehicleDoor)entry.getValue()).closedPos).rotateFine(this.angles).add(this.position);
        }
        for (BoundingBox boundingBox : this.partSlotBoxes.keySet()) {
            boundingBox.updateToEntity(this);
        }
        this.interactionBoxes.clear();
        this.partInteractionBoxes.clear();
        if (this.world.isClient()) {
            this.activePartSlotBoxes.clear();
            IWrapperPlayer player = MasterLoader.gameInterface.getClientPlayer();
            AItemBase aItemBase = player.getHeldItem();
            if (aItemBase instanceof ItemPart) {
                for (Map.Entry entry : this.partSlotBoxes.entrySet()) {
                    ItemPart heldPart = (ItemPart)aItemBase;
                    if (!((JSONVehicle.VehiclePart)entry.getValue()).types.contains(((JSONPart.JSONPartGeneral)((JSONPart)heldPart.definition).general).type) || this.areDoorsBlocking((JSONVehicle.VehiclePart)entry.getValue(), player)) continue;
                    BoundingBox box = (BoundingBox)entry.getKey();
                    if (((JSONPart.JSONPartGeneral)((JSONPart)heldPart.definition).general).type.equals("custom")) {
                        box.widthRadius = (double)((JSONPart)heldPart.definition).custom.width / 2.0;
                        box.heightRadius = (double)((JSONPart)heldPart.definition).custom.height / 2.0;
                        box.depthRadius = (double)((JSONPart)heldPart.definition).custom.width / 2.0;
                    } else {
                        box.widthRadius = 0.375;
                        box.heightRadius = 1.125;
                        box.depthRadius = 0.375;
                    }
                    this.activePartSlotBoxes.put((BoundingBox)entry.getKey(), (JSONVehicle.VehiclePart)entry.getValue());
                }
            }
        }
        this.interactionBoxes.addAll(this.activePartSlotBoxes.keySet());
        for (APart aPart : this.parts) {
            if (this.world.isClient()) {
                IWrapperPlayer clientPlayer = MasterLoader.gameInterface.getClientPlayer();
                if (aPart.isFake() || aPart instanceof PartSeat && aPart.placementOffset.equals(this.locationRiderMap.inverse().get((Object)clientPlayer)) || clientPlayer.getHeldItem() instanceof ItemWrench && !aPart.childParts.isEmpty() || this.areDoorsBlocking(aPart.vehicleDefinition, clientPlayer)) continue;
            }
            this.interactionBoxes.add(aPart.boundingBox);
            this.partInteractionBoxes.add(aPart.boundingBox);
        }
        this.interactionBoxes.addAll(this.collisionBoxes);
        this.hardnessHitThisTick = 0.0f;
    }

    @Override
    public void attack(Damage damage) {
        APart part = this.getPartAtLocation(damage.box.localCenter);
        if (part != null) {
            part.attack(damage);
        }
    }

    @Override
    public void addPart(APart part) {
        super.addPart(part);
        if (part.definition.collision != null && part.definition.collision.size() > 0) {
            this.partCollisionBoxes.put(part, new ArrayList());
            for (JSONVehicle.VehicleCollisionBox boxDefinition : part.definition.collision) {
                BoundingBox newBox = new BoundingBox(boxDefinition.pos, boxDefinition.pos.copy().add(part.totalOffset).add(this.position), boxDefinition.width, boxDefinition.height, boxDefinition.width, boxDefinition.collidesWithLiquids, boxDefinition.isInterior, true, boxDefinition.armorThickness);
                this.partCollisionBoxes.get(part).add(newBox);
                this.collisionBoxes.add(newBox);
                if (newBox.isInterior) continue;
                this.blockCollisionBoxes.add(newBox);
            }
        }
        this.recalculatePartSlots();
    }

    @Override
    public void removePart(APart part, Iterator<APart> iterator) {
        super.removePart(part, iterator);
        if (this.partCollisionBoxes.containsKey(part)) {
            for (BoundingBox box : this.partCollisionBoxes.get(part)) {
                this.collisionBoxes.remove(box);
                this.blockCollisionBoxes.remove(box);
            }
            this.partCollisionBoxes.remove(part);
        }
        this.recalculatePartSlots();
    }

    private void recalculatePartSlots() {
        this.partSlotBoxes.clear();
        for (Map.Entry<Point3d, JSONVehicle.VehiclePart> packPartEntry : this.getAllPossiblePackParts().entrySet()) {
            if (this.getPartAtLocation(packPartEntry.getKey()) != null) continue;
            BoundingBox newSlotBox = new BoundingBox(packPartEntry.getKey(), packPartEntry.getKey().copy().rotateCoarse(this.angles).add(this.position), 0.0, 0.0, 0.0, false, false, false, 0.0);
            this.partSlotBoxes.put(newSlotBox, packPartEntry.getValue());
            if (this.world.isClient()) continue;
            this.activePartSlotBoxes.put(newSlotBox, packPartEntry.getValue());
        }
    }

    public boolean areDoorsBlocking(JSONVehicle.VehiclePart partDef, IWrapperPlayer player) {
        if (partDef.linkedDoors != null && !this.equals(player.getEntityRiding())) {
            for (String door : partDef.linkedDoors) {
                if (!this.doorsOpen.contains(door)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    protected double getCollisionForAxis(BoundingBox box, boolean xAxis, boolean yAxis, boolean zAxis) {
        Point3d collisionMotion = this.motion.copy().multiply(this.SPEED_FACTOR);
        if (box.updateCollidingBlocks(this.world, collisionMotion)) {
            for (IWrapperBlock block : box.collidingBlocks) {
                if (block.isLiquid() || !((double)block.getHardness() <= this.velocity * this.currentMass / 250.0) || !(block.getHardness() >= 0.0f)) continue;
                if (((Boolean)ConfigSystem.configObject.general.blockBreakage.value).booleanValue()) {
                    this.hardnessHitThisTick += block.getHardness();
                    this.motion.multiply(Math.max(1.0 - (double)(block.getHardness() * 0.5f) / ((1000.0 + this.currentMass) / 1000.0), 0.0));
                    if (this.world.isClient()) continue;
                    if (this.ticksExisted > 500L) {
                        this.world.destroyBlock(block.getPosition());
                        continue;
                    }
                    this.motion.set(0.0, 0.0, 0.0);
                    return -1.0;
                }
                this.hardnessHitThisTick = 0.0f;
                this.motion.set(0.0, 0.0, 0.0);
            }
            if ((double)this.hardnessHitThisTick > this.currentMass / (0.75 + this.velocity) / 250.0) {
                if (!this.world.isClient()) {
                    this.destroyAtPosition(box.globalCenter);
                }
                return -1.0;
            }
            if (xAxis) {
                return box.currentCollisionDepth.x;
            }
            if (yAxis) {
                return box.currentCollisionDepth.y;
            }
            if (zAxis) {
                return box.currentCollisionDepth.z;
            }
            throw new IllegalArgumentException("ERROR: Collision requested but no axis was specified!");
        }
        return 0.0;
    }

    public void destroyAtPosition(Point3d position) {
        this.isValid = false;
        for (APart part : this.parts) {
            if (part.getItem() == null) continue;
            this.world.spawnItem(part.getItem(), part.getData(), part.worldPos);
        }
        for (IWrapperItemStack craftingStack : MasterLoader.coreInterface.parseFromJSON((AItemPack<?>)PackParserSystem.getItem(this.definition.packID, this.definition.systemName, this.currentSubName), true, true)) {
            if (!(Math.random() < (Double)ConfigSystem.configObject.damage.crashItemDropPercentage.value)) continue;
            this.world.spawnItemStack(craftingStack, position);
        }
        IWrapperPlayer controller = this.getController();
        Damage controllerCrashDamage = new Damage("crash", (Double)ConfigSystem.configObject.damage.crashDamageFactor.value * this.velocity * 20.0, null, null);
        Damage passengerCrashDamage = new Damage("crash", (Double)ConfigSystem.configObject.damage.crashDamageFactor.value * this.velocity * 20.0, null, controller);
        for (IWrapperEntity rider : this.locationRiderMap.values()) {
            if (rider.equals(controller)) {
                rider.attack(controllerCrashDamage);
                continue;
            }
            rider.attack(passengerCrashDamage);
        }
        Iterator<IWrapperEntity> riderIterator = this.locationRiderMap.inverse().keySet().iterator();
        while (riderIterator.hasNext()) {
            this.removeRider((IWrapperEntity)riderIterator.next(), riderIterator);
        }
    }

    @Override
    public void save(IWrapperNBT data) {
        super.save(data);
        for (String doorName : this.doorsOpen) {
            data.setBoolean("doorsOpen_" + doorName, true);
        }
    }
}

