/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.main;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.baseclasses.VehicleGroundDeviceCollection;
import minecrafttransportsimulator.mcinterface.IWrapperBlock;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketVehicleServerMovement;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleC_Colliding;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartGroundDevice;
import minecrafttransportsimulator.vehicles.parts.PartPropeller;

abstract class EntityVehicleD_Moving
extends EntityVehicleC_Colliding {
    public boolean brakeOn;
    public boolean parkingBrakeOn;
    public boolean locked;
    public String ownerUUID = "";
    public boolean goingInReverse;
    public double groundVelocity;
    public EntityVehicleF_Physics towedVehicle;
    public EntityVehicleF_Physics towedByVehicle;
    private final Point3d serverDeltaM;
    private final Point3d serverDeltaR;
    private final Point3d clientDeltaM;
    private final Point3d clientDeltaR;
    private final Point3d clientDeltaMApplied = new Point3d(0.0, 0.0, 0.0);
    private final Point3d clientDeltaRApplied = new Point3d(0.0, 0.0, 0.0);
    private final Point3d motionApplied = new Point3d(0.0, 0.0, 0.0);
    private final Point3d rotationApplied = new Point3d(0.0, 0.0, 0.0);
    private final Point3d tempBoxPosition = new Point3d(0.0, 0.0, 0.0);
    private final Point3d tempBoxAngles = new Point3d(0.0, 0.0, 0.0);
    private final Point3d normalizedGroundVelocityVector = new Point3d(0.0, 0.0, 0.0);
    private final Point3d normalizedGroundHeadingVector = new Point3d(0.0, 0.0, 0.0);
    private final VehicleGroundDeviceCollection groundDeviceBoxes;
    protected final List<PartGroundDevice> groundedGroundDevices = new ArrayList<PartGroundDevice>();

    public EntityVehicleD_Moving(IWrapperWorld world, IWrapperNBT data) {
        super(world, data);
        this.locked = data.getBoolean("locked");
        this.parkingBrakeOn = data.getBoolean("parkingBrakeOn");
        this.brakeOn = data.getBoolean("brakeOn");
        this.ownerUUID = data.getString("ownerUUID");
        this.serverDeltaM = data.getPoint3d("serverDeltaM");
        this.serverDeltaR = data.getPoint3d("serverDeltaR");
        this.clientDeltaM = this.serverDeltaM.copy();
        this.clientDeltaR = this.serverDeltaR.copy();
        this.groundDeviceBoxes = new VehicleGroundDeviceCollection((EntityVehicleF_Physics)this);
    }

    @Override
    public void update() {
        super.update();
        this.groundedGroundDevices.clear();
        for (APart part : this.parts) {
            if (!(part instanceof PartGroundDevice) || !((PartGroundDevice)part).isOnGround()) continue;
            this.groundedGroundDevices.add((PartGroundDevice)part);
        }
        for (APart part : this.parts) {
            if (!(part instanceof PartGroundDevice) || part.placementOffset.equals(part.totalOffset)) continue;
            this.groundDeviceBoxes.updateBounds();
            break;
        }
        if (!((Boolean)ConfigSystem.configObject.general.noclipVehicles.value).booleanValue() || this.groundDeviceBoxes.isReady()) {
            this.getForcesAndMotions();
            this.performGroundOperations();
            this.moveVehicle();
            if (!this.world.isClient()) {
                this.dampenControlSurfaces();
            }
        }
    }

    @Override
    public void addPart(APart part) {
        super.addPart(part);
        this.groundDeviceBoxes.updateMembers();
        this.groundDeviceBoxes.updateBounds();
    }

    @Override
    public void removePart(APart part, Iterator<APart> iterator) {
        super.removePart(part, iterator);
        this.groundDeviceBoxes.updateMembers();
        this.groundDeviceBoxes.updateBounds();
    }

    private void performGroundOperations() {
        float skiddingFactor;
        float brakingFactor = this.getBrakingForce();
        if (brakingFactor > 0.0f) {
            double brakingForce = (double)(20.0f * brakingFactor) / this.currentMass;
            if (brakingForce > this.velocity) {
                this.motion.x = 0.0;
                this.motion.z = 0.0;
                this.rotation.y = 0.0;
            } else {
                this.motion.x -= brakingForce * this.motion.x / this.velocity;
                this.motion.z -= brakingForce * this.motion.z / this.velocity;
            }
        }
        this.normalizedGroundVelocityVector.set(this.motion.x, 0.0, this.motion.z);
        this.groundVelocity = this.normalizedGroundVelocityVector.length();
        this.normalizedGroundVelocityVector.normalize();
        this.normalizedGroundHeadingVector.set(this.headingVector.x, 0.0, this.headingVector.z).normalize();
        double turningForce = this.getTurningForce();
        double dotProduct = this.normalizedGroundVelocityVector.dotProduct(this.normalizedGroundHeadingVector);
        if (!this.goingInReverse && dotProduct < -0.75 && turningForce == 0.0) {
            this.goingInReverse = true;
        } else if (this.goingInReverse && dotProduct > 0.75 && turningForce == 0.0) {
            this.goingInReverse = false;
        }
        if (turningForce != 0.0) {
            this.rotation.y = this.rotation.y + (this.goingInReverse ? -turningForce : turningForce);
        }
        if ((skiddingFactor = this.getSkiddingForce()) != 0.0f && this.groundVelocity > 0.01) {
            Point3d crossProduct = this.normalizedGroundVelocityVector.crossProduct(this.normalizedGroundHeadingVector);
            double vectorDelta = Math.toDegrees(Math.atan2(crossProduct.y, dotProduct));
            if (this.goingInReverse && dotProduct < 0.0) {
                if (vectorDelta >= 90.0) {
                    vectorDelta = -(180.0 - vectorDelta);
                } else if (vectorDelta <= -90.0) {
                    vectorDelta = 180.0 + vectorDelta;
                }
            }
            if (Math.abs(vectorDelta) > 0.001) {
                double motionFactor = vectorDelta > (double)skiddingFactor ? (double)skiddingFactor / vectorDelta : (vectorDelta < (double)(-skiddingFactor) ? (double)(-skiddingFactor) / vectorDelta : 1.0);
                Point3d idealMotion = this.goingInReverse ? this.normalizedGroundHeadingVector.copy().multiply(-this.groundVelocity) : this.normalizedGroundHeadingVector.copy().multiply(this.groundVelocity);
                idealMotion.multiply(motionFactor).add(this.motion.x * (1.0 - motionFactor), 0.0, this.motion.z * (1.0 - motionFactor));
                this.motion.x = idealMotion.x;
                this.motion.z = idealMotion.z;
            }
        }
    }

    private float getBrakingForce() {
        float brakingFactor = 0.0f;
        for (PartGroundDevice groundDevice : this.groundedGroundDevices) {
            float addedFactor = 0.0f;
            if (this.brakeOn || this.parkingBrakeOn) {
                addedFactor = groundDevice.getMotiveFriction();
            }
            if (addedFactor == 0.0f) continue;
            brakingFactor += Math.max(addedFactor - groundDevice.getFrictionLoss(), 0.0f);
        }
        if (this.brakeOn || this.parkingBrakeOn) {
            brakingFactor = (float)((double)brakingFactor + 0.5 * (double)this.groundDeviceBoxes.getBoxesInLiquid());
        }
        for (BoundingBox box : this.blockCollisionBoxes) {
            Point3i groundPosition;
            IWrapperBlock groundBlock;
            if (box.collidingBlocks.isEmpty() || (groundBlock = this.world.getWrapperBlock(groundPosition = new Point3i(box.globalCenter))) == null) continue;
            float frictionLoss = 0.6f - groundBlock.getSlipperiness() + (groundBlock.isRaining() ? 0.25f : 0.0f);
            brakingFactor = (float)((double)brakingFactor + Math.max(2.0 - (double)frictionLoss, 0.0));
        }
        return brakingFactor;
    }

    private float getSkiddingForce() {
        float skiddingFactor = 0.0f;
        for (PartGroundDevice groundDevice : this.groundedGroundDevices) {
            skiddingFactor += groundDevice.getLateralFriction() - groundDevice.getFrictionLoss();
        }
        return (skiddingFactor = (float)((double)skiddingFactor + 0.5 * (double)this.groundDeviceBoxes.getBoxesInLiquid())) > 0.0f ? skiddingFactor : 0.0f;
    }

    private double getTurningForce() {
        float steeringAngle = this.getSteeringAngle();
        if (steeringAngle != 0.0f) {
            double turningDistance = 0.0;
            for (PartGroundDevice groundDevice : this.groundedGroundDevices) {
                if (!groundDevice.vehicleDefinition.turnsWithSteer) continue;
                turningDistance = Math.max(turningDistance, Math.abs(groundDevice.placementOffset.z));
            }
            if (turningDistance == 0.0) {
                for (APart part : this.parts) {
                    if (!(part instanceof PartPropeller) || !part.isInLiquid()) continue;
                    turningDistance = Math.max(turningDistance, Math.abs(part.placementOffset.z));
                    break;
                }
            }
            if (turningDistance > 0.0) {
                double turningForce = (double)steeringAngle / turningDistance;
                if (this.groundVelocity > 0.35) {
                    turningForce *= Math.pow(0.25, this.groundVelocity - 0.35);
                }
                return turningForce * this.groundVelocity * (this.SPEED_FACTOR / 0.35) / 2.0;
            }
        }
        return 0.0;
    }

    private void moveVehicle() {
        this.groundDeviceBoxes.updateCollisions();
        double groundCollisionBoost = this.groundDeviceBoxes.getMaxCollisionDepth() / this.SPEED_FACTOR;
        if (groundCollisionBoost > 0.0) {
            if (this.motion.y + groundCollisionBoost > 0.0) {
                groundCollisionBoost = Math.min(groundCollisionBoost, 0.125 / this.SPEED_FACTOR);
                this.motion.y += groundCollisionBoost;
                groundCollisionBoost = this.motion.y;
            } else {
                this.motion.y += groundCollisionBoost;
                groundCollisionBoost = 0.0;
            }
            this.groundDeviceBoxes.updateCollisions();
        }
        boolean collisionBoxCollided = false;
        if (this.towedByVehicle == null) {
            this.tempBoxAngles.setTo(this.rotation).add(this.angles);
            for (BoundingBox box : this.blockCollisionBoxes) {
                this.tempBoxPosition.setTo(box.localCenter).rotateCoarse(this.tempBoxAngles).add(this.position).add(this.motion.x * this.SPEED_FACTOR, this.motion.y * this.SPEED_FACTOR, this.motion.z * this.SPEED_FACTOR);
                if (!box.updateCollidingBlocks(this.world, this.tempBoxPosition.subtract(box.globalCenter))) continue;
                collisionBoxCollided = true;
                break;
            }
        }
        double groundRotationBoost = 0.0;
        if (collisionBoxCollided) {
            this.correctCollidingMovement();
        } else {
            groundRotationBoost = this.groundDeviceBoxes.performPitchCorrection(groundCollisionBoost);
            groundRotationBoost = this.groundDeviceBoxes.performRollCorrection(groundCollisionBoost + groundRotationBoost);
        }
        this.motionApplied.setTo(this.motion).multiply(this.SPEED_FACTOR);
        this.rotationApplied.setTo(this.rotation);
        if (!this.world.isClient()) {
            if (!this.motionApplied.isZero() || !this.rotationApplied.isZero()) {
                this.addToServerDeltas(this.motionApplied, this.rotationApplied);
                MasterLoader.networkInterface.sendToAllClients(new PacketVehicleServerMovement((EntityVehicleF_Physics)this, this.motionApplied, this.rotationApplied));
            }
        } else if (!this.serverDeltaM.isZero() || !this.serverDeltaR.isZero()) {
            this.clientDeltaMApplied.setTo(this.serverDeltaM).subtract(this.clientDeltaM);
            this.clientDeltaMApplied.x *= Math.abs(this.clientDeltaMApplied.x);
            this.clientDeltaMApplied.y *= Math.abs(this.clientDeltaMApplied.y);
            this.clientDeltaMApplied.z *= Math.abs(this.clientDeltaMApplied.z);
            this.clientDeltaMApplied.multiply(0.04);
            this.motionApplied.add(this.clientDeltaMApplied);
            this.clientDeltaRApplied.setTo(this.serverDeltaR).subtract(this.clientDeltaR);
            this.clientDeltaRApplied.x *= Math.abs(this.clientDeltaRApplied.x);
            this.clientDeltaRApplied.y *= Math.abs(this.clientDeltaRApplied.y);
            this.clientDeltaRApplied.z *= Math.abs(this.clientDeltaRApplied.z);
            this.clientDeltaRApplied.multiply(0.04);
            this.rotationApplied.add(this.clientDeltaRApplied);
            this.clientDeltaM.add(this.motionApplied);
            this.clientDeltaR.add(this.rotationApplied);
        }
        if (!this.motionApplied.isZero() || !this.rotationApplied.isZero()) {
            this.world.moveEntities(this.collisionBoxes, this.position, this.angles, this.motionApplied, this.rotationApplied);
        }
        this.position.add(this.motionApplied);
        this.angles.add(this.rotationApplied);
        this.motion.y -= groundCollisionBoost + groundRotationBoost;
    }

    private void correctCollidingMovement() {
        double collisionDepth;
        if (this.motion.x != 0.0) {
            for (BoundingBox box : this.blockCollisionBoxes) {
                collisionDepth = this.getCollisionForAxis(box, true, false, false);
                if (collisionDepth == -1.0) {
                    return;
                }
                if (this.motion.x > 0.0) {
                    this.motion.x = Math.max(this.motion.x - collisionDepth / this.SPEED_FACTOR, 0.0);
                    continue;
                }
                if (!(this.motion.x < 0.0)) continue;
                this.motion.x = Math.min(this.motion.x + collisionDepth / this.SPEED_FACTOR, 0.0);
            }
        }
        if (this.motion.z != 0.0) {
            for (BoundingBox box : this.blockCollisionBoxes) {
                collisionDepth = this.getCollisionForAxis(box, false, false, true);
                if (collisionDepth == -1.0) {
                    return;
                }
                if (this.motion.z > 0.0) {
                    this.motion.z = Math.max(this.motion.z - collisionDepth / this.SPEED_FACTOR, 0.0);
                    continue;
                }
                if (!(this.motion.z < 0.0)) continue;
                this.motion.z = Math.min(this.motion.z + collisionDepth / this.SPEED_FACTOR, 0.0);
            }
        }
        if (this.motion.y != 0.0) {
            for (BoundingBox box : this.blockCollisionBoxes) {
                collisionDepth = this.getCollisionForAxis(box, false, true, false);
                if (collisionDepth == -1.0) {
                    return;
                }
                if (collisionDepth == 0.0) continue;
                if (this.motion.y > 0.0) {
                    this.motion.y = Math.max(this.motion.y - collisionDepth / this.SPEED_FACTOR, 0.0);
                    continue;
                }
                if (!(this.motion.y < 0.0)) continue;
                this.motion.y = Math.min(this.motion.y + collisionDepth / this.SPEED_FACTOR, 0.0);
            }
        }
        if (this.rotation.y != 0.0) {
            this.tempBoxAngles.set(0.0, this.rotation.y, 0.0).add(this.angles);
            block3: for (BoundingBox box : this.blockCollisionBoxes) {
                while (this.rotation.y != 0.0) {
                    this.tempBoxPosition.setTo(box.localCenter).rotateCoarse(this.tempBoxAngles).add(this.position).add(this.motion.x * this.SPEED_FACTOR, this.motion.y * this.SPEED_FACTOR, this.motion.z * this.SPEED_FACTOR);
                    this.tempBoxPosition.add(0.0, 0.1, 0.0);
                    if (!box.updateCollidingBlocks(this.world, this.tempBoxPosition.subtract(box.globalCenter))) continue block3;
                    if (this.rotation.y > 0.0) {
                        this.rotation.y = Math.max(this.rotation.y - (double)0.1f, 0.0);
                        continue;
                    }
                    this.rotation.y = Math.min(this.rotation.y + (double)0.1f, 0.0);
                }
            }
        }
        if (this.rotation.x != 0.0) {
            this.tempBoxAngles.set(this.rotation.x, this.rotation.y, 0.0).add(this.angles);
            block5: for (BoundingBox box : this.blockCollisionBoxes) {
                while (this.rotation.x != 0.0) {
                    this.tempBoxPosition.setTo(box.localCenter).rotateCoarse(this.tempBoxAngles).add(this.position).add(this.motion.x * this.SPEED_FACTOR, this.motion.y * this.SPEED_FACTOR, this.motion.z * this.SPEED_FACTOR);
                    if (!box.updateCollidingBlocks(this.world, this.tempBoxPosition.subtract(box.globalCenter))) continue block5;
                    if (this.rotation.x > 0.0) {
                        this.rotation.x = Math.max(this.rotation.x - (double)0.1f, 0.0);
                        continue;
                    }
                    this.rotation.x = Math.min(this.rotation.x + (double)0.1f, 0.0);
                }
            }
        }
        if (this.rotation.z != 0.0) {
            this.tempBoxAngles.setTo(this.rotation).add(this.angles);
            block7: for (BoundingBox box : this.blockCollisionBoxes) {
                while (this.rotation.z != 0.0) {
                    this.tempBoxPosition.setTo(box.localCenter).rotateCoarse(this.tempBoxAngles).add(this.position).add(this.motion.x * this.SPEED_FACTOR, this.motion.y * this.SPEED_FACTOR, this.motion.z * this.SPEED_FACTOR);
                    if (!box.updateCollidingBlocks(this.world, this.tempBoxPosition.subtract(box.globalCenter))) continue block7;
                    if (this.rotation.z > 0.0) {
                        this.rotation.z = Math.max(this.rotation.z - (double)0.1f, 0.0);
                        continue;
                    }
                    this.rotation.z = Math.min(this.rotation.z + (double)0.1f, 0.0);
                }
            }
        }
    }

    public void addToServerDeltas(Point3d motion, Point3d rotation) {
        this.serverDeltaM.add(motion);
        this.serverDeltaR.add(rotation);
    }

    protected abstract float getSteeringAngle();

    protected abstract void getForcesAndMotions();

    protected abstract void dampenControlSurfaces();

    @Override
    public void save(IWrapperNBT data) {
        super.save(data);
        data.setBoolean("locked", this.locked);
        data.setBoolean("brakeOn", this.brakeOn);
        data.setBoolean("parkingBrakeOn", this.parkingBrakeOn);
        data.setString("ownerUUID", this.ownerUUID);
        data.setPoint3d("serverDeltaM", this.serverDeltaM);
        data.setPoint3d("serverDeltaR", this.serverDeltaR);
    }
}

