/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.main;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.FluidTank;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.items.instances.ItemInstrument;
import minecrafttransportsimulator.items.instances.ItemPart;
import minecrafttransportsimulator.jsondefs.JSONInstrument;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketVehicleControlDigital;
import minecrafttransportsimulator.packets.instances.PacketVehiclePartEngine;
import minecrafttransportsimulator.rendering.components.LightType;
import minecrafttransportsimulator.sound.IRadioProvider;
import minecrafttransportsimulator.sound.Radio;
import minecrafttransportsimulator.sound.SoundInstance;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleD_Moving;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartEngine;
import minecrafttransportsimulator.vehicles.parts.PartGroundDevice;
import minecrafttransportsimulator.vehicles.parts.PartGun;
import minecrafttransportsimulator.vehicles.parts.PartInteractable;

abstract class EntityVehicleE_Powered
extends EntityVehicleD_Moving
implements IRadioProvider {
    public boolean hornOn;
    public boolean sirenOn;
    public boolean reverseThrust;
    public boolean gearUpCommand;
    public boolean beingFueled;
    public byte throttle;
    public int gearMovementTime;
    public double electricPower;
    public double electricUsage;
    public double electricFlow;
    public FluidTank fuelTank;
    public final Set<LightType> lightsOn = new HashSet<LightType>();
    public final Set<Byte> customsOn = new HashSet<Byte>();
    public final List<String> textLines = new ArrayList<String>();
    public final Map<Byte, ItemInstrument> instruments = new HashMap<Byte, ItemInstrument>();
    public final Map<Byte, PartEngine> engines = new HashMap<Byte, PartEngine>();
    public final List<PartGroundDevice> wheels = new ArrayList<PartGroundDevice>();
    public final HashMap<ItemPart, List<PartGun>> guns = new LinkedHashMap<ItemPart, List<PartGun>>();
    private final Radio radio;
    private final FloatBuffer soundPosition = ByteBuffer.allocateDirect(12).order(ByteOrder.nativeOrder()).asFloatBuffer();

    public EntityVehicleE_Powered(IWrapperWorld world, IWrapperNBT data) {
        super(world, data);
        this.hornOn = data.getBoolean("hornOn");
        this.sirenOn = data.getBoolean("sirenOn");
        this.reverseThrust = data.getBoolean("reverseThrust");
        this.gearUpCommand = data.getBoolean("gearUpCommand");
        this.throttle = (byte)data.getInteger("throttle");
        this.electricPower = data.getDouble("electricPower");
        this.fuelTank = new FluidTank(data, this.definition.motorized.fuelCapacity, world.isClient());
        this.lightsOn.clear();
        String lightsOnString = data.getString("lightsOn");
        while (!lightsOnString.isEmpty()) {
            String lightName = lightsOnString.substring(0, lightsOnString.indexOf(44));
            for (LightType light : LightType.values()) {
                if (!light.name().equals(lightName)) continue;
                this.lightsOn.add(light);
                break;
            }
            lightsOnString = lightsOnString.substring(lightsOnString.indexOf(44) + 1);
        }
        if (this.definition.rendering.customVariables != null) {
            this.customsOn.clear();
            String customsOnString = data.getString("customsOn");
            while (!customsOnString.isEmpty()) {
                byte customIndex = Byte.valueOf(customsOnString.substring(0, customsOnString.indexOf(44)));
                this.customsOn.add(customIndex);
                customsOnString = customsOnString.substring(customsOnString.indexOf(44) + 1);
            }
        }
        if (this.definition.rendering.textObjects != null) {
            for (int i = 0; i < this.definition.rendering.textObjects.size(); i = (int)((byte)(i + 1))) {
                this.textLines.add(data.getString("textLine" + i));
            }
        }
        for (byte i = 0; i < this.definition.motorized.instruments.size(); i = (byte)((byte)(i + 1))) {
            ItemInstrument instrument;
            String instrumentPackID = data.getString("instrument" + i + "_packID");
            String instrumentSystemName = data.getString("instrument" + i + "_systemName");
            if (instrumentPackID.isEmpty() || (instrument = (ItemInstrument)PackParserSystem.getItem(instrumentPackID, instrumentSystemName)) == null) continue;
            this.instruments.put(i, instrument);
        }
        this.radio = new Radio(this, data);
    }

    @Override
    public void update() {
        super.update();
        if (this.ticksExisted == 1L && this.world.isClient()) {
            this.startSounds();
            for (APart part : this.parts) {
                part.startSounds();
            }
        }
        if (!this.world.isClient() && this.fuelTank.getFluidLevel() < (double)(this.definition.motorized.fuelCapacity - 100)) {
            for (APart part : this.parts) {
                double amountFilled;
                FluidTank tank;
                if (!(part instanceof PartInteractable) || !part.definition.interactable.feedsVehicles || (tank = ((PartInteractable)part).tank) == null || !((amountFilled = tank.drain(this.fuelTank.getFluid(), 1.0, true)) > 0.0)) continue;
                this.fuelTank.fill(this.fuelTank.getFluid(), amountFilled, true);
            }
        }
        if (this.definition.motorized.isTrailer) {
            if (this.towedByVehicle != null && !this.towedByVehicle.isValid) {
                this.towedByVehicle = null;
            } else if (this.towedByVehicle != null) {
                this.lightsOn.clear();
                this.lightsOn.addAll(this.towedByVehicle.lightsOn);
                this.parkingBrakeOn = false;
                this.brakeOn = this.towedByVehicle.brakeOn;
            } else {
                this.parkingBrakeOn = true;
            }
        } else {
            this.lightsOn.remove((Object)LightType.DAYTIMERUNNINGLIGHT);
            for (PartEngine engine : this.engines.values()) {
                if (!engine.state.running) continue;
                this.lightsOn.add(LightType.DAYTIMERUNNINGLIGHT);
                break;
            }
        }
        if (this.electricPower > 2.0) {
            for (LightType light : this.lightsOn) {
                if (!light.hasBeam) continue;
                this.electricUsage += (double)5.0E-4f;
            }
        }
        this.electricPower = Math.max(0.0, Math.min(13.0, this.electricPower -= this.electricUsage));
        this.electricFlow = this.electricUsage;
        this.electricUsage = 0.0;
        if (this.gearUpCommand && this.gearMovementTime < this.definition.motorized.gearSequenceDuration) {
            ++this.gearMovementTime;
        } else if (!this.gearUpCommand && this.gearMovementTime > 0) {
            --this.gearMovementTime;
        }
        this.soundPosition.rewind();
        this.soundPosition.put((float)this.position.x);
        this.soundPosition.put((float)this.position.y);
        this.soundPosition.put((float)this.position.z);
        this.soundPosition.flip();
    }

    @Override
    public boolean addRider(IWrapperEntity rider, Point3d riderLocation) {
        if (super.addRider(rider, riderLocation)) {
            if (this.world.isClient() && ((Boolean)ConfigSystem.configObject.client.autostartEng.value).booleanValue() && rider instanceof IWrapperPlayer && this.locationRiderMap.containsValue((Object)rider) && this.getPartAtLocation((Point3d)((Point3d)this.locationRiderMap.inverse().get((Object)rider))).vehicleDefinition.isController) {
                for (PartEngine engine : this.engines.values()) {
                    if (engine.state.running) continue;
                    MasterLoader.networkInterface.sendToServer(new PacketVehiclePartEngine(engine, PacketVehiclePartEngine.Signal.AS_ON));
                }
                MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital((EntityVehicleF_Physics)this, PacketVehicleControlDigital.Controls.P_BRAKE, false));
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeRider(IWrapperEntity rider, Iterator<IWrapperEntity> iterator) {
        if (this.world.isClient() && ((Boolean)ConfigSystem.configObject.client.autostartEng.value).booleanValue() && rider instanceof IWrapperPlayer && this.locationRiderMap.containsValue((Object)rider) && this.getPartAtLocation((Point3d)((Point3d)this.locationRiderMap.inverse().get((Object)rider))).vehicleDefinition.isController) {
            for (PartEngine engine : this.engines.values()) {
                MasterLoader.networkInterface.sendToServer(new PacketVehiclePartEngine(engine, PacketVehiclePartEngine.Signal.MAGNETO_OFF));
            }
            MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital((EntityVehicleF_Physics)this, PacketVehicleControlDigital.Controls.BRAKE, false));
            MasterLoader.networkInterface.sendToServer(new PacketVehicleControlDigital((EntityVehicleF_Physics)this, PacketVehicleControlDigital.Controls.P_BRAKE, true));
        }
        super.removeRider(rider, iterator);
    }

    @Override
    public boolean isLitUp() {
        return (Boolean)ConfigSystem.configObject.client.vehicleBlklt.value != false && (this.lightsOn.contains((Object)LightType.DAYTIMERUNNINGLIGHT) ? this.lightsOn.size() > 1 : !this.lightsOn.isEmpty());
    }

    public boolean areInteriorLightsOn() {
        return (this.lightsOn.contains((Object)LightType.NAVIGATIONLIGHT) || this.lightsOn.contains((Object)LightType.RUNNINGLIGHT) || this.lightsOn.contains((Object)LightType.HEADLIGHT)) && this.electricPower > 3.0;
    }

    @Override
    public void destroyAtPosition(Point3d position) {
        super.destroyAtPosition(position);
        for (ItemInstrument instrument : this.instruments.values()) {
            this.world.spawnItem(instrument, null, position);
        }
        if (((Boolean)ConfigSystem.configObject.damage.explosions.value).booleanValue()) {
            double explosivePower = 0.0;
            for (APart part : this.parts) {
                if (!(part instanceof PartInteractable)) continue;
                explosivePower += ((PartInteractable)part).getExplosiveContribution();
            }
            this.world.spawnExplosion(this, position, explosivePower + this.fuelTank.getExplosiveness() + 1.0, true);
        }
        if (this.towedByVehicle != null) {
            this.towedByVehicle.towedVehicle = null;
            this.towedByVehicle = null;
        }
    }

    @Override
    protected float getCurrentMass() {
        return (float)((double)super.getCurrentMass() + this.fuelTank.getWeight());
    }

    @Override
    public void addPart(APart part) {
        super.addPart(part);
        if (part instanceof PartEngine) {
            byte engineNumber = 0;
            for (JSONVehicle.VehiclePart packPart : this.definition.parts) {
                for (String type : packPart.types) {
                    if (!type.startsWith("engine")) continue;
                    if (part.placementOffset.equals(packPart.pos)) {
                        this.engines.put(engineNumber, (PartEngine)part);
                        return;
                    }
                    engineNumber = (byte)(engineNumber + 1);
                }
            }
        } else if (part instanceof PartGroundDevice) {
            if (part.definition.ground.isWheel || part.definition.ground.isTread) {
                this.wheels.add((PartGroundDevice)part);
            }
        } else if (part instanceof PartGun) {
            if (!this.guns.containsKey(part.getItem())) {
                this.guns.put(part.getItem(), new ArrayList());
            }
            this.guns.get(part.getItem()).add((PartGun)part);
        }
    }

    @Override
    public void removePart(APart part, Iterator<APart> iterator) {
        super.removePart(part, iterator);
        byte engineNumber = 0;
        for (JSONVehicle.VehiclePart vehiclePart : this.definition.parts) {
            for (String type : vehiclePart.types) {
                if (!type.startsWith("engine")) continue;
                if (part.placementOffset.equals(vehiclePart.pos)) {
                    this.engines.remove(engineNumber);
                    return;
                }
                engineNumber = (byte)(engineNumber + 1);
            }
        }
        if (this.wheels.contains(part)) {
            this.wheels.remove(part);
        } else if (part instanceof PartGun) {
            for (List list : this.guns.values()) {
                if (!list.contains(part)) continue;
                list.remove(part);
            }
        }
    }

    @Override
    public void startSounds() {
        if (this.hornOn) {
            MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, this.definition.motorized.hornSound, true));
        } else if (this.sirenOn) {
            MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, this.definition.motorized.sirenSound, true));
        }
    }

    @Override
    public void updateProviderSound(SoundInstance sound) {
        if (!this.isValid) {
            sound.stop();
        } else if (sound.soundName.equals(this.definition.motorized.hornSound)) {
            if (!this.hornOn) {
                sound.stop();
            }
        } else if (sound.soundName.equals(this.definition.motorized.sirenSound) && !this.sirenOn) {
            sound.stop();
        }
    }

    @Override
    public FloatBuffer getProviderPosition() {
        return this.soundPosition;
    }

    @Override
    public Point3d getProviderVelocity() {
        return this.motion;
    }

    @Override
    public IWrapperWorld getProviderWorld() {
        return this.world;
    }

    @Override
    public Radio getRadio() {
        return this.radio;
    }

    @Override
    public void save(IWrapperNBT data) {
        byte by;
        super.save(data);
        data.setBoolean("hornOn", this.hornOn);
        data.setBoolean("sirenOn", this.sirenOn);
        data.setBoolean("reverseThrust", this.reverseThrust);
        data.setBoolean("gearUpCommand", this.gearUpCommand);
        data.setInteger("throttle", this.throttle);
        data.setDouble("electricPower", this.electricPower);
        this.fuelTank.save(data);
        String lightsOnString = "";
        for (LightType lightType : this.lightsOn) {
            lightsOnString = lightsOnString + lightType.name() + ",";
        }
        data.setString("lightsOn", lightsOnString);
        if (this.definition.rendering.customVariables != null) {
            String customsOnString = "";
            for (byte customIndex : this.customsOn) {
                customsOnString = customsOnString + customIndex + ",";
            }
            data.setString("customsOn", customsOnString);
        }
        if (this.definition.rendering.textObjects != null) {
            for (int i = 0; i < this.definition.rendering.textObjects.size(); i = (int)((byte)(i + 1))) {
                data.setString("textLine" + i, this.textLines.get(i));
            }
        }
        String[] instrumentsInSlots = new String[this.definition.motorized.instruments.size()];
        boolean bl = false;
        while (by < instrumentsInSlots.length) {
            if (this.instruments.containsKey(by)) {
                data.setString("instrument" + by + "_packID", ((JSONInstrument)this.instruments.get((Object)Byte.valueOf((byte)by)).definition).packID);
                data.setString("instrument" + by + "_systemName", ((JSONInstrument)this.instruments.get((Object)Byte.valueOf((byte)by)).definition).systemName);
            }
            by = (byte)(by + true);
        }
        this.radio.save(data);
    }
}

