/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.main;

import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketVehicleControlAnalog;
import minecrafttransportsimulator.packets.instances.PacketVehicleControlDigital;
import minecrafttransportsimulator.rendering.components.LightType;
import minecrafttransportsimulator.rendering.instances.RenderVehicle;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartEngine;
import minecrafttransportsimulator.vehicles.parts.PartPropeller;

public class EntityVehicleF_Physics
extends EntityVehicleE_Powered {
    public static final short MAX_AILERON_ANGLE = 250;
    public static final short AILERON_DAMPEN_RATE = 6;
    public short aileronAngle;
    public short aileronTrim;
    public byte aileronCooldown;
    public static final short MAX_ELEVATOR_ANGLE = 250;
    public static final short ELEVATOR_DAMPEN_RATE = 6;
    public short elevatorAngle;
    public short elevatorTrim;
    public byte elevatorCooldown;
    public static final short MAX_RUDDER_ANGLE = 450;
    public static final short RUDDER_DAMPEN_RATE = 20;
    public short rudderAngle;
    public short rudderTrim;
    public byte rudderCooldown;
    public static final short MAX_FLAP_ANGLE = 350;
    public short flapDesiredAngle;
    public short flapCurrentAngle;
    public boolean autopilot;
    public boolean cruiseControl;
    public double cruiseControlSpeed;
    private boolean updateThisCycle;
    private boolean turningLeft;
    private boolean turningRight;
    private byte turningCooldown;
    private double pitchDirectionFactor;
    private double currentWingArea;
    public double trackAngle;
    private double wingLiftCoeff;
    private double aileronLiftCoeff;
    private double elevatorLiftCoeff;
    private double rudderLiftCoeff;
    private double dragCoeff;
    private double dragForce;
    private double wingForce;
    private double aileronForce;
    private double elevatorForce;
    private double rudderForce;
    private double ballastForce;
    private double gravitationalForce;
    private Point3d thrustForce = new Point3d(0.0, 0.0, 0.0);
    private Point3d totalAxialForce = new Point3d(0.0, 0.0, 0.0);
    private Point3d totalMotiveForce = new Point3d(0.0, 0.0, 0.0);
    private Point3d totalGlobalForce = new Point3d(0.0, 0.0, 0.0);
    private Point3d totalForce = new Point3d(0.0, 0.0, 0.0);
    private double momentRoll;
    private double momentPitch;
    private double momentYaw;
    private double aileronTorque;
    private double elevatorTorque;
    private double rudderTorque;
    private Point3d thrustTorque = new Point3d(0.0, 0.0, 0.0);
    private Point3d totalTorque = new Point3d(0.0, 0.0, 0.0);
    private Point3d rotorRotation = new Point3d(0.0, 0.0, 0.0);

    public EntityVehicleF_Physics(IWrapperWorld world, IWrapperNBT data) {
        super(world, data);
        this.aileronAngle = (short)data.getInteger("aileronAngle");
        this.elevatorAngle = (short)data.getInteger("elevatorAngle");
        this.rudderAngle = (short)data.getInteger("rudderAngle");
        this.flapDesiredAngle = (short)data.getInteger("flapDesiredAngle");
        this.flapCurrentAngle = (short)data.getInteger("flapCurrentAngle");
        this.aileronTrim = (short)data.getInteger("aileronTrim");
        this.elevatorTrim = (short)data.getInteger("elevatorTrim");
        this.rudderTrim = (short)data.getInteger("rudderTrim");
    }

    @Override
    public void update() {
        if (this.towedByVehicle != null && !this.updateThisCycle) {
            return;
        }
        this.updateThisCycle = false;
        super.update();
        if (this.rudderAngle < -200) {
            this.turningLeft = true;
            this.turningCooldown = (byte)40;
            this.lightsOn.add(LightType.LEFTTURNLIGHT);
        } else if (this.rudderAngle > 200) {
            this.turningRight = true;
            this.turningCooldown = (byte)40;
            this.lightsOn.add(LightType.RIGHTTURNLIGHT);
        }
        if (this.turningLeft && (this.rudderAngle > 0 || this.turningCooldown == 0)) {
            this.turningLeft = false;
            this.lightsOn.remove((Object)LightType.LEFTTURNLIGHT);
        }
        if (this.turningRight && (this.rudderAngle < 0 || this.turningCooldown == 0)) {
            this.turningRight = false;
            this.lightsOn.remove((Object)LightType.RIGHTTURNLIGHT);
        }
        if (this.velocity != 0.0 && this.turningCooldown > 0 && this.rudderAngle == 0) {
            this.turningCooldown = (byte)(this.turningCooldown - 1);
        }
        if (this.brakeOn) {
            this.lightsOn.add(LightType.BRAKELIGHT);
            if (this.lightsOn.contains((Object)LightType.LEFTTURNLIGHT)) {
                this.lightsOn.remove((Object)LightType.LEFTINDICATORLIGHT);
            } else {
                this.lightsOn.add(LightType.LEFTINDICATORLIGHT);
            }
            if (this.lightsOn.contains((Object)LightType.RIGHTTURNLIGHT)) {
                this.lightsOn.remove((Object)LightType.RIGHTINDICATORLIGHT);
            } else {
                this.lightsOn.add(LightType.RIGHTINDICATORLIGHT);
            }
        } else {
            this.lightsOn.remove((Object)LightType.BRAKELIGHT);
            this.lightsOn.remove((Object)LightType.LEFTINDICATORLIGHT);
            this.lightsOn.remove((Object)LightType.RIGHTINDICATORLIGHT);
        }
        this.lightsOn.remove((Object)LightType.BACKUPLIGHT);
        for (PartEngine engine : this.engines.values()) {
            if (engine.currentGear >= 0) continue;
            this.lightsOn.add(LightType.BACKUPLIGHT);
            break;
        }
        if (this.flapCurrentAngle < this.flapDesiredAngle) {
            this.flapCurrentAngle = (short)(this.flapCurrentAngle + 1);
        } else if (this.flapCurrentAngle > this.flapDesiredAngle) {
            this.flapCurrentAngle = (short)(this.flapCurrentAngle - 1);
        }
        if (this.towedVehicle != null) {
            this.towedVehicle.updateThisCycle = true;
            this.towedVehicle.update();
        }
    }

    @Override
    protected float getCurrentMass() {
        if (this.towedVehicle != null) {
            return super.getCurrentMass() + this.towedVehicle.getCurrentMass();
        }
        return super.getCurrentMass();
    }

    @Override
    protected float getSteeringAngle() {
        return (float)(-this.rudderAngle) / 10.0f;
    }

    @Override
    protected void getForcesAndMotions() {
        if (this.towedByVehicle == null) {
            this.momentRoll = (double)((JSONVehicle.VehicleGeneral)this.definition.general).emptyMass * (1.5 + this.fuelTank.getFluidLevel() / 10000.0);
            this.momentPitch = 2.0 * this.currentMass;
            this.momentYaw = 3.0 * this.currentMass;
            this.thrustForce.set(0.0, 0.0, 0.0);
            this.thrustTorque.set(0.0, 0.0, 0.0);
            this.rotorRotation.set(0.0, 0.0, 0.0);
            for (APart part : this.parts) {
                Point3d partForce;
                boolean isPropeller = false;
                boolean isRotor = false;
                double jetPower = 0.0;
                if (part instanceof PartEngine) {
                    partForce = ((PartEngine)part).getForceOutput();
                    jetPower = part.definition.engine.jetPowerFactor;
                } else {
                    if (!(part instanceof PartPropeller)) continue;
                    partForce = ((PartPropeller)part).getForceOutput();
                    isPropeller = true;
                    isRotor = part.definition.propeller.isRotor;
                }
                this.thrustForce.add(partForce);
                if (isPropeller || jetPower > 0.0) {
                    this.thrustTorque.add(partForce.y * -part.placementOffset.z, partForce.z * part.placementOffset.x, partForce.y * part.placementOffset.x);
                }
                if (!isRotor) continue;
                this.rotorRotation.add(-5.0 * (double)this.elevatorAngle / 250.0, -5.0 * (double)this.rudderAngle / 450.0, 5.0 * (double)this.aileronAngle / 250.0);
            }
            this.gravitationalForce = this.definition.motorized.ballastVolume == 0.0f ? this.currentMass * 0.0245 : 0.0;
            this.trackAngle = -Math.toDegrees(Math.asin(this.verticalVector.dotProduct(this.normalizedVelocityVector)));
            this.wingLiftCoeff = EntityVehicleF_Physics.getLiftCoeff(this.trackAngle, 2.0 + (double)this.flapCurrentAngle / 350.0);
            this.aileronLiftCoeff = EntityVehicleF_Physics.getLiftCoeff((float)(this.aileronAngle + this.aileronTrim) / 10.0f, 2.0);
            this.elevatorLiftCoeff = EntityVehicleF_Physics.getLiftCoeff(-2.5 + this.trackAngle - (double)((float)(this.elevatorAngle + this.elevatorTrim) / 10.0f), 2.0);
            this.rudderLiftCoeff = EntityVehicleF_Physics.getLiftCoeff((double)((float)(this.rudderAngle + this.rudderTrim) / 10.0f) - Math.toDegrees(Math.asin(this.sideVector.dotProduct(this.normalizedVelocityVector))), 2.0);
            this.currentWingArea = (double)this.definition.motorized.wingArea + (double)this.definition.motorized.wingArea * 0.15 * (double)this.flapCurrentAngle / 350.0;
            if (((JSONVehicle.VehicleGeneral)this.definition.general).isBlimp) {
                if (this.aileronAngle < 0 && this.aileronAngle < this.rudderAngle || this.aileronAngle > 0 && this.aileronAngle > this.rudderAngle) {
                    this.rudderAngle = this.aileronAngle;
                    this.rudderCooldown = this.aileronCooldown;
                }
                if (this.throttle == 0 && Math.abs(this.velocity) < 0.15 && (this.brakeOn || this.parkingBrakeOn)) {
                    this.motion.x = 0.0;
                    this.motion.z = 0.0;
                    this.thrustForce.set(0.0, 0.0, 0.0);
                    this.thrustTorque.set(0.0, 0.0, 0.0);
                }
            }
            if (((JSONVehicle.VehicleGeneral)this.definition.general).isAircraft) {
                this.dragCoeff = (double)4.0E-4f * Math.pow(this.trackAngle, 2.0) + (this.definition.motorized.dragCoefficient != 0.0f ? (double)this.definition.motorized.dragCoefficient : 0.03);
            } else {
                double d = this.dragCoeff = this.definition.motorized.dragCoefficient != 0.0f ? (double)this.definition.motorized.dragCoefficient : 2.0;
                if (this.groundedGroundDevices.isEmpty()) {
                    this.dragCoeff *= 3.0;
                }
            }
            this.dragForce = this.definition.motorized.crossSectionalArea > 0.0f ? 0.5 * this.airDensity * this.velocity * this.velocity * (double)this.definition.motorized.crossSectionalArea * this.dragCoeff : (this.definition.motorized.wingSpan > 0.0f ? 0.5 * this.airDensity * this.velocity * this.velocity * this.currentWingArea * (this.dragCoeff + this.wingLiftCoeff * this.wingLiftCoeff / (Math.PI * (double)this.definition.motorized.wingSpan * (double)this.definition.motorized.wingSpan / this.currentWingArea * 0.8)) : 0.5 * this.airDensity * this.velocity * this.velocity * 5.0 * this.dragCoeff);
            if (this.definition.motorized.ballastVolume > 0.0f) {
                this.ballastForce = this.elevatorAngle < 0 ? this.airDensity * (double)this.definition.motorized.ballastVolume * (double)(-this.elevatorAngle) / 100.0 : (this.elevatorAngle > 0 ? 1.225 * (double)this.definition.motorized.ballastVolume * (double)(-this.elevatorAngle) / 100.0 : 1.225 * (double)this.definition.motorized.ballastVolume * 10.0 * -this.motion.y);
                if (this.motion.y * this.ballastForce != 0.0) {
                    this.ballastForce /= Math.pow(1.0 + Math.abs(this.motion.y), 2.0);
                }
            }
            this.wingForce = 0.5 * this.airDensity * this.axialVelocity * this.axialVelocity * this.currentWingArea * this.wingLiftCoeff;
            this.aileronForce = 0.5 * this.airDensity * this.axialVelocity * this.axialVelocity * (double)this.definition.motorized.aileronArea * this.aileronLiftCoeff;
            this.elevatorForce = 0.5 * this.airDensity * this.axialVelocity * this.axialVelocity * (double)this.definition.motorized.elevatorArea * this.elevatorLiftCoeff;
            this.rudderForce = 0.5 * this.airDensity * this.axialVelocity * this.axialVelocity * (double)this.definition.motorized.rudderArea * this.rudderLiftCoeff;
            this.aileronTorque = this.aileronForce * (double)this.definition.motorized.wingSpan * 0.5 * 0.75;
            this.elevatorTorque = this.elevatorForce * (double)this.definition.motorized.tailDistance;
            this.rudderTorque = this.rudderForce * (double)this.definition.motorized.tailDistance;
            if (((JSONVehicle.VehicleGeneral)this.definition.general).isBlimp) {
                this.aileronTorque = this.angles.z > 0.0 ? -Math.min(0.5, this.angles.z) * this.currentMass : (this.angles.z < 0.0 ? -Math.max(-0.5, this.angles.z) * this.currentMass : 0.0);
                this.elevatorTorque = this.angles.x > 0.0 ? -Math.min(0.5, this.angles.x) * this.currentMass : (this.angles.x < 0.0 ? -Math.max(-0.5, this.angles.x) * this.currentMass : 0.0);
            }
            if (this.definition.motorized.wingArea > 0.0f && this.axialVelocity < 0.25 && this.angles.x < 45.0 && this.groundedGroundDevices.isEmpty()) {
                this.elevatorTorque += 100.0;
            }
            this.totalAxialForce.set(0.0, this.wingForce - this.elevatorForce, 0.0).add(this.thrustForce).rotateFine(this.angles);
            this.totalMotiveForce.set(-this.dragForce, -this.dragForce, -this.dragForce).multiply(this.normalizedVelocityVector);
            this.totalGlobalForce.set(0.0, this.ballastForce - this.gravitationalForce, 0.0);
            this.totalForce.setTo(this.totalAxialForce).add(this.totalMotiveForce).add(this.totalGlobalForce).multiply(1.0 / this.currentMass);
            this.motion.add(this.totalForce);
            this.pitchDirectionFactor = Math.abs(this.angles.z % 360.0);
            this.pitchDirectionFactor = this.pitchDirectionFactor < 90.0 || this.pitchDirectionFactor > 270.0 ? 1.0 : -1.0;
            this.totalTorque.set(this.elevatorTorque, this.rudderTorque, this.aileronTorque).add(this.thrustTorque).multiply(57.29577951308232);
            this.rotation.x = (this.pitchDirectionFactor * (1.0 - Math.abs(this.sideVector.y)) * this.totalTorque.x + this.sideVector.y * this.totalTorque.y) / this.momentPitch;
            this.rotation.y = (this.sideVector.y * this.totalTorque.x - this.verticalVector.y * this.totalTorque.y) / this.momentYaw;
            this.rotation.z = this.totalTorque.z / this.momentRoll;
            this.rotation.add(this.rotorRotation);
        } else {
            Point3d tractorHitchOffset = this.towedByVehicle.definition.motorized.hitchPos.copy().add(0.0, 0.0, 1.0).rotateFine(this.towedByVehicle.angles).add(this.towedByVehicle.position).subtract(this.position);
            Point3d trailerHookupOffset = this.definition.motorized.hookupPos.copy().rotateFine(this.angles);
            tractorHitchOffset.y = 0.0;
            trailerHookupOffset.y = 0.0;
            tractorHitchOffset.normalize();
            trailerHookupOffset.normalize();
            double rotationDelta = -Math.toDegrees(Math.acos(tractorHitchOffset.dotProduct(trailerHookupOffset)));
            if (!Double.isNaN(rotationDelta *= Math.signum(tractorHitchOffset.crossProduct((Point3d)trailerHookupOffset).y))) {
                this.rotation.y += rotationDelta;
                this.angles.y += rotationDelta;
                tractorHitchOffset.setTo(this.towedByVehicle.definition.motorized.hitchPos).rotateFine(this.towedByVehicle.angles).add(this.towedByVehicle.position).subtract(this.position);
                trailerHookupOffset = this.definition.motorized.hookupPos.copy().rotateFine(this.angles);
                this.motion.setTo(tractorHitchOffset.subtract(trailerHookupOffset));
                this.angles.y -= rotationDelta;
            }
            this.rotation.x = -0.001f;
            this.rotation.z = this.towedByVehicle.rotation.z;
        }
    }

    @Override
    protected void dampenControlSurfaces() {
        if (this.cruiseControl) {
            if (this.velocity < this.cruiseControlSpeed) {
                if (this.throttle < 100) {
                    MasterLoader.networkInterface.sendToAllClients(new PacketVehicleControlAnalog(this, PacketVehicleControlAnalog.Controls.THROTTLE, 1, 0));
                    this.throttle = (byte)(this.throttle + 1);
                }
            } else if (this.velocity > this.cruiseControlSpeed && this.throttle > 0) {
                MasterLoader.networkInterface.sendToAllClients(new PacketVehicleControlAnalog(this, PacketVehicleControlAnalog.Controls.THROTTLE, -1, 0));
                this.throttle = (byte)(this.throttle - 1);
            }
        }
        if (this.autopilot) {
            if (-this.angles.z > (double)(this.aileronTrim + 1)) {
                MasterLoader.networkInterface.sendToAllClients(new PacketVehicleControlDigital(this, PacketVehicleControlDigital.Controls.TRIM_ROLL, true));
                this.aileronTrim = (short)(this.aileronTrim + 1);
            } else if (-this.angles.z < (double)(this.aileronTrim - 1)) {
                MasterLoader.networkInterface.sendToAllClients(new PacketVehicleControlDigital(this, PacketVehicleControlDigital.Controls.TRIM_ROLL, false));
                this.aileronTrim = (short)(this.aileronTrim - 1);
            }
            if (-this.motion.z * 100.0 > (double)(this.elevatorTrim + 1)) {
                MasterLoader.networkInterface.sendToAllClients(new PacketVehicleControlDigital(this, PacketVehicleControlDigital.Controls.TRIM_PITCH, true));
                this.elevatorTrim = (short)(this.elevatorTrim + 1);
            } else if (-this.motion.y * 100.0 < (double)(this.elevatorTrim - 1)) {
                MasterLoader.networkInterface.sendToAllClients(new PacketVehicleControlDigital(this, PacketVehicleControlDigital.Controls.TRIM_PITCH, false));
                this.elevatorTrim = (short)(this.elevatorTrim - 1);
            }
        }
        if (this.aileronCooldown == 0) {
            if (this.aileronAngle != 0) {
                if (this.aileronAngle < 6 && this.aileronAngle > -6) {
                    MasterLoader.networkInterface.sendToAllClients(new PacketVehicleControlAnalog(this, PacketVehicleControlAnalog.Controls.AILERON, -this.aileronAngle, 0));
                    this.aileronAngle = 0;
                } else {
                    MasterLoader.networkInterface.sendToAllClients(new PacketVehicleControlAnalog(this, PacketVehicleControlAnalog.Controls.AILERON, this.aileronAngle < 0 ? (short)6 : -6, 0));
                    this.aileronAngle = (short)(this.aileronAngle + (this.aileronAngle < 0 ? 6 : -6));
                }
            }
        } else {
            this.aileronCooldown = (byte)(this.aileronCooldown - 1);
        }
        if (this.elevatorCooldown == 0) {
            if (this.elevatorAngle != 0) {
                if (this.elevatorAngle < 6 && this.elevatorAngle > -6) {
                    MasterLoader.networkInterface.sendToAllClients(new PacketVehicleControlAnalog(this, PacketVehicleControlAnalog.Controls.ELEVATOR, -this.elevatorAngle, 0));
                    this.elevatorAngle = 0;
                } else {
                    MasterLoader.networkInterface.sendToAllClients(new PacketVehicleControlAnalog(this, PacketVehicleControlAnalog.Controls.ELEVATOR, this.elevatorAngle < 0 ? (short)6 : -6, 0));
                    this.elevatorAngle = (short)(this.elevatorAngle + (this.elevatorAngle < 0 ? 6 : -6));
                }
            }
        } else {
            this.elevatorCooldown = (byte)(this.elevatorCooldown - 1);
        }
        if (this.rudderCooldown == 0) {
            if (this.rudderAngle != 0) {
                if (this.rudderAngle < 20 && this.rudderAngle > -20) {
                    MasterLoader.networkInterface.sendToAllClients(new PacketVehicleControlAnalog(this, PacketVehicleControlAnalog.Controls.RUDDER, -this.rudderAngle, 0));
                    this.rudderAngle = 0;
                } else {
                    MasterLoader.networkInterface.sendToAllClients(new PacketVehicleControlAnalog(this, PacketVehicleControlAnalog.Controls.RUDDER, this.rudderAngle < 0 ? (short)20 : -20, 0));
                    this.rudderAngle = (short)(this.rudderAngle + (this.rudderAngle < 0 ? 20 : -20));
                }
            }
        } else {
            this.rudderCooldown = (byte)(this.rudderCooldown - 1);
        }
    }

    @Override
    public void render(float partialTicks) {
        RenderVehicle.render(this, partialTicks);
    }

    protected static double getLiftCoeff(double angleOfAttack, double maxLiftCoeff) {
        if (angleOfAttack == 0.0) {
            return 0.0;
        }
        if (Math.abs(angleOfAttack) <= 18.75) {
            return maxLiftCoeff * Math.sin(1.5707963267948966 * angleOfAttack / 15.0);
        }
        if (Math.abs(angleOfAttack) <= 22.5) {
            if (angleOfAttack > 0.0) {
                return maxLiftCoeff * (0.4 + 1.0 / (angleOfAttack - 15.0));
            }
            return maxLiftCoeff * (-0.4 + 1.0 / (angleOfAttack + 15.0));
        }
        return maxLiftCoeff * Math.sin(0.5235987755982988 * angleOfAttack / 15.0);
    }

    @Override
    public void save(IWrapperNBT data) {
        super.save(data);
        data.setInteger("aileronAngle", this.aileronAngle);
        data.setInteger("elevatorAngle", this.elevatorAngle);
        data.setInteger("rudderAngle", this.rudderAngle);
        data.setInteger("flapDesiredAngle", this.flapDesiredAngle);
        data.setInteger("flapCurrentAngle", this.flapCurrentAngle);
        data.setInteger("aileronTrim", this.aileronTrim);
        data.setInteger("elevatorTrim", this.elevatorTrim);
        data.setInteger("rudderTrim", this.rudderTrim);
    }
}

