/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.parts;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.items.instances.ItemPart;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.rendering.components.DurationDelayClock;
import minecrafttransportsimulator.sound.ISoundProvider;
import minecrafttransportsimulator.sound.SoundInstance;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.systems.VehicleAnimationSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;

public abstract class APart
implements ISoundProvider {
    private static final Point3d ZERO_POINT = new Point3d(0.0, 0.0, 0.0);
    public final JSONPart definition;
    public final JSONVehicle.VehiclePart vehicleDefinition;
    public final Point3d placementOffset;
    public final Point3d placementRotation;
    public final boolean disableMirroring;
    public final EntityVehicleF_Physics vehicle;
    public final APart parentPart;
    public final List<APart> childParts = new ArrayList<APart>();
    public final List<String> textLines = new ArrayList<String>();
    private final List<DurationDelayClock> animations = new ArrayList<DurationDelayClock>();
    private final FloatBuffer soundPosition = ByteBuffer.allocateDirect(12).order(ByteOrder.nativeOrder()).asFloatBuffer();
    public final Point3d totalOffset;
    public final Point3d totalRotation;
    public final Point3d worldPos;
    public final BoundingBox boundingBox;
    public String currentSubName;
    public boolean isValid = true;

    public APart(EntityVehicleF_Physics vehicle, JSONVehicle.VehiclePart packVehicleDef, ItemPart item, IWrapperNBT data, APart parentPart) {
        this.vehicle = vehicle;
        this.placementOffset = packVehicleDef.pos;
        this.totalOffset = this.placementOffset.copy();
        this.definition = (JSONPart)item.definition;
        this.vehicleDefinition = packVehicleDef;
        this.worldPos = this.placementOffset.copy().rotateFine(vehicle.angles).add(vehicle.position);
        this.boundingBox = new BoundingBox(this.placementOffset, this.worldPos, (double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0, (double)this.getWidth() / 2.0, this.definition.ground != null ? this.definition.ground.canFloat : false, false, false, 0.0);
        this.placementRotation = packVehicleDef.rot != null ? packVehicleDef.rot : new Point3d(0.0, 0.0, 0.0);
        this.totalRotation = this.placementRotation.copy();
        this.currentSubName = item.subName;
        this.isValid = true;
        if (this.definition.rendering != null && this.definition.rendering.textObjects != null) {
            for (int i = 0; i < this.definition.rendering.textObjects.size(); i = (int)((byte)(i + 1))) {
                this.textLines.add(data.getString("textLine" + i));
            }
        }
        if (!this.isFake() && parentPart != null) {
            this.parentPart = parentPart;
            parentPart.childParts.add(this);
            this.disableMirroring = packVehicleDef.isSubPart ? parentPart.disableMirroring || ((JSONPart.JSONPartGeneral)this.definition.general).disableMirroring : ((JSONPart.JSONPartGeneral)this.definition.general).disableMirroring;
        } else {
            this.disableMirroring = ((JSONPart.JSONPartGeneral)this.definition.general).disableMirroring;
            this.parentPart = null;
        }
        if (this.vehicleDefinition.animations != null) {
            for (JSONVehicle.VehicleAnimationDefinition animation : this.vehicleDefinition.animations) {
                this.animations.add(new DurationDelayClock(animation));
            }
        }
    }

    public boolean isFake() {
        return false;
    }

    public boolean interact(IWrapperPlayer player) {
        return false;
    }

    public void attack(Damage damage) {
    }

    public void update() {
        if (this.parentPart != null && this.vehicleDefinition.isSubPart) {
            this.totalOffset.setTo(this.getPositionOffset(0.0f)).add(this.placementOffset).subtract(this.parentPart.placementOffset);
            this.totalRotation.setTo(this.parentPart.getPositionRotation(0.0f)).add(this.parentPart.placementRotation);
            this.totalOffset.rotateFine(this.totalRotation);
            Point3d parentActionRotation = this.parentPart.getActionRotation(0.0f);
            this.totalOffset.rotateFine(parentActionRotation);
            this.totalRotation.add(parentActionRotation);
            this.totalOffset.add(this.parentPart.placementOffset).add(this.parentPart.getPositionOffset(0.0f));
        } else {
            this.totalOffset.setTo(this.getPositionOffset(0.0f)).add(this.placementOffset);
            this.totalRotation.setTo(this.getPositionRotation(0.0f)).add(this.placementRotation);
        }
        this.worldPos.setTo(this.totalOffset).rotateFine(this.vehicle.angles).add(this.vehicle.position);
        this.soundPosition.rewind();
        this.soundPosition.put((float)this.worldPos.x);
        this.soundPosition.put((float)this.worldPos.y);
        this.soundPosition.put((float)this.worldPos.z);
        this.soundPosition.flip();
    }

    public final Point3d getPositionOffset(float partialTicks) {
        Point3d rollingOffset = new Point3d(0.0, 0.0, 0.0);
        if (!this.animations.isEmpty()) {
            Point3d rollingRotation = new Point3d(0.0, 0.0, 0.0);
            for (DurationDelayClock animation : this.animations) {
                double variableValue;
                JSONVehicle.VehicleAnimationDefinition definition = animation.definition;
                if (definition.animationType.equals("rotation")) {
                    variableValue = animation.getFactoredState(this.vehicle, VehicleAnimationSystem.getVariableValue(definition.variable, partialTicks, this.vehicle, this));
                    Point3d appliedRotation = new Point3d(0.0, 0.0, 0.0);
                    if (definition.axis.x != 0.0) {
                        appliedRotation.x = VehicleAnimationSystem.clampAndScale(variableValue, definition.axis.x, definition.offset, definition.clampMin, definition.clampMax, definition.absolute);
                    }
                    if (definition.axis.y != 0.0) {
                        appliedRotation.y = VehicleAnimationSystem.clampAndScale(variableValue, definition.axis.y, definition.offset, definition.clampMin, definition.clampMax, definition.absolute);
                    }
                    if (definition.axis.z != 0.0) {
                        appliedRotation.z = VehicleAnimationSystem.clampAndScale(variableValue, definition.axis.z, definition.offset, definition.clampMin, definition.clampMax, definition.absolute);
                    }
                    if (!definition.centerPoint.isZero()) {
                        rollingOffset.add(definition.centerPoint.copy().multiply(-1.0).rotateFine(appliedRotation).add(definition.centerPoint).rotateFine(rollingRotation));
                    }
                    rollingRotation.add(appliedRotation);
                    continue;
                }
                if (!definition.animationType.equals("translation")) continue;
                variableValue = animation.getFactoredState(this.vehicle, VehicleAnimationSystem.getVariableValue(definition.variable, partialTicks, this.vehicle, this));
                Point3d appliedTranslation = new Point3d(0.0, 0.0, 0.0);
                if (definition.axis.x != 0.0) {
                    appliedTranslation.x = VehicleAnimationSystem.clampAndScale(variableValue, definition.axis.x, definition.offset, definition.clampMin, definition.clampMax, definition.absolute);
                }
                if (definition.axis.y != 0.0) {
                    appliedTranslation.y = VehicleAnimationSystem.clampAndScale(variableValue, definition.axis.y, definition.offset, definition.clampMin, definition.clampMax, definition.absolute);
                }
                if (definition.axis.z != 0.0) {
                    appliedTranslation.z = VehicleAnimationSystem.clampAndScale(variableValue, definition.axis.z, definition.offset, definition.clampMin, definition.clampMax, definition.absolute);
                }
                rollingOffset.add(appliedTranslation.rotateFine(rollingRotation));
            }
        }
        return rollingOffset;
    }

    public final Point3d getPositionRotation(float partialTicks) {
        Point3d rollingRotation = new Point3d(0.0, 0.0, 0.0);
        if (!this.animations.isEmpty()) {
            for (DurationDelayClock animation : this.animations) {
                JSONVehicle.VehicleAnimationDefinition definition = animation.definition;
                if (!definition.animationType.equals("rotation")) continue;
                double variableValue = animation.getFactoredState(this.vehicle, VehicleAnimationSystem.getVariableValue(definition.variable, partialTicks, this.vehicle, this));
                if (definition.axis.x != 0.0) {
                    rollingRotation.x += VehicleAnimationSystem.clampAndScale(variableValue, definition.axis.x, definition.offset, definition.clampMin, definition.clampMax, definition.absolute);
                }
                if (definition.axis.y != 0.0) {
                    rollingRotation.y += VehicleAnimationSystem.clampAndScale(variableValue, definition.axis.y, definition.offset, definition.clampMin, definition.clampMax, definition.absolute);
                }
                if (definition.axis.z == 0.0) continue;
                rollingRotation.z += VehicleAnimationSystem.clampAndScale(variableValue, definition.axis.z, definition.offset, definition.clampMin, definition.clampMax, definition.absolute);
            }
        }
        return rollingRotation;
    }

    public Point3d getActionRotation(float partialTicks) {
        return ZERO_POINT;
    }

    public boolean isInLiquid() {
        return this.vehicle.world.isBlockLiquid(new Point3i(this.worldPos));
    }

    public void remove() {
        this.isValid = false;
        if (this.parentPart != null) {
            this.parentPart.childParts.remove(this);
        }
    }

    public ItemPart getItem() {
        ItemPart item = (ItemPart)PackParserSystem.getItem(this.definition.packID, this.definition.systemName, this.currentSubName);
        return item;
    }

    public IWrapperNBT getData() {
        IWrapperNBT data = MasterLoader.coreInterface.createNewTag();
        if (this.definition.rendering != null && this.definition.rendering.textObjects != null) {
            for (int i = 0; i < this.definition.rendering.textObjects.size(); i = (int)((byte)(i + 1))) {
                data.setString("textLine" + i, this.textLines.get(i));
            }
        }
        return data;
    }

    public abstract float getWidth();

    public abstract float getHeight();

    @Override
    public void updateProviderSound(SoundInstance sound) {
        if (!this.isValid || !this.vehicle.isValid) {
            sound.stop();
        }
    }

    @Override
    public void startSounds() {
    }

    @Override
    public FloatBuffer getProviderPosition() {
        return this.soundPosition;
    }

    @Override
    public Point3d getProviderVelocity() {
        return this.vehicle.getProviderVelocity();
    }

    @Override
    public IWrapperWorld getProviderWorld() {
        return this.vehicle.getProviderWorld();
    }
}

