/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.parts;

import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.items.instances.ItemPart;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketVehicleControlDigital;
import minecrafttransportsimulator.packets.instances.PacketVehiclePartEngine;
import minecrafttransportsimulator.rendering.components.IVehiclePartFXProvider;
import minecrafttransportsimulator.rendering.instances.ParticleDrip;
import minecrafttransportsimulator.rendering.instances.ParticleFlame;
import minecrafttransportsimulator.rendering.instances.ParticleSmoke;
import minecrafttransportsimulator.sound.SoundInstance;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartGroundDevice;
import minecrafttransportsimulator.vehicles.parts.PartPropeller;

public class PartEngine
extends APart
implements IVehiclePartFXProvider {
    public boolean isCreative;
    public boolean oilLeak;
    public boolean fuelLeak;
    public boolean brokenStarter;
    public byte reverseGears;
    public byte currentGear;
    public double hours;
    public double rpm;
    public double temp = 20.0;
    public double pressure;
    public float propellerGearboxRatio;
    public EngineStates state = EngineStates.ENGINE_OFF;
    public double fuelFlow;
    public PartEngine linkedEngine;
    private boolean backfired;
    private boolean isPropellerInLiquid;
    private byte starterLevel;
    private byte shiftCooldown;
    private int internalFuel;
    private long lastTimeParticleSpawned;
    private float currentGearRatio;
    private double lowestWheelVelocity;
    private double desiredWheelVelocity;
    private double propellerAxialVelocity;
    private double engineAxialVelocity;
    private float wheelFriction;
    private double ambientTemp;
    private double coolingFactor;
    private double engineTargetRPM;
    private double engineRotation;
    private double prevEngineRotation;
    private double driveshaftRotation;
    private double prevDriveshaftRotation;
    private final Point3d engineForce = new Point3d(0.0, 0.0, 0.0);
    private final int startRPM;
    private final int stallRPM;
    private static final float COLD_TEMP = 30.0f;
    private static final float OVERHEAT_TEMP_1 = 115.556f;
    private static final float OVERHEAT_TEMP_2 = 121.111f;
    private static final float FAILURE_TEMP = 132.222f;
    private static final float LOW_OIL_PRESSURE = 40.0f;

    public PartEngine(EntityVehicleF_Physics vehicle, JSONVehicle.VehiclePart packVehicleDef, ItemPart item, IWrapperNBT data, APart parentPart) {
        super(vehicle, packVehicleDef, item, data, parentPart);
        this.isCreative = data.getBoolean("isCreative");
        this.oilLeak = data.getBoolean("oilLeak");
        this.fuelLeak = data.getBoolean("fuelLeak");
        this.brokenStarter = data.getBoolean("brokenStarter");
        this.currentGear = (byte)data.getInteger("currentGear");
        this.hours = data.getDouble("hours");
        this.rpm = data.getDouble("rpm");
        this.temp = data.getDouble("temp");
        this.pressure = data.getDouble("pressure");
        this.state = EngineStates.values()[data.getInteger("state")];
        for (float gear : this.definition.engine.gearRatios) {
            if (!(gear < 0.0f)) continue;
            this.reverseGears = (byte)(this.reverseGears + 1);
        }
        this.startRPM = this.definition.engine.maxRPM < 15000 ? 500 : 2000;
        int n = this.stallRPM = this.definition.engine.maxRPM < 15000 ? 300 : 1500;
        if (((JSONVehicle.VehicleGeneral)vehicle.definition.general).isAircraft) {
            this.currentGear = 1;
        }
    }

    @Override
    public void attack(Damage damage) {
        if (!this.isCreative) {
            if (damage.isExplosion) {
                this.hours += damage.amount * 20.0 * (Double)ConfigSystem.configObject.general.engineHoursFactor.value;
                if (!this.definition.engine.isSteamPowered) {
                    if (!this.oilLeak) {
                        boolean bl = this.oilLeak = Math.random() < (Double)ConfigSystem.configObject.damage.engineLeakProbability.value * 10.0;
                    }
                    if (!this.fuelLeak) {
                        boolean bl = this.fuelLeak = Math.random() < (Double)ConfigSystem.configObject.damage.engineLeakProbability.value * 10.0;
                    }
                    if (!this.brokenStarter) {
                        this.brokenStarter = Math.random() < 0.05;
                    }
                }
                MasterLoader.networkInterface.sendToAllClients(new PacketVehiclePartEngine(this, damage.amount * 10.0 * (Double)ConfigSystem.configObject.general.engineHoursFactor.value, this.oilLeak, this.fuelLeak, this.brokenStarter));
            } else {
                this.hours += damage.amount * 2.0 * (Double)ConfigSystem.configObject.general.engineHoursFactor.value;
                if (!this.definition.engine.isSteamPowered) {
                    if (!this.oilLeak) {
                        boolean bl = this.oilLeak = Math.random() < (Double)ConfigSystem.configObject.damage.engineLeakProbability.value;
                    }
                    if (!this.fuelLeak) {
                        this.fuelLeak = Math.random() < (Double)ConfigSystem.configObject.damage.engineLeakProbability.value;
                    }
                }
                MasterLoader.networkInterface.sendToAllClients(new PacketVehiclePartEngine(this, damage.amount * (Double)ConfigSystem.configObject.general.engineHoursFactor.value, this.oilLeak, this.fuelLeak, this.brokenStarter));
            }
        }
    }

    @Override
    public void update() {
        super.update();
        this.fuelFlow = 0.0;
        this.currentGearRatio = this.definition.engine.gearRatios[this.currentGear + this.reverseGears];
        if (this.linkedEngine != null) {
            if (this.linkedEngine.worldPos.distanceTo(this.worldPos) > 16.0) {
                this.linkedEngine.linkedEngine = null;
                this.linkedEngine = null;
                if (this.vehicle.world.isClient()) {
                    for (IWrapperEntity entity : this.vehicle.world.getEntitiesWithin(new BoundingBox(this.worldPos, 16.0, 16.0, 16.0))) {
                        if (!(entity instanceof IWrapperPlayer)) continue;
                        ((IWrapperPlayer)entity).displayChatMessage("interact.jumpercable.linkdropped");
                    }
                }
            } else if (this.vehicle.electricPower + 0.5 < this.linkedEngine.vehicle.electricPower) {
                this.linkedEngine.vehicle.electricPower -= (double)0.005f;
                this.vehicle.electricPower += (double)0.005f;
            } else if (this.vehicle.electricPower > this.linkedEngine.vehicle.electricPower + 0.5) {
                this.vehicle.electricPower -= (double)0.005f;
                this.linkedEngine.vehicle.electricPower += (double)0.005f;
            } else {
                this.linkedEngine.linkedEngine = null;
                this.linkedEngine = null;
                if (this.vehicle.world.isClient()) {
                    for (IWrapperEntity entity : this.vehicle.world.getEntitiesWithin(new BoundingBox(this.worldPos, 16.0, 16.0, 16.0))) {
                        if (!(entity instanceof IWrapperPlayer)) continue;
                        ((IWrapperPlayer)entity).displayChatMessage("interact.jumpercable.powerequal");
                    }
                }
            }
        }
        this.ambientTemp = (double)(25.0f * this.vehicle.world.getTemperature(new Point3i(this.vehicle.position))) - 5.0 * (Math.pow(2.0, this.vehicle.position.y / 400.0) - 1.0);
        this.coolingFactor = 0.001 - (double)(this.definition.engine.superchargerEfficiency / 1000.0f) * (this.rpm / 2000.0) + this.vehicle.velocity / 500.0;
        this.temp -= (this.temp - this.ambientTemp) * this.coolingFactor;
        if (this.state.esOn) {
            if (this.starterLevel == 0) {
                if (this.vehicle.electricPower > 1.0) {
                    this.starterLevel = (byte)(this.starterLevel + 4);
                } else {
                    this.setElectricStarterStatus(false);
                }
            }
            if (this.starterLevel > 0) {
                if (!this.isCreative) {
                    this.vehicle.electricUsage += (double)0.05f;
                }
                if (!this.isCreative) {
                    this.fuelFlow += this.vehicle.fuelTank.drain(this.vehicle.fuelTank.getFluid(), (double)this.getTotalFuelConsumption() * (Double)ConfigSystem.configObject.general.fuelUsageFactor.value, !this.vehicle.world.isClient());
                }
            }
        } else if (this.state.hsOn && this.starterLevel == 0) {
            if (this.state.running) {
                this.state = EngineStates.RUNNING;
            } else {
                EngineStates engineStates = this.state = this.state.magnetoOn ? EngineStates.MAGNETO_ON_STARTERS_OFF : EngineStates.ENGINE_OFF;
            }
        }
        if (this.starterLevel > 0) {
            this.starterLevel = (byte)(this.starterLevel - 1);
            this.rpm = this.rpm < (double)this.startRPM * 1.2 ? Math.min(this.rpm + (double)this.definition.engine.starterPower, (double)this.startRPM * 1.2) : Math.max(this.rpm - (double)this.definition.engine.starterPower, (double)this.startRPM * 1.2);
        }
        if (this.state.running) {
            this.vehicle.electricUsage -= 0.05 * this.rpm / (double)this.definition.engine.maxRPM;
            if (!this.isCreative) {
                this.hours += 0.001 * this.getTotalWearFactor();
                if (this.rpm > (double)PartEngine.getSafeRPMFromMax(this.definition.engine.maxRPM)) {
                    this.hours += (this.rpm - (double)PartEngine.getSafeRPMFromMax(this.definition.engine.maxRPM)) / (double)PartEngine.getSafeRPMFromMax(this.definition.engine.maxRPM) * this.getTotalWearFactor();
                }
            }
            if (!this.definition.engine.isSteamPowered) {
                if (!this.isCreative && !this.vehicle.fuelTank.getFluid().isEmpty()) {
                    if (!ConfigSystem.configObject.fuel.fuels.containsKey(this.definition.engine.fuelType)) {
                        throw new IllegalArgumentException("ERROR: Engine:" + this.definition.packID + ":" + this.definition.systemName + " wanted fuel configs for fuel of type:" + this.definition.engine.fuelType + ", but these do not exist in the config file.  Fuels currently in the file are:" + ConfigSystem.configObject.fuel.fuels.keySet().toString() + "If you are on a server, this means the server and client configs are not the same.  If this is a modpack, TELL THE AUTHOR IT IS BORKEN!");
                    }
                    if (!ConfigSystem.configObject.fuel.fuels.get(this.definition.engine.fuelType).containsKey(this.vehicle.fuelTank.getFluid())) {
                        this.vehicle.fuelTank.drain(this.vehicle.fuelTank.getFluid(), this.vehicle.fuelTank.getFluidLevel(), true);
                    } else {
                        this.fuelFlow += this.vehicle.fuelTank.drain(this.vehicle.fuelTank.getFluid(), (double)this.getTotalFuelConsumption() * (Double)ConfigSystem.configObject.general.fuelUsageFactor.value / ConfigSystem.configObject.fuel.fuels.get(this.definition.engine.fuelType).get(this.vehicle.fuelTank.getFluid()) * this.rpm * (double)(this.fuelLeak ? 1.5f : 1.0f) / (double)this.definition.engine.maxRPM, !this.vehicle.world.isClient());
                    }
                }
                this.temp += Math.max(0.0, (7.0 * this.rpm / (double)this.definition.engine.maxRPM - this.temp / 60.0) / 20.0);
                this.pressure = Math.min(90.0 - this.temp / 10.0, this.pressure + this.rpm / (double)this.startRPM - 0.5 * (double)(this.oilLeak ? 5.0f : 1.0f) * (this.pressure / 40.0));
                if (this.pressure < 40.0 && !this.isCreative) {
                    this.temp += Math.max(0.0, 20.0 * this.rpm / (double)this.definition.engine.maxRPM / 20.0);
                    this.hours += 0.01 * this.getTotalWearFactor();
                }
                if (this.rpm > (double)this.startRPM * 1.5 && this.temp < 30.0 && !this.isCreative) {
                    this.hours += 0.001 * (this.rpm / (double)this.startRPM - 1.0) * this.getTotalWearFactor();
                }
                if (this.temp > (double)115.556f && !this.isCreative) {
                    this.hours += 0.001 * (this.temp - (double)115.556f) * this.getTotalWearFactor();
                    if (this.temp > (double)132.222f && !this.vehicle.world.isClient()) {
                        this.explodeEngine();
                    }
                }
                if (this.hours > 100.0 && !this.vehicle.world.isClient() && Math.random() < this.hours / 1000.0 * ((double)PartEngine.getSafeRPMFromMax(this.definition.engine.maxRPM) / (this.rpm + (double)(PartEngine.getSafeRPMFromMax(this.definition.engine.maxRPM) / 2)))) {
                    this.backfireEngine();
                }
                if (!this.vehicle.world.isClient()) {
                    if (!this.vehicle.world.isClient() && this.isInLiquid()) {
                        this.stallEngine(PacketVehiclePartEngine.Signal.DROWN);
                    } else if (!this.isCreative && this.vehicle.fuelTank.getFluidLevel() == 0.0) {
                        this.stallEngine(PacketVehiclePartEngine.Signal.FUEL_OUT);
                    } else if (this.rpm < (double)this.stallRPM) {
                        this.stallEngine(PacketVehiclePartEngine.Signal.TOO_SLOW);
                    }
                }
            }
            if (this.definition.engine.isAutomatic && !this.vehicle.world.isClient() && this.currentGear > 0) {
                if (this.shiftCooldown == 0) {
                    if (this.definition.engine.upShiftRPM != null && this.definition.engine.downShiftRPM != null) {
                        if (this.rpm > (double)this.definition.engine.upShiftRPM[this.currentGear - 1] * 0.5 * (double)(1.0f + (float)this.vehicle.throttle / 100.0f)) {
                            this.shiftUp(true);
                            this.shiftCooldown = this.definition.engine.shiftSpeed;
                        } else if (this.rpm < (double)this.definition.engine.downShiftRPM[this.currentGear - 1] * 0.5 * (double)(1.0f + (float)this.vehicle.throttle / 100.0f) && this.currentGear > 1) {
                            this.shiftDown(true);
                            this.shiftCooldown = this.definition.engine.shiftSpeed;
                        }
                    } else if (this.rpm > (double)((float)PartEngine.getSafeRPMFromMax(this.definition.engine.maxRPM) * 0.5f * (1.0f + (float)this.vehicle.throttle / 100.0f))) {
                        this.shiftUp(true);
                        this.shiftCooldown = this.definition.engine.shiftSpeed;
                    } else if (this.rpm < (double)PartEngine.getSafeRPMFromMax(this.definition.engine.maxRPM) * 0.25 * (double)(1.0f + (float)this.vehicle.throttle / 100.0f) && this.currentGear > 1) {
                        this.shiftDown(true);
                        this.shiftCooldown = this.definition.engine.shiftSpeed;
                    }
                } else {
                    this.shiftCooldown = (byte)(this.shiftCooldown - 1);
                }
            }
        } else {
            if (!this.definition.engine.isSteamPowered) {
                this.pressure = 0.0;
                this.fuelFlow = 0.0;
            }
            if (this.internalFuel > 0) {
                --this.internalFuel;
                if (this.rpm < (double)this.startRPM) {
                    this.internalFuel = 0;
                }
            }
            if (this.rpm > (double)this.startRPM && !this.vehicle.world.isClient() && (this.isCreative || this.vehicle.fuelTank.getFluidLevel() > 0.0) && !this.isInLiquid() && this.state.magnetoOn) {
                this.startEngine();
            }
        }
        if (this.vehicle.definition.motorized.isFrontWheelDrive || this.vehicle.definition.motorized.isRearWheelDrive) {
            this.lowestWheelVelocity = 999.0;
            this.desiredWheelVelocity = -999.0;
            this.wheelFriction = 0.0f;
            this.engineTargetRPM = !this.state.esOn ? (double)((float)this.vehicle.throttle / 100.0f) * ((double)this.definition.engine.maxRPM - (double)this.startRPM / 1.25 - this.hours * 10.0) + (double)this.startRPM / 1.25 : (double)this.startRPM * 1.2;
            for (Object wheel : this.vehicle.wheels) {
                if (!(((PartGroundDevice)wheel).placementOffset.z > 0.0 && this.vehicle.definition.motorized.isFrontWheelDrive) && (!(((PartGroundDevice)wheel).placementOffset.z <= 0.0) || !this.vehicle.definition.motorized.isRearWheelDrive) || !((PartGroundDevice)wheel).isOnGround()) continue;
                this.wheelFriction += ((PartGroundDevice)wheel).getMotiveFriction() - ((PartGroundDevice)wheel).getFrictionLoss();
                this.lowestWheelVelocity = Math.min(((PartGroundDevice)wheel).angularVelocity, this.lowestWheelVelocity);
                this.desiredWheelVelocity = Math.max(((PartGroundDevice)wheel).getDesiredAngularVelocity(), this.desiredWheelVelocity);
            }
            if (this.currentGearRatio != 0.0f && this.starterLevel == 0) {
                if (this.wheelFriction > 0.0f) {
                    double desiredRPM = this.lowestWheelVelocity * 1200.0 * (double)this.currentGearRatio * (double)this.vehicle.definition.motorized.axleRatio;
                    this.rpm += (desiredRPM - this.rpm) / (double)this.definition.engine.revResistance;
                    if (this.rpm < (double)this.stallRPM && this.state.running) {
                        this.rpm = this.stallRPM;
                    }
                } else {
                    for (Object wheel : this.vehicle.wheels) {
                        ((PartGroundDevice)wheel).skipAngularCalcs = false;
                        if (!(((PartGroundDevice)wheel).placementOffset.z > 0.0 && this.vehicle.definition.motorized.isFrontWheelDrive) && (!(((PartGroundDevice)wheel).placementOffset.z <= 0.0) || !this.vehicle.definition.motorized.isRearWheelDrive)) continue;
                        if (this.currentGearRatio != 0.0f) {
                            ((PartGroundDevice)wheel).angularVelocity = this.rpm / (double)this.currentGearRatio / (double)this.vehicle.definition.motorized.axleRatio / 1200.0;
                            continue;
                        }
                        if (((PartGroundDevice)wheel).angularVelocity > 0.0) {
                            ((PartGroundDevice)wheel).angularVelocity = Math.max(0.0, ((PartGroundDevice)wheel).angularVelocity - 0.01);
                            continue;
                        }
                        ((PartGroundDevice)wheel).angularVelocity = Math.min(0.0, ((PartGroundDevice)wheel).angularVelocity + 0.01);
                    }
                }
            }
        }
        boolean havePropeller = false;
        for (APart part : this.childParts) {
            if (!(part instanceof PartPropeller)) continue;
            PartPropeller propeller = (PartPropeller)part;
            havePropeller = true;
            Point3d propellerThrustAxis = new Point3d(0.0, 0.0, 1.0).rotateCoarse(propeller.totalRotation.copy().add(this.vehicle.angles));
            this.propellerAxialVelocity = this.vehicle.motion.dotProduct(propellerThrustAxis);
            if (this.wheelFriction != 0.0f || this.currentGearRatio == 0.0f) continue;
            this.isPropellerInLiquid = propeller.isInLiquid();
            this.propellerGearboxRatio = this.definition.engine.propellerRatio != 0.0f ? this.definition.engine.propellerRatio : this.currentGearRatio;
            double propellerForcePenalty = Math.max(0.0f, (float)(propeller.definition.propeller.diameter - 75) / (50.0f * (this.definition.engine.fuelConsumption + this.definition.engine.superchargerFuelConsumption * this.definition.engine.superchargerEfficiency) - 15.0f));
            double propellerDesiredSpeed = 0.0254 * (double)propeller.currentPitch * this.rpm / (double)this.propellerGearboxRatio * (double)Math.signum(this.currentGearRatio) / 60.0 / 20.0;
            double propellerFeedback = (propellerDesiredSpeed - this.propellerAxialVelocity) * (double)(this.isPropellerInLiquid ? 130 : 40);
            if (this.currentGearRatio < 0.0f || propeller.currentPitch < 0) {
                propellerFeedback *= -1.0;
            }
            if (this.state.running) {
                propellerFeedback += propellerForcePenalty * 50.0;
                double engineTargetRPM = (double)((float)this.vehicle.throttle / 100.0f) * ((double)this.definition.engine.maxRPM - (double)this.startRPM * 1.25 - this.hours) + (double)this.startRPM * 1.25;
                double engineRPMDifference = engineTargetRPM - this.rpm;
                if (this.rpm + engineRPMDifference / 10.0 > (double)this.stallRPM && this.rpm + engineRPMDifference / 10.0 - propellerFeedback < (double)this.stallRPM) {
                    this.rpm = this.stallRPM;
                    continue;
                }
                this.rpm += engineRPMDifference / 10.0 - propellerFeedback;
                continue;
            }
            if (this.state.esOn || this.state.hsOn) continue;
            this.rpm -= propellerFeedback * (double)this.propellerGearboxRatio;
        }
        if (this.wheelFriction == 0.0f && !havePropeller || this.currentGearRatio == 0.0f) {
            if (this.state.running) {
                double engineTargetRPM = (double)((float)this.vehicle.throttle / 100.0f) * ((double)this.definition.engine.maxRPM - (double)this.startRPM * 1.25 - this.hours * 10.0) + (double)this.startRPM * 1.25;
                this.rpm += (engineTargetRPM - this.rpm) / (double)(this.definition.engine.revResistance * 3);
                if (this.rpm > (double)PartEngine.getSafeRPMFromMax(this.definition.engine.maxRPM) && this.definition.engine.jetPowerFactor == 0.0f) {
                    this.rpm -= Math.abs(engineTargetRPM - this.rpm) / (double)this.definition.engine.revResistance;
                }
            } else if (!this.state.esOn && !this.state.hsOn) {
                this.rpm = Math.max(this.rpm - 10.0, 0.0);
            }
        }
        if (this.definition.engine.jetPowerFactor > 0.0f) {
            Point3d engineThrustAxis = new Point3d(0.0, 0.0, 1.0).rotateCoarse(this.totalRotation.copy().add(this.vehicle.angles));
            this.engineAxialVelocity = this.vehicle.motion.dotProduct(engineThrustAxis);
            if (!this.vehicle.world.isClient() && this.rpm >= 5000.0) {
                this.boundingBox.widthRadius += 0.25;
                this.boundingBox.heightRadius += 0.25;
                this.boundingBox.depthRadius += 0.25;
                this.boundingBox.globalCenter.add(this.vehicle.headingVector);
                Damage jetIntake = new Damage("jet_intake", (double)this.definition.engine.jetPowerFactor * (Double)ConfigSystem.configObject.damage.jetDamageFactor.value * this.rpm / 1000.0, this.boundingBox, this.vehicle.getController());
                this.vehicle.world.attackEntities(jetIntake, this.vehicle, null);
                this.boundingBox.globalCenter.subtract(this.vehicle.headingVector);
                this.boundingBox.globalCenter.subtract(this.vehicle.headingVector);
                Damage jetExhaust = new Damage("jet_exhaust", (double)this.definition.engine.jetPowerFactor * (Double)ConfigSystem.configObject.damage.jetDamageFactor.value * this.rpm / 2000.0, this.boundingBox, jetIntake.attacker).setFire();
                this.vehicle.world.attackEntities(jetExhaust, this.vehicle, null);
                this.boundingBox.globalCenter.add(this.vehicle.headingVector);
                this.boundingBox.widthRadius -= 0.25;
                this.boundingBox.heightRadius -= 0.25;
                this.boundingBox.depthRadius -= 0.25;
            }
        }
        this.prevEngineRotation = this.engineRotation;
        this.engineRotation += 360.0 * this.rpm / 1200.0;
        this.prevDriveshaftRotation = this.driveshaftRotation;
        double driveshaftDesiredSpeed = -999.0;
        for (PartGroundDevice wheel : this.vehicle.wheels) {
            if (!(wheel.placementOffset.z > 0.0 && this.vehicle.definition.motorized.isFrontWheelDrive) && (!(wheel.placementOffset.z <= 0.0) || !this.vehicle.definition.motorized.isRearWheelDrive)) continue;
            driveshaftDesiredSpeed = Math.max(wheel.angularVelocity, driveshaftDesiredSpeed);
        }
        this.driveshaftRotation = driveshaftDesiredSpeed != -999.0 ? (this.driveshaftRotation += 360.0 * driveshaftDesiredSpeed * this.vehicle.SPEED_FACTOR) : (this.driveshaftRotation += 360.0 * this.rpm / 1200.0 * (double)this.currentGearRatio);
    }

    @Override
    public void remove() {
        super.remove();
        this.state = EngineStates.ENGINE_OFF;
        for (PartGroundDevice wheel : this.vehicle.wheels) {
            if (wheel.isOnGround() || !(wheel.placementOffset.z > 0.0 && this.vehicle.definition.motorized.isFrontWheelDrive) && (!(wheel.placementOffset.z <= 0.0) || !this.vehicle.definition.motorized.isRearWheelDrive)) continue;
            wheel.skipAngularCalcs = false;
        }
    }

    @Override
    public IWrapperNBT getData() {
        IWrapperNBT data = super.getData();
        data.setBoolean("isCreative", this.isCreative);
        data.setBoolean("oilLeak", this.oilLeak);
        data.setBoolean("fuelLeak", this.fuelLeak);
        data.setBoolean("brokenStarter", this.brokenStarter);
        data.setInteger("currentGear", this.currentGear);
        data.setDouble("hours", this.hours);
        data.setDouble("rpm", this.rpm);
        data.setDouble("temp", this.temp);
        data.setDouble("pressure", this.pressure);
        data.setInteger("state", (byte)this.state.ordinal());
        return data;
    }

    @Override
    public float getWidth() {
        return 1.0f;
    }

    @Override
    public float getHeight() {
        return 1.0f;
    }

    public void setMagnetoStatus(boolean on) {
        if (on) {
            if (this.state.equals((Object)EngineStates.MAGNETO_OFF_ES_ON)) {
                this.state = EngineStates.MAGNETO_ON_ES_ON;
            } else if (this.state.equals((Object)EngineStates.MAGNETO_OFF_HS_ON)) {
                this.state = EngineStates.MAGNETO_ON_HS_ON;
            } else if (this.state.equals((Object)EngineStates.ENGINE_OFF)) {
                this.state = EngineStates.MAGNETO_ON_STARTERS_OFF;
            }
        } else if (this.state.equals((Object)EngineStates.MAGNETO_ON_ES_ON)) {
            this.state = EngineStates.MAGNETO_OFF_ES_ON;
        } else if (this.state.equals((Object)EngineStates.MAGNETO_ON_HS_ON)) {
            this.state = EngineStates.MAGNETO_OFF_HS_ON;
        } else if (this.state.equals((Object)EngineStates.MAGNETO_ON_STARTERS_OFF)) {
            this.state = EngineStates.ENGINE_OFF;
        } else if (this.state.equals((Object)EngineStates.RUNNING)) {
            this.state = EngineStates.ENGINE_OFF;
            this.internalFuel = 100;
            if (this.vehicle.world.isClient()) {
                MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, this.definition.packID + ":" + this.definition.systemName + "_stopping"));
            }
        }
    }

    public void setElectricStarterStatus(boolean engaged) {
        if (!this.brokenStarter) {
            if (engaged) {
                if (this.state.equals((Object)EngineStates.ENGINE_OFF)) {
                    this.state = EngineStates.MAGNETO_OFF_ES_ON;
                } else if (this.state.equals((Object)EngineStates.MAGNETO_ON_STARTERS_OFF)) {
                    this.state = EngineStates.MAGNETO_ON_ES_ON;
                    if (this.vehicle.world.isClient()) {
                        MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, this.definition.packID + ":" + this.definition.systemName + "_cranking", true));
                    }
                } else if (this.state.equals((Object)EngineStates.RUNNING)) {
                    this.state = EngineStates.RUNNING_ES_ON;
                    if (this.vehicle.world.isClient()) {
                        MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, this.definition.packID + ":" + this.definition.systemName + "_cranking", true));
                    }
                }
            } else if (this.state.equals((Object)EngineStates.MAGNETO_OFF_ES_ON)) {
                this.state = EngineStates.ENGINE_OFF;
            } else if (this.state.equals((Object)EngineStates.MAGNETO_ON_ES_ON)) {
                this.state = EngineStates.MAGNETO_ON_STARTERS_OFF;
            } else if (this.state.equals((Object)EngineStates.RUNNING_ES_ON)) {
                this.state = EngineStates.RUNNING;
            }
        }
    }

    public void startEngine() {
        if (this.state.equals((Object)EngineStates.MAGNETO_ON_STARTERS_OFF)) {
            this.state = EngineStates.RUNNING;
        } else if (this.state.equals((Object)EngineStates.MAGNETO_ON_ES_ON)) {
            this.state = EngineStates.RUNNING_ES_ON;
        } else if (this.state.equals((Object)EngineStates.MAGNETO_ON_HS_ON)) {
            this.state = EngineStates.RUNNING;
        }
        this.starterLevel = 0;
        if (!this.definition.engine.isSteamPowered) {
            this.pressure = 60.0;
        }
        if (!this.vehicle.world.isClient()) {
            MasterLoader.networkInterface.sendToAllClients(new PacketVehiclePartEngine(this, PacketVehiclePartEngine.Signal.START));
        } else {
            MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, this.definition.packID + ":" + this.definition.systemName + "_starting"));
            if (this.definition.engine.customSoundset != null) {
                for (JSONPart.JSONPartEngine.EngineSound soundDefinition : this.definition.engine.customSoundset) {
                    MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, soundDefinition.soundName, true));
                }
            } else if (this.internalFuel == 0) {
                MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, this.definition.packID + ":" + this.definition.systemName + "_running", true));
                MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, this.definition.packID + ":" + this.definition.systemName + "_supercharger", true));
            }
        }
    }

    public void handStartEngine() {
        if (this.state.equals((Object)EngineStates.ENGINE_OFF)) {
            this.state = EngineStates.MAGNETO_OFF_HS_ON;
        } else if (this.state.equals((Object)EngineStates.MAGNETO_ON_STARTERS_OFF)) {
            this.state = EngineStates.MAGNETO_ON_HS_ON;
        } else if (this.state.equals((Object)EngineStates.RUNNING)) {
            this.state = EngineStates.RUNNING_HS_ON;
        } else {
            return;
        }
        this.starterLevel = (byte)(this.starterLevel + 4);
        if (this.vehicle.world.isClient()) {
            MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, this.definition.packID + ":" + this.definition.systemName + "_cranking", true));
        }
    }

    public void stallEngine(PacketVehiclePartEngine.Signal signal) {
        if (this.state.equals((Object)EngineStates.RUNNING)) {
            this.state = EngineStates.MAGNETO_ON_STARTERS_OFF;
        } else if (this.state.equals((Object)EngineStates.RUNNING_ES_ON)) {
            this.state = EngineStates.MAGNETO_ON_ES_ON;
        } else if (this.state.equals((Object)EngineStates.RUNNING_HS_ON)) {
            this.state = EngineStates.MAGNETO_ON_HS_ON;
        }
        if (this.vehicle.world.isClient() && !signal.equals((Object)PacketVehiclePartEngine.Signal.DROWN)) {
            this.internalFuel = 100;
        }
        if (!this.vehicle.world.isClient()) {
            MasterLoader.networkInterface.sendToAllClients(new PacketVehiclePartEngine(this, signal));
        } else {
            MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, this.definition.packID + ":" + this.definition.systemName + "_stopping"));
        }
    }

    public void backfireEngine() {
        this.rpm -= this.definition.engine.maxRPM < 15000 ? 100.0 : 500.0;
        if (!this.vehicle.world.isClient()) {
            MasterLoader.networkInterface.sendToAllClients(new PacketVehiclePartEngine(this, PacketVehiclePartEngine.Signal.BACKFIRE));
        } else {
            MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, this.definition.packID + ":" + this.definition.systemName + "_sputter"));
            this.backfired = true;
        }
    }

    protected void explodeEngine() {
        if (((Boolean)ConfigSystem.configObject.damage.explosions.value).booleanValue()) {
            this.vehicle.world.spawnExplosion(this.vehicle, this.worldPos, 1.0, true);
        } else {
            this.vehicle.world.spawnExplosion(this.vehicle, this.worldPos, 0.0, false);
        }
        this.isValid = false;
    }

    public float getGearshiftRotation() {
        return this.definition.engine.isAutomatic ? (float)Math.min(1, this.currentGear) * 15.0f : (float)(this.currentGear * 5);
    }

    public float getGearshiftPosition_Vertical() {
        if (this.currentGear < 0) {
            return this.definition.engine.gearRatios.length % 2 == 0 ? 15.0f : -15.0f;
        }
        if (this.currentGear == 0) {
            return 0.0f;
        }
        return this.currentGear % 2 == 0 ? -15.0f : 15.0f;
    }

    public float getGearshiftPosition_Horizontal() {
        float columnAngleDelta;
        int columns = this.definition.engine.gearRatios.length / 2;
        int firstColumnAngle = columns / 2 * -5;
        float f = columnAngleDelta = columns != 1 ? (float)(-firstColumnAngle * 2 / (columns - 1)) : 0.0f;
        if (this.currentGear < 0) {
            return -firstColumnAngle;
        }
        if (this.currentGear == 0) {
            return 0.0f;
        }
        return (float)firstColumnAngle + (float)((this.currentGear - 1) / 2) * columnAngleDelta;
    }

    public void shiftUp(boolean autoShift) {
        byte nextGear = 0;
        boolean doShift = false;
        if (this.currentGear < 0) {
            doShift = true;
            nextGear = !autoShift ? (byte)0 : (byte)(this.currentGear + 1);
        } else if (this.currentGear == 0) {
            nextGear = 1;
            doShift = this.vehicle.axialVelocity < 0.35 || this.wheelFriction == 0.0f || !this.vehicle.goingInReverse;
        } else if (this.currentGear < this.definition.engine.gearRatios.length - (1 + this.reverseGears)) {
            doShift = !this.definition.engine.isAutomatic || autoShift && !this.vehicle.world.isClient();
            nextGear = (byte)(this.currentGear + 1);
        }
        if (doShift || this.vehicle.world.isClient()) {
            this.currentGear = nextGear;
            if (!this.vehicle.world.isClient()) {
                MasterLoader.networkInterface.sendToAllClients(new PacketVehicleControlDigital(this.vehicle, PacketVehicleControlDigital.Controls.SHIFT_UP, autoShift));
            }
        } else if (!this.vehicle.world.isClient() && !autoShift && this.currentGear <= 0) {
            MasterLoader.networkInterface.sendToAllClients(new PacketVehiclePartEngine(this, PacketVehiclePartEngine.Signal.BAD_SHIFT));
        }
    }

    public void shiftDown(boolean autoShift) {
        int nextGear = 0;
        boolean doShift = false;
        if (this.currentGear >= 1) {
            doShift = true;
            nextGear = (byte)(this.definition.engine.isAutomatic && !autoShift ? 0 : (byte)(this.currentGear - 1));
        } else if (this.currentGear == 0) {
            nextGear = -1;
            doShift = this.vehicle.axialVelocity < 0.35 || this.wheelFriction == 0.0f || this.vehicle.goingInReverse;
        } else if (this.currentGear + this.reverseGears > 0) {
            doShift = true;
            nextGear = (byte)(this.currentGear - 1);
        }
        if (doShift || this.vehicle.world.isClient()) {
            this.currentGear = (byte)nextGear;
            if (!this.vehicle.world.isClient()) {
                MasterLoader.networkInterface.sendToAllClients(new PacketVehicleControlDigital(this.vehicle, PacketVehicleControlDigital.Controls.SHIFT_DN, autoShift));
            }
            if (this.currentGear == -1 && this.vehicle.definition.motorized.isBigTruck && this.vehicle.world.isClient()) {
                MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, MasterLoader.resourceDomain + ":backup_beeper", true));
            }
        } else if (!this.vehicle.world.isClient() && !autoShift && this.currentGear >= 0) {
            MasterLoader.networkInterface.sendToAllClients(new PacketVehiclePartEngine(this, PacketVehiclePartEngine.Signal.BAD_SHIFT));
        }
    }

    public static int getSafeRPMFromMax(int maxRPM) {
        return maxRPM < 15000 ? maxRPM - (maxRPM - 2500) / 2 : (int)((double)maxRPM / 1.1);
    }

    public float getTotalFuelConsumption() {
        return this.definition.engine.fuelConsumption + this.definition.engine.superchargerFuelConsumption;
    }

    public double getTotalWearFactor() {
        if (this.definition.engine.superchargerEfficiency > 1.0f) {
            return (double)this.definition.engine.superchargerEfficiency * (Double)ConfigSystem.configObject.general.engineHoursFactor.value;
        }
        return (Double)ConfigSystem.configObject.general.engineHoursFactor.value;
    }

    public double getEngineRotation(float partialTicks) {
        return this.engineRotation + (this.engineRotation - this.prevEngineRotation) * (double)partialTicks;
    }

    public double getDriveshaftRotation(float partialTicks) {
        return this.driveshaftRotation + (this.driveshaftRotation - this.prevDriveshaftRotation) * (double)partialTicks;
    }

    public Point3d getForceOutput() {
        this.engineForce.set(0.0, 0.0, 0.0);
        if (this.wheelFriction != 0.0f) {
            double wheelForce = 0.0;
            if (this.state.running || this.state.esOn) {
                wheelForce = (this.engineTargetRPM - this.rpm) / (double)this.definition.engine.maxRPM * (double)this.currentGearRatio * (double)this.vehicle.definition.motorized.axleRatio * (double)(this.definition.engine.fuelConsumption + this.definition.engine.superchargerFuelConsumption * this.definition.engine.superchargerEfficiency) * (double)0.6f * 30.0;
                if (Math.abs(wheelForce / 300.0) > (double)this.wheelFriction || Math.abs(this.lowestWheelVelocity) - Math.abs(this.desiredWheelVelocity) > 0.1 && Math.abs(this.lowestWheelVelocity) - Math.abs(this.desiredWheelVelocity) < Math.abs(wheelForce / 300.0)) {
                    wheelForce *= this.vehicle.currentMass / 100000.0 * (double)this.wheelFriction / Math.abs(wheelForce / 300.0);
                    for (PartGroundDevice wheel : this.vehicle.wheels) {
                        if (!(wheel.placementOffset.z > 0.0 && this.vehicle.definition.motorized.isFrontWheelDrive) && (!(wheel.placementOffset.z <= 0.0) || !this.vehicle.definition.motorized.isRearWheelDrive)) continue;
                        wheel.angularVelocity = this.currentGearRatio > 0.0f ? (wheelForce >= 0.0 ? Math.min(this.engineTargetRPM / 1200.0 / (double)this.currentGearRatio / (double)this.vehicle.definition.motorized.axleRatio, wheel.angularVelocity + 0.01) : Math.min(this.engineTargetRPM / 1200.0 / (double)this.currentGearRatio / (double)this.vehicle.definition.motorized.axleRatio, wheel.angularVelocity - 0.01)) : (wheelForce >= 0.0 ? Math.max(this.engineTargetRPM / 1200.0 / (double)this.currentGearRatio / (double)this.vehicle.definition.motorized.axleRatio, wheel.angularVelocity - 0.01) : Math.max(this.engineTargetRPM / 1200.0 / (double)this.currentGearRatio / (double)this.vehicle.definition.motorized.axleRatio, wheel.angularVelocity + 0.01));
                        wheel.skipAngularCalcs = true;
                    }
                } else {
                    for (PartGroundDevice wheel : this.vehicle.wheels) {
                        wheel.skipAngularCalcs = false;
                        if (wheel.isOnGround() || !(wheel.placementOffset.z > 0.0 && this.vehicle.definition.motorized.isFrontWheelDrive) && (!(wheel.placementOffset.z <= 0.0) || !this.vehicle.definition.motorized.isRearWheelDrive)) continue;
                        wheel.angularVelocity = this.lowestWheelVelocity;
                    }
                }
                if ((wheelForce < 0.0 && this.currentGear > 0 || wheelForce > 0.0 && this.currentGear < 0) && this.vehicle.velocity < 0.25) {
                    wheelForce = 0.0;
                }
            } else {
                wheelForce = -this.rpm / (double)this.definition.engine.maxRPM * (double)Math.signum(this.currentGear) * 30.0;
            }
            this.engineForce.z += wheelForce;
        }
        if (this.definition.engine.jetPowerFactor > 0.0f && this.state.running) {
            double safeRPMFactor = this.rpm / (double)PartEngine.getSafeRPMFromMax(this.definition.engine.maxRPM);
            double coreContribution = Math.max(10.0 * this.vehicle.airDensity * (double)this.definition.engine.fuelConsumption * safeRPMFactor - (double)this.definition.engine.bypassRatio, 0.0);
            double fanVelocityFactor = (6.35 * this.rpm / 60.0 / 20.0 - this.engineAxialVelocity) / 200.0;
            double fanContribution = 10.0 * this.vehicle.airDensity * safeRPMFactor * fanVelocityFactor * (double)this.definition.engine.bypassRatio;
            double thrust = (this.vehicle.reverseThrust ? -(coreContribution + fanContribution) : coreContribution + fanContribution) * (double)this.definition.engine.jetPowerFactor;
            this.engineForce.add(new Point3d(0.0, 0.0, thrust).rotateCoarse(this.totalRotation));
        }
        return this.engineForce;
    }

    @Override
    public void updateProviderSound(SoundInstance sound) {
        super.updateProviderSound(sound);
        if (sound.soundName.endsWith("_cranking")) {
            if (!this.state.esOn && !this.state.hsOn) {
                sound.stop();
            } else {
                sound.pitch = this.definition.engine.isCrankingNotPitched ? (float)Math.min(1.0, (this.vehicle.electricPower + 3.0) / 10.0) : (float)(this.rpm / (double)this.startRPM);
            }
        } else if (sound.soundName.endsWith("backup_beeper")) {
            if (this.currentGear >= 0) {
                sound.stop();
            } else {
                sound.volume = this.state.running ? 1.0f : 0.0f;
            }
        } else if (this.definition.engine.customSoundset != null) {
            for (JSONPart.JSONPartEngine.EngineSound soundDefinition : this.definition.engine.customSoundset) {
                double rpmPercentOfMax = Math.max(0.0, (this.rpm - (double)this.startRPM) / (double)this.definition.engine.maxRPM);
                float customPitch = soundDefinition.pitchAdvanced ? (float)Math.max(-1.0E-6 / (double)(soundDefinition.pitchLength / 1000.0f) * Math.pow(this.rpm - (double)soundDefinition.pitchCenter, 2.0) + (double)(soundDefinition.pitchLength / 20000.0f) + 1.0, 0.0) : (float)Math.max((double)(soundDefinition.pitchMax - soundDefinition.pitchIdle) * rpmPercentOfMax + (double)soundDefinition.pitchIdle, 0.0);
                float customVolume = soundDefinition.volumeAdvanced ? (float)Math.max(-1.0E-6 / (double)(soundDefinition.volumeLength / 1000.0f) * Math.pow(this.rpm - (double)soundDefinition.volumeCenter, 2.0) + (double)(soundDefinition.volumeLength / 20000.0f) + 1.0, 0.0) : (float)Math.max((double)(soundDefinition.volumeMax - soundDefinition.volumeIdle) * rpmPercentOfMax + (double)soundDefinition.volumeIdle, 0.0);
                if (!sound.soundName.equals(soundDefinition.soundName)) continue;
                if (!this.state.running && this.internalFuel == 0) {
                    sound.stop();
                    continue;
                }
                sound.pitch = customPitch;
                sound.volume = customVolume;
            }
        } else if (sound.soundName.endsWith("_running")) {
            if (!this.state.running && this.internalFuel == 0) {
                sound.stop();
            } else {
                sound.pitch = this.definition.engine.isSteamPowered ? 1.0f : (float)(0.35 * (1.0 + Math.max(0.0, this.rpm - (double)this.startRPM) / (double)(this.definition.engine.maxRPM < 15000 ? 500 : 5000)));
            }
        } else if (sound.soundName.endsWith("_supercharger")) {
            if (!this.state.running && this.internalFuel == 0) {
                sound.stop();
            } else {
                sound.volume = (float)this.rpm / (float)this.definition.engine.maxRPM;
                sound.pitch = this.definition.engine.isSteamPowered ? 1.0f : (float)(0.35 * (1.0 + Math.max(0.0, this.rpm - (double)this.startRPM) / (double)(this.definition.engine.maxRPM < 15000 ? 500 : 5000)));
            }
        } else if (sound.soundName.endsWith("_piston")) {
            sound.pitch = (float)(0.35 * (1.0 + Math.max(0.0, this.rpm - (double)this.startRPM) / 500.0));
        }
    }

    @Override
    public void startSounds() {
        if (this.state.running) {
            if (this.definition.engine.customSoundset != null) {
                for (JSONPart.JSONPartEngine.EngineSound soundDefinition : this.definition.engine.customSoundset) {
                    MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, soundDefinition.soundName, true));
                }
            } else {
                MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, this.definition.packID + ":" + this.definition.systemName + "_running", true));
                MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, this.definition.packID + ":" + this.definition.systemName + "_supercharger", true));
            }
        }
        if (this.state.esOn || this.state.hsOn) {
            MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, this.definition.packID + ":" + this.definition.systemName + "_cranking", true));
        }
        if (this.currentGear < 0 && this.vehicle.definition.motorized.isBigTruck) {
            MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, MasterLoader.resourceDomain + ":backup_beeper", true));
        }
    }

    @Override
    public void spawnParticles() {
        if (this.vehicleDefinition.exhaustObjects != null && (this.state.running || this.definition.engine.flamesOnStartup && this.state.esOn)) {
            long engineCycleTimeMills = (long)(2.0 * (1.0 / (this.rpm / 60.0 / 1000.0)));
            long currentTime = System.currentTimeMillis();
            if (engineCycleTimeMills != 0L) {
                long camTime = currentTime % engineCycleTimeMills;
                float particleColor = this.definition.engine.isSteamPowered ? 0.0f : (float)Math.max(1.0 - this.temp / 30.0, 0.0);
                boolean singleExhaust = this.vehicleDefinition.exhaustObjects.size() == 1;
                for (JSONVehicle.VehiclePart.ExhaustObject exhaust : this.vehicleDefinition.exhaustObjects) {
                    if (singleExhaust) {
                        if (this.lastTimeParticleSpawned + camTime > currentTime) {
                            continue;
                        }
                    } else {
                        long camOffset = engineCycleTimeMills / (long)this.vehicleDefinition.exhaustObjects.size();
                        long camMin = (long)this.vehicleDefinition.exhaustObjects.indexOf(exhaust) * camOffset;
                        long camMax = camMin + camOffset;
                        if (camTime < camMin || camTime > camMax || this.lastTimeParticleSpawned > camMin && this.lastTimeParticleSpawned < camMax) continue;
                    }
                    Point3d exhaustOffset = exhaust.pos.copy().rotateFine(this.vehicle.angles).add(this.vehicle.position);
                    Point3d velocityOffset = exhaust.velocity.copy().rotateFine(this.vehicle.angles);
                    velocityOffset.x = velocityOffset.x / 10.0 + 0.02 - Math.random() * 0.04;
                    velocityOffset.y /= 10.0;
                    velocityOffset.z = velocityOffset.z / 10.0 + 0.02 - Math.random() * 0.04;
                    if (this.state.running) {
                        MasterLoader.renderInterface.spawnParticle(new ParticleSmoke(this.vehicle.world, exhaustOffset, velocityOffset, particleColor, particleColor, particleColor, (float)Math.min((50.0 + this.hours) / 500.0, 1.0), exhaust.scale));
                        if (this.definition.engine.isSteamPowered) {
                            MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, this.definition.packID + ":" + this.definition.systemName + "_piston"));
                        }
                    }
                    if (this.definition.engine.flamesOnStartup && this.state.esOn) {
                        MasterLoader.renderInterface.spawnParticle(new ParticleFlame(this.vehicle.world, exhaustOffset, velocityOffset, 1.0f));
                    }
                    this.lastTimeParticleSpawned = singleExhaust ? currentTime : camTime;
                }
            }
        }
        if (this.backfired) {
            this.backfired = false;
            if (this.vehicleDefinition.exhaustObjects != null) {
                for (JSONVehicle.VehiclePart.ExhaustObject exhaust : this.vehicleDefinition.exhaustObjects) {
                    Point3d exhaustOffset = exhaust.pos.copy().rotateFine(this.vehicle.angles).add(this.vehicle.position);
                    Point3d velocityOffset = exhaust.velocity.copy().rotateFine(this.vehicle.angles);
                    velocityOffset.x = velocityOffset.x / 10.0 + 0.07 - Math.random() * 0.14;
                    velocityOffset.y /= 10.0;
                    velocityOffset.z = velocityOffset.z / 10.0 + 0.07 - Math.random() * 0.14;
                    for (int j = 0; j < 5; j = (int)((byte)(j + 1))) {
                        MasterLoader.renderInterface.spawnParticle(new ParticleSmoke(this.vehicle.world, exhaustOffset, velocityOffset, 0.0f, 0.0f, 0.0f, 1.0f, exhaust.scale * 2.5f));
                    }
                }
            } else {
                for (int i = 0; i < 5; i = (int)((byte)(i + 1))) {
                    MasterLoader.renderInterface.spawnParticle(new ParticleSmoke(this.vehicle.world, this.worldPos.copy(), new Point3d(0.07 - Math.random() * 0.14, 0.15, 0.07 - Math.random() * 0.14), 0.0f, 0.0f, 0.0f, 1.0f, 2.5f));
                }
            }
        }
        if (this.oilLeak && this.vehicle.ticksExisted % 20L == 0L) {
            MasterLoader.renderInterface.spawnParticle(new ParticleDrip(this.vehicle.world, this.worldPos.copy(), this.vehicle.motion.copy(), 0.0f, 0.0f, 0.0f, 1.0f));
        }
        if (this.fuelLeak && (this.vehicle.ticksExisted + 5L) % 20L == 0L) {
            MasterLoader.renderInterface.spawnParticle(new ParticleDrip(this.vehicle.world, this.worldPos.copy(), this.vehicle.motion.copy(), 1.0f, 0.0f, 0.0f, 1.0f));
        }
        if (!this.definition.engine.isSteamPowered && this.temp > (double)115.556f) {
            Point3d velocityOffset = this.vehicle.motion.copy().rotateFine(this.vehicle.angles);
            velocityOffset.x = velocityOffset.x / 10.0 + 0.02 - Math.random() * 0.04;
            velocityOffset.y /= 10.0;
            velocityOffset.z = velocityOffset.z / 10.0 + 0.02 - Math.random() * 0.04;
            MasterLoader.renderInterface.spawnParticle(new ParticleSmoke(this.vehicle.world, this.worldPos.copy(), velocityOffset, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f));
            if (this.temp > (double)121.111f) {
                MasterLoader.renderInterface.spawnParticle(new ParticleSmoke(this.vehicle.world, this.worldPos.copy(), velocityOffset, 0.0f, 0.0f, 0.0f, 1.0f, 2.5f));
            }
        }
    }

    public static enum EngineStates {
        ENGINE_OFF(false, false, false, false),
        MAGNETO_ON_STARTERS_OFF(true, false, false, false),
        MAGNETO_OFF_ES_ON(false, true, false, false),
        MAGNETO_OFF_HS_ON(false, false, true, false),
        MAGNETO_ON_ES_ON(true, true, false, false),
        MAGNETO_ON_HS_ON(true, false, true, false),
        RUNNING(true, false, false, true),
        RUNNING_ES_ON(true, true, false, true),
        RUNNING_HS_ON(true, false, true, true);

        public final boolean magnetoOn;
        public final boolean esOn;
        public final boolean hsOn;
        public final boolean running;

        private EngineStates(boolean magnetoOn, boolean esOn, boolean hsOn, boolean running) {
            this.magnetoOn = magnetoOn;
            this.esOn = esOn;
            this.hsOn = hsOn;
            this.running = running;
        }
    }
}

