/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.parts;

import java.util.Iterator;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.items.instances.ItemPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperBlock;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketVehiclePartGroundDevice;
import minecrafttransportsimulator.rendering.components.IVehiclePartFXProvider;
import minecrafttransportsimulator.rendering.instances.ParticleSmoke;
import minecrafttransportsimulator.sound.SoundInstance;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartGroundDeviceFake;

public class PartGroundDevice
extends APart
implements IVehiclePartFXProvider {
    public static final Point3d groundDetectionOffset = new Point3d(0.0, -0.05f, 0.0);
    public boolean skipAngularCalcs = false;
    public double angularPosition;
    public double angularVelocity;
    private boolean isFlat;
    private boolean contactThisTick = false;
    private int ticksCalcsSkipped = 0;
    private double prevAngularVelocity;
    private final PartGroundDeviceFake fakePart;

    public PartGroundDevice(EntityVehicleF_Physics vehicle, JSONVehicle.VehiclePart packVehicleDef, ItemPart item, IWrapperNBT data, APart parentPart) {
        super(vehicle, packVehicleDef, item, data, parentPart);
        this.isFlat = data.getBoolean("isFlat");
        if (!this.isFake() && this.getLongPartOffset() != 0.0f) {
            Point3d actualPlacement = packVehicleDef.pos;
            packVehicleDef.pos = packVehicleDef.pos.copy().add(0.0, 0.0, this.getLongPartOffset());
            this.fakePart = new PartGroundDeviceFake(this, packVehicleDef, item, data, null);
            packVehicleDef.pos = actualPlacement;
            if (vehicle.partSlotBoxes != null) {
                vehicle.addPart(this.fakePart);
            } else {
                vehicle.partsFromNBT.add(this.fakePart);
            }
        } else {
            this.fakePart = null;
        }
    }

    @Override
    public void attack(Damage damage) {
        if (damage.isExplosion || Math.random() < 0.5) {
            this.setFlatState(true);
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.isOnGround()) {
            if (!this.skipAngularCalcs) {
                this.prevAngularVelocity = this.angularVelocity;
                this.angularVelocity = this.getDesiredAngularVelocity();
            }
            if (this.definition.ground.isWheel) {
                IWrapperBlock blockBelow;
                if (this.prevAngularVelocity / (this.vehicle.groundVelocity / ((double)this.getHeight() * Math.PI)) < 0.25 && this.vehicle.velocity > 0.3 && (blockBelow = this.vehicle.world.getWrapperBlock(new Point3i((int)this.worldPos.x, (int)this.worldPos.y - 1, (int)this.worldPos.z))) != null && (double)blockBelow.getHardness() >= 1.25) {
                    this.contactThisTick = true;
                }
                if (!this.vehicle.world.isClient() && !this.isFlat) {
                    if (!this.skipAngularCalcs) {
                        if (this.ticksCalcsSkipped > 0) {
                            --this.ticksCalcsSkipped;
                        }
                    } else {
                        ++this.ticksCalcsSkipped;
                        if (Math.random() * 50000.0 < (double)this.ticksCalcsSkipped) {
                            this.setFlatState(true);
                        }
                    }
                }
            }
            if (!this.vehicle.world.isClient() && this.vehicle.velocity >= (Double)ConfigSystem.configObject.damage.wheelDamageMinimumVelocity.value) {
                this.boundingBox.widthRadius += 0.25;
                this.boundingBox.depthRadius += 0.25;
                double wheelDamageAmount = (Boolean)ConfigSystem.configObject.damage.wheelDamageIgnoreVelocity.value == false ? (Double)ConfigSystem.configObject.damage.wheelDamageFactor.value * this.vehicle.velocity * this.vehicle.currentMass / 1000.0 : (Double)ConfigSystem.configObject.damage.wheelDamageFactor.value * this.vehicle.currentMass / 1000.0;
                Damage wheelDamage = new Damage("wheel", wheelDamageAmount, this.boundingBox, this.vehicle.getController());
                this.vehicle.world.attackEntities(wheelDamage, this.vehicle, null);
                this.boundingBox.widthRadius -= 0.25;
                this.boundingBox.depthRadius -= 0.25;
            }
        } else if (this.placementOffset.z > 0.0 && !this.vehicle.definition.motorized.isFrontWheelDrive || this.placementOffset.z <= 0.0 && !this.vehicle.definition.motorized.isRearWheelDrive) {
            if (this.vehicle.brakeOn || this.vehicle.parkingBrakeOn) {
                this.angularVelocity = 0.0;
            } else if (this.angularVelocity > 0.0) {
                this.angularVelocity = (float)Math.max(this.angularVelocity - 0.05, 0.0);
            }
        }
        this.angularPosition += this.angularVelocity;
    }

    @Override
    public void remove() {
        super.remove();
        if (this.fakePart != null) {
            this.fakePart.isValid = false;
            this.vehicle.removePart((APart)this.fakePart, (Iterator)null);
        }
    }

    @Override
    public IWrapperNBT getData() {
        IWrapperNBT data = super.getData();
        data.setBoolean("isFlat", this.isFlat);
        return data;
    }

    @Override
    public ItemPart getItem() {
        return this.isFlat ? null : super.getItem();
    }

    @Override
    public float getWidth() {
        return this.definition.ground.width;
    }

    @Override
    public float getHeight() {
        return this.isFlat ? this.definition.ground.height / 2.0f : this.definition.ground.height;
    }

    @Override
    public Point3d getActionRotation(float partialTicks) {
        double xRotation = this.definition.ground.isWheel ? this.vehicle.SPEED_FACTOR * (this.angularPosition + this.angularVelocity * (double)partialTicks) * 360.0 : 0.0;
        double yRotation = this.vehicleDefinition.turnsWithSteer && this.definition.ground.extraCollisionBoxOffset == 0.0f ? (double)(-this.vehicle.rudderAngle) / 10.0 * Math.signum(this.totalOffset.z) : 0.0;
        return new Point3d(xRotation, yRotation, 0.0);
    }

    public void setFlatState(boolean flat) {
        if (this.vehicle.world.isClient()) {
            if (flat) {
                MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, MasterLoader.resourceDomain + ":wheel_blowout"));
            }
        } else {
            if (flat ? this.isFlat || !this.definition.ground.canGoFlat || (Boolean)ConfigSystem.configObject.damage.wheelBreakage.value == false : !this.isFlat) {
                return;
            }
            MasterLoader.networkInterface.sendToAllClients(new PacketVehiclePartGroundDevice(this, flat));
        }
        this.isFlat = flat;
        this.boundingBox.heightRadius = (double)this.getHeight() / 2.0;
    }

    public boolean getFlatState() {
        return this.isFlat;
    }

    public float getFrictionLoss() {
        Point3i groundPosition = new Point3i((int)this.worldPos.x, (int)this.worldPos.y - 1, (int)this.worldPos.z);
        IWrapperBlock groundBlock = this.vehicle.world.getWrapperBlock(groundPosition);
        if (groundBlock != null) {
            return 0.6f - groundBlock.getSlipperiness() + (groundBlock.isRaining() ? 0.25f : 0.0f);
        }
        return 0.0f;
    }

    public double getDesiredAngularVelocity() {
        if (this.vehicle.goingInReverse) {
            return this.getLongPartOffset() == 0.0f ? -this.vehicle.groundVelocity / ((double)this.getHeight() * Math.PI) : -this.vehicle.groundVelocity;
        }
        return this.getLongPartOffset() == 0.0f ? this.vehicle.groundVelocity / ((double)this.getHeight() * Math.PI) : this.vehicle.groundVelocity;
    }

    public boolean isOnGround() {
        return this.boundingBox.updateCollidingBlocks(this.vehicle.world, groundDetectionOffset);
    }

    public float getMotiveFriction() {
        return !this.isFlat ? this.definition.ground.motiveFriction : this.definition.ground.motiveFriction / 10.0f;
    }

    public float getLateralFriction() {
        return !this.isFlat ? this.definition.ground.lateralFriction : this.definition.ground.lateralFriction / 10.0f;
    }

    public float getLongPartOffset() {
        return this.vehicleDefinition.extraCollisionBoxOffset != 0.0f ? this.vehicleDefinition.extraCollisionBoxOffset : this.definition.ground.extraCollisionBoxOffset;
    }

    @Override
    public void spawnParticles() {
        int i;
        if (this.contactThisTick) {
            for (i = 0; i < 4; i = (int)((byte)(i + 1))) {
                MasterLoader.renderInterface.spawnParticle(new ParticleSmoke(this.vehicle.world, this.worldPos, new Point3d(Math.random() * 0.1 - 0.05, 0.15, Math.random() * 0.1 - 0.05), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f));
            }
            MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, MasterLoader.resourceDomain + ":wheel_striking"));
            this.contactThisTick = false;
        }
        if (this.skipAngularCalcs && this.isOnGround()) {
            for (i = 0; i < 4; i = (int)((byte)(i + 1))) {
                MasterLoader.renderInterface.spawnParticle(new ParticleSmoke(this.vehicle.world, this.worldPos, new Point3d(Math.random() * 0.1 - 0.05, 0.15, Math.random() * 0.1 - 0.05), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f));
            }
        }
    }
}

