/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.parts;

import java.util.Iterator;
import java.util.List;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.items.instances.ItemPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperInventory;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartInteractable;

public class PartGroundEffector
extends APart {
    protected final Point3i[] lastBlocksModified;
    protected final Point3i[] affectedBlocks;

    public PartGroundEffector(EntityVehicleF_Physics vehicle, JSONVehicle.VehiclePart packVehicleDef, ItemPart item, IWrapperNBT data, APart parentPart) {
        super(vehicle, packVehicleDef, item, data, parentPart);
        this.lastBlocksModified = new Point3i[this.definition.effector.blocksWide];
        this.affectedBlocks = new Point3i[this.definition.effector.blocksWide];
    }

    @Override
    public void update() {
        int i;
        super.update();
        int startingIndex = -this.definition.effector.blocksWide / 2;
        for (i = 0; i < this.definition.effector.blocksWide; ++i) {
            int xOffset = startingIndex + i;
            Point3d partAffectorPosition = new Point3d(xOffset, 0.0, 0.0).rotateCoarse(this.totalRotation).add(this.worldPos);
            this.affectedBlocks[i] = new Point3i(partAffectorPosition);
            if (!this.definition.effector.type.equals("planter") && !this.definition.effector.type.equals("plow")) continue;
            this.affectedBlocks[i].add(0, -1, 0);
        }
        for (i = 0; i < this.affectedBlocks.length; i = (int)((byte)(i + 1))) {
            if (this.affectedBlocks[i].equals(this.lastBlocksModified[i])) continue;
            switch (this.definition.effector.type) {
                case "fertilizer": {
                    IWrapperInventory inventory;
                    block14: for (Object part : this.vehicle.parts) {
                        if (!(part instanceof PartInteractable) || (inventory = ((PartInteractable)part).inventory) == null || !((APart)part).definition.interactable.feedsVehicles) continue;
                        for (int j = 0; j < inventory.getSize(); ++j) {
                            if (!this.vehicle.world.fertilizeBlock(this.affectedBlocks[i], inventory.getStackInSlot(j))) continue;
                            inventory.decrementSlot(j);
                            continue block14;
                        }
                    }
                }
                case "harvester": {
                    List<IWrapperItemStack> drops = this.vehicle.world.harvestBlock(this.affectedBlocks[i]);
                    if (drops != null) {
                        Object part;
                        block16: for (APart part2 : this.vehicle.parts) {
                            IWrapperInventory inventory;
                            if (!(part2 instanceof PartInteractable) || (inventory = ((PartInteractable)part2).inventory) == null) continue;
                            Iterator<IWrapperItemStack> iterator = drops.iterator();
                            while (iterator.hasNext()) {
                                IWrapperItemStack stack = iterator.next();
                                if (!inventory.addStack(stack)) continue;
                                iterator.remove();
                                continue block16;
                            }
                        }
                        part = drops.iterator();
                        while (part.hasNext()) {
                            IWrapperItemStack stack = part.next();
                            if (stack.getSize() <= 0) continue;
                            this.vehicle.world.spawnItemStack(stack, this.worldPos);
                        }
                    }
                }
                case "planter": {
                    IWrapperInventory inventory;
                    block19: for (Object part : this.vehicle.parts) {
                        if (!(part instanceof PartInteractable) || (inventory = ((PartInteractable)part).inventory) == null || !((APart)part).definition.interactable.feedsVehicles) continue;
                        for (int j = 0; j < inventory.getSize(); ++j) {
                            if (!this.vehicle.world.plantBlock(this.affectedBlocks[i], inventory.getStackInSlot(j))) continue;
                            inventory.decrementSlot(j);
                            continue block19;
                        }
                    }
                }
                case "plow": {
                    this.vehicle.world.plowBlock(this.affectedBlocks[i]);
                }
            }
            this.lastBlocksModified[i] = this.affectedBlocks[i];
        }
    }

    @Override
    public float getWidth() {
        return 1.0f;
    }

    @Override
    public float getHeight() {
        return 1.0f;
    }
}

