/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.parts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.instances.ItemPart;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperInventory;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketVehiclePartGun;
import minecrafttransportsimulator.rendering.components.IVehiclePartFXProvider;
import minecrafttransportsimulator.rendering.instances.ParticleBullet;
import minecrafttransportsimulator.sound.SoundInstance;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartInteractable;
import minecrafttransportsimulator.vehicles.parts.PartSeat;

public class PartGun
extends APart
implements IVehiclePartFXProvider {
    public int bulletsFired;
    public int bulletsLeft;
    public int gunNumber;
    public Point3d currentOrientation;
    public Point3d prevOrientation;
    private ItemPart loadedBullet;
    public boolean firing;
    public boolean active;
    public int cooldownTimeRemaining;
    public int reloadTimeRemaining;
    private IWrapperEntity lastController;
    private long lastTimeFired;
    private long timeToFire;
    private final double anglePerTickSpeed;
    public final List<Integer> bulletsHitOnServer = new ArrayList<Integer>();

    public PartGun(EntityVehicleF_Physics vehicle, JSONVehicle.VehiclePart packVehicleDef, ItemPart item, IWrapperNBT data, APart parentPart) {
        super(vehicle, packVehicleDef, item, data, parentPart);
        this.bulletsFired = data.getInteger("shotsFired");
        this.bulletsLeft = data.getInteger("bulletsLeft");
        this.currentOrientation = data.getPoint3d("currentOrientation");
        this.prevOrientation = this.currentOrientation.copy();
        String loadedBulletPack = data.getString("loadedBulletPack");
        String loadedBulletName = data.getString("loadedBulletName");
        if (!loadedBulletPack.isEmpty()) {
            this.loadedBullet = (ItemPart)PackParserSystem.getItem(loadedBulletPack, loadedBulletName);
        }
        if (this.loadedBullet == null) {
            this.bulletsLeft = 0;
        }
        this.anglePerTickSpeed = 50.0f / this.definition.gun.diameter + 1.0f / this.definition.gun.length;
    }

    @Override
    public boolean interact(IWrapperPlayer player) {
        AItemBase heldItem = player.getHeldItem();
        if (heldItem instanceof ItemPart && this.tryToReload((ItemPart)heldItem) && !player.isCreative()) {
            player.getInventory().removeItem(heldItem, null);
        }
        return true;
    }

    @Override
    public void attack(Damage damage) {
        if (damage.isExplosion) {
            this.reloadTimeRemaining = this.definition.gun.reloadTime;
        }
    }

    @Override
    public void update() {
        super.update();
        this.prevOrientation.setTo(this.currentOrientation);
        IWrapperEntity controller = this.getCurrentController();
        boolean bl = this.active = controller != null && this.getItem().equals(((PartSeat)this.vehicle.getPartAtLocation((Point3d)((Point3d)this.vehicle.locationRiderMap.inverse().get((Object)controller)))).activeGun);
        if (this.active) {
            double deltaYaw;
            boolean lockedOn = true;
            if (!(controller instanceof IWrapperPlayer)) {
                IWrapperEntity hostile = this.vehicle.world.getNearestHostile(controller, 48);
                if (hostile != null) {
                    Point3d hostilePosition = hostile.getPosition().add(0.0, hostile.getEyeHeight() / 2.0, 0.0);
                    double ticksToTarget = hostilePosition.distanceTo(this.worldPos) / (double)this.definition.gun.muzzleVelocity / 20.0 / 10.0;
                    hostilePosition.add(hostile.getVelocity().copy().multiply(ticksToTarget));
                    double yawHostile = Math.toDegrees(Math.atan2(hostilePosition.x - this.worldPos.x, hostilePosition.z - this.worldPos.z));
                    double pitchHostile = -Math.toDegrees(Math.atan2(hostilePosition.y - this.worldPos.y, Math.hypot(hostilePosition.x - this.worldPos.x, hostilePosition.z - this.worldPos.z)));
                    controller.setYaw(yawHostile);
                    controller.setHeadYaw(yawHostile);
                    controller.setPitch(pitchHostile);
                    this.firing = true;
                } else {
                    this.firing = false;
                }
            }
            for (deltaYaw = (double)controller.getHeadYaw() - (this.vehicle.angles.y + this.totalRotation.y + this.currentOrientation.y); deltaYaw > 180.0; deltaYaw -= 360.0) {
            }
            while (deltaYaw < -180.0) {
                deltaYaw += 360.0;
            }
            if (deltaYaw < 0.0) {
                if (deltaYaw < -this.anglePerTickSpeed) {
                    deltaYaw = -this.anglePerTickSpeed;
                    lockedOn = false;
                }
                this.currentOrientation.y += deltaYaw;
            } else if (deltaYaw > 0.0) {
                if (deltaYaw > this.anglePerTickSpeed) {
                    deltaYaw = this.anglePerTickSpeed;
                    lockedOn = false;
                }
                this.currentOrientation.y += deltaYaw;
            }
            if (this.definition.gun.minYaw == -180.0f && this.definition.gun.maxYaw == 180.0f) {
                if (this.currentOrientation.y > 180.0) {
                    this.currentOrientation.y -= 360.0;
                    this.prevOrientation.y -= 360.0;
                } else if (this.currentOrientation.y < -180.0) {
                    this.currentOrientation.y += 360.0;
                    this.prevOrientation.y += 360.0;
                }
            } else {
                if (this.currentOrientation.y > (double)this.definition.gun.maxYaw) {
                    this.currentOrientation.y = this.definition.gun.maxYaw;
                }
                if (this.currentOrientation.y < (double)this.definition.gun.minYaw) {
                    this.currentOrientation.y = this.definition.gun.minYaw;
                }
            }
            double vehiclePitchContribution = (this.vehicle.angles.x + this.totalRotation.x) * Math.cos(Math.toRadians(this.totalRotation.y + this.currentOrientation.y));
            double vehicleRollContribution = -(this.vehicle.angles.z + this.totalRotation.z) * Math.sin(Math.toRadians(this.totalRotation.y + this.currentOrientation.y));
            double deltaPitch = (double)controller.getPitch() - (vehiclePitchContribution + vehicleRollContribution + this.currentOrientation.x);
            if (deltaPitch < 0.0) {
                if (deltaPitch < -this.anglePerTickSpeed) {
                    deltaPitch = -this.anglePerTickSpeed;
                    lockedOn = false;
                }
                this.currentOrientation.x += deltaPitch;
            } else if (deltaPitch > 0.0) {
                if (deltaPitch > this.anglePerTickSpeed) {
                    deltaPitch = this.anglePerTickSpeed;
                    lockedOn = false;
                }
                this.currentOrientation.x += deltaPitch;
            }
            if (this.currentOrientation.x < (double)(-this.definition.gun.maxPitch)) {
                this.currentOrientation.x = -this.definition.gun.maxPitch;
            }
            if (this.currentOrientation.x > (double)(-this.definition.gun.minPitch)) {
                this.currentOrientation.x = -this.definition.gun.minPitch;
            }
            if (!(controller instanceof IWrapperPlayer || lockedOn && this.currentOrientation.y != (double)this.definition.gun.maxYaw && this.currentOrientation.y != (double)this.definition.gun.minYaw && this.currentOrientation.x != (double)(-this.definition.gun.minPitch) && this.currentOrientation.x != (double)(-this.definition.gun.maxPitch))) {
                this.firing = false;
            }
        } else {
            this.firing = false;
        }
        if (this.cooldownTimeRemaining > 0) {
            --this.cooldownTimeRemaining;
        }
        if (this.reloadTimeRemaining > 0) {
            --this.reloadTimeRemaining;
            return;
        }
        if (this.firing && this.bulletsLeft > 0 && this.reloadTimeRemaining == 0 && this.cooldownTimeRemaining == 0) {
            PartGun gun;
            this.gunNumber = 1;
            Iterator iterator = ((List)this.vehicle.guns.get(this.getItem())).iterator();
            while (iterator.hasNext() && !(gun = (PartGun)iterator.next()).equals(this)) {
                ++this.gunNumber;
            }
            long millisecondCamOffset = (long)((double)this.definition.gun.fireDelay * 50.0 * ((double)this.gunNumber - 1.0) / (double)((List)this.vehicle.guns.get(this.getItem())).size());
            this.cooldownTimeRemaining = this.definition.gun.fireDelay;
            this.timeToFire = System.currentTimeMillis() + millisecondCamOffset;
            this.lastController = controller;
            if (!this.vehicle.world.isClient()) {
                --this.bulletsLeft;
                ++this.bulletsFired;
                if (this.bulletsLeft == 0) {
                    this.loadedBullet = null;
                }
            }
        }
        if (this.bulletsLeft == 0 && this.definition.gun.autoReload && this.reloadTimeRemaining == 0) {
            for (APart part : this.vehicle.parts) {
                IWrapperInventory inventory;
                if (!(part instanceof PartInteractable) || (inventory = ((PartInteractable)part).inventory) == null || !part.definition.interactable.feedsVehicles) continue;
                for (int i = 0; i < inventory.getSize(); i = (int)((byte)(i + 1))) {
                    AItemBase item = inventory.getItemInSlot(i);
                    if (!(item instanceof ItemPart) || !this.tryToReload((ItemPart)item)) continue;
                    inventory.decrementSlot(i);
                    return;
                }
            }
            if (!this.vehicle.world.isClient()) {
                this.loadedBullet = null;
            }
        }
    }

    public boolean tryToReload(ItemPart part) {
        if (((JSONPart)part.definition).bullet != null && (this.reloadTimeRemaining == 0 && (this.loadedBullet != null ? this.loadedBullet.equals(part) : ((JSONPart)part.definition).bullet.diameter == this.definition.gun.diameter) || this.vehicle.world.isClient()) && (((JSONPart)part.definition).bullet.quantity + this.bulletsLeft <= this.definition.gun.capacity || this.vehicle.world.isClient())) {
            this.loadedBullet = part;
            this.bulletsLeft += ((JSONPart)part.definition).bullet.quantity;
            this.reloadTimeRemaining = this.definition.gun.reloadTime;
            if (this.vehicle.world.isClient()) {
                MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, this.definition.packID + ":" + this.definition.systemName + "_reloading"));
            } else {
                MasterLoader.networkInterface.sendToAllClients(new PacketVehiclePartGun(this, this.loadedBullet));
            }
            return true;
        }
        return false;
    }

    public IWrapperEntity getCurrentController() {
        if (this.parentPart instanceof PartSeat) {
            return (IWrapperEntity)this.vehicle.locationRiderMap.get((Object)this.parentPart.placementOffset);
        }
        for (APart childPart : this.childParts) {
            if (!(childPart instanceof PartSeat)) continue;
            return (IWrapperEntity)this.vehicle.locationRiderMap.get((Object)childPart.placementOffset);
        }
        for (APart vehiclePart : this.vehicle.parts) {
            if (!(vehiclePart instanceof PartSeat) || !vehiclePart.vehicleDefinition.isController) continue;
            return (IWrapperEntity)this.vehicle.locationRiderMap.get((Object)vehiclePart.placementOffset);
        }
        return null;
    }

    @Override
    public IWrapperNBT getData() {
        IWrapperNBT data = super.getData();
        data.setInteger("shotsFired", this.bulletsFired);
        data.setInteger("bulletsLeft", this.bulletsLeft);
        data.setPoint3d("currentOrientation", this.currentOrientation);
        if (this.loadedBullet != null) {
            data.setString("loadedBulletPack", ((JSONPart)this.loadedBullet.definition).packID);
            data.setString("loadedBulletName", ((JSONPart)this.loadedBullet.definition).systemName);
        }
        return data;
    }

    @Override
    public float getWidth() {
        return 0.75f;
    }

    @Override
    public float getHeight() {
        return 0.75f;
    }

    @Override
    public Point3d getActionRotation(float partialTicks) {
        Point3d rotation = this.currentOrientation.copy().subtract(this.prevOrientation).multiply(partialTicks).add(this.currentOrientation);
        if (this.definition.gun.isTurret) {
            rotation.x = 0.0;
        }
        return rotation;
    }

    @Override
    public void spawnParticles() {
        if (this.timeToFire != this.lastTimeFired && System.currentTimeMillis() >= this.timeToFire && this.bulletsLeft > 0) {
            Point3d vehicleFactoredAngles = this.vehicle.angles.copy().add((Math.random() - 0.5) * (double)(10.0f * this.definition.gun.diameter / (this.definition.gun.length * 1000.0f)), (Math.random() - 0.5) * (double)(10.0f * this.definition.gun.diameter / (this.definition.gun.length * 1000.0f)), 0.0);
            Point3d bulletVelocity = this.vehicle.motion.copy().multiply(this.vehicle.SPEED_FACTOR).add(new Point3d(0.0, 0.0, (double)this.definition.gun.muzzleVelocity / 20.0 / 10.0).rotateFine(this.currentOrientation).rotateFine(this.totalRotation).rotateFine(vehicleFactoredAngles));
            Point3d bulletPosition = new Point3d(0.0, 0.0, this.definition.gun.length).rotateFine(this.currentOrientation).rotateFine(this.totalRotation).rotateFine(vehicleFactoredAngles).add(this.worldPos);
            MasterLoader.renderInterface.spawnParticle(new ParticleBullet(bulletPosition, bulletVelocity, this.loadedBullet, this, this.lastController));
            MasterLoader.audioInterface.playQuickSound(new SoundInstance(this, this.definition.packID + ":" + this.definition.systemName + "_firing"));
            this.lastTimeFired = this.timeToFire;
            --this.bulletsLeft;
            ++this.bulletsFired;
        }
    }
}

