/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.parts;

import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.FluidTank;
import minecrafttransportsimulator.items.instances.ItemPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperInventory;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperTileEntity;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;

public final class PartInteractable
extends APart {
    private final IWrapperTileEntity interactable;
    public final IWrapperInventory inventory;
    public final FluidTank tank;

    public PartInteractable(EntityVehicleF_Physics vehicle, JSONVehicle.VehiclePart packVehicleDef, ItemPart item, IWrapperNBT data, APart parentPart) {
        super(vehicle, packVehicleDef, item, data, parentPart);
        switch (this.definition.interactable.interactionType) {
            case "crate": {
                this.interactable = MasterLoader.coreInterface.getFakeTileEntity("chest", vehicle.world, data, this.definition.interactable.inventoryUnits * 9);
                break;
            }
            case "barrel": {
                this.interactable = null;
                break;
            }
            case "crafting_table": {
                this.interactable = null;
                break;
            }
            case "furnace": {
                this.interactable = MasterLoader.coreInterface.getFakeTileEntity("furnace", vehicle.world, data, 0);
                break;
            }
            case "brewing_stand": {
                this.interactable = MasterLoader.coreInterface.getFakeTileEntity("brewing_stand", vehicle.world, data, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("ERROR: " + this.definition.interactable.interactionType + " is not a valid type of interactable part.");
            }
        }
        this.inventory = this.interactable != null ? this.interactable.getInventory() : null;
        this.tank = this.definition.interactable.interactionType.equals("barrel") ? new FluidTank(data, this.definition.interactable.inventoryUnits * 10000, vehicle.world.isClient()) : null;
    }

    @Override
    public boolean interact(IWrapperPlayer player) {
        if (!this.vehicle.locked) {
            if (this.definition.interactable.interactionType.equals("crafting_table")) {
                player.openCraftingGUI();
            } else if (this.interactable != null) {
                player.openTileEntityGUI(this.interactable);
            } else if (this.tank != null) {
                player.getHeldStack().interactWithTank(this.tank, player);
            }
        } else {
            player.sendPacket(new PacketPlayerChatMessage("interact.failure.vehiclelocked"));
        }
        return true;
    }

    @Override
    public void attack(Damage damage) {
        double explosivePower = this.getExplosiveContribution();
        if (explosivePower > 0.0) {
            this.vehicle.world.spawnExplosion(this.vehicle, this.worldPos, explosivePower, true);
            this.isValid = false;
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.interactable != null) {
            this.interactable.update();
        }
    }

    @Override
    public IWrapperNBT getData() {
        IWrapperNBT data = super.getData();
        if (this.interactable != null) {
            this.interactable.save(data);
        } else if (this.tank != null) {
            this.tank.save(data);
        }
        return data;
    }

    @Override
    public float getWidth() {
        return 1.0f;
    }

    @Override
    public float getHeight() {
        return 1.0f;
    }

    public int getInventoryCount() {
        int count = 0;
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.getSize(); ++i) {
                if (this.inventory.getItemInSlot(i) == null) continue;
                ++count;
            }
        }
        return count;
    }

    public double getInventoryPercent() {
        if (this.inventory != null) {
            int count = 0;
            for (int i = 0; i < this.inventory.getSize(); ++i) {
                if (this.inventory.getItemInSlot(i) == null) continue;
                ++count;
            }
            return (double)count / (double)this.inventory.getSize();
        }
        if (this.tank != null) {
            return this.tank.getFluidLevel() / (double)this.tank.getMaxLevel();
        }
        return 0.0;
    }

    public int getInventoryCapacity() {
        if (this.inventory != null) {
            return this.inventory.getSize();
        }
        if (this.tank != null) {
            return this.tank.getMaxLevel() / 1000;
        }
        return 0;
    }

    public double getInventoryWeight() {
        if (this.inventory != null) {
            return this.inventory.getInventoryWeight(ConfigSystem.configObject.general.itemWeights.weights);
        }
        if (this.tank != null) {
            return this.tank.getWeight();
        }
        return 0.0;
    }

    public double getExplosiveContribution() {
        if (this.inventory != null) {
            return this.inventory.getExplosiveness();
        }
        if (this.tank != null) {
            return this.tank.getExplosiveness();
        }
        return 0.0;
    }
}

