/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.parts;

import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.items.instances.ItemPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketVehiclePartEngine;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartEngine;

public class PartPropeller
extends APart {
    public double angularPosition;
    public double angularVelocity;
    public double damage;
    public short currentPitch;
    private final PartEngine connectedEngine;
    private final Point3d propellerForce = new Point3d(0.0, 0.0, 0.0);
    public static final int MIN_DYNAMIC_PITCH = 45;

    public PartPropeller(EntityVehicleF_Physics vehicle, JSONVehicle.VehiclePart packVehicleDef, ItemPart item, IWrapperNBT data, APart parentPart) {
        super(vehicle, packVehicleDef, item, data, parentPart);
        this.damage = data.getDouble("damage");
        this.currentPitch = this.definition.propeller.pitch;
        this.connectedEngine = (PartEngine)parentPart;
        if (this.definition.propeller.isRotor) {
            this.boundingBox.widthRadius = (double)this.getWidth() / 2.0;
            this.boundingBox.heightRadius = 0.25;
            this.boundingBox.depthRadius = (double)this.getWidth() / 2.0;
        }
    }

    @Override
    public void attack(Damage damage) {
        if (damage.attacker != null && damage.attacker instanceof IWrapperPlayer && ((IWrapperPlayer)damage.attacker).getHeldItem() == null) {
            if (!this.vehicle.equals(damage.attacker.getEntityRiding())) {
                this.connectedEngine.handStartEngine();
                MasterLoader.networkInterface.sendToAllClients(new PacketVehiclePartEngine(this.connectedEngine, PacketVehiclePartEngine.Signal.HS_ON));
            }
            return;
        }
        this.damage += damage.amount;
    }

    @Override
    public void update() {
        super.update();
        if (this.connectedEngine == null) {
            this.isValid = false;
            return;
        }
        if (this.definition.propeller.isDynamicPitch) {
            if (this.vehicle.reverseThrust && this.currentPitch > -45) {
                this.currentPitch = (short)(this.currentPitch - 1);
            } else if (!this.vehicle.reverseThrust && this.currentPitch < 45) {
                this.currentPitch = (short)(this.currentPitch + 1);
            } else if (this.connectedEngine.rpm < (double)PartEngine.getSafeRPMFromMax(this.connectedEngine.definition.engine.maxRPM) * 0.6 && this.currentPitch > 45) {
                this.currentPitch = (short)(this.currentPitch - 1);
            } else if (this.connectedEngine.rpm > (double)PartEngine.getSafeRPMFromMax(this.connectedEngine.definition.engine.maxRPM) * 0.85 && this.currentPitch < this.definition.propeller.pitch) {
                this.currentPitch = (short)(this.currentPitch + 1);
            }
        }
        this.angularVelocity = this.connectedEngine.propellerGearboxRatio != 0.0f ? (double)((float)(this.connectedEngine.rpm / (double)this.connectedEngine.propellerGearboxRatio / 60.0 / 20.0)) : (this.angularVelocity > 1.0 ? (this.angularVelocity -= 1.0) : (this.angularVelocity < -1.0 ? (this.angularVelocity += 1.0) : 0.0));
        this.angularPosition += this.angularVelocity;
        if (!this.vehicle.world.isClient()) {
            if (this.connectedEngine.rpm >= 100.0) {
                this.boundingBox.widthRadius += 0.2;
                this.boundingBox.heightRadius += 0.2;
                this.boundingBox.depthRadius += 0.2;
                Damage propellerDamage = new Damage("propellor", (Double)ConfigSystem.configObject.damage.propellerDamageFactor.value * this.connectedEngine.rpm * (double)this.connectedEngine.propellerGearboxRatio / 500.0, this.boundingBox, this.vehicle.getController());
                this.vehicle.world.attackEntities(propellerDamage, this.vehicle, null);
                this.boundingBox.widthRadius -= 0.2;
                this.boundingBox.heightRadius -= 0.2;
                this.boundingBox.depthRadius -= 0.2;
                if (!this.boundingBox.collidingBlocks.isEmpty()) {
                    this.damage += 1.0;
                }
                if (20.0 * this.angularVelocity * Math.PI * (double)this.definition.propeller.diameter * 0.0254 > 340.29) {
                    this.damage += (double)this.definition.propeller.startingHealth;
                }
            }
            if (this.damage > (double)this.definition.propeller.startingHealth && !this.vehicle.world.isClient()) {
                if (((Boolean)ConfigSystem.configObject.damage.explosions.value).booleanValue()) {
                    this.vehicle.world.spawnExplosion(this.vehicle, this.worldPos, 1.0, true);
                } else {
                    this.vehicle.world.spawnExplosion(this.vehicle, this.worldPos, 0.0, false);
                }
                this.isValid = false;
            }
        }
    }

    @Override
    public IWrapperNBT getData() {
        IWrapperNBT data = super.getData();
        data.setDouble("damage", this.damage);
        return data;
    }

    @Override
    public float getWidth() {
        return (float)this.definition.propeller.diameter * 0.0254f;
    }

    @Override
    public float getHeight() {
        return (float)this.definition.propeller.diameter * 0.0254f;
    }

    @Override
    public Point3d getActionRotation(float partialTicks) {
        if (this.definition.propeller.isRotor) {
            return new Point3d((double)this.vehicle.elevatorAngle * 10.0 / 250.0, (double)this.vehicle.aileronAngle * 10.0 / 250.0, (this.angularPosition + this.angularVelocity * (double)partialTicks) * 360.0);
        }
        return new Point3d(0.0, 0.0, (this.angularPosition + this.angularVelocity * (double)partialTicks) * 360.0);
    }

    public Point3d getForceOutput() {
        this.propellerForce.set(0.0, 0.0, 0.0);
        if (this.connectedEngine != null && this.connectedEngine.state.running) {
            Point3d propellerThrustAxis = new Point3d(0.0, 0.0, 1.0).rotateCoarse(this.totalRotation.copy().add(this.vehicle.angles));
            double currentLinearVelocity = 20.0 * this.vehicle.motion.dotProduct(propellerThrustAxis);
            double desiredLinearVelocity = 0.0254 * (double)(this.currentPitch + 20) * 20.0 * this.angularVelocity;
            if (desiredLinearVelocity != 0.0) {
                double thrust = desiredLinearVelocity - currentLinearVelocity;
                thrust *= Math.PI * Math.pow(0.0254 * (double)this.definition.propeller.diameter / 2.0, 2.0);
                thrust *= this.vehicle.airDensity / 25.0;
                double angleOfAttack = (desiredLinearVelocity - currentLinearVelocity) / (this.connectedEngine.rpm / (double)this.connectedEngine.propellerGearboxRatio / 60.0) / ((double)this.definition.propeller.diameter * Math.PI * 0.0254);
                if (Math.abs(angleOfAttack) > 0.4663) {
                    thrust *= 0.4663 / Math.abs(angleOfAttack);
                }
                if (this.isInLiquid()) {
                    thrust *= 50.0;
                }
                Point3d propellerThrustVector = new Point3d(0.0, 0.0, thrust);
                if (this.definition.propeller.isRotor) {
                    Point3d propellerActionRotation = this.getActionRotation(0.0f);
                    propellerActionRotation.z = 0.0;
                    propellerThrustVector.rotateCoarse(propellerActionRotation);
                }
                this.propellerForce.add(propellerThrustVector.rotateCoarse(this.totalRotation));
            }
        }
        return this.propellerForce;
    }
}

