/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.parts;

import java.util.Iterator;
import java.util.List;
import minecrafttransportsimulator.items.instances.ItemPart;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packets.instances.PacketVehiclePartSeat;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartGun;

public final class PartSeat
extends APart {
    public ItemPart activeGun;

    public PartSeat(EntityVehicleF_Physics vehicle, JSONVehicle.VehiclePart packVehicleDef, ItemPart item, IWrapperNBT data, APart parentPart) {
        super(vehicle, packVehicleDef, item, data, parentPart);
        this.activeGun = (ItemPart)PackParserSystem.getItem(data.getString("activeGunPackID"), data.getString("activeGunSystemName"));
    }

    @Override
    public boolean interact(IWrapperPlayer player) {
        if (!this.vehicle.locked || this.vehicle.equals(player.getEntityRiding())) {
            IWrapperEntity riderForSeat = (IWrapperEntity)this.vehicle.locationRiderMap.get((Object)this.placementOffset);
            if (riderForSeat != null) {
                if (riderForSeat instanceof IWrapperPlayer) {
                    if (!player.equals(riderForSeat)) {
                        player.sendPacket(new PacketPlayerChatMessage("interact.failure.seattaken"));
                    }
                } else if (!riderForSeat.leashTo(player)) {
                    player.sendPacket(new PacketPlayerChatMessage("interact.failure.seattaken"));
                }
            } else {
                IWrapperEntity leashedEntity = player.getLeashedEntity();
                if (leashedEntity != null) {
                    this.vehicle.addRider(leashedEntity, this.placementOffset);
                } else if (!player.isSneaking()) {
                    this.vehicle.addRider(player, this.placementOffset);
                    if (this.activeGun == null) {
                        for (List gunList : this.vehicle.guns.values()) {
                            for (PartGun gun : gunList) {
                                if (!player.equals(gun.getCurrentController())) continue;
                                this.activeGun = gun.getItem();
                                this.setNextActiveGun();
                                MasterLoader.networkInterface.sendToAllClients(new PacketVehiclePartSeat(this));
                            }
                        }
                    }
                }
            }
        } else {
            player.sendPacket(new PacketPlayerChatMessage("interact.failure.vehiclelocked"));
        }
        return true;
    }

    public void setNextActiveGun() {
        IWrapperEntity rider = (IWrapperEntity)this.vehicle.locationRiderMap.get((Object)this.placementOffset);
        if (this.activeGun == null) {
            for (ItemPart gunType : this.vehicle.guns.keySet()) {
                for (PartGun gun : (List)this.vehicle.guns.get(gunType)) {
                    if (!rider.equals(gun.getCurrentController())) continue;
                    this.activeGun = gunType;
                    return;
                }
            }
        } else {
            ItemPart firstPossibleGun = null;
            ItemPart currentGun = this.activeGun;
            this.activeGun = null;
            boolean pastActiveGun = false;
            block2: for (ItemPart gunType : this.vehicle.guns.keySet()) {
                for (PartGun gun : (List)this.vehicle.guns.get(gunType)) {
                    if (!rider.equals(gun.getCurrentController())) continue;
                    if (pastActiveGun) {
                        this.activeGun = gunType;
                        return;
                    }
                    if (firstPossibleGun == null) {
                        firstPossibleGun = gunType;
                    }
                    if (!gunType.equals(currentGun)) continue block2;
                    pastActiveGun = true;
                    continue block2;
                }
            }
            if (this.activeGun == null) {
                this.activeGun = firstPossibleGun;
            }
        }
    }

    @Override
    public void remove() {
        super.remove();
        IWrapperEntity rider = (IWrapperEntity)this.vehicle.locationRiderMap.get((Object)this.placementOffset);
        if (rider != null) {
            this.vehicle.removeRider(rider, (Iterator)null);
        }
    }

    @Override
    public IWrapperNBT getData() {
        IWrapperNBT data = super.getData();
        if (this.activeGun != null) {
            data.setString("activeGunPackID", ((JSONPart)this.activeGun.definition).packID);
            data.setString("activeGunSystemName", ((JSONPart)this.activeGun.definition).systemName);
        }
        return data;
    }

    @Override
    public float getWidth() {
        return 0.75f;
    }

    @Override
    public float getHeight() {
        return 0.75f;
    }
}

