/*
 * Decompiled with CFR 0.152.
 */
package ru.wirelesstools;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.tile.IEnergyStorage;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileVajraChargerElectric
extends TileEntity
implements IEnergySink,
IEnergyStorage {
    public int tier;
    public int maxStorage;
    public int output;
    public double energy = 0.0;
    private boolean addedToEnergyNet = false;

    public TileVajraChargerElectric(int tier1, int output1, int storage1) {
        this.tier = tier1;
        this.output = output1;
        this.maxStorage = storage1;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onChunkUnloadOrInvalidate();
    }

    public void onChunkUnload() {
        this.onChunkUnloadOrInvalidate();
    }

    protected void onChunkUnloadOrInvalidate() {
        this.removeFromENet();
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.addToENet();
    }

    protected void addToENet() {
        if (!this.addedToEnergyNet && !this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    protected void removeFromENet() {
        if (!this.field_145850_b.field_72995_K && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74769_h("energy");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
    }

    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    public boolean acceptsEnergyFrom(TileEntity nameTileEntity, ForgeDirection nameForgeDirection) {
        return true;
    }

    public double getDemandedEnergy() {
        return (double)this.maxStorage - this.energy;
    }

    public int getSinkTier() {
        return this.tier;
    }

    public double injectEnergy(ForgeDirection nameForgeDirection, double amount, double voltage) {
        if (this.energy >= (double)this.maxStorage) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    public int getStored() {
        return (int)this.energy;
    }

    public void setStored(int energy) {
        this.energy = energy;
    }

    public int addEnergy(int amount) {
        this.energy += (double)amount;
        return this.getStored();
    }

    public int getCapacity() {
        return this.maxStorage;
    }

    public int getOutput() {
        return this.output;
    }

    public double getOutputEnergyUnitsPerTick() {
        return 128.0;
    }

    public boolean isTeleporterCompatible(ForgeDirection side) {
        return false;
    }
}

