/*
 * Decompiled with CFR 0.152.
 */
package net.iPixeli.Gender.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import net.iPixeli.Gender.common.Gender;

public class Config {
    private File suchFile;
    public final ArrayList<String> modelNames = new ArrayList();
    public boolean enableDebugMode;
    protected int priorityMode = 3;
    public boolean clientIgnoreingOwnHC;
    public boolean enableNameColors;
    public boolean enableChatColors;
    public boolean enablePlayerGenders;
    public boolean enablePlayerChildren;
    public boolean enablePlayerGenderSounds;
    public boolean enableZombieGenders;
    public byte settingZombieModel;
    public static final byte defaultSettingPlayerModel = 2;

    public Config(File veryDir) {
        System.out.println("[Gender] " + this.getClass().getSimpleName() + " initilized");
        this.suchFile = new File(veryDir, "gender.cfg");
        this.modelNames.add("stephanie");
        this.modelNames.add("cynthia");
        this.modelNames.add("default");
        this.defaults();
        if (!this.suchFile.exists()) {
            try {
                this.suchFile.createNewFile();
            }
            catch (IOException e) {
                if (Gender.instance.config.enableDebugMode) {
                    e.printStackTrace();
                }
                System.out.println("[Gender] Failed to create or locate file " + this.suchFile.getName() + " with error: " + e.getMessage());
            }
        }
        this.readList();
        this.saveList();
    }

    public void defaults() {
        this.enableDebugMode = false;
        this.priorityMode = 3;
        this.clientIgnoreingOwnHC = false;
        this.enableNameColors = true;
        this.enableChatColors = true;
        this.enablePlayerGenders = true;
        this.enablePlayerChildren = true;
        this.enablePlayerGenderSounds = true;
        this.enableZombieGenders = true;
        this.settingZombieModel = 1;
    }

    private void readList() {
        try {
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.suchFile));
            String s = "";
            while ((s = bufferedreader.readLine()) != null) {
                String[] t = s.split("=");
                if (t[0].equals("enableDebugMode")) {
                    this.enableDebugMode = t[1].equals("true");
                    continue;
                }
                if (t[0].equals("enableClientPriority")) {
                    this.priorityMode = Integer.parseInt(t[1]);
                    continue;
                }
                if (t[0].equals("enableNameColors")) {
                    this.enableNameColors = t[1].equals("true");
                    continue;
                }
                if (t[0].equals("enableChatColors")) {
                    this.enableChatColors = t[1].equals("true");
                    continue;
                }
                if (t[0].equals("enablePlayerGenders")) {
                    this.enablePlayerGenders = t[1].equals("true");
                    continue;
                }
                if (t[0].equals("enablePlayerChildren")) {
                    this.enablePlayerChildren = t[1].equals("true");
                    continue;
                }
                if (t[0].equals("enablePlayerGenderSounds")) {
                    this.enablePlayerGenderSounds = t[1].equals("true");
                    continue;
                }
                if (t[0].equals("enableZombieGenders")) {
                    this.enableZombieGenders = t[1].equals("true");
                    continue;
                }
                if (!t[0].equals("settingZombieModel")) continue;
                this.settingZombieModel = Byte.parseByte(t[1]);
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            System.out.println("[Gender] Failed to load modification settings: " + exception);
        }
    }

    private void saveList() {
        try {
            PrintWriter printwriter = new PrintWriter((Writer)new FileWriter(this.suchFile), false);
            printwriter.println("enableDebugMode=" + this.enableDebugMode);
            printwriter.println("enableClientPriority=" + this.priorityMode);
            printwriter.println("enableNameColors=" + this.enableNameColors);
            printwriter.println("enableChatColors=" + this.enableChatColors);
            printwriter.println("enablePlayerGenders=" + this.enablePlayerGenders);
            printwriter.println("enablePlayerChildren=" + this.enablePlayerChildren);
            printwriter.println("enablePlayerGenderSounds=" + this.enablePlayerGenderSounds);
            printwriter.println("enableZombieGenders=" + this.enableZombieGenders);
            printwriter.println("settingZombieModel=" + this.settingZombieModel);
            printwriter.close();
        }
        catch (Exception exception) {
            System.out.println("[Gender] Failed to save modification settings: " + exception);
        }
    }

    public void updateConfig() {
        this.saveList();
    }

    public boolean isEnablePlayerGenders() {
        return this.enablePlayerGenders;
    }

    public boolean isPlayerChildrenEnabled() {
        return this.enablePlayerChildren;
    }

    public int priorityMode() {
        return this.priorityMode;
    }
}

