/*
 * Decompiled with CFR 0.152.
 */
package net.iPixeli.Gender.util;

import java.util.ArrayList;
import java.util.List;
import net.iPixeli.Gender.common.ManagerInfoServer;
import net.iPixeli.Gender.common.PlayerInfo;
import net.iPixeli.Gender.util.PacketHandler;
import net.iPixeli.Gender.util.References;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class CommandListenerGender
implements ICommand {
    private List aliases;
    private ArrayList<String> helpmsgs = new ArrayList();
    private static final String perms = EnumChatFormatting.RED + "You do not have permission to use this command.";

    public CommandListenerGender() {
        this.aliases = new ArrayList();
        this.aliases.add("gender");
        this.aliases.add("g");
        String aargs = EnumChatFormatting.GREEN + "{args}" + EnumChatFormatting.RESET;
        this.helpmsgs.add(EnumChatFormatting.LIGHT_PURPLE + "" + EnumChatFormatting.BOLD + "Command information" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + " (version " + "1.0.1" + ")" + EnumChatFormatting.RESET);
        this.helpmsgs.add(EnumChatFormatting.GOLD + "One or more args are used in place of " + aargs + EnumChatFormatting.RESET);
        this.helpmsgs.add(EnumChatFormatting.ITALIC + "" + EnumChatFormatting.BOLD + EnumChatFormatting.GREEN + "Gender:" + EnumChatFormatting.RESET + EnumChatFormatting.ITALIC + " male, female " + EnumChatFormatting.ITALIC + "" + EnumChatFormatting.BOLD + EnumChatFormatting.GREEN + "Age:" + EnumChatFormatting.RESET + " adult, child " + EnumChatFormatting.ITALIC + "" + EnumChatFormatting.BOLD + EnumChatFormatting.GREEN + "Model:" + EnumChatFormatting.RESET + " 0, 1, 2");
        this.helpmsgs.add("/gender " + aargs + EnumChatFormatting.ITALIC + EnumChatFormatting.GRAY + " - Set settings for self");
        this.helpmsgs.add("/gender set [username] " + aargs + EnumChatFormatting.ITALIC + EnumChatFormatting.GRAY + " - Set settings for player");
        this.helpmsgs.add("/gender sync" + EnumChatFormatting.ITALIC + EnumChatFormatting.GRAY + " - Resynchronizes player settings to all clients");
        this.helpmsgs.add("/gender help" + EnumChatFormatting.ITALIC + EnumChatFormatting.GRAY + " - Prints command information");
        this.helpmsgs.add("For downloads, support information, please visit http://gender.ipixeli.net/");
    }

    public int compareTo(Object arg0) {
        return 0;
    }

    public String func_71517_b() {
        return "gender";
    }

    public String func_71518_a(ICommandSender var1) {
        return null;
    }

    public List func_71514_a() {
        return this.aliases;
    }

    private boolean isUserConnected(String name) {
        for (String s : MinecraftServer.func_71276_C().func_71203_ab().func_72369_d()) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isSuperUser(ICommandSender sender) {
        return sender instanceof DedicatedServer || !(sender instanceof EntityPlayer);
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        try {
            if (args[0].equalsIgnoreCase("help")) {
                for (String s : this.helpmsgs) {
                    CommandListenerGender.sendChat(sender, s);
                }
            } else if (args[0].equalsIgnoreCase("sync")) {
                if (this.isSuperUser(sender)) {
                    PacketHandler.sendFromServerBroadcastEverything();
                } else {
                    CommandListenerGender.sendChat(sender, perms);
                }
            } else if (args[0].equalsIgnoreCase("set") && args.length >= 3 && args.length <= 5) {
                if (this.isSuperUser(sender)) {
                    if (this.isUserConnected(args[1])) {
                        PlayerInfo iTarget = ManagerInfoServer.instance.get(args[1]);
                        String arg2 = args[2];
                        boolean female = arg2.equalsIgnoreCase("female");
                        boolean male = arg2.equalsIgnoreCase("male");
                        boolean child = arg2.equalsIgnoreCase("child");
                        boolean adult = arg2.equalsIgnoreCase("adult");
                        if (female || male) {
                            iTarget = ManagerInfoServer.instance.addWithGender(args[1], female);
                        } else if (child || adult) {
                            iTarget = ManagerInfoServer.instance.addWithAge(args[1], child);
                        } else if (args[2].equalsIgnoreCase("0") || args[2].equalsIgnoreCase("1") || args[2].equalsIgnoreCase("2")) {
                            iTarget = ManagerInfoServer.instance.addWithModel(args[1], Byte.parseByte(args[2]));
                        }
                        if (iTarget != null) {
                            PacketHandler.sendFromServerBroadcastOne(iTarget);
                        }
                        CommandListenerGender.sendChatServerWide(sender.func_70005_c_() + " changed the settings for " + iTarget.getName() + " to: " + (iTarget.isFemale() ? "female" : "male") + (iTarget.isChild() ? " child " : " adult ") + References.getModelName(iTarget.getModel()));
                    } else {
                        CommandListenerGender.sendChat(sender, args[1] + " is not online.");
                    }
                } else {
                    CommandListenerGender.sendChat(sender, perms);
                }
            } else if (args.length >= 1 && args.length <= 3) {
                if (sender instanceof EntityPlayer) {
                    PlayerInfo iSend = ManagerInfoServer.instance.get(sender.func_70005_c_());
                    for (String arg : args) {
                        if (arg.equalsIgnoreCase("female")) {
                            iSend.setFemale(true);
                        } else if (arg.equalsIgnoreCase("male")) {
                            iSend.setFemale(false);
                        } else if (arg.equalsIgnoreCase("child")) {
                            iSend.setChild(true);
                        } else if (arg.equalsIgnoreCase("adult")) {
                            iSend.setChild(false);
                        } else if (arg.equalsIgnoreCase("0") || args[0].equalsIgnoreCase("2") || args[0].equalsIgnoreCase("3")) {
                            iSend.setModel(Byte.parseByte(args[0]));
                        } else {
                            CommandListenerGender.sendChat(sender, "Invalid command. Please use /gender help");
                            return;
                        }
                        PacketHandler.sendFromServerBroadcastOne(iSend);
                        CommandListenerGender.sendChat(sender, "You changed your settings to: " + (iSend.isFemale() ? "female" : "male") + (iSend.isChild() ? " child " : " adult ") + References.getModelName(iSend.getModel()));
                    }
                } else {
                    CommandListenerGender.sendChat(sender, "Only players may use this command.");
                }
            } else {
                CommandListenerGender.sendChat(sender, "Invalid command. Please use /gender help");
            }
        }
        catch (Exception e) {
            System.out.println("[Gender] Error when processing command. Sender: " + sender.func_70005_c_() + "  Data: " + args.toString() + "  Exception: " + e.getMessage());
        }
    }

    private static void sendChatServerWide(String s) {
        MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(s));
    }

    private static void sendChat(ICommandSender sender, String s) {
        sender.func_145747_a((IChatComponent)new ChatComponentText(References.prefixInGame + s));
    }

    public boolean func_71519_b(ICommandSender var1) {
        return true;
    }

    public List func_71516_a(ICommandSender var1, String[] var2) {
        return null;
    }

    public boolean func_82358_a(String[] var1, int var2) {
        return false;
    }
}

