/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.ingredients.Ingredients;
import mezz.jei.util.Log;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public final class ErrorUtil {
    private ErrorUtil() {
    }

    public static <T> String getInfoFromRecipe(T recipe, IRecipeWrapper recipeWrapper) {
        StringBuilder recipeInfoBuilder = new StringBuilder();
        try {
            recipeInfoBuilder.append(recipe);
        }
        catch (RuntimeException e) {
            Log.error("Failed recipe.toString", e);
            recipeInfoBuilder.append(recipe.getClass());
        }
        Ingredients ingredients = new Ingredients();
        try {
            recipeWrapper.getIngredients(ingredients);
        }
        catch (RuntimeException ignored) {
            recipeInfoBuilder.append("\nFailed to get ingredients from recipe wrapper");
            return recipeInfoBuilder.toString();
        }
        catch (LinkageError ignored) {
            recipeInfoBuilder.append("\nFailed to get ingredients from recipe wrapper");
            return recipeInfoBuilder.toString();
        }
        recipeInfoBuilder.append("\nOutputs:");
        Set<Class> outputClasses = ingredients.getOutputIngredients().keySet();
        for (Class outputClass : outputClasses) {
            List<String> ingredientOutputInfo = ErrorUtil.getIngredientOutputInfo(outputClass, ingredients);
            recipeInfoBuilder.append('\n').append(outputClass.getName()).append(": ").append(ingredientOutputInfo);
        }
        recipeInfoBuilder.append("\nInputs:");
        Set<Class> inputClasses = ingredients.getInputIngredients().keySet();
        for (Class inputClass : inputClasses) {
            List<String> ingredientInputInfo = ErrorUtil.getIngredientInputInfo(inputClass, ingredients);
            recipeInfoBuilder.append('\n').append(inputClass.getName()).append(": ").append(ingredientInputInfo);
        }
        return recipeInfoBuilder.toString();
    }

    private static <T> List<String> getIngredientOutputInfo(Class<T> ingredientClass, IIngredients ingredients) {
        List<List<T>> outputs = ingredients.getOutputs(ingredientClass);
        return ErrorUtil.getIngredientInfo(ingredientClass, outputs);
    }

    private static <T> List<String> getIngredientInputInfo(Class<T> ingredientClass, IIngredients ingredients) {
        List<List<T>> inputs = ingredients.getInputs(ingredientClass);
        return ErrorUtil.getIngredientInfo(ingredientClass, inputs);
    }

    public static <T> String getInfoFromBrokenCraftingRecipe(T recipe, List inputs, ItemStack output) {
        StringBuilder recipeInfoBuilder = new StringBuilder();
        try {
            recipeInfoBuilder.append(recipe);
        }
        catch (RuntimeException e) {
            Log.error("Failed recipe.toString", e);
            recipeInfoBuilder.append(recipe.getClass());
        }
        recipeInfoBuilder.append("\nOutputs:");
        List<List<ItemStack>> outputs = Collections.singletonList(Collections.singletonList(output));
        List<String> ingredientOutputInfo = ErrorUtil.getIngredientInfo(ItemStack.class, outputs);
        recipeInfoBuilder.append('\n').append(ItemStack.class.getName()).append(": ").append(ingredientOutputInfo);
        recipeInfoBuilder.append("\nInputs:");
        List<List<ItemStack>> inputLists = Internal.getStackHelper().expandRecipeItemStackInputs(inputs, false);
        List<String> ingredientInputInfo = ErrorUtil.getIngredientInfo(ItemStack.class, inputLists);
        recipeInfoBuilder.append('\n').append(ItemStack.class.getName()).append(": ").append(ingredientInputInfo);
        return recipeInfoBuilder.toString();
    }

    public static <T> List<String> getIngredientInfo(Class<T> ingredientClass, List<? extends List<T>> ingredients) {
        IIngredientHelper<T> ingredientHelper = Internal.getIngredientRegistry().getIngredientHelper(ingredientClass);
        ArrayList<String> allInfos = new ArrayList<String>(ingredients.size());
        for (List<T> inputList : ingredients) {
            ArrayList<String> infos = new ArrayList<String>(inputList.size());
            for (T input : inputList) {
                String errorInfo = ingredientHelper.getErrorInfo(input);
                infos.add(errorInfo);
            }
            allInfos.add(((Object)infos).toString());
        }
        return allInfos;
    }

    public static String getItemStackInfo(@Nullable ItemStack itemStack) {
        String itemName;
        if (itemStack == null) {
            return "null";
        }
        Item item = itemStack.func_77973_b();
        ResourceLocation registryName = item.getRegistryName();
        if (registryName != null) {
            itemName = registryName.toString();
        } else if (item instanceof ItemBlock) {
            ResourceLocation blockRegistryName;
            Block block = ((ItemBlock)item).func_179223_d();
            String blockName = block == null ? "null" : ((blockRegistryName = block.getRegistryName()) != null ? blockRegistryName.toString() : block.getClass().getName());
            itemName = "ItemBlock(" + blockName + ")";
        } else {
            itemName = item.getClass().getName();
        }
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt != null) {
            return itemStack + " " + itemName + " nbt:" + nbt;
        }
        return itemStack + " " + itemName;
    }

    public static void checkNotEmpty(@Nullable String string, String name) {
        if (string == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
    }

    public static void checkNotEmpty(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("ItemStack must not be null.");
        }
        if (itemStack.func_190926_b()) {
            String info = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("ItemStack value must not be empty. " + info);
        }
    }

    public static void checkNotEmpty(@Nullable ItemStack itemStack, String name) {
        if (itemStack == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (itemStack.func_190926_b()) {
            String info = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("ItemStack " + name + " must not be empty. " + info);
        }
    }

    public static <T> void checkNotEmpty(@Nullable T[] values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (values.length <= 0) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
    }

    public static void checkNotEmpty(@Nullable Collection values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (values.isEmpty()) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        if (!(values instanceof NonNullList)) {
            for (Object value : values) {
                if (value != null) continue;
                throw new NullPointerException(name + " must not contain null values.");
            }
        }
    }

    public static <T> T checkNotNull(@Nullable T object, String name) {
        if (object == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        return object;
    }

    public static void checkIsKnownIngredientType(Object object) {
        if (!Internal.getIngredientRegistry().isKnownIngredientType(object)) {
            throw new IllegalArgumentException(object.getClass() + " is not a known ingredient type.");
        }
        if (object instanceof ItemStack) {
            ErrorUtil.checkNotEmpty((ItemStack)object);
        }
    }
}

