/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.collect.IngredientSet;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientBlacklistInternal;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientListElementFactory;
import mezz.jei.ingredients.IngredientListElementInfo;
import mezz.jei.util.ErrorUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IngredientManager
implements IIngredientManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IModIdHelper modIdHelper;
    private final IngredientBlacklistInternal blacklist;
    private final Map<IIngredientType, IngredientSet> ingredientsMap;
    private final ImmutableMap<IIngredientType, IIngredientHelper> ingredientHelperMap;
    private final ImmutableMap<IIngredientType, IIngredientRenderer> ingredientRendererMap;
    private final boolean enableDebugLogs;
    private final ImmutableMap<Class, IIngredientType> ingredientTypeMap;
    private final NonNullList<ItemStack> fuels = NonNullList.func_191196_a();
    private final NonNullList<ItemStack> potionIngredients = NonNullList.func_191196_a();

    public IngredientManager(IModIdHelper modIdHelper, IngredientBlacklistInternal blacklist, Map<IIngredientType, IngredientSet> ingredientsMap, ImmutableMap<IIngredientType, IIngredientHelper> ingredientHelperMap, ImmutableMap<IIngredientType, IIngredientRenderer> ingredientRendererMap, boolean enableDebugLogs) {
        this.modIdHelper = modIdHelper;
        this.blacklist = blacklist;
        this.ingredientsMap = ingredientsMap;
        this.ingredientHelperMap = ingredientHelperMap;
        this.ingredientRendererMap = ingredientRendererMap;
        this.enableDebugLogs = enableDebugLogs;
        ImmutableMap.Builder ingredientTypeBuilder = ImmutableMap.builder();
        for (IIngredientType ingredientType : ingredientsMap.keySet()) {
            ingredientTypeBuilder.put(ingredientType.getIngredientClass(), (Object)ingredientType);
        }
        this.ingredientTypeMap = ingredientTypeBuilder.build();
        for (ItemStack itemStack : this.getAllIngredients(VanillaTypes.ITEM)) {
            this.getStackProperties(itemStack);
        }
    }

    private void getStackProperties(ItemStack itemStack) {
        String itemStackInfo;
        try {
            if (TileEntityFurnace.func_145954_b((ItemStack)itemStack)) {
                this.fuels.add((Object)itemStack);
            }
        }
        catch (LinkageError | RuntimeException e) {
            itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.error("Failed to check if item is fuel {}.", (Object)itemStackInfo, (Object)e);
        }
        try {
            if (PotionBrewing.func_185205_a((ItemStack)itemStack)) {
                this.potionIngredients.add((Object)itemStack);
            }
        }
        catch (LinkageError | RuntimeException e) {
            itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.error("Failed to check if item is a potion ingredient {}.", (Object)itemStackInfo, (Object)e);
        }
    }

    @Override
    public <V> Collection<V> getAllIngredients(IIngredientType<V> ingredientType) {
        IngredientSet ingredients = this.ingredientsMap.get(ingredientType);
        if (ingredients == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(ingredients);
    }

    @Nullable
    public <V> V getIngredientByUid(IIngredientType<V> ingredientType, String uid) {
        IngredientSet ingredients = this.ingredientsMap.get(ingredientType);
        if (ingredients == null) {
            return null;
        }
        return ingredients.getByUid(uid);
    }

    public <V> boolean isValidIngredient(V ingredient) {
        try {
            IIngredientHelper<V> ingredientHelper = this.getIngredientHelper(ingredient);
            return ingredientHelper.isValidIngredient(ingredient);
        }
        catch (RuntimeException ignored) {
            return false;
        }
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        IIngredientType<V> ingredientType = this.getIngredientType(ingredient);
        return this.getIngredientHelper(ingredientType);
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(IIngredientType<V> ingredientType) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        IIngredientHelper ingredientHelper = (IIngredientHelper)this.ingredientHelperMap.get(ingredientType);
        if (ingredientHelper != null) {
            return ingredientHelper;
        }
        throw new IllegalArgumentException("Unknown ingredient type: " + ingredientType.getIngredientClass());
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        IIngredientType<V> ingredientType = this.getIngredientType(ingredient);
        return this.getIngredientRenderer(ingredientType);
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(IIngredientType<V> ingredientType) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        IIngredientRenderer ingredientRenderer = (IIngredientRenderer)this.ingredientRendererMap.get(ingredientType);
        if (ingredientRenderer == null) {
            throw new IllegalArgumentException("Could not find ingredient renderer for " + ingredientType);
        }
        return ingredientRenderer;
    }

    @Override
    public Collection<IIngredientType> getRegisteredIngredientTypes() {
        return this.ingredientTypeMap.values();
    }

    @Override
    public List<ItemStack> getFuels() {
        return Collections.unmodifiableList(this.fuels);
    }

    @Override
    public List<ItemStack> getPotionIngredients() {
        return Collections.unmodifiableList(this.potionIngredients);
    }

    @Override
    public <V> void addIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        this.addIngredientsAtRuntime(ingredientType, ingredients, Internal.getIngredientFilter());
    }

    public <V> void addIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients, IngredientFilter ingredientFilter) {
        ErrorUtil.assertMainThread();
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        LOGGER.info("Ingredients are being added at runtime: {} {}", (Object)ingredients.size(), (Object)ingredientType.getIngredientClass().getName());
        IIngredientHelper ingredientHelper = this.getIngredientHelper(ingredientType);
        Set set = this.ingredientsMap.computeIfAbsent(ingredientType, k -> IngredientSet.create(ingredientHelper));
        for (V ingredient : ingredients) {
            set.add(ingredient);
            if (!(ingredient instanceof ItemStack)) continue;
            this.getStackProperties((ItemStack)ingredient);
        }
        for (V ingredient : ingredients) {
            List<IIngredientListElement<V>> matchingElements = ingredientFilter.findMatchingElements(ingredientHelper, ingredient);
            if (!matchingElements.isEmpty()) {
                for (IIngredientListElement<V> matchingElement : matchingElements) {
                    this.blacklist.removeIngredientFromBlacklist(matchingElement.getIngredient(), ingredientHelper);
                    ingredientFilter.updateHiddenState(matchingElement);
                }
                if (!this.enableDebugLogs) continue;
                LOGGER.debug("Updated ingredient: {}", (Object)ingredientHelper.getErrorInfo(ingredient));
                continue;
            }
            IIngredientListElement<V> element = IngredientListElementFactory.createOrderedElement(this, ingredientType, ingredient);
            IngredientListElementInfo<V> info = IngredientListElementInfo.create(element, this, this.modIdHelper);
            if (info == null) continue;
            this.blacklist.removeIngredientFromBlacklist(ingredient, ingredientHelper);
            ingredientFilter.addIngredient(info);
            if (!this.enableDebugLogs) continue;
            LOGGER.debug("Added ingredient: {}", (Object)ingredientHelper.getErrorInfo(ingredient));
        }
        ingredientFilter.invalidateCache();
    }

    @Override
    public <V> void removeIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        this.removeIngredientsAtRuntime(ingredientType, ingredients, Internal.getIngredientFilter());
    }

    @Override
    public <V> IIngredientType<V> getIngredientType(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        Class<?> ingredientClass = ingredient.getClass();
        return this.getIngredientType(ingredientClass);
    }

    @Override
    public <V> IIngredientType<V> getIngredientType(Class<? extends V> ingredientClass) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        IIngredientType ingredientType = (IIngredientType)this.ingredientTypeMap.get(ingredientClass);
        if (ingredientType != null) {
            return ingredientType;
        }
        for (IIngredientType type : this.ingredientTypeMap.values()) {
            if (!type.getIngredientClass().isAssignableFrom(ingredientClass)) continue;
            IIngredientType castType = type;
            return castType;
        }
        throw new IllegalArgumentException("Unknown ingredient class: " + ingredientClass);
    }

    public <V> void removeIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients, IngredientFilter ingredientFilter) {
        ErrorUtil.assertMainThread();
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        LOGGER.info("Ingredients are being removed at runtime: {} {}", (Object)ingredients.size(), (Object)ingredientType.getIngredientClass().getName());
        IngredientSet set = this.ingredientsMap.get(ingredientType);
        if (set != null) {
            set.removeAll(ingredients);
        }
        IIngredientHelper<V> ingredientHelper = this.getIngredientHelper(ingredientType);
        for (V ingredient : ingredients) {
            List<IIngredientListElement<V>> matchingElements = ingredientFilter.findMatchingElements(ingredientHelper, ingredient);
            if (matchingElements.isEmpty()) {
                String errorInfo = ingredientHelper.getErrorInfo(ingredient);
                LOGGER.error("Could not find any matching ingredients to remove: {}", (Object)errorInfo);
            } else if (this.enableDebugLogs) {
                LOGGER.debug("Removed ingredient: {}", (Object)ingredientHelper.getErrorInfo(ingredient));
            }
            for (IIngredientListElement<V> matchingElement : matchingElements) {
                this.blacklist.addIngredientToBlacklist(matchingElement.getIngredient(), ingredientHelper);
                matchingElement.setVisible(false);
            }
        }
        ingredientFilter.invalidateCache();
    }

    public <V> boolean isIngredientVisible(V ingredient, IngredientFilter ingredientFilter) {
        IIngredientType<V> ingredientType = this.getIngredientType(ingredient);
        IIngredientHelper<V> ingredientHelper = this.getIngredientHelper(ingredientType);
        List<IIngredientListElement<V>> matchingElements = ingredientFilter.findMatchingElements(ingredientHelper, ingredient);
        if (matchingElements.isEmpty()) {
            return true;
        }
        for (IIngredientListElement<V> matchingElement : matchingElements) {
            if (!matchingElement.isVisible()) continue;
            return true;
        }
        return false;
    }
}

