/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.INbtIgnoreList;
import mezz.jei.util.Log;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class NbtIgnoreList
implements INbtIgnoreList {
    private final Set<String> nbtTagNameBlacklist = new HashSet<String>();
    private final HashMultimap<Item, String> itemNbtTagNameBlacklist = HashMultimap.create();

    @Override
    public void ignoreNbtTagNames(String ... nbtTagNames) {
        Collections.addAll(this.nbtTagNameBlacklist, nbtTagNames);
    }

    @Override
    public void ignoreNbtTagNames(@Nullable Item item, String ... nbtTagNames) {
        if (item == null) {
            Log.error("Null item", new NullPointerException());
            return;
        }
        Set ignoredNbtTagNames = this.itemNbtTagNameBlacklist.get((Object)item);
        Collections.addAll(ignoredNbtTagNames, nbtTagNames);
    }

    @Override
    public boolean isNbtTagIgnored(@Nullable String nbtTagName) {
        if (nbtTagName == null) {
            Log.error("Null nbtTagName", new NullPointerException());
            return false;
        }
        return this.nbtTagNameBlacklist.contains(nbtTagName);
    }

    @Override
    @Nonnull
    public Set<String> getIgnoredNbtTags(@Nullable Set<String> nbtTagNames) {
        if (nbtTagNames == null) {
            Log.error("Null nbtTagNames", new NullPointerException());
            return Collections.emptySet();
        }
        return Sets.intersection(nbtTagNames, this.nbtTagNameBlacklist);
    }

    @Override
    @Nullable
    public NBTTagCompound getNbt(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            Log.error("Null itemStack", new NullPointerException());
            return null;
        }
        NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
        if (nbtTagCompound == null || nbtTagCompound.func_82582_d()) {
            return null;
        }
        Set keys = nbtTagCompound.func_150296_c();
        Set allIgnoredKeysForItem = this.itemNbtTagNameBlacklist.get((Object)itemStack.func_77973_b());
        Sets.SetView ignoredKeys = Sets.intersection((Set)keys, this.nbtTagNameBlacklist);
        Sets.SetView ignoredKeysForItem = Sets.intersection((Set)keys, (Set)allIgnoredKeysForItem);
        if ((ignoredKeys = Sets.union((Set)ignoredKeys, (Set)ignoredKeysForItem)).isEmpty()) {
            return nbtTagCompound;
        }
        NBTTagCompound nbtTagCompoundCopy = (NBTTagCompound)nbtTagCompound.func_74737_b();
        for (String ignoredKey : ignoredKeys) {
            nbtTagCompoundCopy.func_82580_o(ignoredKey);
        }
        if (nbtTagCompoundCopy.func_82582_d()) {
            return null;
        }
        return nbtTagCompoundCopy;
    }
}

