/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.Log;
import mezz.jei.util.StackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ErrorUtil {
    @Nonnull
    public static String getInfoFromBrokenRecipe(@Nonnull Object recipe, @Nonnull IRecipeHandler recipeHandler) {
        List<List<String>> itemStackIngredientsInfo;
        IRecipeWrapper recipeWrapper;
        StringBuilder recipeInfoBuilder = new StringBuilder();
        try {
            recipeInfoBuilder.append(recipe);
        }
        catch (RuntimeException e) {
            Log.error("Failed recipe.toString", e);
            recipeInfoBuilder.append(recipe.getClass());
        }
        try {
            recipeWrapper = recipeHandler.getRecipeWrapper(recipe);
        }
        catch (RuntimeException ignored) {
            recipeInfoBuilder.append("\nFailed to create recipe wrapper");
            return recipeInfoBuilder.toString();
        }
        recipeInfoBuilder.append("\nOutput ItemStacks: ");
        try {
            List outputs = recipeWrapper.getOutputs();
            itemStackIngredientsInfo = ErrorUtil.getItemStackIngredientsInfo(outputs);
            recipeInfoBuilder.append(itemStackIngredientsInfo);
        }
        catch (RuntimeException e) {
            recipeInfoBuilder.append(e.getMessage());
        }
        recipeInfoBuilder.append("\nOutput Fluids: ");
        try {
            recipeInfoBuilder.append(recipeWrapper.getFluidOutputs());
        }
        catch (RuntimeException e) {
            recipeInfoBuilder.append(e.getMessage());
        }
        recipeInfoBuilder.append("\nInput ItemStacks: ");
        try {
            List inputs = recipeWrapper.getInputs();
            itemStackIngredientsInfo = ErrorUtil.getItemStackIngredientsInfo(inputs);
            recipeInfoBuilder.append(itemStackIngredientsInfo);
        }
        catch (RuntimeException e) {
            recipeInfoBuilder.append(e.getMessage());
        }
        recipeInfoBuilder.append("\nInput Fluids: ");
        try {
            recipeInfoBuilder.append(recipeWrapper.getFluidInputs());
        }
        catch (RuntimeException e) {
            recipeInfoBuilder.append(e.getMessage());
        }
        return recipeInfoBuilder.toString();
    }

    public static List<List<String>> getItemStackIngredientsInfo(@Nullable List list) {
        if (list == null) {
            return null;
        }
        StackHelper stackHelper = Internal.getStackHelper();
        ArrayList<List<String>> ingredientsInfo = new ArrayList<List<String>>();
        for (Object ingredient : list) {
            ArrayList<String> ingredientInfo = new ArrayList<String>();
            List<ItemStack> stacks = stackHelper.toItemStackList(ingredient);
            String oreDict = stackHelper.getOreDictEquivalent(stacks);
            if (oreDict != null) {
                ingredientInfo.add("OreDict: " + oreDict);
            }
            for (ItemStack stack : stacks) {
                String itemStackInfo = ErrorUtil.getItemStackInfo(stack);
                ingredientInfo.add(itemStackInfo);
            }
            ingredientsInfo.add(ingredientInfo);
        }
        return ingredientsInfo;
    }

    public static String getItemStackInfo(@Nonnull ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return itemStack.field_77994_a + "x (null)";
        }
        String registryName = item.getRegistryName();
        String itemName = registryName != null ? registryName : item.getClass().getName();
        return itemStack.toString().replace(item.func_77658_a(), itemName);
    }
}

