/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Table;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.Internal;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.util.RecipeCategoryComparator;
import mezz.jei.util.StackHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMap {
    @Nonnull
    private final Table<IRecipeCategory, String, List<Object>> recipeTable = HashBasedTable.create();
    @Nonnull
    private final ArrayListMultimap<String, IRecipeCategory> categoryMap = ArrayListMultimap.create();
    @Nonnull
    private final Ordering<IRecipeCategory> recipeCategoryOrdering;

    public RecipeMap(RecipeCategoryComparator recipeCategoryComparator) {
        this.recipeCategoryOrdering = Ordering.from((Comparator)recipeCategoryComparator);
    }

    @Nonnull
    public ImmutableList<IRecipeCategory> getRecipeCategories(@Nonnull ItemStack itemStack) {
        HashSet recipeCategories = new HashSet();
        for (String stackKey : Internal.getStackHelper().getUniqueIdentifiersWithWildcard(itemStack)) {
            recipeCategories.addAll(this.categoryMap.get((Object)stackKey));
        }
        return this.recipeCategoryOrdering.immutableSortedCopy(recipeCategories);
    }

    @Nonnull
    public ImmutableList<IRecipeCategory> getRecipeCategories(@Nonnull Fluid fluid) {
        String key = this.getKeyForFluid(fluid);
        return this.recipeCategoryOrdering.immutableSortedCopy((Iterable)this.categoryMap.get((Object)key));
    }

    private void addRecipeCategory(@Nonnull IRecipeCategory recipeCategory, @Nonnull ItemStack itemStack) {
        String stackKey = Internal.getStackHelper().getUniqueIdentifierForStack(itemStack);
        List recipeCategories = this.categoryMap.get((Object)stackKey);
        if (!recipeCategories.contains(recipeCategory)) {
            recipeCategories.add(recipeCategory);
        }
    }

    private void addRecipeCategory(@Nonnull IRecipeCategory recipeCategory, @Nonnull Fluid fluid) {
        String key = this.getKeyForFluid(fluid);
        List recipeCategories = this.categoryMap.get((Object)key);
        if (!recipeCategories.contains(recipeCategory)) {
            recipeCategories.add(recipeCategory);
        }
    }

    @Nonnull
    private String getKeyForFluid(Fluid fluid) {
        return "fluid:" + fluid.getName();
    }

    @Nonnull
    public ImmutableList<Object> getRecipes(@Nonnull IRecipeCategory recipeCategory, @Nonnull ItemStack stack) {
        Map recipesForType = this.recipeTable.row((Object)recipeCategory);
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (String name : Internal.getStackHelper().getUniqueIdentifiersWithWildcard(stack)) {
            List recipes = (List)recipesForType.get(name);
            if (recipes == null) continue;
            listBuilder.addAll((Iterable)recipes);
        }
        return listBuilder.build();
    }

    @Nonnull
    public List<Object> getRecipes(@Nonnull IRecipeCategory recipeCategory, @Nonnull Fluid fluid) {
        String name;
        Map recipesForType = this.recipeTable.row((Object)recipeCategory);
        List recipes = (List)recipesForType.get(name = this.getKeyForFluid(fluid));
        if (recipes == null) {
            return ImmutableList.of();
        }
        return Collections.unmodifiableList(recipes);
    }

    public void addRecipe(@Nonnull Object recipe, @Nonnull IRecipeCategory recipeCategory, @Nonnull Iterable<ItemStack> itemStacks, @Nonnull Iterable<FluidStack> fluidStacks) {
        Map recipesForType = this.recipeTable.row((Object)recipeCategory);
        StackHelper stackHelper = Internal.getStackHelper();
        for (ItemStack itemStack : itemStacks) {
            if (itemStack == null) continue;
            String stackKey = stackHelper.getUniqueIdentifierForStack(itemStack);
            List recipes = (List)recipesForType.get(stackKey);
            if (recipes == null) {
                recipes = Lists.newArrayList();
                recipesForType.put(stackKey, recipes);
            }
            recipes.add(recipe);
            this.addRecipeCategory(recipeCategory, itemStack);
        }
        for (FluidStack fluidStack : fluidStacks) {
            Fluid fluid;
            if (fluidStack == null || (fluid = fluidStack.getFluid()) == null) continue;
            String fluidKey = this.getKeyForFluid(fluid);
            List recipes = (List)recipesForType.get(fluidKey);
            if (recipes == null) {
                recipes = Lists.newArrayList();
                recipesForType.put(fluidKey, recipes);
            }
            recipes.add(recipe);
            this.addRecipeCategory(recipeCategory, fluid);
        }
    }
}

