/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.GuiEventHandler;
import mezz.jei.Internal;
import mezz.jei.ItemFilter;
import mezz.jei.ItemRegistry;
import mezz.jei.ItemRegistryFactory;
import mezz.jei.JeiHelpers;
import mezz.jei.JeiRuntime;
import mezz.jei.ProxyCommon;
import mezz.jei.RecipeRegistry;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.config.Config;
import mezz.jei.config.KeyBindings;
import mezz.jei.config.SessionData;
import mezz.jei.gui.ItemListOverlay;
import mezz.jei.gui.RecipesGui;
import mezz.jei.network.packets.PacketJEI;
import mezz.jei.plugins.jei.JEIInternalPlugin;
import mezz.jei.plugins.vanilla.VanillaPlugin;
import mezz.jei.util.AnnotatedInstanceUtil;
import mezz.jei.util.Log;
import mezz.jei.util.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.crash.CrashReport;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ProxyCommonClient
extends ProxyCommon {
    @Nullable
    private ItemFilter itemFilter;
    private List<IModPlugin> plugins;

    private static void initVersionChecker() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("curseProjectName", "just-enough-items-jei");
        compound.func_74778_a("curseFilenameParser", "jei_1.9.4-[].jar");
        FMLInterModComms.sendRuntimeMessage((Object)"JEI", (String)"VersionChecker", (String)"addCurseCheck", (NBTTagCompound)compound);
    }

    @Override
    public void preInit(@Nonnull FMLPreInitializationEvent event) {
        IModPlugin jeiInternalPlugin;
        Config.preInit(event);
        ProxyCommonClient.initVersionChecker();
        ASMDataTable asmDataTable = event.getAsmData();
        this.plugins = AnnotatedInstanceUtil.getModPlugins(asmDataTable);
        IModPlugin vanillaPlugin = this.getVanillaPlugin(this.plugins);
        if (vanillaPlugin != null) {
            this.plugins.remove(vanillaPlugin);
            this.plugins.add(0, vanillaPlugin);
        }
        if ((jeiInternalPlugin = this.getJeiInternalPlugin(this.plugins)) != null) {
            this.plugins.remove(jeiInternalPlugin);
            this.plugins.add(jeiInternalPlugin);
        }
    }

    @Nullable
    private IModPlugin getVanillaPlugin(@Nonnull List<IModPlugin> modPlugins) {
        for (IModPlugin modPlugin : modPlugins) {
            if (!(modPlugin instanceof VanillaPlugin)) continue;
            return modPlugin;
        }
        return null;
    }

    @Nullable
    private IModPlugin getJeiInternalPlugin(@Nonnull List<IModPlugin> modPlugins) {
        for (IModPlugin modPlugin : modPlugins) {
            if (!(modPlugin instanceof JEIInternalPlugin)) continue;
            return modPlugin;
        }
        return null;
    }

    @Override
    public void init(@Nonnull FMLInitializationEvent event) {
        KeyBindings.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        GuiEventHandler guiEventHandler = new GuiEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)guiEventHandler);
        ProxyCommonClient.fixVanillaItemHasSubtypes();
    }

    @Override
    public void postInit(@Nonnull FMLPostInitializationEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        IReloadableResourceManager reloadableResourceManager = (IReloadableResourceManager)minecraft.func_110442_L();
        reloadableResourceManager.func_110542_a(new IResourceManagerReloadListener(){

            public void func_110549_a(IResourceManager resourceManager) {
                ProxyCommonClient.this.restartJEI();
            }
        });
    }

    private static void fixVanillaItemHasSubtypes() {
        List<Item> items = Arrays.asList(Items.field_151068_bn, Items.field_185156_bI, Items.field_185155_bH, Items.field_185167_i, Items.field_151134_bR);
        for (Item item : items) {
            item.func_77627_a(true);
        }
    }

    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        if (!SessionData.isJeiStarted() && Minecraft.func_71410_x().field_71439_g != null) {
            try {
                this.startJEI();
            }
            catch (Throwable e) {
                Minecraft.func_71410_x().func_71377_b(new CrashReport("JEI failed to start:", e));
            }
        }
    }

    private void startJEI() {
        SessionData.setJeiStarted();
        Config.startJei();
        Internal.setHelpers(new JeiHelpers());
        Internal.getStackHelper().enableUidCache();
        ItemRegistryFactory itemRegistryFactory = new ItemRegistryFactory();
        ItemRegistry itemRegistry = itemRegistryFactory.createItemRegistry();
        Internal.setItemRegistry(itemRegistry);
        ModRegistry modRegistry = new ModRegistry(Internal.getHelpers(), itemRegistry);
        Iterator<IModPlugin> iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                long start_time = System.nanoTime();
                Log.info("Registering plugin: {}", plugin.getClass().getName());
                plugin.register(modRegistry);
                long timeElapsedSeconds = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start_time);
                Log.info("Registered  plugin: {} in {} seconds", plugin.getClass().getName(), timeElapsedSeconds);
            }
            catch (LinkageError | RuntimeException e) {
                Log.error("Failed to register mod plugin: {}", plugin.getClass(), e);
                iterator.remove();
            }
        }
        RecipeRegistry recipeRegistry = modRegistry.createRecipeRegistry();
        List<IAdvancedGuiHandler<?>> advancedGuiHandlers = modRegistry.getAdvancedGuiHandlers();
        this.itemFilter = new ItemFilter(itemRegistry);
        ItemListOverlay itemListOverlay = new ItemListOverlay(this.itemFilter, advancedGuiHandlers);
        RecipesGui recipesGui = new RecipesGui();
        JeiRuntime jeiRuntime = new JeiRuntime(recipeRegistry, itemListOverlay, recipesGui);
        Internal.setRuntime(jeiRuntime);
        iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                plugin.onRuntimeAvailable(jeiRuntime);
            }
            catch (LinkageError | RuntimeException e) {
                Log.error("Mod plugin failed: {}", plugin.getClass(), e);
                iterator.remove();
            }
        }
        Internal.getStackHelper().disableUidCache();
    }

    @Override
    public void restartJEI() {
        if (SessionData.isJeiStarted()) {
            this.startJEI();
        }
    }

    @Override
    public void resetItemFilter() {
        if (this.itemFilter != null) {
            this.itemFilter.reset();
        }
    }

    @Override
    public void sendPacketToServer(PacketJEI packet) {
        NetHandlerPlayClient netHandler = FMLClientHandler.instance().getClient().func_147114_u();
        if (netHandler != null) {
            netHandler.func_147297_a((Packet)packet.getPacket());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onConfigChanged(@Nonnull ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (!"JEI".equals(eventArgs.getModID())) {
            return;
        }
        if (SessionData.isJeiStarted() && Config.syncAllConfig()) {
            this.restartJEI();
        }
    }
}

