/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.crafting;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.plugins.vanilla.crafting.ShapelessOreRecipeWrapper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ShapelessOreRecipeHandler
implements IRecipeHandler<ShapelessOreRecipe> {
    @Nonnull
    private final IGuiHelper guiHelper;

    public ShapelessOreRecipeHandler(@Nonnull IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    @Override
    @Nonnull
    public Class<ShapelessOreRecipe> getRecipeClass() {
        return ShapelessOreRecipe.class;
    }

    @Override
    @Nonnull
    public String getRecipeCategoryUid() {
        return "minecraft.crafting";
    }

    @Override
    @Nonnull
    public String getRecipeCategoryUid(@Nonnull ShapelessOreRecipe recipe) {
        return "minecraft.crafting";
    }

    @Override
    @Nonnull
    public IRecipeWrapper getRecipeWrapper(@Nonnull ShapelessOreRecipe recipe) {
        return new ShapelessOreRecipeWrapper(this.guiHelper, recipe);
    }

    @Override
    public boolean isRecipeValid(@Nonnull ShapelessOreRecipe recipe) {
        String recipeInfo;
        if (recipe.func_77571_b() == null) {
            String recipeInfo2 = ErrorUtil.getInfoFromBrokenRecipe(recipe, this);
            Log.error("Recipe has no outputs. {}", recipeInfo2);
            return false;
        }
        int inputCount = 0;
        for (Object input : recipe.getInput()) {
            if (input instanceof List && ((List)input).isEmpty()) {
                return false;
            }
            if (input == null) continue;
            ++inputCount;
        }
        if (inputCount > 9) {
            recipeInfo = ErrorUtil.getInfoFromBrokenRecipe(recipe, this);
            Log.error("Recipe has too many inputs. {}", recipeInfo);
            return false;
        }
        if (inputCount == 0) {
            recipeInfo = ErrorUtil.getInfoFromBrokenRecipe(recipe, this);
            Log.error("Recipe has no inputs. {}", recipeInfo);
            return false;
        }
        return true;
    }
}

