/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import com.google.common.base.Joiner;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.config.Config;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class ItemStackElement {
    @Nonnull
    private final ItemStack itemStack;
    @Nonnull
    private final String searchString;
    @Nonnull
    private final String modNameString;
    @Nonnull
    private final String tooltipString;
    @Nonnull
    private final String oreDictString;
    @Nonnull
    private final String creativeTabsString;
    @Nonnull
    private final String colorString;

    @Nullable
    public static ItemStackElement create(@Nonnull ItemStack itemStack) {
        try {
            return new ItemStackElement(itemStack);
        }
        catch (RuntimeException e) {
            try {
                String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
                Log.warning("Found a broken itemStack {}", itemStackInfo, e);
            }
            catch (RuntimeException e2) {
                Log.warning("Found a broken itemStack.", e2);
            }
            return null;
        }
    }

    private ItemStackElement(@Nonnull ItemStack itemStack) {
        String tooltipString;
        this.itemStack = itemStack;
        Item item = itemStack.func_77973_b();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ResourceLocation itemResourceLocation = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
        String modId = itemResourceLocation.func_110624_b().toLowerCase(Locale.ENGLISH);
        String modName = Internal.getItemRegistry().getModNameForItem(item).toLowerCase(Locale.ENGLISH);
        String displayName = itemStack.func_82833_r();
        if (displayName == null) {
            String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
            throw new NullPointerException("No display name for item. " + stackInfo);
        }
        displayName = displayName.toLowerCase();
        this.modNameString = modId + ' ' + modName;
        try {
            List tooltip = itemStack.func_82840_a((EntityPlayer)player, false);
            tooltipString = Joiner.on((char)' ').join((Iterable)tooltip).toLowerCase();
            tooltipString = ChatFormatting.stripFormatting((String)tooltipString);
            tooltipString = tooltipString.replace(modId, "");
            tooltipString = tooltipString.replace(modName, "");
            tooltipString = tooltipString.replace(displayName, "");
        }
        catch (RuntimeException ignored) {
            tooltipString = "";
        }
        this.tooltipString = tooltipString;
        StringBuilder oreDictStringBuilder = new StringBuilder();
        for (int oreId : OreDictionary.getOreIDs((ItemStack)itemStack)) {
            String oreName = OreDictionary.getOreName((int)oreId).toLowerCase(Locale.ENGLISH);
            oreDictStringBuilder.append(oreName).append(' ');
        }
        this.oreDictString = oreDictStringBuilder.toString();
        StringBuilder creativeTabStringBuilder = new StringBuilder();
        for (CreativeTabs creativeTab : item.getCreativeTabs()) {
            if (creativeTab == null) continue;
            String creativeTabName = I18n.func_135052_a((String)creativeTab.func_78024_c(), (Object[])new Object[0]).toLowerCase();
            creativeTabStringBuilder.append(creativeTabName).append(' ');
        }
        this.creativeTabsString = creativeTabStringBuilder.toString();
        if (Config.isColorSearchEnabled()) {
            Collection<String> colorNames = Internal.getColorNamer().getColorNames(itemStack);
            this.colorString = Joiner.on((char)' ').join(colorNames).toLowerCase();
        } else {
            this.colorString = "";
        }
        StringBuilder searchStringBuilder = new StringBuilder(displayName);
        if (!Config.isPrefixRequiredForModNameSearch()) {
            searchStringBuilder.append(' ').append(this.modNameString);
        }
        if (!Config.isPrefixRequiredForTooltipSearch()) {
            searchStringBuilder.append(' ').append(this.tooltipString);
        }
        if (!Config.isPrefixRequiredForOreDictSearch()) {
            searchStringBuilder.append(' ').append(this.oreDictString);
        }
        if (!Config.isPrefixRequiredForCreativeTabSearch()) {
            searchStringBuilder.append(' ').append(this.creativeTabsString);
        }
        if (!Config.isPrefixRequiredForColorSearch()) {
            searchStringBuilder.append(' ').append(this.colorString);
        }
        this.searchString = searchStringBuilder.toString();
    }

    @Nonnull
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Nonnull
    public String getSearchString() {
        return this.searchString;
    }

    @Nonnull
    public String getModNameString() {
        return this.modNameString;
    }

    @Nonnull
    public String getTooltipString() {
        return this.tooltipString;
    }

    @Nonnull
    public String getOreDictString() {
        return this.oreDictString;
    }

    @Nonnull
    public String getCreativeTabsString() {
        return this.creativeTabsString;
    }

    @Nonnull
    public String getColorString() {
        return this.colorString;
    }
}

